/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.bio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.io.BufferPool;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.ListenCallback;
import org.apache.catalina.tribes.io.ObjectReader;
import org.apache.catalina.tribes.transport.AbstractRxTask;
import org.apache.catalina.tribes.transport.Constants;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class BioReplicationTask
extends AbstractRxTask {
    private static final Log log = LogFactory.getLog(BioReplicationTask.class);
    protected static final StringManager sm = StringManager.getManager(BioReplicationTask.class);
    protected Socket socket;
    protected ObjectReader reader;

    public BioReplicationTask(ListenCallback listenCallback) {
        super(listenCallback);
    }

    @Override
    public synchronized void run() {
        if (this.socket == null) {
            return;
        }
        try {
            this.drainSocket();
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("bioReplicationTask.unable.service"), (Throwable)exception);
        }
        finally {
            block21: {
                block20: {
                    try {
                        this.socket.close();
                    }
                    catch (Exception exception) {
                        if (!log.isDebugEnabled()) break block20;
                        log.debug((Object)sm.getString("bioReplicationTask.socket.closeFailed"), (Throwable)exception);
                    }
                }
                try {
                    this.reader.close();
                }
                catch (Exception exception) {
                    if (!log.isDebugEnabled()) break block21;
                    log.debug((Object)sm.getString("bioReplicationTask.reader.closeFailed"), (Throwable)exception);
                }
            }
            this.reader = null;
            this.socket = null;
        }
        if (this.getTaskPool() != null) {
            this.getTaskPool().returnWorker(this);
        }
    }

    public synchronized void serviceSocket(Socket socket, ObjectReader objectReader) {
        this.socket = socket;
        this.reader = objectReader;
    }

    protected void execute(ObjectReader objectReader) throws Exception {
        int n = objectReader.count();
        if (n > 0) {
            ChannelMessage[] channelMessageArray = objectReader.execute();
            for (int i = 0; i < channelMessageArray.length; ++i) {
                if (ChannelData.sendAckAsync(channelMessageArray[i].getOptions())) {
                    this.sendAck(Constants.ACK_COMMAND);
                }
                try {
                    this.getCallback().messageDataReceived(channelMessageArray[i]);
                    if (ChannelData.sendAckSync(channelMessageArray[i].getOptions())) {
                        this.sendAck(Constants.ACK_COMMAND);
                    }
                }
                catch (Exception exception) {
                    if (ChannelData.sendAckSync(channelMessageArray[i].getOptions())) {
                        this.sendAck(Constants.FAIL_ACK_COMMAND);
                    }
                    log.error((Object)sm.getString("bioReplicationTask.messageDataReceived.error"), (Throwable)exception);
                }
                if (!this.getUseBufferPool()) continue;
                BufferPool.getBufferPool().returnBuffer(channelMessageArray[i].getMessage());
                channelMessageArray[i].setMessage(null);
            }
        }
    }

    protected void drainSocket() throws Exception {
        InputStream inputStream = this.socket.getInputStream();
        byte[] byArray = new byte[1024];
        int n = inputStream.read(byArray);
        while (n >= 0) {
            int n2 = this.reader.append(byArray, 0, n, true);
            if (n2 > 0) {
                this.execute(this.reader);
            }
            n = inputStream.read(byArray);
        }
    }

    protected void sendAck(byte[] byArray) {
        try {
            OutputStream outputStream = this.socket.getOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
            if (log.isTraceEnabled()) {
                log.trace((Object)("ACK sent to " + this.socket.getPort()));
            }
        }
        catch (IOException iOException) {
            log.warn((Object)sm.getString("bioReplicationTask.unable.sendAck", iOException.getMessage()));
        }
    }

    @Override
    public void close() {
        block5: {
            block4: {
                this.setDoRun(false);
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)sm.getString("bioReplicationTask.socket.closeFailed"), (Throwable)exception);
                }
            }
            try {
                this.reader.close();
            }
            catch (Exception exception) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)sm.getString("bioReplicationTask.reader.closeFailed"), (Throwable)exception);
            }
        }
        this.reader = null;
        this.socket = null;
        super.close();
    }
}

