/* tracker-array-cursor.c generated by valac 0.56.3, the Vala compiler
 * generated from tracker-array-cursor.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include "libtracker-sparql/tracker-generated-no-checks.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "tracker-bus.h"

#define TRACKER_BUS_TYPE_ARRAY_CURSOR (tracker_bus_array_cursor_get_type ())
#define TRACKER_BUS_ARRAY_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursor))
#define TRACKER_BUS_ARRAY_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursorClass))
#define TRACKER_BUS_IS_ARRAY_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BUS_TYPE_ARRAY_CURSOR))
#define TRACKER_BUS_IS_ARRAY_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_BUS_TYPE_ARRAY_CURSOR))
#define TRACKER_BUS_ARRAY_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursorClass))

typedef struct _TrackerBusArrayCursor TrackerBusArrayCursor;
typedef struct _TrackerBusArrayCursorClass TrackerBusArrayCursorClass;
typedef struct _TrackerBusArrayCursorPrivate TrackerBusArrayCursorPrivate;
enum  {
	TRACKER_BUS_ARRAY_CURSOR_0_PROPERTY,
	TRACKER_BUS_ARRAY_CURSOR_N_COLUMNS_PROPERTY,
	TRACKER_BUS_ARRAY_CURSOR_NUM_PROPERTIES
};
static GParamSpec* tracker_bus_array_cursor_properties[TRACKER_BUS_ARRAY_CURSOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TrackerBusArrayCursorNextAsyncData TrackerBusArrayCursorNextAsyncData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TrackerBusArrayCursor {
	TrackerSparqlCursor parent_instance;
	TrackerBusArrayCursorPrivate * priv;
};

struct _TrackerBusArrayCursorClass {
	TrackerSparqlCursorClass parent_class;
};

struct _TrackerBusArrayCursorPrivate {
	gint rows;
	gint current_row;
	gchar** results;
	gint results_length1;
	gint results_length2;
	gchar** var_names;
	gint var_names_length1;
	gint _var_names_size_;
	TrackerSparqlValueType* types;
	gint types_length1;
	gint _types_size_;
	gint cols;
};

struct _TrackerBusArrayCursorNextAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusArrayCursor* self;
	GCancellable* cancellable;
	gboolean result;
	gboolean _tmp0_;
	GError* _inner_error0_;
};

static gint TrackerBusArrayCursor_private_offset;
static gpointer tracker_bus_array_cursor_parent_class = NULL;

VALA_EXTERN GType tracker_bus_array_cursor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TrackerBusArrayCursor* tracker_bus_array_cursor_new (gchar** results,
                                                     gint results_length1,
                                                     gint results_length2,
                                                     gint rows,
                                                     gint cols,
                                                     gchar** var_names,
                                                     gint var_names_length1,
                                                     TrackerSparqlValueType* types,
                                                     gint types_length1);
VALA_EXTERN TrackerBusArrayCursor* tracker_bus_array_cursor_construct (GType object_type,
                                                           gchar** results,
                                                           gint results_length1,
                                                           gint results_length2,
                                                           gint rows,
                                                           gint cols,
                                                           gchar** var_names,
                                                           gint var_names_length1,
                                                           TrackerSparqlValueType* types,
                                                           gint types_length1);
static TrackerSparqlValueType* _vala_array_dup1 (TrackerSparqlValueType* self,
                                          gssize length);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static TrackerSparqlValueType tracker_bus_array_cursor_real_get_value_type (TrackerSparqlCursor* base,
                                                                     gint column);
static const gchar* tracker_bus_array_cursor_real_get_variable_name (TrackerSparqlCursor* base,
                                                              gint column);
static const gchar* tracker_bus_array_cursor_real_get_string (TrackerSparqlCursor* base,
                                                       gint column,
                                                       glong* length);
static gboolean tracker_bus_array_cursor_real_next (TrackerSparqlCursor* base,
                                             GCancellable* cancellable,
                                             GError** error);
static void tracker_bus_array_cursor_real_next_async_data_free (gpointer _data);
static void tracker_bus_array_cursor_real_next_async (TrackerSparqlCursor* base,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean tracker_bus_array_cursor_real_next_async_co (TrackerBusArrayCursorNextAsyncData* _data_);
static void tracker_bus_array_cursor_real_rewind (TrackerSparqlCursor* base);
static void tracker_bus_array_cursor_finalize (GObject * obj);
static GType tracker_bus_array_cursor_get_type_once (void);
static void _vala_tracker_bus_array_cursor_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
tracker_bus_array_cursor_get_instance_private (TrackerBusArrayCursor* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerBusArrayCursor_private_offset);
}

static TrackerSparqlValueType*
_vala_array_dup1 (TrackerSparqlValueType* self,
                  gssize length)
{
#line 32 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	if (length > 0) {
#line 32 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		return _vala_memdup2 (self, length * sizeof (TrackerSparqlValueType));
#line 164 "tracker-array-cursor.c"
	}
#line 32 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	return NULL;
#line 168 "tracker-array-cursor.c"
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
#line 33 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	if (length >= 0) {
#line 177 "tracker-array-cursor.c"
		gchar** result;
		gssize i;
#line 33 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		result = g_new0 (gchar*, length + 1);
#line 33 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		for (i = 0; i < length; i++) {
#line 184 "tracker-array-cursor.c"
			gchar* _tmp0_;
#line 33 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
			_tmp0_ = g_strdup (self[i]);
#line 33 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
			result[i] = _tmp0_;
#line 190 "tracker-array-cursor.c"
		}
#line 33 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		return result;
#line 194 "tracker-array-cursor.c"
	}
#line 33 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	return NULL;
#line 198 "tracker-array-cursor.c"
}

TrackerBusArrayCursor*
tracker_bus_array_cursor_construct (GType object_type,
                                    gchar** results,
                                    gint results_length1,
                                    gint results_length2,
                                    gint rows,
                                    gint cols,
                                    gchar** var_names,
                                    gint var_names_length1,
                                    TrackerSparqlValueType* types,
                                    gint types_length1)
{
	TrackerBusArrayCursor * self = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	TrackerSparqlValueType* _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
#line 28 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self = (TrackerBusArrayCursor*) tracker_sparql_cursor_construct (object_type);
#line 29 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->rows = rows;
#line 30 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->cols = cols;
#line 31 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp0_ = results;
#line 31 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp0__length1 = results_length1;
#line 31 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp0__length2 = results_length2;
#line 31 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	results = NULL;
#line 31 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	results_length1 = 0;
#line 31 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	results_length2 = 0;
#line 31 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->results = (_vala_array_free (self->priv->results, self->priv->results_length1 * self->priv->results_length2, (GDestroyNotify) g_free), NULL);
#line 31 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->results = _tmp0_;
#line 31 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->results_length1 = _tmp0__length1;
#line 31 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->results_length2 = _tmp0__length2;
#line 32 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp1_ = (types != NULL) ? _vala_array_dup1 (types, types_length1) : types;
#line 32 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp1__length1 = types_length1;
#line 32 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->types = (g_free (self->priv->types), NULL);
#line 32 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->types = _tmp1_;
#line 32 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->types_length1 = _tmp1__length1;
#line 32 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->_types_size_ = self->priv->types_length1;
#line 33 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp2_ = (var_names != NULL) ? _vala_array_dup2 (var_names, var_names_length1) : var_names;
#line 33 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp2__length1 = var_names_length1;
#line 33 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->var_names = (_vala_array_free (self->priv->var_names, self->priv->var_names_length1, (GDestroyNotify) g_free), NULL);
#line 33 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->var_names = _tmp2_;
#line 33 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->var_names_length1 = _tmp2__length1;
#line 33 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->_var_names_size_ = self->priv->var_names_length1;
#line 28 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
#line 28 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	return self;
#line 275 "tracker-array-cursor.c"
}

TrackerBusArrayCursor*
tracker_bus_array_cursor_new (gchar** results,
                              gint results_length1,
                              gint results_length2,
                              gint rows,
                              gint cols,
                              gchar** var_names,
                              gint var_names_length1,
                              TrackerSparqlValueType* types,
                              gint types_length1)
{
#line 28 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	return tracker_bus_array_cursor_construct (TRACKER_BUS_TYPE_ARRAY_CURSOR, results, results_length1, results_length2, rows, cols, var_names, var_names_length1, types, types_length1);
#line 291 "tracker-array-cursor.c"
}

static TrackerSparqlValueType
tracker_bus_array_cursor_real_get_value_type (TrackerSparqlCursor* base,
                                              gint column)
{
	TrackerBusArrayCursor * self;
	TrackerSparqlValueType* _tmp0_;
	gint _tmp0__length1;
	TrackerSparqlValueType _tmp1_;
	TrackerSparqlValueType result;
#line 38 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self = (TrackerBusArrayCursor*) base;
#line 38 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_vala_return_val_if_fail (self->priv->current_row >= 0, "current_row >= 0", 0);
#line 40 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp0_ = self->priv->types;
#line 40 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp0__length1 = self->priv->types_length1;
#line 40 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp1_ = _tmp0_[column];
#line 40 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	result = _tmp1_;
#line 40 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	return result;
#line 317 "tracker-array-cursor.c"
}

static const gchar*
tracker_bus_array_cursor_real_get_variable_name (TrackerSparqlCursor* base,
                                                 gint column)
{
	TrackerBusArrayCursor * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	const gchar* result;
#line 43 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self = (TrackerBusArrayCursor*) base;
#line 43 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_vala_return_val_if_fail (self->priv->current_row >= 0, "current_row >= 0", NULL);
#line 45 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp0_ = self->priv->var_names;
#line 45 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp0__length1 = self->priv->var_names_length1;
#line 45 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp1_ = _tmp0_[column];
#line 45 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	result = _tmp1_;
#line 45 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	return result;
#line 343 "tracker-array-cursor.c"
}

static const gchar*
tracker_bus_array_cursor_real_get_string (TrackerSparqlCursor* base,
                                          gint column,
                                          glong* length)
{
	TrackerBusArrayCursor * self;
	glong _vala_length = 0L;
	const gchar* str = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	const gchar* result;
#line 48 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self = (TrackerBusArrayCursor*) base;
#line 48 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_vala_return_val_if_fail (self->priv->current_row >= 0, "current_row >= 0", NULL);
#line 52 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp0_ = self->priv->results;
#line 52 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp0__length1 = self->priv->results_length1;
#line 52 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp0__length2 = self->priv->results_length2;
#line 52 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp1_ = _tmp0_[(self->priv->current_row * _tmp0__length2) + column];
#line 52 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	str = _tmp1_;
#line 54 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp2_ = strlen (str);
#line 54 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp3_ = _tmp2_;
#line 54 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_vala_length = (glong) _tmp3_;
#line 56 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	result = str;
#line 56 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	if (length) {
#line 56 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		*length = _vala_length;
#line 387 "tracker-array-cursor.c"
	}
#line 56 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	return result;
#line 391 "tracker-array-cursor.c"
}

static gboolean
tracker_bus_array_cursor_real_next (TrackerSparqlCursor* base,
                                    GCancellable* cancellable,
                                    GError** error)
{
	TrackerBusArrayCursor * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp3_;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 59 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self = (TrackerBusArrayCursor*) base;
#line 60 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	if (cancellable != NULL) {
#line 60 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		_tmp0_ = g_cancellable_is_cancelled (cancellable);
#line 410 "tracker-array-cursor.c"
	} else {
#line 60 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		_tmp0_ = FALSE;
#line 414 "tracker-array-cursor.c"
	}
#line 60 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	if (_tmp0_) {
#line 418 "tracker-array-cursor.c"
		GError* _tmp1_;
		gboolean _tmp2_ = FALSE;
#line 61 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		_tmp1_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
#line 61 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		_inner_error0_ = _tmp1_;
#line 61 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		g_propagate_error (error, _inner_error0_);
#line 61 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		return _tmp2_;
#line 429 "tracker-array-cursor.c"
	}
#line 64 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	if (self->priv->current_row >= (self->priv->rows - 1)) {
#line 65 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		result = FALSE;
#line 65 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		return result;
#line 437 "tracker-array-cursor.c"
	}
#line 67 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp3_ = self->priv->current_row;
#line 67 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->current_row = _tmp3_ + 1;
#line 68 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	result = TRUE;
#line 68 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	return result;
#line 447 "tracker-array-cursor.c"
}

static void
tracker_bus_array_cursor_real_next_async_data_free (gpointer _data)
{
	TrackerBusArrayCursorNextAsyncData* _data_;
	_data_ = _data;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_g_object_unref0 (_data_->self);
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	g_slice_free (TrackerBusArrayCursorNextAsyncData, _data_);
#line 461 "tracker-array-cursor.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	return self ? g_object_ref (self) : NULL;
#line 469 "tracker-array-cursor.c"
}

static void
tracker_bus_array_cursor_real_next_async (TrackerSparqlCursor* base,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	TrackerBusArrayCursor * self;
	TrackerBusArrayCursorNextAsyncData* _data_;
	TrackerBusArrayCursor* _tmp0_;
	GCancellable* _tmp1_;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self = (TrackerBusArrayCursor*) base;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_data_ = g_slice_new0 (TrackerBusArrayCursorNextAsyncData);
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_array_cursor_real_next_async_data_free);
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_data_->self = _tmp0_;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_data_->cancellable = _tmp1_;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	tracker_bus_array_cursor_real_next_async_co (_data_);
#line 502 "tracker-array-cursor.c"
}

static gboolean
tracker_bus_array_cursor_next_finish (TrackerSparqlCursor* base,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	gboolean result;
	TrackerBusArrayCursorNextAsyncData* _data_;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	if (NULL == _data_) {
#line 516 "tracker-array-cursor.c"
		gboolean _tmp0_ = FALSE;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		return _tmp0_;
#line 520 "tracker-array-cursor.c"
	}
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	result = _data_->result;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	return result;
#line 526 "tracker-array-cursor.c"
}

static gboolean
tracker_bus_array_cursor_real_next_async_co (TrackerBusArrayCursorNextAsyncData* _data_)
{
#line 71 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	switch (_data_->_state_) {
#line 71 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		case 0:
#line 536 "tracker-array-cursor.c"
		goto _state_0;
		default:
#line 71 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		g_assert_not_reached ();
#line 541 "tracker-array-cursor.c"
	}
	_state_0:
#line 73 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_data_->_tmp0_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _data_->self, _data_->cancellable, &_data_->_inner_error0_);
#line 73 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 73 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 73 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		g_object_unref (_data_->_async_result);
#line 73 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		return FALSE;
#line 554 "tracker-array-cursor.c"
	}
#line 73 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	_data_->result = _data_->_tmp0_;
#line 73 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 73 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	if (_data_->_state_ != 0) {
#line 73 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 73 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 566 "tracker-array-cursor.c"
		}
	}
#line 73 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	g_object_unref (_data_->_async_result);
#line 73 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	return FALSE;
#line 573 "tracker-array-cursor.c"
}

static void
tracker_bus_array_cursor_real_rewind (TrackerSparqlCursor* base)
{
	TrackerBusArrayCursor * self;
#line 76 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self = (TrackerBusArrayCursor*) base;
#line 77 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->current_row = 0;
#line 584 "tracker-array-cursor.c"
}

static gint
tracker_bus_array_cursor_real_get_n_columns (TrackerSparqlCursor* base)
{
	gint result;
	TrackerBusArrayCursor* self;
#line 36 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self = (TrackerBusArrayCursor*) base;
#line 36 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	result = self->priv->cols;
#line 36 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	return result;
#line 598 "tracker-array-cursor.c"
}

static void
tracker_bus_array_cursor_class_init (TrackerBusArrayCursorClass * klass,
                                     gpointer klass_data)
{
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	tracker_bus_array_cursor_parent_class = g_type_class_peek_parent (klass);
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	g_type_class_adjust_private_offset (klass, &TrackerBusArrayCursor_private_offset);
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_value_type = (TrackerSparqlValueType (*) (TrackerSparqlCursor*, gint)) tracker_bus_array_cursor_real_get_value_type;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_variable_name = (const gchar* (*) (TrackerSparqlCursor*, gint)) tracker_bus_array_cursor_real_get_variable_name;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_string = (const gchar* (*) (TrackerSparqlCursor*, gint, glong*)) tracker_bus_array_cursor_real_get_string;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->next = (gboolean (*) (TrackerSparqlCursor*, GCancellable*, GError**)) tracker_bus_array_cursor_real_next;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->next_async = (void (*) (TrackerSparqlCursor*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_array_cursor_real_next_async;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->next_finish = (gboolean (*) (TrackerSparqlCursor*, GAsyncResult*, GError**)) tracker_bus_array_cursor_next_finish;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->rewind = (void (*) (TrackerSparqlCursor*)) tracker_bus_array_cursor_real_rewind;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	TRACKER_SPARQL_CURSOR_CLASS (klass)->get_n_columns = tracker_bus_array_cursor_real_get_n_columns;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_bus_array_cursor_get_property;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_bus_array_cursor_finalize;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_BUS_ARRAY_CURSOR_N_COLUMNS_PROPERTY, tracker_bus_array_cursor_properties[TRACKER_BUS_ARRAY_CURSOR_N_COLUMNS_PROPERTY] = g_param_spec_int ("n-columns", "n-columns", "n-columns", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 631 "tracker-array-cursor.c"
}

static void
tracker_bus_array_cursor_instance_init (TrackerBusArrayCursor * self,
                                        gpointer klass)
{
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv = tracker_bus_array_cursor_get_instance_private (self);
#line 22 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->current_row = -1;
#line 642 "tracker-array-cursor.c"
}

static void
tracker_bus_array_cursor_finalize (GObject * obj)
{
	TrackerBusArrayCursor * self;
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursor);
#line 23 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->results = (_vala_array_free (self->priv->results, self->priv->results_length1 * self->priv->results_length2, (GDestroyNotify) g_free), NULL);
#line 24 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->var_names = (_vala_array_free (self->priv->var_names, self->priv->var_names_length1, (GDestroyNotify) g_free), NULL);
#line 25 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	self->priv->types = (g_free (self->priv->types), NULL);
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	G_OBJECT_CLASS (tracker_bus_array_cursor_parent_class)->finalize (obj);
#line 659 "tracker-array-cursor.c"
}

static GType
tracker_bus_array_cursor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerBusArrayCursorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_bus_array_cursor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerBusArrayCursor), 0, (GInstanceInitFunc) tracker_bus_array_cursor_instance_init, NULL };
	GType tracker_bus_array_cursor_type_id;
	tracker_bus_array_cursor_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CURSOR, "TrackerBusArrayCursor", &g_define_type_info, 0);
	TrackerBusArrayCursor_private_offset = g_type_add_instance_private (tracker_bus_array_cursor_type_id, sizeof (TrackerBusArrayCursorPrivate));
	return tracker_bus_array_cursor_type_id;
}

GType
tracker_bus_array_cursor_get_type (void)
{
	static volatile gsize tracker_bus_array_cursor_type_id__once = 0;
	if (g_once_init_enter (&tracker_bus_array_cursor_type_id__once)) {
		GType tracker_bus_array_cursor_type_id;
		tracker_bus_array_cursor_type_id = tracker_bus_array_cursor_get_type_once ();
		g_once_init_leave (&tracker_bus_array_cursor_type_id__once, tracker_bus_array_cursor_type_id);
	}
	return tracker_bus_array_cursor_type_id__once;
}

static void
_vala_tracker_bus_array_cursor_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	TrackerBusArrayCursor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursor);
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
	switch (property_id) {
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		case TRACKER_BUS_ARRAY_CURSOR_N_COLUMNS_PROPERTY:
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		g_value_set_int (value, tracker_sparql_cursor_get_n_columns ((TrackerSparqlCursor*) self));
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		break;
#line 700 "tracker-array-cursor.c"
		default:
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "../tracker/src/libtracker-bus/tracker-array-cursor.vala"
		break;
#line 706 "tracker-array-cursor.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

