"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSvelteSys = createSvelteSys;
const utils_1 = require("./utils");
/**
 * This should only be accessed by TS svelte module resolution.
 */
function createSvelteSys(ts, logger) {
    const svelteSys = {
        ...ts.sys,
        fileExists(path) {
            return ts.sys.fileExists((0, utils_1.ensureRealSvelteFilePath)(path));
        },
        readDirectory(path, extensions, exclude, include, depth) {
            const extensionsWithSvelte = (extensions ?? []).concat('.svelte');
            return ts.sys.readDirectory(path, extensionsWithSvelte, exclude, include, depth);
        },
        readFile(path, encoding) {
            // imba typescript plugin patch this with Object.defineProperty
            // and copying the property descriptor from a class that extends the original ts.sys
            // so we explicitly define it here
            return ts.sys.readFile(path, encoding);
        }
    };
    if (ts.sys.realpath) {
        const realpath = ts.sys.realpath;
        svelteSys.realpath = function (path) {
            if ((0, utils_1.isVirtualSvelteFilePath)(path)) {
                return realpath((0, utils_1.toRealSvelteFilePath)(path));
            }
            return realpath(path);
        };
    }
    return svelteSys;
}
//# sourceMappingURL=svelte-sys.js.map