/**
 * ./src/krill/modules/umount.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 * https://stackoverflow.com/questions/23876782/how-do-i-split-a-typescript-class-into-multiple-files
 */
import Utils from '../../../classes/utils.js';
import { exec } from '../../../lib/utils.js';
/**
 *
 * @param mountpoint
 */
export default async function umount(mountPoint = '') {
    let message = 'umount: ' + mountPoint;
    if (Utils.isMountpoint(mountPoint)) {
        const cmd = `umount -l ${mountPoint} ${this.toNull}`;
        try {
            await exec(cmd, this.echo);
            await exec('sleep 1', this.echo);
        }
        catch (error) {
            message += cmd + (error instanceof Error ? error.message : JSON.stringify(error));
            await Utils.pressKeyToExit(message, true);
        }
    }
}
