/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.Resource;

public class BuildBase
extends PluginConfiguration
implements Serializable,
Cloneable {
    private String defaultGoal;
    private List<Resource> resources;
    private List<Resource> testResources;
    private String directory;
    private String finalName;
    private List<String> filters;

    public void addFilter(String string2) {
        this.getFilters().add(string2);
    }

    public void addResource(Resource resource2) {
        this.getResources().add(resource2);
    }

    public void addTestResource(Resource resource2) {
        this.getTestResources().add(resource2);
    }

    @Override
    public BuildBase clone() {
        try {
            BuildBase copy2 = (BuildBase)super.clone();
            if (this.resources != null) {
                copy2.resources = new ArrayList<Resource>();
                for (Resource item : this.resources) {
                    copy2.resources.add(item.clone());
                }
            }
            if (this.testResources != null) {
                copy2.testResources = new ArrayList<Resource>();
                for (Resource item : this.testResources) {
                    copy2.testResources.add(item.clone());
                }
            }
            if (this.filters != null) {
                copy2.filters = new ArrayList<String>();
                copy2.filters.addAll(this.filters);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getDefaultGoal() {
        return this.defaultGoal;
    }

    public String getDirectory() {
        return this.directory;
    }

    public List<String> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<String>();
        }
        return this.filters;
    }

    public String getFinalName() {
        return this.finalName;
    }

    public List<Resource> getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList<Resource>();
        }
        return this.resources;
    }

    public List<Resource> getTestResources() {
        if (this.testResources == null) {
            this.testResources = new ArrayList<Resource>();
        }
        return this.testResources;
    }

    public void removeFilter(String string2) {
        this.getFilters().remove(string2);
    }

    public void removeResource(Resource resource2) {
        this.getResources().remove(resource2);
    }

    public void removeTestResource(Resource resource2) {
        this.getTestResources().remove(resource2);
    }

    public void setDefaultGoal(String defaultGoal) {
        this.defaultGoal = defaultGoal;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    public void setFinalName(String finalName) {
        this.finalName = finalName;
    }

    public void setResources(List<Resource> resources2) {
        this.resources = resources2;
    }

    public void setTestResources(List<Resource> testResources) {
        this.testResources = testResources;
    }

    @Override
    public String toString() {
        return "BuildBase {" + super.toString() + "}";
    }
}

