##  <#GAPDoc Label="Saturate:example">
##  <Example><![CDATA[
##  gap> zz := HomalgRingOfIntegers( );
##  Z
##  gap> Display( zz );
##  <An internal ring>
##  gap> m := LeftSubmodule( "2", zz );
##  <A principal (left) ideal given by a cyclic generator>
##  gap> Display( m );
##  [ [  2 ] ]
##  
##  A (left) ideal generated by the entry of the above matrix
##  gap> J := LeftSubmodule( "3", zz );
##  <A principal (left) ideal given by a cyclic generator>
##  gap> Display( J );
##  [ [  3 ] ]
##  
##  A (left) ideal generated by the entry of the above matrix
##  gap> I := Intersect( J, m^3 );
##  <A principal (left) ideal given by a cyclic generator>
##  gap> Display( I );
##  [ [  24 ] ]
##  
##  A (left) ideal generated by the entry of the above matrix
##  gap> Im := SubobjectQuotient( I, m );
##  <A principal (left) ideal of rank 1 given by a free generator>
##  gap> Display( Im );
##  [ [  -12 ] ]
##  
##  A (left) ideal generated by the entry of the above matrix
##  gap> I_m := Saturate( I, m );
##  <A principal (left) ideal of rank 1 given by a free generator>
##  gap> Display( I_m );
##  [ [  -3 ] ]
##  
##  A (left) ideal generated by the entry of the above matrix
##  gap> I_m = J;
##  true
##  ]]></Example>
##  <#/GAPDoc>

LoadPackage( "Modules" );

zz := HomalgRingOfIntegers( );

m := LeftSubmodule( "2", zz );

J := LeftSubmodule( "3", zz );

I := Intersect( J, m^3 );

Im := SubobjectQuotient( I, m );

I_m := Saturate( I, m );
