/* libgda-6.0.vapi generated by vapigen-0.56, do not modify. */

[CCode (cprefix = "Gda", gir_namespace = "Gda", gir_version = "6.0", lower_case_cprefix = "gda_")]
namespace Gda {
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_batch_get_type ()")]
	public class Batch : GLib.Object {
		[CCode (has_construct_function = false)]
		public Batch ();
		public void add_statement (owned Gda.Statement stmt);
		public Gda.Batch copy ();
		public static GLib.Quark error_quark ();
		public bool get_parameters (out Gda.Set? out_params) throws GLib.Error;
		public unowned GLib.SList<Gda.Statement> get_statements ();
		public void remove_statement (Gda.Statement stmt);
		public string serialize ();
		public virtual signal void changed (GLib.Object changed_stmt);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_binary_get_type ()")]
	[Compact]
	public class Binary {
		[CCode (has_construct_function = false)]
		[Version (since = "6.0")]
		public Binary ();
		public Gda.Binary copy ();
		[DestroysInstance]
		public void free ();
		[Version (since = "6.0")]
		public void* get_data ();
		[Version (since = "6.0")]
		public long get_size ();
		[Version (since = "6.0")]
		public void reset_data ();
		[Version (since = "6.0")]
		public void set_data ([CCode (array_length_cname = "size", array_length_pos = 1.1, array_length_type = "glong")] uint8[] val);
		public void take_data ([CCode (array_length_cname = "size", array_length_pos = 1.1, array_length_type = "glong")] uint8[] val);
		public string to_string (uint maxlen);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_blob_get_type ()")]
	[Compact]
	public class Blob {
		[CCode (has_construct_function = false)]
		[Version (since = "6.0")]
		public Blob ();
		public Gda.Blob copy ();
		[DestroysInstance]
		public void free ();
		[Version (since = "6.0")]
		public unowned Gda.Binary get_binary ();
		[Version (since = "6.0")]
		public unowned Gda.BlobOp get_op ();
		public void set_op (Gda.BlobOp? op);
		public string to_string (uint maxlen);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_blob_op_get_type ()")]
	public class BlobOp : GLib.Object {
		[CCode (has_construct_function = false)]
		protected BlobOp ();
		public long get_length ();
		public long read (Gda.Blob blob, long offset, long size);
		public bool read_all (Gda.Blob blob);
		public long write (Gda.Blob blob, long offset);
		public bool write_all (Gda.Blob blob);
		[NoAccessorMethod]
		public Gda.Connection connection { owned get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	[Compact]
	public abstract class BlobOpFunctions {
		public abstract long get_length (Gda.BlobOp op);
		public abstract long read (Gda.BlobOp op, Gda.Blob blob, long offset, long size);
		public abstract long write (Gda.BlobOp op, Gda.Blob blob, long offset);
		public abstract bool write_all (Gda.BlobOp op, Gda.Blob blob);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_column_get_type ()")]
	public class Column : GLib.Object {
		[CCode (has_construct_function = false)]
		public Column ();
		public Gda.Column copy ();
		public bool get_allow_null ();
		public bool get_auto_increment ();
		public unowned string get_dbms_type ();
		public unowned GLib.Value? get_default_value ();
		public unowned string get_description ();
		public GLib.Type get_g_type ();
		public unowned string get_name ();
		public int get_position ();
		public void set_allow_null (bool allow);
		public void set_auto_increment (bool is_auto);
		public void set_dbms_type (string dbms_type);
		public void set_default_value (GLib.Value? default_value);
		public void set_description (string descr);
		public void set_g_type (GLib.Type type);
		public void set_name (string name);
		public void set_position (int position);
		[NoAccessorMethod]
		public string desc { owned get; set; }
		[NoAccessorMethod]
		public string id { owned get; set; }
		public string name { get; set; }
		public virtual signal void g_type_changed (GLib.Type old_type, GLib.Type new_type);
		public virtual signal void name_changed (string old_name);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_config_get_type ()")]
	public class Config : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Config ();
		public static bool can_modify_system_config ();
		public static bool define_dsn (Gda.DsnInfo info) throws GLib.Error;
		public static bool dsn_needs_authentication (string dsn_name);
		public static GLib.Quark error_quark ();
		public static Gda.Config @get ();
		public static unowned Gda.DsnInfo get_dsn_info (string dsn_name);
		public static unowned Gda.DsnInfo get_dsn_info_at_index (int index);
		public static int get_dsn_info_index (string dsn_name);
		public static int get_nb_dsn ();
		public static unowned Gda.ServerProvider get_provider (string provider_name) throws GLib.Error;
		public static unowned Gda.ProviderInfo get_provider_info (string provider_name);
		public static Gda.DataModel list_dsn ();
		public static Gda.DataModel list_providers ();
		public static bool remove_dsn (string dsn_name) throws GLib.Error;
		[NoAccessorMethod]
		public string system_filename { owned get; set; }
		[NoAccessorMethod]
		public string user_filename { owned get; set; }
		public virtual signal void dsn_added (void* new_dsn);
		public virtual signal void dsn_changed (void* dsn);
		public virtual signal void dsn_removed (void* old_dsn);
		public virtual signal void dsn_to_be_removed (void* old_dsn);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_connection_get_type ()")]
	public class Connection : GLib.Object, Gda.Lockable {
		[CCode (has_construct_function = false)]
		protected Connection ();
		public void add_event (owned Gda.ConnectionEvent event);
		public void add_prepared_statement (Gda.Statement gda_stmt, Gda.PStmt prepared_stmt);
		public bool add_savepoint (string? name) throws GLib.Error;
		public GLib.SList<GLib.Object> batch_execute (Gda.Batch batch, Gda.Set? @params, Gda.StatementModelUsage model_usage) throws GLib.Error;
		public bool begin_transaction (string? name, Gda.TransactionIsolation level) throws GLib.Error;
		public void clear_events_list ();
		public bool close () throws GLib.Error;
		public bool commit_transaction (string? name) throws GLib.Error;
		[Version (since = "6.0")]
		public Gda.DbCatalog create_db_catalog ();
		public Gda.ServerOperation create_operation (Gda.ServerOperationType type, Gda.Set? options) throws GLib.Error;
		public Gda.SqlParser create_parser ();
		public void del_prepared_statement (Gda.Statement gda_stmt);
		[Version (since = "4.2.3")]
		public bool delete_row_from_table (string table, string condition_column_name, GLib.Value condition_value) throws GLib.Error;
		public bool delete_savepoint (string? name) throws GLib.Error;
		public static GLib.Quark error_quark ();
		[Version (since = "4.2.3")]
		public int execute_non_select_command (string sql) throws GLib.Error;
		[Version (since = "4.2.3")]
		public Gda.DataModel execute_select_command (string sql) throws GLib.Error;
		[CCode (has_construct_function = false)]
		[Version (since = "6.0")]
		public Connection.from_dsn (Gda.DsnInfo dsn, string? auth_string, Gda.ConnectionOptions options) throws GLib.Error;
		[CCode (has_construct_function = false)]
		[Version (since = "6.0")]
		public Connection.from_dsn_name (string dsn_name, string? auth_string, Gda.ConnectionOptions options) throws GLib.Error;
		[CCode (has_construct_function = false)]
		[Version (since = "5.0.2")]
		public Connection.from_string (string? provider_name, string cnc_string, string? auth_string, Gda.ConnectionOptions options) throws GLib.Error;
		public unowned string get_authentication ();
		public unowned string get_cnc_string ();
		[Version (since = "5.2")]
		public bool get_date_format (out GLib.DateDMY? out_first, out GLib.DateDMY? out_second, out GLib.DateDMY? out_third, out string? out_sep) throws GLib.Error;
		public unowned string get_dsn ();
		public unowned GLib.List<Gda.ConnectionEvent> get_events ();
		[Version (since = "6.0")]
		public unowned GLib.MainContext get_main_context (GLib.Thread? thread);
		public unowned Gda.MetaStore get_meta_store ();
		public Gda.DataModel get_meta_store_data_v (Gda.ConnectionMetaType meta_type, GLib.List<Gda.Holder> filters) throws GLib.Error;
		public Gda.ConnectionOptions get_options ();
		public unowned Gda.PStmt get_prepared_statement (Gda.Statement gda_stmt);
		public unowned Gda.ServerProvider get_provider ();
		public unowned string get_provider_name ();
		[Version (since = "6.0")]
		public Gda.ConnectionStatus get_status ();
		public unowned Gda.TransactionStatus get_transaction_status ();
		[Version (since = "4.2.3")]
		public bool insert_row_into_table_v (string table, GLib.SList<string> col_names, GLib.SList<GLib.Value?> values) throws GLib.Error;
		public void internal_change_transaction_state (Gda.TransactionStatusState newstate);
		[Version (since = "5.0.2")]
		public Gda.ServerProviderConnectionData? internal_get_provider_data_error () throws GLib.Error;
		public static unowned Gda.Worker internal_get_worker (Gda.ServerProviderConnectionData? data);
		public void internal_reset_transaction_status ();
		public void internal_savepoint_added (string? parent_trans, string svp_name);
		public void internal_savepoint_removed (string? svp_name);
		public void internal_savepoint_rolledback (string? svp_name);
		public void internal_set_provider_data (Gda.ServerProviderConnectionData data, GLib.DestroyNotify destroy_func);
		public void internal_statement_executed (Gda.Statement stmt, Gda.Set? @params, Gda.ConnectionEvent error);
		public void internal_transaction_committed (string? trans_name);
		public void internal_transaction_rolledback (string? trans_name);
		public void internal_transaction_started (string? parent_trans, string trans_name, Gda.TransactionIsolation isol_level);
		public bool is_opened ();
		public bool open () throws GLib.Error;
		[Version (since = "6.0")]
		public uint open_async (Gda.ConnectionOpenFunc callback) throws GLib.Error;
		[Version (since = "6.0")]
		public static Gda.Connection open_from_dsn (Gda.DsnInfo dsn, string? auth_string, Gda.ConnectionOptions options) throws GLib.Error;
		public static Gda.Connection open_from_dsn_name (string dsn_name, string? auth_string, Gda.ConnectionOptions options) throws GLib.Error;
		public static Gda.Connection open_from_string (string? provider_name, string cnc_string, string? auth_string, Gda.ConnectionOptions options) throws GLib.Error;
		public static Gda.Connection open_sqlite (string? directory, string filename, bool auto_unlink);
		[Version (since = "6.0")]
		public string? operation_get_sql_identifier_at_path (Gda.ServerOperation op, string path) throws GLib.Error;
		[Version (since = "4.2.3")]
		public Gda.Statement parse_sql_string (string sql, out Gda.Set? @params = null) throws GLib.Error;
		public bool perform_operation (Gda.ServerOperation op) throws GLib.Error;
		[Version (since = "4.2")]
		public Gda.ConnectionEvent point_available_event (Gda.ConnectionEventType type);
		[Version (since = "6.0")]
		public Gda.ServerOperation? prepare_operation_create_table (string table_name, GLib.List<Gda.ServerOperationCreateTableArg> arguments) throws GLib.Error;
		[Version (since = "6.0")]
		public Gda.ServerOperation? prepare_operation_drop_table (string table_name) throws GLib.Error;
		[Version (since = "4.0.3")]
		public string quote_sql_identifier (string id);
		[Version (since = "4.2")]
		public GLib.SList<GLib.Object> repetitive_statement_execute (Gda.RepetitiveStatement rstmt, Gda.StatementModelUsage model_usage, [CCode (array_length = false)] GLib.Type[]? col_types, bool stop_on_error) throws GLib.Error;
		public bool rollback_savepoint (string? name) throws GLib.Error;
		public bool rollback_transaction (string? name) throws GLib.Error;
		[Version (since = "6.0")]
		public void set_main_context (GLib.Thread? thread, GLib.MainContext? context);
		public GLib.Object statement_execute (Gda.Statement stmt, Gda.Set? @params, Gda.StatementModelUsage model_usage, out Gda.Set? last_insert_row = null) throws GLib.Error;
		public int statement_execute_non_select (Gda.Statement stmt, Gda.Set? @params = null, out Gda.Set? last_insert_row = null) throws GLib.Error;
		public Gda.DataModel statement_execute_select (Gda.Statement stmt, Gda.Set? @params = null) throws GLib.Error;
		public Gda.DataModel statement_execute_select_full (Gda.Statement stmt, Gda.Set? @params, Gda.StatementModelUsage model_usage, [CCode (array_length = false)] GLib.Type[]? col_types = null) throws GLib.Error;
		public bool statement_prepare (Gda.Statement stmt) throws GLib.Error;
		public string statement_to_sql (Gda.Statement stmt, Gda.Set? @params, Gda.StatementSqlFlag flags, out GLib.SList<weak Gda.Holder>? params_used) throws GLib.Error;
		public static void string_split (string string, out string out_cnc_params, out string out_provider, out string out_username, out string out_password);
		public bool supports_feature (Gda.ConnectionFeature feature);
		public bool update_meta_store (Gda.MetaContext? context) throws GLib.Error;
		[Version (since = "4.2.3")]
		public bool update_row_in_table_v (string table, string condition_column_name, GLib.Value condition_value, GLib.SList<string> col_names, GLib.SList<GLib.Value?> values) throws GLib.Error;
		public string value_to_sql_string (GLib.Value from);
		[NoAccessorMethod]
		public string auth_string { owned get; set; }
		[NoAccessorMethod]
		public string cnc_string { owned get; set; }
		[NoAccessorMethod]
		public string dsn { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "4.2")]
		public int events_history_size { get; set; }
		[NoAccessorMethod]
		[Version (since = "5.2.0")]
		public uint execution_slowdown { get; set; }
		[NoAccessorMethod]
		[Version (since = "4.2.9")]
		public bool execution_timer { get; set; }
		[NoAccessorMethod]
		public Gda.MetaStore meta_store { owned get; set; }
		[NoAccessorMethod]
		public Gda.ServerProvider provider { owned get; set; }
		public virtual signal void closed ();
		public virtual signal void dsn_changed ();
		public virtual signal void error (Gda.ConnectionEvent error);
		public virtual signal void opened ();
		[Version (since = "6.0")]
		public virtual signal void status_changed (Gda.ConnectionStatus status);
		public virtual signal void transaction_status_changed ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_connection_event_get_type ()")]
	public class ConnectionEvent : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ConnectionEvent ();
		public long get_code ();
		public unowned string get_description ();
		public Gda.ConnectionEventType get_event_type ();
		public Gda.ConnectionEventCode get_gda_code ();
		public unowned string get_source ();
		public unowned string get_sqlstate ();
		public void set_code (long code);
		public void set_description (string? description);
		public void set_event_type (Gda.ConnectionEventType type);
		public void set_gda_code (Gda.ConnectionEventCode code);
		public void set_source (string source);
		public void set_sqlstate (string sqlstate);
		[NoAccessorMethod]
		public int type { get; set; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_data_access_wrapper_get_type ()")]
	public class DataAccessWrapper : GLib.Object, Gda.DataModel {
		[CCode (has_construct_function = false)]
		protected DataAccessWrapper ();
		public static Gda.DataModel @new (Gda.DataModel model);
		[Version (since = "5.2")]
		public bool set_mapping ([CCode (array_length_cname = "mapping_size", array_length_pos = 1.1)] int[]? mapping);
		[NoAccessorMethod]
		public Gda.DataModel model { owned get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_data_comparator_get_type ()")]
	public class DataComparator : GLib.Object {
		[CCode (has_construct_function = false, type = "GObject*")]
		public DataComparator (Gda.DataModel old_model, Gda.DataModel new_model);
		public bool compute_diff () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public unowned Gda.Diff get_diff (int pos);
		public int get_n_diffs ();
		public void set_key_columns ([CCode (array_length_cname = "nb_cols", array_length_pos = 1.1)] int[] col_numbers);
		[NoAccessorMethod]
		public Gda.DataModel new_model { owned get; set; }
		[NoAccessorMethod]
		public Gda.DataModel old_model { owned get; set; }
		public virtual signal bool diff_computed (void* diff);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_data_model_array_get_type ()")]
	public class DataModelArray : GLib.Object, Gda.DataModel {
		[CCode (has_construct_function = false)]
		protected DataModelArray ();
		public void clear ();
		public unowned Gda.Row get_row (int row) throws GLib.Error;
		public static Gda.DataModel @new (int cols);
		[Version (since = "4.2.6")]
		public static Gda.DataModel new_with_g_types_v (int cols, [CCode (array_length = false)] GLib.Type[] types);
		public void set_n_columns (int cols);
		[NoAccessorMethod]
		public uint n_columns { get; set; }
		[NoAccessorMethod]
		public bool read_only { get; set; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_data_model_dir_get_type ()")]
	public class DataModelDir : GLib.Object, Gda.DataModel {
		[CCode (has_construct_function = false)]
		protected DataModelDir ();
		public void clean_errors ();
		public unowned GLib.SList<GLib.Error> get_errors ();
		public static Gda.DataModel @new (string basedir);
		[NoAccessorMethod]
		public string basedir { owned get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_data_model_import_get_type ()")]
	public class DataModelImport : GLib.Object, Gda.DataModel {
		[CCode (has_construct_function = false)]
		protected DataModelImport ();
		public void clean_errors ();
		public unowned GLib.SList<GLib.Error> get_errors ();
		public static Gda.DataModel new_file (string filename, bool random_access, Gda.Set? options);
		public static Gda.DataModel new_mem (string data, bool random_access, Gda.Set? options);
		public static Gda.DataModel new_xml_node ([CCode (type = "xmlNodePtr")] Xml.Node* node);
		[NoAccessorMethod]
		public string data_string { owned get; construct; }
		[NoAccessorMethod]
		public string filename { owned get; construct; }
		[NoAccessorMethod]
		public Gda.Set options { owned get; construct; }
		[NoAccessorMethod]
		public bool random_access { get; construct; }
		[NoAccessorMethod]
		[Version (since = "4.2.1")]
		public bool strict { get; set construct; }
		[NoAccessorMethod]
		public void* xml_node { get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_data_model_import_iter_get_type ()")]
	public class DataModelImportIter : Gda.DataModelIter {
		[CCode (has_construct_function = false)]
		protected DataModelImportIter ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_data_model_iter_get_type ()")]
	public class DataModelIter : Gda.Set {
		[CCode (has_construct_function = false)]
		protected DataModelIter ();
		public static GLib.Quark error_quark ();
		public unowned Gda.Holder get_holder_for_field (int col);
		public int get_row ();
		public unowned GLib.Value? get_value_at (int col);
		[Version (since = "4.2.10")]
		public unowned GLib.Value? get_value_at_e (int col) throws GLib.Error;
		public unowned GLib.Value? get_value_for_field (string field_name);
		public void invalidate_contents ();
		public bool is_valid ();
		public virtual bool move_next ();
		public virtual bool move_prev ();
		public virtual bool move_to_row (int row);
		public virtual bool set_value_at (int col, GLib.Value value) throws GLib.Error;
		[NoAccessorMethod]
		public int current_row { get; set; }
		[NoAccessorMethod]
		public Gda.DataModel data_model { owned get; set construct; }
		[NoAccessorMethod]
		public bool update_model { get; set; }
		public virtual signal void end_of_data ();
		public virtual signal void row_changed (int row);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_data_model_select_get_type ()")]
	public class DataModelSelect : GLib.Object, Gda.DataModel {
		[CCode (has_construct_function = false)]
		public DataModelSelect (Gda.Connection cnc, Gda.Statement stm, Gda.Set? @params);
		[CCode (has_construct_function = false)]
		public DataModelSelect.from_string (Gda.Connection cnc, string sql);
		public Gda.Set get_parameters ();
		public bool is_valid ();
		public void set_parameters (Gda.Set @params);
		[NoAccessorMethod]
		public bool valid { get; }
		public virtual signal void updated ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_data_pivot_get_type ()")]
	public class DataPivot : GLib.Object, Gda.DataModel {
		[CCode (has_construct_function = false)]
		protected DataPivot ();
		[Version (since = "5.0")]
		public bool add_data (Gda.DataPivotAggregate aggregate_type, string field, string? alias) throws GLib.Error;
		[Version (since = "5.0")]
		public bool add_field (Gda.DataPivotFieldType field_type, string field, string? alias) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public static Gda.DataModel @new (Gda.DataModel? model);
		[Version (since = "5.0")]
		public bool populate () throws GLib.Error;
		[NoAccessorMethod]
		public Gda.DataModel model { owned get; set; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_data_proxy_get_type ()")]
	public class DataProxy : GLib.Object, Gda.DataModel {
		[CCode (has_construct_function = false, type = "GObject*")]
		public DataProxy (Gda.DataModel model);
		public void alter_value_attributes (int proxy_row, int col, Gda.ValueAttribute alter_flags);
		public bool apply_all_changes () throws GLib.Error;
		public bool apply_row_changes (int proxy_row) throws GLib.Error;
		public bool cancel_all_changes ();
		public void cancel_row_changes (int proxy_row, int col);
		public void @delete (int proxy_row);
		public static GLib.Quark error_quark ();
		public unowned string get_filter_expr ();
		public int get_filtered_n_rows ();
		public int get_n_modified_rows ();
		public int get_n_new_rows ();
		public unowned Gda.DataModel get_proxied_model ();
		public int get_proxied_model_n_cols ();
		public int get_proxied_model_n_rows ();
		public int get_proxied_model_row (int proxy_row);
		public int get_sample_end ();
		public int get_sample_size ();
		public int get_sample_start ();
		public Gda.ValueAttribute get_value_attributes (int proxy_row, int col);
		public GLib.SList<weak GLib.Value?> get_values (int proxy_row, [CCode (array_length_cname = "n_cols", array_length_pos = 2.1)] int[] cols_index);
		public bool has_changed ();
		public bool is_read_only ();
		public bool row_has_changed (int proxy_row);
		public bool row_is_deleted (int proxy_row);
		public bool row_is_inserted (int proxy_row);
		public bool set_filter_expr (string? filter_expr) throws GLib.Error;
		public bool set_ordering_column (int col) throws GLib.Error;
		public void set_sample_size (int sample_size);
		public void set_sample_start (int sample_start);
		public void undelete (int proxy_row);
		[CCode (has_construct_function = false)]
		[Version (since = "5.2.0")]
		public DataProxy.with_data_model (Gda.DataModel model);
		[NoAccessorMethod]
		[Version (since = "5.2")]
		public bool cache_changes { get; set; }
		[NoAccessorMethod]
		public bool defer_sync { get; set; }
		[NoAccessorMethod]
		public Gda.DataModel model { owned get; set construct; }
		[NoAccessorMethod]
		public bool prepend_null_entry { get; set; }
		public int sample_size { get; set construct; }
		public virtual signal void filter_changed ();
		public virtual signal void row_changes_applied (int row, int proxied_row);
		public virtual signal void row_delete_changed (int row, bool to_be_deleted);
		public virtual signal void sample_changed (int sample_start, int sample_end);
		public virtual signal void sample_size_changed (int sample_size);
		public virtual signal GLib.Error validate_row_changes (int row, int proxied_row);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_data_select_get_type ()")]
	public class DataSelect : GLib.Object, Gda.DataModel {
		[CCode (has_construct_function = false)]
		protected DataSelect ();
		public bool compute_columns_attributes () throws GLib.Error;
		public bool compute_modification_statements () throws GLib.Error;
		[Version (since = "4.2.9")]
		public bool compute_modification_statements_ext (Gda.DataSelectConditionType cond_type) throws GLib.Error;
		public bool compute_row_selection_condition () throws GLib.Error;
		public static GLib.Quark error_quark ();
		[NoWrapper]
		public virtual bool fetch_at (Gda.Row prow, int rownum) throws GLib.Error;
		[NoWrapper]
		public virtual int fetch_nb_rows ();
		[NoWrapper]
		public virtual bool fetch_next (Gda.Row prow, int rownum) throws GLib.Error;
		[NoWrapper]
		public virtual bool fetch_prev (Gda.Row prow, int rownum) throws GLib.Error;
		[NoWrapper]
		public virtual bool fetch_random (Gda.Row prow, int rownum) throws GLib.Error;
		public int get_advertized_nrows ();
		public unowned Gda.Connection get_connection ();
		public int get_nb_stored_rows ();
		public unowned Gda.PStmt get_prep_stmt ();
		[Version (since = "5.2.0")]
		public bool prepare_for_offline () throws GLib.Error;
		public void set_advertized_nrows (int n);
		public bool set_modification_statement (Gda.Statement mod_stmt) throws GLib.Error;
		public bool set_modification_statement_sql (string sql) throws GLib.Error;
		public bool set_row_selection_condition (Gda.SqlExpr expr) throws GLib.Error;
		public bool set_row_selection_condition_sql (string sql_where) throws GLib.Error;
		[NoWrapper]
		public virtual bool store_all () throws GLib.Error;
		public Gda.Connection connection { get; construct; }
		[NoAccessorMethod]
		public Gda.Statement delete_stmt { owned get; set; }
		[NoAccessorMethod]
		public Gda.Set exec_params { owned get; construct; }
		[NoAccessorMethod]
		[Version (since = "4.2.9")]
		public double execution_delay { get; set; }
		[NoAccessorMethod]
		public Gda.Statement insert_stmt { owned get; set; }
		[NoAccessorMethod]
		public uint model_usage { get; construct; }
		[NoAccessorMethod]
		public Gda.PStmt prepared_stmt { owned get; set; }
		[NoAccessorMethod]
		public Gda.Statement select_stmt { owned get; }
		[NoAccessorMethod]
		public bool store_all_rows { get; set; }
		[NoAccessorMethod]
		public Gda.Statement update_stmt { owned get; set; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_data_select_iter_get_type ()")]
	public class DataSelectIter : Gda.DataModelIter {
		[CCode (has_construct_function = false)]
		protected DataSelectIter ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_db_base_get_type ()")]
	public class DbBase : GLib.Object {
		[CCode (has_construct_function = false)]
		public DbBase ();
		[Version (since = "6.0")]
		public int compare (Gda.DbBase b);
		[Version (since = "6.0")]
		public unowned string get_catalog ();
		[Version (since = "6.0")]
		public unowned string get_full_name ();
		[Version (since = "6.0")]
		public unowned string get_name ();
		[Version (since = "6.0")]
		public unowned string get_schema ();
		[Version (since = "6.0")]
		public void set_catalog (string catalog);
		[Version (since = "6.0")]
		public void set_name (string name);
		[Version (since = "6.0")]
		public void set_names (string? catalog, string? schema, string name);
		[Version (since = "6.0")]
		public void set_schema (string schema);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_db_catalog_get_type ()")]
	public class DbCatalog : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "6.0")]
		public DbCatalog ();
		[Version (since = "6.0")]
		public void append_table (Gda.DbTable table);
		[Version (since = "6.0")]
		public void append_view (Gda.DbView view);
		public static GLib.Quark error_quark ();
		[Version (since = "6.2")]
		public unowned Gda.DbTable get_table (string catalog, string schema, string name);
		[Version (since = "6.0")]
		public unowned GLib.List<Gda.DbTable> get_tables ();
		[Version (since = "6.0")]
		public unowned Gda.DbView get_view (string catalog, string schema, string name);
		[Version (since = "6.0")]
		public unowned GLib.List<Gda.DbView> get_views ();
		[Version (since = "6.0")]
		public bool parse_cnc () throws GLib.Error;
		[Version (since = "6.0")]
		public bool parse_file (GLib.File xmlfile) throws GLib.Error;
		public bool parse_file_from_path (string xmlfile) throws GLib.Error;
		public bool perform_operation () throws GLib.Error;
		[Version (since = "6.0")]
		public static bool validate_file_from_path (string xmlfile) throws GLib.Error;
		[Version (since = "6.0")]
		public bool write_to_file (GLib.File file) throws GLib.Error;
		[Version (since = "6.0")]
		public bool write_to_path (string path) throws GLib.Error;
		[NoAccessorMethod]
		public Gda.Connection connection { owned get; set; }
		[NoAccessorMethod]
		public string schema_name { owned get; set; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_db_column_get_type ()")]
	public class DbColumn : GLib.Object, Gda.DbBuildable, Gda.DdlModifiable {
		[CCode (has_construct_function = false)]
		[Version (since = "6.0")]
		public DbColumn ();
		public static GLib.Quark error_quark ();
		[Version (since = "6.0")]
		public bool get_autoinc ();
		[Version (since = "6.0")]
		public unowned string get_check ();
		[Version (since = "6.0")]
		public unowned string get_comment ();
		[Version (since = "6.0")]
		public unowned string get_ctype ();
		[Version (since = "6.0")]
		public unowned string get_default ();
		[Version (since = "6.0")]
		public GLib.Type get_gtype ();
		[Version (since = "6.0")]
		public unowned string get_name ();
		[Version (since = "6.0")]
		public bool get_nnul ();
		[Version (since = "6.0")]
		public bool get_pkey ();
		[Version (since = "6.0")]
		public uint get_scale ();
		[Version (since = "6.0")]
		public uint get_size ();
		[Version (since = "6.0")]
		public bool get_unique ();
		[Version (since = "6.0")]
		public bool prepare_add (Gda.ServerOperation op) throws GLib.Error;
		[Version (since = "6.0")]
		public bool prepare_create (Gda.ServerOperation op, uint order) throws GLib.Error;
		[Version (since = "6.0")]
		public void set_autoinc (bool autoinc);
		[Version (since = "6.0")]
		public void set_check (string value);
		[Version (since = "6.0")]
		public void set_comment (string comnt);
		[Version (since = "6.0")]
		public void set_default (string value);
		[Version (since = "6.0")]
		public void set_name (string name);
		[Version (since = "6.0")]
		public void set_nnul (bool nnul);
		[Version (since = "6.0")]
		public void set_pkey (bool pkey);
		[Version (since = "6.0")]
		public void set_scale (uint scale);
		[Version (since = "6.0")]
		public void set_size (uint size);
		[Version (since = "6.0")]
		public void set_type (GLib.Type type);
		[Version (since = "6.0")]
		public void set_unique (bool unique);
		public bool autoinc { get; set; }
		public string check { get; set; }
		public string comment { get; set; }
		public string @default { get; set; }
		public string name { get; set; }
		public bool nnul { get; set; }
		public bool pkey { get; set; }
		public uint scale { get; set; }
		public uint size { get; set; }
		[NoAccessorMethod]
		public Gda.DbTable table { owned get; set; }
		public bool unique { get; set; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_db_fkey_get_type ()")]
	public class DbFkey : GLib.Object, Gda.DbBuildable {
		[CCode (has_construct_function = false)]
		[Version (since = "6.0")]
		public DbFkey ();
		[Version (since = "6.0")]
		public unowned GLib.List<string> get_field_name ();
		[Version (since = "6.0")]
		public unowned string get_ondelete ();
		[Version (since = "6.0")]
		public Gda.DbFkeyReferenceAction get_ondelete_id ();
		[Version (since = "6.0")]
		public unowned string get_onupdate ();
		[Version (since = "6.0")]
		public Gda.DbFkeyReferenceAction get_onupdate_id ();
		[Version (since = "6.0")]
		public unowned GLib.List<string> get_ref_field ();
		[Version (since = "6.0")]
		public unowned string get_ref_table ();
		[Version (since = "6.0")]
		public bool prepare_create (Gda.ServerOperation op, int i) throws GLib.Error;
		[Version (since = "6.0")]
		public void set_field (string field, string reffield);
		[Version (since = "6.0")]
		public void set_ondelete (Gda.DbFkeyReferenceAction id);
		[Version (since = "6.0")]
		public void set_onupdate (Gda.DbFkeyReferenceAction id);
		[Version (since = "6.0")]
		public void set_ref_table (string rtable);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_db_index_get_type ()")]
	public class DbIndex : Gda.DbBase, Gda.DdlModifiable {
		[CCode (has_construct_function = false)]
		public DbIndex ();
		[Version (since = "6.0")]
		public void append_field (Gda.DbIndexField field);
		public static GLib.Quark error_quark ();
		[Version (since = "6.0")]
		public unowned GLib.SList<Gda.DbIndexField>? get_fields ();
		[Version (since = "6.0")]
		public bool get_unique ();
		[Version (since = "6.0")]
		public void remove_field (string name);
		[Version (since = "6.0")]
		public void set_unique (bool val);
		[NoAccessorMethod]
		public Gda.DbTable table { owned get; set; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_db_index_field_get_type ()")]
	public class DbIndexField : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "6.0")]
		public DbIndexField ();
		[Version (since = "6.0")]
		public unowned string get_collate ();
		[Version (since = "6.0")]
		public unowned Gda.DbColumn get_column ();
		[Version (since = "6.0")]
		public Gda.DbIndexSortOrder get_sort_order ();
		[Version (since = "6.0")]
		public unowned string get_sort_order_str ();
		[Version (since = "6.0")]
		public void set_collate (string collate);
		[Version (since = "6.0")]
		public void set_column (Gda.DbColumn column);
		[Version (since = "6.0")]
		public void set_sort_order (Gda.DbIndexSortOrder sorder);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_db_table_get_type ()")]
	public class DbTable : Gda.DbBase, Gda.DbBuildable, Gda.DdlModifiable {
		[CCode (has_construct_function = false)]
		[Version (since = "6.0")]
		public DbTable ();
		[Version (since = "6.0")]
		public void append_column (Gda.DbColumn column);
		[Version (since = "6.0")]
		public void append_constraint (string constr);
		[Version (since = "6.0")]
		public void append_fkey (Gda.DbFkey fkey);
		public static GLib.Quark error_quark ();
		[Version (since = "6.0")]
		public unowned GLib.List<Gda.DbColumn> get_columns ();
		[Version (since = "6.0")]
		public unowned GLib.List<Gda.DbFkey> get_fkeys ();
		public bool get_is_temp ();
		[Version (since = "6.0")]
		public bool is_valid ();
		[Version (since = "6.0")]
		public bool prepare_create (Gda.ServerOperation op, bool ifnotexists) throws GLib.Error;
		[Version (since = "6.0")]
		public void set_is_temp (bool istemp);
		public bool update (Gda.MetaTable obj, Gda.Connection cnc) throws GLib.Error;
		[NoAccessorMethod]
		public string comment { owned get; set; }
		[NoAccessorMethod]
		public string istemp { owned get; set; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_db_view_get_type ()")]
	public class DbView : Gda.DbBase, Gda.DbBuildable, Gda.DdlModifiable {
		[CCode (has_construct_function = false)]
		[Version (since = "6.0")]
		public DbView ();
		[Version (since = "6.0")]
		public unowned string get_defstring ();
		[Version (since = "6.0")]
		public bool get_ifnoexist ();
		[Version (since = "6.0")]
		public bool get_istemp ();
		[Version (since = "6.0")]
		public bool get_replace ();
		public bool prepare_create (Gda.ServerOperation op) throws GLib.Error;
		[Version (since = "6.0")]
		public void set_defstring (string str);
		[Version (since = "6.0")]
		public void set_ifnoexist (bool noexist);
		[Version (since = "6.0")]
		public void set_istemp (bool temp);
		[Version (since = "6.0")]
		public void set_replace (bool replace);
		public string defstring { get; set; }
		public bool ifnoexist { get; set; }
		public bool istemp { get; set; }
		public bool replace { get; set; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_default_get_type ()")]
	[Compact]
	public class Default {
		public static string? escape_string (string string);
		public static string? unescape_string (string string);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_diff_get_type ()")]
	[Compact]
	public class Diff {
		public int new_row;
		public int old_row;
		public Gda.DiffType type;
		public weak GLib.HashTable<void*,void*> values;
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_dsn_info_get_type ()")]
	[Compact]
	public class DsnInfo {
		public weak string auth_string;
		public weak string cnc_string;
		public weak string description;
		public bool is_system;
		public weak string name;
		public weak string provider;
		[CCode (has_construct_function = false)]
		[Version (since = "5.2")]
		public DsnInfo ();
		[Version (since = "5.2")]
		public Gda.DsnInfo copy ();
		public bool equal (Gda.DsnInfo? dsn2);
		[Version (since = "5.2")]
		public void free ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_geometric_point_get_type ()")]
	[Compact]
	public class GeometricPoint {
		[CCode (has_construct_function = false)]
		public GeometricPoint ();
		public Gda.GeometricPoint copy ();
		public void free ();
		public double get_x ();
		public double get_y ();
		public void set_x (double x);
		public void set_y (double y);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_handler_bin_get_type ()")]
	public class HandlerBin : GLib.Object, Gda.DataHandler {
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerBin ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_handler_boolean_get_type ()")]
	public class HandlerBoolean : GLib.Object, Gda.DataHandler {
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerBoolean ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_handler_numerical_get_type ()")]
	public class HandlerNumerical : GLib.Object, Gda.DataHandler {
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerNumerical ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_handler_string_get_type ()")]
	public class HandlerString : GLib.Object, Gda.DataHandler {
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerString ();
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerString.with_provider (Gda.ServerProvider prov, Gda.Connection? cnc);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_handler_text_get_type ()")]
	public class HandlerText : GLib.Object, Gda.DataHandler {
		[CCode (has_construct_function = false)]
		protected HandlerText ();
		public static Gda.DataHandler @new ();
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerText.with_connection (Gda.Connection? cnc);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_handler_time_get_type ()")]
	public class HandlerTime : GLib.Object, Gda.DataHandler {
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerTime ();
		public string get_format (GLib.Type type);
		[Version (since = "6.0")]
		public string get_hint (GLib.Type type);
		public string get_no_locale_str_from_value (GLib.Value value);
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerTime.no_locale ();
		public void set_sql_spec (GLib.DateDMY first, GLib.DateDMY sec, GLib.DateDMY third, char separator, bool twodigits_years);
		[Version (since = "4.2.1")]
		public void set_str_spec (GLib.DateDMY first, GLib.DateDMY sec, GLib.DateDMY third, char separator, bool twodigits_years);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_handler_type_get_type ()")]
	public class HandlerType : GLib.Object, Gda.DataHandler {
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerType ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_holder_get_type ()")]
	public class Holder : GLib.Object, Gda.Lockable {
		[CCode (has_construct_function = false)]
		public Holder (GLib.Type type, string id);
		public Gda.Holder copy ();
		public static GLib.Quark error_quark ();
		public void force_invalid ();
		[Version (since = "4.2.10")]
		public void force_invalid_e (owned GLib.Error? error);
		public string get_alphanum_id ();
		public unowned Gda.Holder get_bind ();
		public unowned GLib.Value? get_default_value ();
		public GLib.Type get_g_type ();
		public unowned string get_id ();
		public bool get_not_null ();
		public unowned Gda.DataModel get_source_model (int col);
		public unowned GLib.Value? get_value ();
		public string get_value_str (Gda.DataHandler? dh);
		public bool is_valid ();
		[Version (since = "4.2.10")]
		public bool is_valid_e () throws GLib.Error;
		public bool set_bind (Gda.Holder bind_to) throws GLib.Error;
		public void set_default_value (GLib.Value value);
		public void set_not_null (bool not_null);
		public bool set_source_model (Gda.DataModel model, int col) throws GLib.Error;
		public bool set_value (GLib.Value? value) throws GLib.Error;
		public bool set_value_str (Gda.DataHandler dh, string value) throws GLib.Error;
		public bool set_value_to_default ();
		public GLib.Value? take_static_value (GLib.Value value, bool value_changed) throws GLib.Error;
		public bool take_value (owned GLib.Value value) throws GLib.Error;
		public bool value_is_default ();
		[NoAccessorMethod]
		public string description { owned get; set; }
		[NoAccessorMethod]
		public Gda.Holder full_bind { owned get; set; }
		[NoAccessorMethod]
		public GLib.Type g_type { get; set construct; }
		[NoAccessorMethod]
		public string id { owned get; set; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		public bool not_null { get; set; }
		[NoAccessorMethod]
		public string plugin { owned get; set; }
		[NoAccessorMethod]
		public Gda.Holder simple_bind { owned get; set; }
		[NoAccessorMethod]
		public int source_column { get; set; }
		[NoAccessorMethod]
		public Gda.DataModel source_model { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "5.2.0")]
		public bool validate_changes { get; set; }
		public virtual signal void changed ();
		public virtual signal void source_changed ();
		public virtual signal void to_default ();
		public virtual signal GLib.Error validate_change (GLib.Value new_value);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_meta_context_get_type ()")]
	[Compact]
	public class MetaContext {
		[CCode (array_length_cname = "size")]
		public weak string[] column_names;
		[CCode (array_length_cname = "size")]
		public weak GLib.Value[] column_values;
		public weak GLib.HashTable<string,GLib.Value?> columns;
		public int size;
		public weak string table_name;
		[CCode (has_construct_function = false)]
		[Version (since = "5.2")]
		public MetaContext ();
		[Version (since = "5.2")]
		public Gda.MetaContext copy ();
		[Version (since = "5.2")]
		public void free ();
		public int get_n_columns ();
		[Version (since = "5.2")]
		public unowned string get_table ();
		[Version (since = "5.2")]
		public void set_column (string column, GLib.Value value, Gda.Connection? cnc);
		[Version (since = "5.2")]
		public void set_columns (GLib.HashTable<string,GLib.Value?> columns, Gda.Connection? cnc);
		[Version (since = "5.2")]
		public void set_table (string table);
		public string stringify ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_meta_store_get_type ()")]
	public class MetaStore : GLib.Object {
		[CCode (has_construct_function = false)]
		public MetaStore (string? cnc_string);
		public Gda.DataModel create_modify_data_model (string table_name);
		public Gda.MetaStruct create_struct (Gda.MetaStructFeature features);
		[Version (since = "4.2.4")]
		public bool declare_foreign_key (Gda.MetaStruct? mstruct, string fk_name, string? catalog, string? schema, string table, string? ref_catalog, string? ref_schema, string ref_table, [CCode (array_length_cname = "nb_cols", array_length_pos = 8.5, array_length_type = "guint")] string[] colnames, [CCode (array_length_cname = "nb_cols", array_length_pos = 8.5, array_length_type = "guint")] string[] ref_colnames) throws GLib.Error;
		public static GLib.Quark error_quark ();
		[CCode (cname = "gda_meta_store_extract_v")]
		[Version (since = "4.2.6")]
		public Gda.DataModel extract (string select_sql, GLib.HashTable<string,GLib.Value?>? vars) throws GLib.Error;
		public bool get_attribute_value (string att_name, out string att_value) throws GLib.Error;
		public unowned Gda.Connection get_internal_connection ();
		public int get_version ();
		[Version (since = "4.2.6")]
		public bool modify_v (string table_name, Gda.DataModel? new_data, string? condition, [CCode (array_length_cname = "nvalues", array_length_pos = 3.5)] string[] value_names, [CCode (array_length_cname = "nvalues", array_length_pos = 3.5)] GLib.Value[] values) throws GLib.Error;
		public bool modify_with_context (Gda.MetaContext context, Gda.DataModel? new_data) throws GLib.Error;
		public bool schema_add_custom_object (string xml_description) throws GLib.Error;
		public GLib.SList<weak string> schema_get_all_tables ();
		public GLib.SList<weak string> schema_get_depend_tables (string table_name);
		public Gda.MetaStruct schema_get_structure () throws GLib.Error;
		public bool schema_remove_custom_object (string obj_name) throws GLib.Error;
		public bool set_attribute_value (string att_name, string? att_value) throws GLib.Error;
		[Version (since = "4.2")]
		public void set_identifiers_style (Gda.SqlIdentifierStyle style);
		[Version (since = "4.2")]
		public void set_reserved_keywords_func (Gda.SqlReservedKeywordsFunc? func);
		[Version (since = "4.0.3")]
		public static string sql_identifier_quote (string id, Gda.Connection cnc);
		[Version (since = "4.2.4")]
		public bool undeclare_foreign_key (Gda.MetaStruct? mstruct, string fk_name, string? catalog, string? schema, string table, string? ref_catalog, string? ref_schema, string ref_table) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public MetaStore.with_file (string file_name);
		[NoAccessorMethod]
		public string catalog { construct; }
		[NoAccessorMethod]
		public Gda.Connection cnc { owned get; construct; }
		[NoAccessorMethod]
		public string cnc_string { construct; }
		[NoAccessorMethod]
		public string schema { construct; }
		public signal void meta_changed (GLib.SList<Gda.MetaStoreChange> changes);
		public virtual signal void meta_reset ();
		public virtual signal GLib.Error suggest_update (Gda.MetaContext suggest);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_meta_store_change_get_type ()")]
	[Compact]
	public class MetaStoreChange {
		[CCode (has_construct_function = false)]
		public MetaStoreChange ();
		public Gda.MetaStoreChange copy ();
		public void free ();
		public Gda.MetaStoreChangeType get_change_type ();
		public unowned GLib.HashTable<string,GLib.Value?> get_keys ();
		public string get_table_name ();
		public void set_change_type (Gda.MetaStoreChangeType ctype);
		public void set_table_name (string table_name);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_meta_struct_get_type ()")]
	public class MetaStruct : GLib.Object {
		[CCode (has_construct_function = false)]
		protected MetaStruct ();
		public unowned Gda.MetaDbObject? complement (Gda.MetaDbObjectType type, GLib.Value? catalog, GLib.Value? schema, GLib.Value name) throws GLib.Error;
		public bool complement_all () throws GLib.Error;
		public bool complement_default () throws GLib.Error;
		public bool complement_depend (Gda.MetaDbObject dbo) throws GLib.Error;
		public bool complement_schema (GLib.Value? catalog, GLib.Value? schema) throws GLib.Error;
		public string? dump_as_graph (Gda.MetaGraphInfo info) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public GLib.SList<weak Gda.MetaDbObject?>? get_all_db_objects ();
		public unowned Gda.MetaDbObject? get_db_object (GLib.Value? catalog, GLib.Value? schema, GLib.Value name);
		public unowned Gda.MetaTableColumn? get_table_column (Gda.MetaTable table, GLib.Value col_name);
		public bool load_from_xml_file (string? catalog, string? schema, string xml_spec_file) throws GLib.Error;
		public bool sort_db_objects (Gda.MetaSortType sort_type) throws GLib.Error;
		[NoAccessorMethod]
		public uint features { get; construct; }
		[NoAccessorMethod]
		public Gda.MetaStore meta_store { owned get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_null_get_type ()")]
	[Compact]
	public class Null {
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_numeric_get_type ()")]
	[Compact]
	public class Numeric {
		[CCode (has_construct_function = false)]
		[Version (since = "5.0.2")]
		public Numeric ();
		public Gda.Numeric copy ();
		[DestroysInstance]
		public void free ();
		[Version (since = "5.0.2")]
		public double get_double ();
		[Version (since = "5.0.2")]
		public long get_precision ();
		[Version (since = "5.0.2")]
		public string? get_string ();
		[Version (since = "5.0.2")]
		public long get_width ();
		[Version (since = "5.0.2")]
		public void set_double (double number);
		[Version (since = "5.0.2")]
		public void set_from_string (string str);
		[Version (since = "5.0.2")]
		public void set_precision (long precision);
		[Version (since = "5.0.2")]
		public void set_width (long width);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_pstmt_get_type ()")]
	public class PStmt : GLib.Object {
		[CCode (has_construct_function = false)]
		protected PStmt ();
		public void copy_contents (Gda.PStmt dest);
		public Gda.Statement get_gda_statement ();
		public int get_ncols ();
		public unowned GLib.SList<string> get_param_ids ();
		public unowned string get_sql ();
		public unowned GLib.SList<Gda.Column> get_tmpl_columns ();
		[CCode (array_length = false)]
		public unowned GLib.Type[] get_types ();
		public void set_cols ([CCode (array_length_cname = "ncols", array_length_pos = 0.5)] owned GLib.Type[] types);
		public void set_gda_statement (Gda.Statement? stmt);
		public void set_param_ids (owned GLib.SList<string> @params);
		public void set_sql (string sql);
		public void set_tmpl_columns (owned GLib.SList<Gda.Column> columns);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_provider_info_get_type ()")]
	[Compact]
	public class ProviderInfo {
		public weak Gda.Set auth_params;
		public weak string description;
		public weak Gda.Set dsn_params;
		public weak string icon_id;
		public weak string id;
		public weak string location;
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_quark_list_get_type ()")]
	[Compact]
	public class QuarkList {
		[CCode (has_construct_function = false)]
		public QuarkList ();
		public void add_from_string (string string, bool cleanup);
		public void clear ();
		public Gda.QuarkList copy ();
		public unowned string find (string name);
		public void @foreach (GLib.HFunc func);
		public void free ();
		[CCode (has_construct_function = false)]
		public QuarkList.from_string (string string);
		[Version (since = "5.2.0")]
		public void protect_values ();
		public void remove (string name);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_repetitive_statement_get_type ()")]
	public class RepetitiveStatement : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "4.2")]
		public RepetitiveStatement (Gda.Statement stmt);
		[Version (since = "4.2")]
		public bool append_set (Gda.Set values, bool make_copy);
		[Version (since = "4.2")]
		public GLib.SList<weak Gda.Set> get_all_sets ();
		[Version (since = "4.2")]
		public bool get_template_set (Gda.Set @set) throws GLib.Error;
		[NoAccessorMethod]
		public Gda.Statement statement { owned get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_row_get_type ()")]
	public class Row : GLib.Object {
		[CCode (has_construct_function = false)]
		public Row (int count);
		[CCode (has_construct_function = false)]
		public Row.from_data_model (Gda.DataModel model, uint row);
		public int get_length ();
		public unowned GLib.Value? get_value (int num);
		public void invalidate_value (GLib.Value value);
		[Version (since = "4.2.10")]
		public void invalidate_value_e (GLib.Value value, owned GLib.Error? error);
		public bool value_is_valid (GLib.Value value);
		[Version (since = "4.2.10")]
		public bool value_is_valid_e (GLib.Value value) throws GLib.Error;
		[NoAccessorMethod]
		public Gda.DataModel model { owned get; construct; }
		[NoAccessorMethod]
		public int model_row { get; construct; }
		[NoAccessorMethod]
		public int nb_values { get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_server_operation_get_type ()")]
	public class ServerOperation : GLib.Object {
		[CCode (has_construct_function = false)]
		public ServerOperation (Gda.ServerOperationType op_type, string xml_file);
		public uint add_item_to_sequence (string seq_path);
		public bool del_item_from_sequence (string item_path);
		public static GLib.Quark error_quark ();
		public string get_node_parent (string path);
		public string get_node_path_portion (string path);
		public Gda.ServerOperationNodeType get_node_type (string path, Gda.ServerOperationNodeStatus? status);
		public Gda.ServerOperationType get_op_type ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_root_nodes ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_sequence_item_names (string path);
		public uint get_sequence_max_size (string path);
		public uint get_sequence_min_size (string path);
		public unowned string get_sequence_name (string path);
		public uint get_sequence_size (string path);
		public string get_sql_identifier_at_path (string path) throws GLib.Error;
		[CCode (cname = "gda_server_operation_get_value_at_path")]
		[Version (since = "4.2.6")]
		public unowned GLib.Value? get_value_at (string path);
		[Version (since = "6.0")]
		public bool is_valid (string? xml_file) throws GLib.Error;
		public bool is_valid_from_resource (string? resource) throws GLib.Error;
		public bool load_data_from_xml ([CCode (type = "xmlNodePtr")] Xml.Node* node) throws GLib.Error;
		[Version (since = "4.2.3")]
		public bool perform_create_database (string? provider) throws GLib.Error;
		[Version (since = "4.2.3")]
		public bool perform_drop_database (string? provider) throws GLib.Error;
		[Version (since = "4.2.3")]
		public static Gda.ServerOperation? prepare_create_database (string provider, string? db_name) throws GLib.Error;
		[Version (since = "4.2.3")]
		public static Gda.ServerOperation? prepare_drop_database (string provider, string? db_name) throws GLib.Error;
		public string? render () throws GLib.Error;
		public string save_data_to_xml_string () throws GLib.Error;
		[NoWrapper]
		public virtual void seq_item_added (string seq_path, int item_index);
		[NoWrapper]
		public virtual void seq_item_remove (string seq_path, int item_index);
		[CCode (cname = "gda_server_operation_set_value_at_path")]
		[Version (since = "4.2.6")]
		public bool set_value_at (string? value, string path) throws GLib.Error;
		[NoAccessorMethod]
		public Gda.Connection connection { owned get; construct; }
		public int op_type { get; construct; }
		[NoAccessorMethod]
		public Gda.ServerProvider provider { owned get; construct; }
		[NoAccessorMethod]
		public string spec_filename { construct; }
		[NoAccessorMethod]
		public string spec_resource { construct; }
		public signal void sequence_item_added (string seq_path, int item_index);
		public signal void sequence_item_remove (string seq_path, int item_index);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_server_operation_create_table_arg_get_type ()")]
	[Compact]
	public class ServerOperationCreateTableArg {
		[CCode (has_construct_function = false)]
		public ServerOperationCreateTableArg ();
		public Gda.ServerOperationCreateTableArg copy ();
		public void free ();
		public string get_column_name ();
		public GLib.Type get_column_type ();
		public string get_fkey_ondelete ();
		public string get_fkey_onupdate ();
		public static GLib.Type get_fkey_ref_field_get_type ();
		public unowned GLib.List<Gda.ServerOperationCreateTableArgFKeyRefField> get_fkey_refs ();
		public string get_fkey_table ();
		public Gda.ServerOperationCreateTableFlag get_flags ();
		public void set_column_name (string name);
		public void set_column_type (GLib.Type ctype);
		public void set_fkey_ondelete (string action);
		public void set_fkey_ondupdate (string action);
		public void set_fkey_refs (GLib.List<Gda.ServerOperationCreateTableArgFKeyRefField> refs);
		public void set_fkey_table (string name);
		public void set_flags (Gda.ServerOperationCreateTableFlag flags);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_server_operation_create_table_arg_fkey_ref_field_get_type ()")]
	[Compact]
	public class ServerOperationCreateTableArgFKeyRefField {
		[CCode (has_construct_function = false)]
		public ServerOperationCreateTableArgFKeyRefField ();
		public Gda.ServerOperationCreateTableArgFKeyRefField copy ();
		public void free ();
		public string get_local_field ();
		public string get_referenced_field ();
		public void set_local_field (string name);
		public void set_referenced_field (string name);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_server_operation_node_get_type ()")]
	[Compact]
	public class ServerOperationNode {
		public weak Gda.Column column;
		public weak Gda.DataModel model;
		public weak Gda.Holder param;
		public weak Gda.Set plist;
		public void* priv;
		public Gda.ServerOperationNodeStatus status;
		public Gda.ServerOperationNodeType type;
		public Gda.ServerOperationNode copy ();
		public void free ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_server_provider_get_type ()")]
	public abstract class ServerProvider : GLib.Object, Gda.Lockable {
		[CCode (has_construct_function = false)]
		protected ServerProvider ();
		public Gda.ServerOperation? create_operation (Gda.Connection? cnc, Gda.ServerOperationType type, Gda.Set? options) throws GLib.Error;
		public Gda.SqlParser create_parser (Gda.Connection? cnc);
		public static GLib.Quark error_quark ();
		public string escape_string (Gda.Connection? cnc, string str);
		public unowned Gda.DataHandler get_data_handler_dbms (Gda.Connection? cnc, string for_type);
		public unowned Gda.DataHandler get_data_handler_g_type (Gda.Connection? cnc, GLib.Type for_type);
		public unowned string? get_default_dbms_type (Gda.Connection? cnc, GLib.Type type);
		public static void* get_impl_functions_for_class (GLib.ObjectClass klass, Gda.ServerProviderFunctionsType type);
		public unowned string get_name ();
		public static GLib.MainContext get_real_main_context (Gda.Connection? cnc);
		public unowned string get_server_version (Gda.Connection cnc);
		public unowned string get_version ();
		public void handler_declare (Gda.DataHandler dh, Gda.Connection cnc, GLib.Type g_type, string dbms_type);
		public unowned Gda.DataHandler handler_find (Gda.Connection? cnc, GLib.Type g_type, string? dbms_type);
		[Version (since = "5.2")]
		public unowned Gda.DataHandler handler_use_default (GLib.Type type);
		public unowned Gda.SqlParser internal_get_parser ();
		[Version (since = "6.0")]
		public static string load_resource_contents (string prov_name, string resource);
		public bool perform_operation (Gda.Connection? cnc, Gda.ServerOperation op) throws GLib.Error;
		public bool perform_operation_default (Gda.Connection? cnc, Gda.ServerOperation op) throws GLib.Error;
		public string? render_operation (Gda.Connection? cnc, Gda.ServerOperation op) throws GLib.Error;
		public GLib.Value? string_to_value (Gda.Connection? cnc, string string, GLib.Type preferred_type, string? dbms_type);
		public bool supports_feature (Gda.Connection? cnc, Gda.ConnectionFeature feature);
		public bool supports_operation (Gda.Connection? cnc, Gda.ServerOperationType type, Gda.Set? options);
		public string unescape_string (Gda.Connection? cnc, string str);
		public string value_to_sql_string (Gda.Connection? cnc, GLib.Value from);
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	[Compact]
	public abstract class ServerProviderBase {
		public abstract void _gda_reserved11 ();
		public abstract void _gda_reserved12 ();
		public abstract void _gda_reserved13 ();
		public abstract void _gda_reserved14 ();
		public abstract bool add_savepoint (Gda.ServerProvider provider, Gda.Connection cnc, string name) throws GLib.Error;
		public abstract bool begin_transaction (Gda.ServerProvider provider, Gda.Connection cnc, string name, Gda.TransactionIsolation level) throws GLib.Error;
		public abstract bool close_connection (Gda.ServerProvider provider, Gda.Connection cnc);
		public abstract bool commit_transaction (Gda.ServerProvider provider, Gda.Connection cnc, string name) throws GLib.Error;
		public abstract Gda.Connection create_connection (Gda.ServerProvider provider);
		public abstract Gda.ServerOperation create_operation (Gda.ServerProvider provider, Gda.Connection cnc, Gda.ServerOperationType type, Gda.Set options) throws GLib.Error;
		public abstract Gda.SqlParser create_parser (Gda.ServerProvider provider, Gda.Connection cnc);
		public abstract Gda.Worker create_worker (Gda.ServerProvider provider, bool for_cnc);
		public abstract bool delete_savepoint (Gda.ServerProvider provider, Gda.Connection cnc, string name) throws GLib.Error;
		public abstract string escape_string (Gda.ServerProvider provider, Gda.Connection cnc, string str);
		public abstract Gda.DataHandler get_data_handler (Gda.ServerProvider provider, Gda.Connection? cnc, GLib.Type g_type, string dbms_type);
		public abstract string get_def_dbms_type (Gda.ServerProvider provider, Gda.Connection cnc, GLib.Type g_type);
		public abstract string get_name (Gda.ServerProvider provider);
		public abstract string get_server_version (Gda.ServerProvider provider, Gda.Connection cnc);
		public abstract string get_version (Gda.ServerProvider provider);
		public abstract string identifier_quote (Gda.ServerProvider provider, Gda.Connection? cnc, string id, bool for_meta_store, bool force_quotes);
		public abstract bool open_connection (Gda.ServerProvider provider, Gda.Connection cnc, Gda.QuarkList @params, Gda.QuarkList auth);
		public abstract bool perform_operation (Gda.ServerProvider provider, Gda.Connection? cnc, Gda.ServerOperation op) throws GLib.Error;
		public abstract bool prepare_connection (Gda.ServerProvider provider, Gda.Connection cnc, Gda.QuarkList @params, Gda.QuarkList auth);
		public abstract string render_operation (Gda.ServerProvider provider, Gda.Connection cnc, Gda.ServerOperation op) throws GLib.Error;
		public abstract bool rollback_savepoint (Gda.ServerProvider provider, Gda.Connection cnc, string name) throws GLib.Error;
		public abstract bool rollback_transaction (Gda.ServerProvider provider, Gda.Connection cnc, string name) throws GLib.Error;
		public abstract GLib.Object statement_execute (Gda.ServerProvider provider, Gda.Connection cnc, Gda.Statement stmt, Gda.Set @params, Gda.StatementModelUsage model_usage, GLib.Type[] col_types, ref Gda.Set last_inserted_row) throws GLib.Error;
		public abstract bool statement_prepare (Gda.ServerProvider provider, Gda.Connection cnc, Gda.Statement stmt) throws GLib.Error;
		public abstract Gda.SqlStatement statement_rewrite (Gda.ServerProvider provider, Gda.Connection cnc, Gda.Statement stmt, Gda.Set @params) throws GLib.Error;
		public abstract string statement_to_sql (Gda.ServerProvider provider, Gda.Connection cnc, Gda.Statement stmt, Gda.Set @params, Gda.StatementSqlFlag flags, ref GLib.SList params_used) throws GLib.Error;
		public abstract bool supports_feature (Gda.ServerProvider provider, Gda.Connection cnc, Gda.ConnectionFeature feature);
		public abstract bool supports_operation (Gda.ServerProvider provider, Gda.Connection cnc, Gda.ServerOperationType type, Gda.Set options);
		public abstract string unescape_string (Gda.ServerProvider provider, Gda.Connection cnc, string str);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_server_provider_connection_data_get_type ()")]
	[Compact]
	public class ServerProviderConnectionData {
		public void* pad1;
		public void* pad2;
		public weak GLib.DestroyNotify provider_data_destroy_func;
		public weak Gda.Worker worker;
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_set_get_type ()")]
	public class Set : GLib.Object {
		[CCode (has_construct_function = false)]
		public Set (GLib.SList<Gda.Holder> holders);
		public bool add_holder (Gda.Holder holder);
		public Gda.Set copy ();
		public static GLib.Quark error_quark ();
		[CCode (has_construct_function = false)]
		public Set.from_spec_node ([CCode (type = "xmlNodePtr")] Xml.Node* xml_spec) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Set.from_spec_string (string xml_spec) throws GLib.Error;
		public unowned Gda.SetGroup get_group (Gda.Holder holder);
		public unowned GLib.SList<Gda.SetGroup> get_groups ();
		public unowned Gda.Holder get_holder (string holder_id);
		public unowned GLib.Value? get_holder_value (string holder_id);
		public unowned GLib.SList<Gda.Holder> get_holders ();
		public unowned Gda.SetNode get_node (Gda.Holder holder);
		public unowned GLib.SList<Gda.SetNode> get_nodes ();
		[Version (since = "4.2")]
		public unowned Gda.Holder get_nth_holder (int pos);
		public unowned Gda.SetSource get_source (Gda.Holder holder);
		public unowned Gda.SetSource get_source_for_model (Gda.DataModel model);
		public unowned GLib.SList<Gda.SetSource> get_sources ();
		public bool is_valid () throws GLib.Error;
		public void merge_with_set (Gda.Set set_to_merge);
		[CCode (has_construct_function = false)]
		[Version (since = "4.2")]
		public Set.read_only (GLib.SList<Gda.Holder> holders);
		public void remove_holder (Gda.Holder holder);
		[Version (since = "4.2")]
		public void replace_source_model (Gda.SetSource source, Gda.DataModel model);
		[NoAccessorMethod]
		public string description { owned get; set; }
		[NoAccessorMethod]
		public void* holders { construct; }
		[NoAccessorMethod]
		public string id { owned get; set; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "5.2.0")]
		public bool validate_changes { get; set; }
		public virtual signal void holder_attr_changed (Gda.Holder holder, string attr_name, GLib.Value attr_value);
		public virtual signal void holder_changed (Gda.Holder holder);
		[Version (since = "4.2")]
		public virtual signal void holder_type_set (Gda.Holder holder);
		public virtual signal void public_data_changed ();
		[Version (since = "4.2")]
		public virtual signal void source_model_changed (void* source);
		public virtual signal GLib.Error validate_holder_change (Gda.Holder holder, GLib.Value new_value);
		public virtual signal GLib.Error validate_set ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_set_group_get_type ()")]
	[Compact]
	public class SetGroup {
		[CCode (has_construct_function = false)]
		[Version (since = "5.2")]
		public SetGroup (Gda.SetNode node);
		[Version (since = "5.2")]
		public void add_node (Gda.SetNode node);
		[Version (since = "5.2")]
		public Gda.SetGroup copy ();
		[Version (since = "5.2")]
		public void free ();
		[Version (since = "5.2")]
		public int get_n_nodes ();
		[Version (since = "5.2")]
		public Gda.SetNode get_node ();
		[Version (since = "5.2")]
		public unowned GLib.SList<Gda.SetNode> get_nodes ();
		[Version (since = "5.2")]
		public Gda.SetSource get_source ();
		[Version (since = "5.2")]
		public void set_source (Gda.SetSource source);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_set_node_get_type ()")]
	[Compact]
	public class SetNode {
		[CCode (has_construct_function = false)]
		[Version (since = "5.2")]
		public SetNode (Gda.Holder holder);
		[Version (since = "5.2")]
		public Gda.SetNode copy ();
		[Version (since = "5.2")]
		public void free ();
		[Version (since = "5.2")]
		public unowned Gda.DataModel get_data_model ();
		[Version (since = "5.2")]
		public unowned Gda.Holder get_holder ();
		[Version (since = "5.2")]
		public int get_source_column ();
		[Version (since = "5.2")]
		public void set_data_model (Gda.DataModel? model);
		[Version (since = "5.2")]
		public void set_holder (Gda.Holder holder);
		[Version (since = "5.2")]
		public void set_source_column (int column);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_set_source_get_type ()")]
	[Compact]
	public class SetSource {
		[CCode (has_construct_function = false)]
		[Version (since = "5.2")]
		public SetSource (Gda.DataModel model);
		[Version (since = "5.2")]
		public void add_node (Gda.SetNode node);
		[Version (since = "5.2")]
		public Gda.SetSource copy ();
		[Version (since = "5.2")]
		public void free ();
		[Version (since = "5.2")]
		public unowned Gda.DataModel get_data_model ();
		[Version (since = "5.2")]
		public int get_n_nodes ();
		[Version (since = "5.2")]
		public unowned GLib.SList<Gda.SetNode> get_nodes ();
		[Version (since = "5.2")]
		public void set_data_model (Gda.DataModel model);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_short_get_type ()")]
	public class Short {
		[CCode (has_construct_function = false)]
		protected Short ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_sql_any_part_get_type ()")]
	[Compact]
	public class SqlAnyPart {
		public weak Gda.SqlAnyPart parent;
		public Gda.SqlAnyPartType type;
		public bool check_structure () throws GLib.Error;
		public bool @foreach (Gda.SqlForeachFunc func) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_sql_builder_get_type ()")]
	public class SqlBuilder : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "4.2")]
		public SqlBuilder (Gda.SqlStatementType stmt_type);
		[Version (since = "4.2")]
		public Gda.SqlBuilderId add_case_v (Gda.SqlBuilderId test_expr, Gda.SqlBuilderId else_expr, [CCode (array_length_cname = "args_size", array_length_pos = 4.1)] Gda.SqlBuilderId[] when_array, [CCode (array_length_cname = "args_size", array_length_pos = 4.1)] Gda.SqlBuilderId[] then_array);
		[Version (since = "4.2")]
		public Gda.SqlBuilderId add_cond (Gda.SqlOperatorType op, Gda.SqlBuilderId op1, Gda.SqlBuilderId op2, Gda.SqlBuilderId op3);
		[Version (since = "4.2")]
		public Gda.SqlBuilderId add_cond_v (Gda.SqlOperatorType op, [CCode (array_length_cname = "op_ids_size", array_length_pos = 2.1)] Gda.SqlBuilderId[] op_ids);
		[Version (since = "4.2")]
		public Gda.SqlBuilderId add_expr_value (GLib.Value? value);
		[Version (since = "4.2")]
		public Gda.SqlBuilderId add_field_id (string field_name, string? table_name = null);
		[Version (since = "4.2")]
		public void add_field_value_as_gvalue (string field_name, GLib.Value? value);
		[Version (since = "4.2")]
		public void add_field_value_id (Gda.SqlBuilderId field_id, Gda.SqlBuilderId value_id);
		[Version (since = "4.2")]
		public Gda.SqlBuilderId add_function_v (string func_name, [CCode (array_length_cname = "args_size", array_length_pos = 2.1)] Gda.SqlBuilderId[] args);
		[Version (since = "4.2")]
		public Gda.SqlBuilderId add_id (string str);
		[Version (since = "4.2")]
		public Gda.SqlBuilderId add_param (string param_name, GLib.Type type, bool nullok);
		[Version (since = "4.2")]
		public Gda.SqlBuilderId add_sub_select (Gda.SqlStatement sqlst);
		[Version (since = "4.2")]
		public void compound_add_sub_select (Gda.SqlStatement sqlst);
		[Version (since = "4.2")]
		public void compound_add_sub_select_from_builder (Gda.SqlBuilder subselect);
		[Version (since = "4.2")]
		public void compound_set_type (Gda.SqlStatementCompoundType compound_type);
		public static GLib.Quark error_quark ();
		[Version (since = "4.2")]
		public Gda.SqlExpr export_expression (Gda.SqlBuilderId id);
		[Version (since = "4.2")]
		public unowned Gda.SqlStatement? get_sql_statement ();
		[Version (since = "4.2")]
		public Gda.Statement get_statement () throws GLib.Error;
		[Version (since = "4.2")]
		public Gda.SqlBuilderId import_expression (Gda.SqlExpr expr);
		[Version (since = "4.2")]
		public Gda.SqlBuilderId import_expression_from_builder (Gda.SqlBuilder query, Gda.SqlBuilderId expr_id);
		[Version (since = "4.2")]
		public void join_add_field (Gda.SqlBuilderId join_id, string field_name);
		[Version (since = "4.2")]
		public Gda.SqlBuilderId select_add_field (string field_name, string? table_name = null, string? alias = null);
		[Version (since = "4.2")]
		public Gda.SqlBuilderId select_add_target (string table_name, string? alias = null);
		[Version (since = "4.2")]
		public Gda.SqlBuilderId select_add_target_id (Gda.SqlBuilderId table_id, string? alias = null);
		[Version (since = "4.2")]
		public void select_group_by (Gda.SqlBuilderId expr_id);
		[Version (since = "4.2")]
		public Gda.SqlBuilderId select_join_targets (Gda.SqlBuilderId left_target_id, Gda.SqlBuilderId right_target_id, Gda.SqlSelectJoinType join_type, Gda.SqlBuilderId join_expr);
		[Version (since = "4.2")]
		public void select_order_by (Gda.SqlBuilderId expr_id, bool asc, string? collation_name = null);
		[Version (since = "4.2")]
		public void select_set_distinct (bool distinct, Gda.SqlBuilderId expr_id);
		[Version (since = "4.2")]
		public void select_set_having (Gda.SqlBuilderId cond_id);
		[Version (since = "4.2")]
		public void select_set_limit (Gda.SqlBuilderId limit_count_expr_id, Gda.SqlBuilderId limit_offset_expr_id);
		[Version (since = "4.2")]
		public void set_table (string table_name);
		[Version (since = "4.2")]
		public void set_where (Gda.SqlBuilderId cond_id);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_sql_case_get_type ()")]
	[Compact]
	public class SqlCase {
		public weak Gda.SqlAnyPart any;
		public weak Gda.SqlExpr base_expr;
		public weak Gda.SqlExpr else_expr;
		public weak GLib.SList<void*> then_expr_list;
		public weak GLib.SList<void*> when_expr_list;
		[CCode (has_construct_function = false)]
		public SqlCase (Gda.SqlAnyPart parent);
		public Gda.SqlCase copy ();
		public void free ();
		public string serialize ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_sql_expr_get_type ()")]
	[Compact]
	public class SqlExpr {
		public weak Gda.SqlAnyPart any;
		public weak Gda.SqlCase case_s;
		public weak string cast_as;
		public weak Gda.SqlOperation cond;
		public weak Gda.SqlFunction func;
		public weak Gda.SqlParamSpec param_spec;
		public weak Gda.SqlAnyPart select;
		public GLib.Value value;
		public bool value_is_ident;
		[CCode (has_construct_function = false)]
		public SqlExpr (Gda.SqlAnyPart parent);
		public Gda.SqlExpr copy ();
		public void free ();
		public string serialize ();
		public void take_select (Gda.SqlStatement stmt);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_sql_field_get_type ()")]
	[Compact]
	public class SqlField {
		public weak Gda.SqlAnyPart any;
		public weak string field_name;
		public Gda.MetaTableColumn validity_meta_table_column;
		[CCode (has_construct_function = false)]
		public SqlField (Gda.SqlAnyPart parent);
		public Gda.SqlField copy ();
		public void free ();
		public string serialize ();
		public void take_name (GLib.Value value);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_sql_function_get_type ()")]
	[Compact]
	public class SqlFunction {
		public weak Gda.SqlAnyPart any;
		public weak GLib.SList<void*> args_list;
		public weak string function_name;
		[CCode (has_construct_function = false)]
		public SqlFunction (Gda.SqlAnyPart parent);
		public void check_clean ();
		public Gda.SqlFunction copy ();
		public void free ();
		public string serialize ();
		public void take_args_list (GLib.SList<Gda.SqlExpr> args);
		public void take_name (GLib.Value value);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_sql_operation_get_type ()")]
	[Compact]
	public class SqlOperation {
		public weak Gda.SqlAnyPart any;
		public weak GLib.SList<Gda.SqlExpr> operands;
		public Gda.SqlOperatorType operator_type;
		[CCode (has_construct_function = false)]
		public SqlOperation (Gda.SqlAnyPart parent);
		public Gda.SqlOperation copy ();
		public void free ();
		public static Gda.SqlOperatorType operator_from_string (string op);
		public static unowned string operator_to_string (Gda.SqlOperatorType op);
		public string serialize ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_sql_param_spec_get_type ()")]
	[Compact]
	public class SqlParamSpec {
		public void* _gda_reserved1;
		public void* _gda_reserved2;
		public weak string descr;
		public GLib.Type g_type;
		public bool is_param;
		public weak string name;
		public bool nullok;
		public void* validity_meta_dict;
		[CCode (has_construct_function = false)]
		public SqlParamSpec (owned GLib.Value simple_spec);
		public Gda.SqlParamSpec copy ();
		public void free ();
		public string serialize ();
		public void take_descr (owned GLib.Value value);
		public void take_name (owned GLib.Value value);
		public void take_nullok (owned GLib.Value value);
		public void take_type (owned GLib.Value value);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_sql_parser_get_type ()")]
	public class SqlParser : GLib.Object, Gda.Lockable {
		[CCode (has_construct_function = false)]
		public SqlParser ();
		public static GLib.Quark error_quark ();
		public Gda.Batch? parse_file_as_batch (string filename) throws GLib.Error;
		public Gda.Statement? parse_string (string sql, out string? remain) throws GLib.Error;
		public Gda.Batch? parse_string_as_batch (string sql, out string? remain) throws GLib.Error;
		public void set_overflow_error ();
		public void set_syntax_error ();
		[NoAccessorMethod]
		public int column_error { get; }
		[NoAccessorMethod]
		public int line_error { get; }
		[NoAccessorMethod]
		public int mode { get; set; }
		[NoAccessorMethod]
		public int tokenizer_flavour { get; set; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_sql_select_field_get_type ()")]
	[Compact]
	public class SqlSelectField {
		public weak Gda.SqlAnyPart any;
		public weak string @as;
		public weak Gda.SqlExpr expr;
		public weak string field_name;
		public weak string table_name;
		public Gda.MetaDbObject validity_meta_object;
		public Gda.MetaTableColumn validity_meta_table_column;
		[CCode (has_construct_function = false)]
		public SqlSelectField (Gda.SqlAnyPart parent);
		public Gda.SqlSelectField copy ();
		public void free ();
		public string serialize ();
		public void take_alias (GLib.Value alias);
		public void take_expr (Gda.SqlExpr expr);
		public void take_star_value (GLib.Value value);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_sql_select_from_get_type ()")]
	[Compact]
	public class SqlSelectFrom {
		public weak Gda.SqlAnyPart any;
		public weak GLib.SList<Gda.SqlSelectJoin> joins;
		public weak GLib.SList<Gda.SqlSelectTarget> targets;
		[CCode (has_construct_function = false)]
		public SqlSelectFrom (Gda.SqlAnyPart parent);
		public Gda.SqlSelectFrom copy ();
		public void free ();
		public string serialize ();
		public void take_new_join (Gda.SqlSelectJoin join);
		public void take_new_target (Gda.SqlSelectTarget target);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_sql_select_join_get_type ()")]
	[Compact]
	public class SqlSelectJoin {
		public weak Gda.SqlAnyPart any;
		public weak Gda.SqlExpr expr;
		public int position;
		public Gda.SqlSelectJoinType type;
		public weak GLib.SList<void*> use;
		[CCode (has_construct_function = false)]
		public SqlSelectJoin (Gda.SqlAnyPart parent);
		public Gda.SqlSelectJoin copy ();
		public void free ();
		public string serialize ();
		public static unowned string type_to_string (Gda.SqlSelectJoinType type);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_sql_select_order_get_type ()")]
	[Compact]
	public class SqlSelectOrder {
		public weak Gda.SqlAnyPart any;
		public bool asc;
		public weak string collation_name;
		public weak Gda.SqlExpr expr;
		[CCode (has_construct_function = false)]
		public SqlSelectOrder (Gda.SqlAnyPart parent);
		public Gda.SqlSelectOrder copy ();
		public void free ();
		public string serialize ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_sql_select_target_get_type ()")]
	[Compact]
	public class SqlSelectTarget {
		public weak Gda.SqlAnyPart any;
		public weak string @as;
		public weak Gda.SqlExpr expr;
		public weak string table_name;
		public Gda.MetaDbObject validity_meta_object;
		[CCode (has_construct_function = false)]
		public SqlSelectTarget (Gda.SqlAnyPart parent);
		public Gda.SqlSelectTarget copy ();
		public void free ();
		public string serialize ();
		public void take_alias (GLib.Value alias);
		public void take_select (Gda.SqlStatement stmt);
		public void take_table_name (GLib.Value value);
	}
	[CCode (cheader_filename = "libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_sql_statement_get_type ()")]
	[Compact]
	public class SqlStatement {
		public void* contents;
		public weak string sql;
		public Gda.SqlStatementType stmt_type;
		public weak Gda.MetaStruct validity_meta_struct;
		[CCode (has_construct_function = false)]
		public SqlStatement (Gda.SqlStatementType type);
		public void check_clean ();
		public bool check_structure () throws GLib.Error;
		public bool check_validity (Gda.Connection? cnc) throws GLib.Error;
		[Version (since = "4.2")]
		public bool check_validity_m (Gda.MetaStruct? mstruct) throws GLib.Error;
		public void compound_set_type (Gda.SqlStatementCompoundType type);
		public void compound_take_stmt (Gda.SqlStatement s);
		public Gda.SqlStatement copy ();
		public void delete_take_condition (Gda.SqlExpr cond);
		public void delete_take_table_name (GLib.Value value);
		public void free ();
		public static Gda.SqlStatementContentsInfo get_contents_infos (Gda.SqlStatementType type);
		public void insert_take_1_values_list (GLib.SList<Gda.SqlExpr> list);
		public void insert_take_extra_values_list (GLib.SList<Gda.SqlExpr> list);
		public void insert_take_fields_list (GLib.SList<Gda.SqlField> list);
		public void insert_take_on_conflict (GLib.Value value);
		public void insert_take_select (Gda.SqlStatement select);
		public void insert_take_table_name (GLib.Value value);
		public bool normalize (Gda.Connection? cnc) throws GLib.Error;
		public void select_take_distinct (bool distinct, Gda.SqlExpr? distinct_expr);
		public void select_take_expr_list (GLib.SList<Gda.SqlSelectField> expr_list);
		public void select_take_from (Gda.SqlSelectFrom from);
		public void select_take_group_by (GLib.SList<Gda.SqlExpr> group_by);
		public void select_take_having_cond (Gda.SqlExpr expr);
		public void select_take_limits (Gda.SqlExpr count, Gda.SqlExpr offset);
		public void select_take_order_by (GLib.SList<Gda.SqlSelectOrder> order_by);
		public void select_take_where_cond (Gda.SqlExpr expr);
		public string serialize ();
		public static Gda.SqlStatementType string_to_type (string type);
		public void trans_set_isol_level (Gda.TransactionIsolation level);
		public void trans_take_mode (owned GLib.Value value);
		public void trans_take_name (owned GLib.Value value);
		public static unowned string type_to_string (Gda.SqlStatementType type);
		public void unknown_take_expressions (GLib.SList<Gda.SqlExpr> expressions);
		public void update_take_condition (Gda.SqlExpr cond);
		public void update_take_on_conflict (GLib.Value value);
		public void update_take_set_value (GLib.Value fname, Gda.SqlExpr expr);
		public void update_take_table_name (GLib.Value value);
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	[Compact]
	public abstract class SqlStatementContentsInfo {
		public weak Gda.SqlForeachFunc check_structure_func;
		public weak Gda.SqlForeachFunc check_validity_func;
		public weak string name;
		public Gda.SqlStatementType type;
		public abstract void* _gda_reserved1 ();
		public abstract void* _gda_reserved2 ();
		public abstract void* _gda_reserved3 ();
		public abstract void* _gda_reserved4 ();
		public abstract void* @construct ();
		public abstract void* copy (void* stm);
		public abstract void free (void* stm);
		public abstract string serialize (void* stm);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_sql_table_get_type ()")]
	[Compact]
	public class SqlTable {
		public weak Gda.SqlAnyPart any;
		public weak string table_name;
		public Gda.MetaDbObject validity_meta_object;
		[CCode (has_construct_function = false)]
		public SqlTable (Gda.SqlAnyPart parent);
		public Gda.SqlTable copy ();
		public void free ();
		public string serialize ();
		public void take_name (GLib.Value value);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_statement_get_type ()")]
	public class Statement : GLib.Object {
		[CCode (has_construct_function = false)]
		public Statement ();
		public bool check_structure () throws GLib.Error;
		public bool check_validity (Gda.Connection? cnc) throws GLib.Error;
		public Gda.Statement copy ();
		public static GLib.Quark error_quark ();
		public bool get_parameters (out Gda.Set? out_params) throws GLib.Error;
		public Gda.SqlStatementType get_statement_type ();
		public bool is_useless ();
		public bool normalize (Gda.Connection cnc) throws GLib.Error;
		[Version (since = "4.2")]
		public Gda.SqlStatement? rewrite_for_default_values (Gda.Set @params, bool remove) throws GLib.Error;
		public string serialize ();
		public string to_sql_extended (Gda.Connection? cnc, Gda.Set? @params, Gda.StatementSqlFlag flags, out GLib.SList<weak Gda.Holder>? params_used) throws GLib.Error;
		[NoAccessorMethod]
		public Gda.SqlStatement structure { owned get; set; }
		public virtual signal void checked (Gda.Connection cnc, bool checked);
		public virtual signal void reset ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_text_get_type ()")]
	[Compact]
	public class Text {
		[CCode (has_construct_function = false)]
		public Text ();
		public void free ();
		public unowned string get_string ();
		public void set_string (string str);
		public void take_string (string str);
		public static string to_alphanum (string text);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_time_get_type ()")]
	[Compact]
	public class Time {
		[CCode (has_construct_function = false)]
		public Time ();
		public Gda.Time copy ();
		[Version (since = "6.0")]
		public void free ();
		[CCode (has_construct_function = false)]
		[Version (since = "6.0")]
		public Time.from_date_time (GLib.DateTime dt);
		[CCode (has_construct_function = false)]
		public Time.from_values (ushort hour, ushort minute, ushort second, ulong fraction, long timezone);
		[Version (since = "6.0")]
		public ulong get_fraction ();
		[Version (since = "6.0")]
		public ushort get_hour ();
		[Version (since = "6.0")]
		public ushort get_minute ();
		[Version (since = "6.0")]
		public ushort get_second ();
		[Version (since = "6.0")]
		public long get_timezone ();
		[Version (since = "6.0")]
		public GLib.TimeZone get_tz ();
		[Version (since = "6.0")]
		public void set_fraction (ulong fraction);
		[Version (since = "6.0")]
		public void set_hour (ushort hour);
		[Version (since = "6.0")]
		public void set_minute (ushort minute);
		[Version (since = "6.0")]
		public void set_second (ushort second);
		[Version (since = "6.0")]
		public void set_timezone (long timezone);
		[Version (since = "6.0")]
		public string to_string ();
		[Version (since = "6.0")]
		public string to_string_local ();
		[Version (since = "6.0")]
		public string to_string_utc ();
		[Version (since = "6.0")]
		public Gda.Time to_timezone (GLib.TimeZone ntz);
		public Gda.Time to_utc ();
		[Version (deprecated = true, deprecated_since = "6.0", since = "4.2")]
		public bool valid ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_transaction_status_get_type ()")]
	public class TransactionStatus : GLib.Object {
		[CCode (has_construct_function = false)]
		public TransactionStatus (string name);
		public Gda.TransactionStatusEvent add_event_sql (string sql, Gda.ConnectionEvent conn_event);
		public Gda.TransactionStatusEvent add_event_sub (Gda.TransactionStatus sub_trans);
		public Gda.TransactionStatusEvent add_event_svp (string svp_name);
		public Gda.TransactionStatus? find (string str, Gda.TransactionStatusEvent destev);
		public Gda.TransactionStatus? find_current (Gda.TransactionStatusEvent destev, bool unnamed_only);
		public void free_events (Gda.TransactionStatusEvent event, bool free_after);
		public Gda.TransactionIsolation get_isolation_level ();
		public Gda.TransactionStatusState get_state ();
		public void set_isolation_level (Gda.TransactionIsolation il);
		public void set_state (Gda.TransactionStatusState state);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_transaction_status_event_get_type ()")]
	[Compact]
	public class TransactionStatusEvent {
		public weak Gda.ConnectionEvent conn_event;
		[CCode (cname = "pl.sql")]
		public weak string pl_sql;
		[CCode (cname = "pl.sub_trans")]
		public weak Gda.TransactionStatus pl_sub_trans;
		[CCode (cname = "pl.svp_name")]
		public weak string pl_svp_name;
		public weak Gda.TransactionStatus trans;
		public Gda.TransactionStatusEventType type;
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_tree_get_type ()")]
	public class Tree : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "4.2")]
		public Tree ();
		[Version (since = "4.2")]
		public void add_manager (Gda.TreeManager manager);
		[Version (since = "4.2")]
		public void clean ();
		[Version (since = "4.2")]
		public void dump (Gda.TreeNode? node, void* stream);
		public static GLib.Quark error_quark ();
		[Version (since = "4.2")]
		public unowned Gda.TreeNode? get_node (string tree_path, bool use_names);
		[Version (since = "4.2")]
		public unowned Gda.TreeManager get_node_manager (Gda.TreeNode node);
		[Version (since = "4.2")]
		public string get_node_path (Gda.TreeNode node);
		[Version (since = "4.2")]
		public GLib.SList<weak Gda.TreeNode> get_nodes_in_path (string? tree_path, bool use_names);
		[Version (since = "4.2")]
		public void set_attribute (string attribute, GLib.Value value, GLib.DestroyNotify destroy);
		[Version (since = "4.2")]
		public bool update_all () throws GLib.Error;
		[Version (since = "4.2.8")]
		public bool update_children (Gda.TreeNode? node) throws GLib.Error;
		[Version (since = "4.2")]
		public bool update_part (Gda.TreeNode node) throws GLib.Error;
		[NoAccessorMethod]
		public bool is_list { get; }
		[Version (since = "4.2")]
		public virtual signal void node_changed (Gda.TreeNode node);
		[Version (since = "4.2")]
		public virtual signal void node_deleted (string node_path);
		[Version (since = "4.2")]
		public virtual signal void node_has_child_toggled (Gda.TreeNode node);
		[Version (since = "4.2")]
		public virtual signal void node_inserted (Gda.TreeNode node);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_tree_manager_get_type ()")]
	public class TreeManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected TreeManager ();
		[Version (since = "4.2")]
		public void add_manager (Gda.TreeManager sub);
		[Version (since = "4.2")]
		public void add_new_node_attribute (string attribute, GLib.Value? value);
		[Version (since = "4.2")]
		public Gda.TreeNode create_node (Gda.TreeNode? parent, string? name);
		public static GLib.Quark error_quark ();
		[Version (since = "4.2")]
		public unowned GLib.SList<Gda.TreeManager> get_managers ();
		[Version (since = "4.2")]
		public void set_node_create_func (Gda.TreeManagerNodeFunc? func);
		[CCode (has_construct_function = false)]
		[Version (since = "4.2")]
		public TreeManager.with_func (Gda.TreeManagerNodesFunc update_func);
		[NoAccessorMethod]
		public Gda.TreeManagerNodesFunc func { get; set construct; }
		[NoAccessorMethod]
		public bool recursive { get; set construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_tree_mgr_columns_get_type ()")]
	public class TreeMgrColumns : Gda.TreeManager {
		[CCode (has_construct_function = false, type = "GdaTreeManager*")]
		[Version (since = "4.2")]
		public TreeMgrColumns (Gda.Connection cnc, string schema, string table_name);
		[NoAccessorMethod]
		public Gda.Connection connection { owned get; construct; }
		[NoAccessorMethod]
		[Version (since = "4.2.4")]
		public Gda.MetaStore meta_store { owned get; construct; }
		[NoAccessorMethod]
		public string schema { construct; }
		[NoAccessorMethod]
		public string table_name { construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_tree_mgr_label_get_type ()")]
	public class TreeMgrLabel : Gda.TreeManager {
		[CCode (has_construct_function = false, type = "GdaTreeManager*")]
		[Version (since = "4.2")]
		public TreeMgrLabel (string label);
		[NoAccessorMethod]
		public string label { construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_tree_mgr_schemas_get_type ()")]
	public class TreeMgrSchemas : Gda.TreeManager {
		[CCode (has_construct_function = false, type = "GdaTreeManager*")]
		[Version (since = "4.2")]
		public TreeMgrSchemas (Gda.Connection cnc);
		[NoAccessorMethod]
		public Gda.Connection connection { owned get; construct; }
		[NoAccessorMethod]
		[Version (since = "4.2.4")]
		public Gda.MetaStore meta_store { owned get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_tree_mgr_select_get_type ()")]
	public class TreeMgrSelect : Gda.TreeManager {
		[CCode (has_construct_function = false, type = "GdaTreeManager*")]
		[Version (since = "4.2")]
		public TreeMgrSelect (Gda.Connection cnc, Gda.Statement stmt, Gda.Set @params);
		[NoAccessorMethod]
		public Gda.Connection connection { owned get; construct; }
		[NoAccessorMethod]
		public Gda.Set @params { owned get; construct; }
		[NoAccessorMethod]
		public Gda.Statement statement { owned get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_tree_mgr_tables_get_type ()")]
	public class TreeMgrTables : Gda.TreeManager {
		[CCode (has_construct_function = false, type = "GdaTreeManager*")]
		[Version (since = "4.2")]
		public TreeMgrTables (Gda.Connection cnc, string? schema);
		[NoAccessorMethod]
		public Gda.Connection connection { owned get; construct; }
		[NoAccessorMethod]
		[Version (since = "4.2.4")]
		public Gda.MetaStore meta_store { owned get; construct; }
		[NoAccessorMethod]
		public string schema { construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_tree_node_get_type ()")]
	public class TreeNode : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "4.2")]
		public TreeNode (string? name);
		[NoWrapper]
		public virtual void dump_children (string prefix, GLib.StringBuilder in_string);
		[NoWrapper]
		public virtual string dump_header ();
		public static GLib.Quark error_quark ();
		[Version (since = "4.2")]
		public unowned GLib.Value? fetch_attribute (string attribute);
		[Version (since = "4.2")]
		public unowned Gda.TreeNode get_child_index (int index);
		[Version (since = "4.2")]
		public unowned Gda.TreeNode get_child_name (string name);
		[Version (since = "4.2")]
		public GLib.SList<weak Gda.TreeNode> get_children ();
		[Version (since = "4.2")]
		public unowned GLib.Value? get_node_attribute (string attribute);
		[Version (since = "4.2")]
		public unowned Gda.TreeNode get_parent ();
		[Version (since = "4.2")]
		public void set_node_attribute (string attribute, GLib.Value? value, GLib.DestroyNotify destroy);
		[NoAccessorMethod]
		public string name { owned get; set; }
		[Version (since = "4.2")]
		public virtual signal void node_changed (Gda.TreeNode node);
		[Version (since = "4.2")]
		public virtual signal void node_deleted (string relative_path);
		[Version (since = "4.2")]
		public virtual signal void node_has_child_toggled (Gda.TreeNode node);
		[Version (since = "4.2")]
		public virtual signal void node_inserted (Gda.TreeNode node);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_ushort_get_type ()")]
	public class UShort {
		[CCode (has_construct_function = false)]
		protected UShort ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", ref_function = "gda_worker_ref", type_id = "gda_worker_get_type ()", unref_function = "gda_worker_unref")]
	[Compact]
	public class Worker {
		[CCode (has_construct_function = false)]
		[Version (since = "6.0")]
		public Worker ();
		[Version (since = "6.0")]
		public bool cancel_job (uint job_id) throws GLib.Error;
		[Version (since = "6.0")]
		public bool do_job (GLib.MainContext? context, int timeout_ms, void* out_result, uint? out_job_id, [CCode (delegate_target_pos = 5.5, destroy_notify_pos = 6.1)] owned Gda.WorkerFunc func, GLib.DestroyNotify? data_destroy_func) throws GLib.Error;
		public static GLib.Quark error_quark ();
		[Version (since = "6.0")]
		public bool fetch_job_result (uint job_id, void* out_result) throws GLib.Error;
		[Version (since = "6.0")]
		public void forget_job (uint job_id);
		[Version (since = "6.0")]
		public unowned GLib.Thread get_worker_thread ();
		public Gda.Worker new_unique (bool allow_destroy);
		[Version (since = "6.0")]
		public Gda.Worker @ref ();
		[Version (since = "6.0")]
		public bool set_callback (GLib.MainContext? context, Gda.WorkerCallback? callback) throws GLib.Error;
		[Version (since = "6.0")]
		public uint submit_job (GLib.MainContext? callback_context, [CCode (delegate_target_pos = 2.5, destroy_notify_pos = 3.1)] owned Gda.WorkerFunc func, GLib.DestroyNotify? data_destroy_func) throws GLib.Error;
		[Version (since = "6.0")]
		public bool thread_is_worker ();
		[Version (since = "6.0")]
		public void unref ();
		[Version (since = "6.0")]
		public void* wait_job (owned Gda.WorkerFunc func) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_xa_transaction_get_type ()")]
	public class XaTransaction : GLib.Object {
		[CCode (has_construct_function = false)]
		public XaTransaction (uint32 format, string global_transaction_id);
		public bool begin () throws GLib.Error;
		public bool commit (out GLib.SList<Gda.Connection>? cnc_to_recover) throws GLib.Error;
		public bool commit_recovered (out GLib.SList<Gda.Connection>? cnc_to_recover) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public bool register_connection (Gda.Connection cnc, string branch) throws GLib.Error;
		public bool rollback () throws GLib.Error;
		public static Gda.XaTransactionId string_to_id (string str);
		public void unregister_connection (Gda.Connection cnc);
		[NoAccessorMethod]
		public uint format_id { get; construct; }
		[NoAccessorMethod]
		public string transaction_id { owned get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gda_xa_transaction_id_get_type ()")]
	[Compact]
	public class XaTransactionId {
		public ushort bqual_length;
		[CCode (array_length = false)]
		public weak char data[128];
		public uint32 format;
		public ushort gtrid_length;
		public string to_string ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_cname = "GdaDataHandlerInterface", type_id = "gda_data_handler_get_type ()")]
	public interface DataHandler : GLib.Object {
		public abstract bool accepts_g_type (GLib.Type type);
		[Version (since = "4.2.3")]
		public static Gda.DataHandler get_default (GLib.Type for_type);
		public abstract unowned string get_descr ();
		public abstract GLib.Value? get_sane_init_value (GLib.Type type);
		public abstract string get_sql_from_value (GLib.Value? value);
		public abstract string get_str_from_value (GLib.Value? value);
		public abstract GLib.Value? get_value_from_sql (string? sql, GLib.Type type);
		public abstract GLib.Value? get_value_from_str (string? str, GLib.Type type);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_id = "gda_data_model_get_type ()")]
	public interface DataModel : GLib.Object {
		public bool add_data_from_xml_node ([CCode (type = "xmlNodePtr")] Xml.Node* node) throws GLib.Error;
		public int append_row () throws GLib.Error;
		public int append_values (GLib.List<GLib.Value?>? values) throws GLib.Error;
		public Gda.DataModelArray? array_copy_model () throws GLib.Error;
		[Version (since = "5.2.0")]
		public Gda.DataModelArray? array_copy_model_ext ([CCode (array_length_cname = "ncols", array_length_pos = 0.5)] int[] cols) throws GLib.Error;
		public Gda.DataModelIter create_iter ();
		public unowned Gda.Column? describe_column (int col);
		public void dump (void* to_stream);
		public string dump_as_string ();
		public static GLib.Quark error_quark ();
		public bool export_to_file (Gda.DataModelIOFormat format, string file, [CCode (array_length_cname = "nb_cols", array_length_pos = 3.5)] int[]? cols, [CCode (array_length_cname = "nb_rows", array_length_pos = 4.5)] int[]? rows, Gda.Set options) throws GLib.Error;
		public string export_to_string (Gda.DataModelIOFormat format, [CCode (array_length_cname = "nb_cols", array_length_pos = 2.5)] int[]? cols, [CCode (array_length_cname = "nb_rows", array_length_pos = 3.5)] int[]? rows, Gda.Set options);
		public void freeze ();
		public Gda.DataModelAccessFlags get_access_flags ();
		public Gda.ValueAttribute get_attributes_at (int col, int row);
		public int get_column_index (string name);
		[Version (since = "3.2")]
		public unowned string get_column_name (int col);
		public unowned string get_column_title (int col);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "4.2.6")]
		public unowned GLib.Error[] get_exceptions ();
		public int get_n_columns ();
		public int get_n_rows ();
		public bool get_notify ();
		public int get_row_from_values (GLib.SList<GLib.Value?> values, [CCode (array_length = false)] int[] cols_index);
		public unowned GLib.Value? get_typed_value_at (int col, int row, GLib.Type expected_type, bool nullok) throws GLib.Error;
		public unowned GLib.Value? get_value_at (int col, int row) throws GLib.Error;
		public bool import_from_file (string file, GLib.HashTable<int,int>? cols_trans, Gda.Set options) throws GLib.Error;
		public bool import_from_model (Gda.DataModel from, bool overwrite, GLib.HashTable<int,int>? cols_trans) throws GLib.Error;
		public bool import_from_string (string string, GLib.HashTable<int,int>? cols_trans, Gda.Set options) throws GLib.Error;
		public bool iter_move_next_default (Gda.DataModelIter iter);
		public bool iter_move_prev_default (Gda.DataModelIter iter);
		public bool iter_move_to_row_default (Gda.DataModelIter iter, int row);
		public bool remove_row (int row) throws GLib.Error;
		public void send_hint (Gda.DataModelHint hint, GLib.Value? hint_value);
		[Version (since = "3.2")]
		public void set_column_name (int col, string name);
		public void set_column_title (int col, string title);
		public bool set_value_at (int col, int row, GLib.Value value) throws GLib.Error;
		public bool set_values (int row, GLib.List<GLib.Value?>? values) throws GLib.Error;
		public void thaw ();
		public signal void access_changed ();
		public signal void changed ();
		[HasEmitter]
		public signal void reset ();
		[HasEmitter]
		public signal void row_inserted (int row);
		[HasEmitter]
		public signal void row_removed (int row);
		[HasEmitter]
		public signal void row_updated (int row);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_cname = "GdaDbBuildableInterface", type_id = "gda_db_buildable_get_type ()")]
	public interface DbBuildable : GLib.Object {
		[Version (since = "6.0")]
		public abstract bool parse_node ([CCode (type = "xmlNodePtr")] Xml.Node* node) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract bool write_node ([CCode (type = "xmlNodePtr")] Xml.Node* node) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_cname = "GdaDdlModifiableInterface", type_id = "gda_ddl_modifiable_get_type ()")]
	public interface DdlModifiable : GLib.Object {
		[Version (since = "6.0")]
		public abstract bool create (Gda.Connection cnc) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract bool drop (Gda.Connection cnc) throws GLib.Error;
		public static GLib.Quark error_quark ();
		[Version (since = "6.0")]
		public abstract bool rename (Gda.Connection cnc) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_cname = "GdaLockableInterface", type_id = "gda_lockable_get_type ()")]
	public interface Lockable : GLib.Object {
		public abstract void @lock ();
		public abstract bool trylock ();
		public abstract void @unlock ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_cname = "GdaProviderInterface", type_id = "gda_provider_get_type ()")]
	public interface Provider : GLib.Object {
		[Version (since = "6.0")]
		public abstract bool add_savepoint (Gda.Connection cnc, string name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract bool begin_transaction (Gda.Connection cnc, string name, Gda.TransactionIsolation level) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract bool close_connection (Gda.Connection cnc);
		[Version (since = "6.0")]
		public abstract bool commit_transaction (Gda.Connection cnc, string name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Connection create_connection ();
		[Version (since = "6.0")]
		public abstract Gda.ServerOperation create_operation (Gda.Connection cnc, Gda.ServerOperationType type, Gda.Set options) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.SqlParser create_parser (Gda.Connection cnc);
		[Version (since = "6.0")]
		public abstract bool delete_savepoint (Gda.Connection cnc, string name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract string escape_string (Gda.Connection cnc, string str);
		[Version (since = "6.0")]
		public abstract Gda.DataHandler get_data_handler (Gda.Connection cnc, GLib.Type g_type, string dbms_type);
		[Version (since = "6.0")]
		public abstract string get_def_dbms_type (Gda.Connection cnc, GLib.Type g_type);
		public abstract Gda.Set get_last_inserted (Gda.Connection cnc) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract unowned string get_name ();
		[Version (since = "6.0")]
		public abstract unowned string get_server_version (Gda.Connection cnc);
		[Version (since = "6.0")]
		public abstract unowned string get_version ();
		[Version (since = "6.0")]
		public abstract string identifier_quote (Gda.Connection? cnc, string id, bool for_meta_store, bool force_quotes);
		[Version (since = "6.0")]
		public abstract bool open_connection (Gda.Connection cnc, Gda.QuarkList @params, Gda.QuarkList auth);
		[Version (since = "6.0")]
		public abstract bool perform_operation (Gda.Connection cnc, Gda.ServerOperation op) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract bool prepare_connection (Gda.Connection cnc, Gda.QuarkList @params, Gda.QuarkList auth);
		[Version (since = "6.0")]
		public abstract string render_operation (Gda.Connection cnc, Gda.ServerOperation op) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract bool rollback_savepoint (Gda.Connection cnc, string name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract bool rollback_transaction (Gda.Connection cnc, string name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract GLib.Object statement_execute (Gda.Connection cnc, Gda.Statement stmt, Gda.Set @params, Gda.StatementModelUsage model_usage, GLib.Type col_types, Gda.Set last_inserted_row) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract bool statement_prepare (Gda.Connection cnc, Gda.Statement stmt) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.SqlStatement statement_rewrite (Gda.Connection cnc, Gda.Statement stmt, Gda.Set @params) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract string statement_to_sql (Gda.Connection cnc, Gda.Statement stmt, Gda.Set? @params, Gda.StatementSqlFlag flags, out GLib.SList<weak Gda.Holder>? params_used) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract bool supports_feature (Gda.Connection cnc, Gda.ConnectionFeature feature);
		[Version (since = "6.0")]
		public abstract bool supports_operation (Gda.Connection cnc, Gda.ServerOperationType type, Gda.Set options);
		[Version (since = "6.0")]
		public abstract string unescape_string (Gda.Connection cnc, string str);
	}
	[CCode (cheader_filename = "libgda/libgda.h", type_cname = "GdaProviderMetaInterface", type_id = "gda_provider_meta_get_type ()")]
	public interface ProviderMeta : GLib.Object {
		[Version (since = "6.0")]
		public abstract Gda.DataModel btypes () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row character_set (string chset_catalog, string chset_schema, string chset_name_n) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel character_sets () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row check_column (string table_catalog, string table_schema, string table_name, string constraint_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel check_columns () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row collation (string collation_catalog, string collation_schema, string collation_name_n) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel collations () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel columns () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row constraint_ref (string table_catalog, string table_schema, string table_name, string constraint_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row constraint_table (string table_catalog, string table_schema, string table_name, string constraint_name_n) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel constraints_ref () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel constraints_ref_table (string table_catalog, string table_schema, string table_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel constraints_table (string table_catalog, string table_schema, string table_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel constraints_tables () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row domain (string domain_catalog, string domain_schema) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row domain_constraint (string domain_catalog, string domain_schema, string domain_name, string constraint_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel domain_constraints (string domain_catalog, string domain_schema, string domain_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel domains () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel domains_constraints () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row element_type (string specific_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel element_types () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row enum_type (string udt_catalog, string udt_schema, string udt_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel enums_type () throws GLib.Error;
		public static GLib.Quark error_quark ();
		[Version (since = "6.0")]
		public Gda.DataModel? execute_query (string sql, Gda.Set? @params) throws GLib.Error;
		[Version (since = "6.0")]
		public Gda.Row? execute_query_row (string sql, Gda.Set @params) throws GLib.Error;
		[Version (since = "6.0")]
		public Gda.Connection get_connection ();
		[Version (since = "6.0")]
		public abstract Gda.Row index_col (string table_catalog, string table_schema, string table_name, string index_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel index_cols () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row index_table (string table_catalog, string table_schema, string table_name, string index_name_n) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel indexes_table (string table_catalog, string table_schema, string table_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel indexes_tables () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row key_column (string table_catalog, string table_schema, string table_name, string constraint_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel key_columns () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row routine (string routine_catalog, string routine_schema, string routine_name_n) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row routine_col (string rout_catalog, string rout_schema, string rout_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row routine_pars (string rout_catalog, string rout_schema, string rout_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel routines () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel routines_col () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel routines_pars () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row schemata (string catalog_name, string schema_name_n) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel schematas () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row table (string table_catalog, string table_schema, string table_name_n) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row table_column (string table_catalog, string table_schema, string table_name, string column_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel table_columns (string table_catalog, string table_schema, string table_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel tables () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel tables_columns () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row trigger (string table_catalog, string table_schema, string table_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel triggers () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row udt (string udt_catalog, string udt_schema) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row udt_col (string udt_catalog, string udt_schema, string udt_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel udt_cols () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel udts () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row view (string view_catalog, string view_schema, string view_name_n) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.Row view_column (string view_catalog, string view_schema, string view_name, string column_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel view_columns (string view_catalog, string view_schema, string view_name) throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel views () throws GLib.Error;
		[Version (since = "6.0")]
		public abstract Gda.DataModel views_columns () throws GLib.Error;
		[ConcreteAccessor]
		public abstract Gda.Connection connection { owned get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	public struct MetaDbObject {
		public Gda.MetaDbObjectType obj_type;
		public bool outdated;
		public weak string obj_catalog;
		public weak string obj_schema;
		public weak string obj_name;
		public weak string obj_short_name;
		public weak string obj_full_name;
		public weak string obj_owner;
		public weak GLib.SList<Gda.MetaDbObject?> depend_list;
		[CCode (cname = "extra.meta_table")]
		public Gda.MetaTable extra_meta_table;
		[CCode (cname = "extra.meta_view")]
		public Gda.MetaView extra_meta_view;
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	public struct MetaTable {
		public weak GLib.SList<Gda.MetaTableColumn?> columns;
		public int pk_cols_array;
		public int pk_cols_nb;
		public weak GLib.SList<Gda.MetaTableForeignKey?> reverse_fk_list;
		public weak GLib.SList<Gda.MetaTableForeignKey?> fk_list;
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	public struct MetaTableColumn {
		public weak string column_name;
		public weak string column_type;
		public GLib.Type gtype;
		public bool pkey;
		public bool nullok;
		public weak string default_value;
		public bool auto_incement;
		public weak string desc;
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	public struct MetaTableForeignKey {
		public Gda.MetaDbObject meta_table;
		public Gda.MetaDbObject depend_on;
		public int cols_nb;
		public int fk_cols_array;
		public weak string fk_names_array;
		public int ref_pk_cols_array;
		public weak string ref_pk_names_array;
		public weak string fk_name;
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	public struct MetaView {
		public Gda.MetaTable table;
		public weak string view_def;
		public bool is_updatable;
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	public struct ServerProviderHandlerInfo {
		public weak Gda.Connection cnc;
		public GLib.Type g_type;
		public weak string dbms_type;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[SimpleType]
	public struct SqlBuilderId : uint {
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	public struct SqlParserIface {
		public weak Gda.SqlParser parser;
		public weak Gda.SqlStatement parsed_statement;
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	public struct SqlStatementCheckValidityData {
		public weak Gda.Connection cnc;
		public weak Gda.MetaStore store;
		public weak Gda.MetaStruct mstruct;
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	public struct SqlStatementCompound {
		public weak Gda.SqlAnyPart any;
		public Gda.SqlStatementCompoundType compound_type;
		public weak GLib.SList<void*> stmt_list;
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	public struct SqlStatementDelete {
		public weak Gda.SqlAnyPart any;
		public weak Gda.SqlTable table;
		public weak Gda.SqlExpr cond;
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	public struct SqlStatementInsert {
		public weak Gda.SqlAnyPart any;
		public weak string on_conflict;
		public weak Gda.SqlTable table;
		public weak GLib.SList<void*> fields_list;
		public weak GLib.SList<void*> values_list;
		public weak Gda.SqlAnyPart select;
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	public struct SqlStatementSelect {
		public weak Gda.SqlAnyPart any;
		public bool distinct;
		public weak Gda.SqlExpr distinct_expr;
		public weak GLib.SList<void*> expr_list;
		public weak Gda.SqlSelectFrom from;
		public weak Gda.SqlExpr where_cond;
		public weak GLib.SList<void*> group_by;
		public weak Gda.SqlExpr having_cond;
		public weak GLib.SList<void*> order_by;
		public weak Gda.SqlExpr limit_count;
		public weak Gda.SqlExpr limit_offset;
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	public struct SqlStatementTransaction {
		public weak Gda.SqlAnyPart any;
		public Gda.TransactionIsolation isolation_level;
		public weak string trans_mode;
		public weak string trans_name;
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	public struct SqlStatementUnknown {
		public weak Gda.SqlAnyPart any;
		public weak GLib.SList<void*> expressions;
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_type_id = false)]
	public struct SqlStatementUpdate {
		public weak Gda.SqlAnyPart any;
		public weak string on_conflict;
		public weak Gda.SqlTable table;
		public weak GLib.SList<void*> fields_list;
		public weak GLib.SList<void*> expr_list;
		public weak Gda.SqlExpr cond;
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_BATCH_CONFLICTING_PARAMETER_", has_type_id = false)]
	public enum BatchError {
		[CCode (cname = "GDA_BATCH_CONFLICTING_PARAMETER_ERROR")]
		BATCH_CONFLICTING_PARAMETER_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_CONFIG_", has_type_id = false)]
	public enum ConfigError {
		DSN_NOT_FOUND_ERROR,
		PERMISSION_ERROR,
		PROVIDER_NOT_FOUND_ERROR,
		PROVIDER_CREATION_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_CONNECTION_", has_type_id = false)]
	public enum ConnectionError {
		DSN_NOT_FOUND_ERROR,
		PROVIDER_NOT_FOUND_ERROR,
		PROVIDER_ERROR,
		NO_CNC_SPEC_ERROR,
		NO_PROVIDER_SPEC_ERROR,
		OPEN_ERROR,
		ALREADY_OPENED_ERROR,
		STATEMENT_TYPE_ERROR,
		CANT_LOCK_ERROR,
		TASK_NOT_FOUND_ERROR,
		CLOSED_ERROR,
		META_DATA_CONTEXT_ERROR,
		NO_MAIN_CONTEXT_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_CONNECTION_EVENT_CODE_", has_type_id = false)]
	public enum ConnectionEventCode {
		CONSTRAINT_VIOLATION,
		RESTRICT_VIOLATION,
		NOT_NULL_VIOLATION,
		FOREIGN_KEY_VIOLATION,
		UNIQUE_VIOLATION,
		CHECK_VIOLATION,
		INSUFFICIENT_PRIVILEGES,
		UNDEFINED_COLUMN,
		UNDEFINED_FUNCTION,
		UNDEFINED_TABLE,
		DUPLICATE_COLUMN,
		DUPLICATE_DATABASE,
		DUPLICATE_FUNCTION,
		DUPLICATE_SCHEMA,
		DUPLICATE_TABLE,
		DUPLICATE_ALIAS,
		DUPLICATE_OBJECT,
		SYNTAX_ERROR,
		UNKNOWN
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_CONNECTION_EVENT_", has_type_id = false)]
	public enum ConnectionEventType {
		NOTICE,
		WARNING,
		ERROR,
		COMMAND
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_CONNECTION_FEATURE_", has_type_id = false)]
	public enum ConnectionFeature {
		AGGREGATES,
		BLOBS,
		INDEXES,
		INHERITANCE,
		NAMESPACES,
		PROCEDURES,
		SEQUENCES,
		SQL,
		TRANSACTIONS,
		SAVEPOINTS,
		SAVEPOINTS_REMOVE,
		TRIGGERS,
		UPDATABLE_CURSOR,
		USERS,
		VIEWS,
		TRANSACTION_ISOLATION_READ_COMMITTED,
		TRANSACTION_ISOLATION_READ_UNCOMMITTED,
		TRANSACTION_ISOLATION_REPEATABLE_READ,
		TRANSACTION_ISOLATION_SERIALIZABLE,
		XA_TRANSACTIONS,
		LAST
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_CONNECTION_META_", has_type_id = false)]
	public enum ConnectionMetaType {
		NAMESPACES,
		TYPES,
		TABLES,
		VIEWS,
		FIELDS,
		INDEXES
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_CONNECTION_OPTIONS_", has_type_id = false)]
	[Flags]
	public enum ConnectionOptions {
		NONE,
		READ_ONLY,
		SQL_IDENTIFIERS_CASE_SENSITIVE,
		AUTO_META_DATA
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_CONNECTION_STATUS_", has_type_id = false)]
	public enum ConnectionStatus {
		CLOSED,
		OPENING,
		IDLE,
		BUSY
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_COMPARATOR_", has_type_id = false)]
	public enum DataComparatorError {
		MISSING_DATA_MODEL_ERROR,
		COLUMN_TYPES_MISMATCH_ERROR,
		MODEL_ACCESS_ERROR,
		USER_CANCELLED_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_MODEL_ACCESS_", has_type_id = false)]
	[Flags]
	public enum DataModelAccessFlags {
		RANDOM,
		CURSOR_FORWARD,
		CURSOR_BACKWARD,
		CURSOR,
		INSERT,
		UPDATE,
		DELETE,
		WRITE
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_MODEL_HINT_", has_type_id = false)]
	public enum DataModelHint {
		START_BATCH_UPDATE,
		END_BATCH_UPDATE,
		REFRESH
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_MODEL_IO_", has_type_id = false)]
	public enum DataModelIOFormat {
		DATA_ARRAY_XML,
		TEXT_SEPARATED,
		TEXT_TABLE
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_MODEL_ITER_COLUMN_OUT_OF_RANGE_", has_type_id = false)]
	public enum DataModelIterError {
		[CCode (cname = "GDA_DATA_MODEL_ITER_COLUMN_OUT_OF_RANGE_ERROR")]
		DATA_MODEL_ITER_COLUMN_OUT_OF_RANGE_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_PIVOT_", has_type_id = false)]
	public enum DataPivotAggregate {
		AVG,
		COUNT,
		MAX,
		MIN,
		SUM
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_PIVOT_", has_type_id = false)]
	public enum DataPivotError {
		INTERNAL_ERROR,
		SOURCE_MODEL_ERROR,
		FIELD_FORMAT_ERROR,
		USAGE_ERROR,
		OVERFLOW_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_PIVOT_FIELD_", has_type_id = false)]
	public enum DataPivotFieldType {
		ROW,
		COLUMN
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_PROXY_", has_type_id = false)]
	public enum DataProxyError {
		COMMIT_ERROR,
		COMMIT_CANCELLED,
		READ_ONLY_VALUE,
		READ_ONLY_ROW,
		FILTER_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_SELECT_COND_", has_type_id = false)]
	public enum DataSelectConditionType {
		PK,
		ALL_COLUMNS
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_SELECT_", has_type_id = false)]
	public enum DataSelectError {
		MODIFICATION_STATEMENT_ERROR,
		MISSING_MODIFICATION_STATEMENT_ERROR,
		CONNECTION_ERROR,
		ACCESS_ERROR,
		SQL_ERROR,
		SAFETY_LOCKED_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DB_CATALOG_", has_type_id = false)]
	public enum DbCatalogError {
		CONTEXT_NULL,
		DOC_NULL,
		INVALID_XML,
		INVALID_SCHEMA,
		SERVER_OPERATION,
		FILE_READ,
		PARSE_CONTEXT,
		PARSE,
		PARSE_CHUNK,
		CONNECTION_CLOSED
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DB_COLUMN_ERROR_", has_type_id = false)]
	public enum DbColumnError {
		TYPE,
		WRONG_OPERATION
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DB_FKEY_", has_type_id = false)]
	public enum DbFkeyReferenceAction {
		NO_ACTION,
		SET_NULL,
		RESTRICT,
		SET_DEFAULT,
		CASCADE
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DB_INDEX_", has_type_id = false)]
	public enum DbIndexError {
		CONNECTION_NOT_OPENED,
		SERVER_OPERATION
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DB_INDEX_SORT_ORDER_", has_type_id = false)]
	public enum DbIndexSortOrder {
		ASC,
		DESC
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DB_TABLE_", has_type_id = false)]
	public enum DbTableError {
		COLUMN_EMPTY,
		CONNECTION_NOT_OPENED,
		SERVER_OPERATION
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DB_VIEW_", has_type_id = false)]
	public enum DbViewRefAction {
		RESTRICT,
		CASCADE
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DIFF_", has_type_id = false)]
	public enum DiffType {
		ADD_ROW,
		REMOVE_ROW,
		MODIFY_ROW
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_HOLDER_", has_type_id = false)]
	public enum HolderError {
		STRING_CONVERSION_ERROR,
		VALUE_TYPE_ERROR,
		VALUE_NULL_ERROR,
		VALUE_CHANGE_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_META_DB_", has_type_id = false)]
	public enum MetaDbObjectType {
		UNKNOWN,
		TABLE,
		VIEW
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_META_FOREIGN_KEY_", has_type_id = false)]
	public enum MetaForeignKeyPolicy {
		UNKNOWN,
		NONE,
		NO_ACTION,
		RESTRICT,
		CASCADE,
		SET_NULL,
		SET_DEFAULT
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_META_GRAPH_", has_type_id = false)]
	[Flags]
	public enum MetaGraphInfo {
		[CCode (cname = "GDA_META_GRAPH_COLUMNS")]
		META_GRAPH_COLUMNS
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_META_SORT_", has_type_id = false)]
	public enum MetaSortType {
		ALHAPETICAL,
		DEPENDENCIES
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_META_STORE_", has_type_id = false)]
	public enum MetaStoreChangeType {
		ADD,
		REMOVE,
		MODIFY
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_META_STORE_", has_type_id = false)]
	public enum MetaStoreError {
		INCORRECT_SCHEMA_ERROR,
		UNSUPPORTED_PROVIDER_ERROR,
		INTERNAL_ERROR,
		META_CONTEXT_ERROR,
		MODIFY_CONTENTS_ERROR,
		EXTRACT_SQL_ERROR,
		ATTRIBUTE_NOT_FOUND_ERROR,
		ATTRIBUTE_ERROR,
		SCHEMA_OBJECT_NOT_FOUND_ERROR,
		SCHEMA_OBJECT_CONFLICT_ERROR,
		SCHEMA_OBJECT_DESCR_ERROR,
		TRANSACTION_ALREADY_STARTED_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_META_STRUCT_", has_type_id = false)]
	public enum MetaStructError {
		UNKNOWN_OBJECT_ERROR,
		DUPLICATE_OBJECT_ERROR,
		INCOHERENCE_ERROR,
		XML_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_META_STRUCT_FEATURE_", has_type_id = false)]
	[Flags]
	public enum MetaStructFeature {
		NONE,
		FOREIGN_KEYS,
		VIEW_DEPENDENCIES,
		ALL
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SERVER_OPERATION_CREATE_TABLE_", has_type_id = false)]
	[Flags]
	public enum ServerOperationCreateTableFlag {
		NOTHING_FLAG,
		PKEY_FLAG,
		NOT_NULL_FLAG,
		UNIQUE_FLAG,
		AUTOINC_FLAG,
		FKEY_FLAG,
		PKEY_AUTOINC_FLAG
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SERVER_OPERATION_", has_type_id = false)]
	public enum ServerOperationError {
		OBJECT_NAME_ERROR,
		INCORRECT_VALUE_ERROR,
		XML_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SERVER_OPERATION_STATUS_", has_type_id = false)]
	public enum ServerOperationNodeStatus {
		OPTIONAL,
		REQUIRED,
		UNKNOWN
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SERVER_OPERATION_NODE_", has_type_id = false)]
	public enum ServerOperationNodeType {
		PARAMLIST,
		DATA_MODEL,
		PARAM,
		SEQUENCE,
		SEQUENCE_ITEM,
		DATA_MODEL_COLUMN,
		UNKNOWN
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SERVER_OPERATION_", has_type_id = false)]
	public enum ServerOperationType {
		CREATE_DB,
		DROP_DB,
		CREATE_TABLE,
		DROP_TABLE,
		RENAME_TABLE,
		ADD_COLUMN,
		DROP_COLUMN,
		RENAME_COLUMN,
		CREATE_INDEX,
		DROP_INDEX,
		RENAME_INDEX,
		CREATE_VIEW,
		DROP_VIEW,
		COMMENT_TABLE,
		COMMENT_COLUMN,
		CREATE_USER,
		ALTER_USER,
		DROP_USER,
		LAST;
		[CCode (cname = "gda_server_operation_op_type_to_string")]
		public unowned string to_string ();
		[CCode (cname = "gda_server_operation_string_to_op_type")]
		[Version (since = "4.2")]
		public static Gda.ServerOperationType from_string (string str);
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SERVER_PROVIDER_", has_type_id = false)]
	public enum ServerProviderError {
		METHOD_NON_IMPLEMENTED_ERROR,
		PREPARE_STMT_ERROR,
		EMPTY_STMT_ERROR,
		MISSING_PARAM_ERROR,
		STATEMENT_EXEC_ERROR,
		OPERATION_ERROR,
		INTERNAL_ERROR,
		BUSY_ERROR,
		NON_SUPPORTED_ERROR,
		SERVER_VERSION_ERROR,
		DATA_ERROR,
		DEFAULT_VALUE_HANDLING_ERROR,
		MISUSE_ERROR,
		FILE_NOT_FOUND_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SERVER_PROVIDER_FUNCTIONS_", has_type_id = false)]
	public enum ServerProviderFunctionsType {
		BASE,
		META,
		XA,
		MAX
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SERVER_META_", has_type_id = false)]
	public enum ServerProviderMetaType {
		_INFO,
		_BTYPES,
		_UDT,
		UDT,
		_UDT_COLS,
		UDT_COLS,
		_ENUMS,
		ENUMS,
		_DOMAINS,
		DOMAINS,
		_CONSTRAINTS_DOM,
		CONSTRAINTS_DOM,
		_EL_TYPES,
		EL_TYPES,
		_COLLATIONS,
		COLLATIONS,
		_CHARACTER_SETS,
		CHARACTER_SETS,
		_SCHEMATA,
		SCHEMATA,
		_TABLES_VIEWS,
		TABLES_VIEWS,
		_COLUMNS,
		COLUMNS,
		_VIEW_COLS,
		VIEW_COLS,
		_CONSTRAINTS_TAB,
		CONSTRAINTS_TAB,
		_CONSTRAINTS_REF,
		CONSTRAINTS_REF,
		_KEY_COLUMNS,
		KEY_COLUMNS,
		_CHECK_COLUMNS,
		CHECK_COLUMNS,
		_TRIGGERS,
		TRIGGERS,
		_ROUTINES,
		ROUTINES,
		_ROUTINE_COL,
		ROUTINE_COL,
		_ROUTINE_PAR,
		ROUTINE_PAR,
		_INDEXES_TAB,
		INDEXES_TAB,
		_INDEX_COLS,
		INDEX_COLS
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SET_", has_type_id = false)]
	public enum SetError {
		XML_SPEC_ERROR,
		HOLDER_NOT_FOUND_ERROR,
		INVALID_ERROR,
		READ_ONLY_ERROR,
		IMPLEMENTATION_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_ANY_", has_type_id = false)]
	public enum SqlAnyPartType {
		STMT_SELECT,
		STMT_INSERT,
		STMT_UPDATE,
		STMT_DELETE,
		STMT_COMPOUND,
		STMT_BEGIN,
		STMT_ROLLBACK,
		STMT_COMMIT,
		STMT_SAVEPOINT,
		STMT_ROLLBACK_SAVEPOINT,
		STMT_DELETE_SAVEPOINT,
		STMT_UNKNOWN,
		EXPR,
		SQL_FIELD,
		SQL_TABLE,
		SQL_FUNCTION,
		SQL_OPERATION,
		SQL_CASE,
		SQL_SELECT_FIELD,
		SQL_SELECT_TARGET,
		SQL_SELECT_JOIN,
		SQL_SELECT_FROM,
		SQL_SELECT_ORDER
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_BUILDER_", has_type_id = false)]
	public enum SqlBuilderError {
		WRONG_TYPE_ERROR,
		MISUSE_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_IDENTIFIERS_", has_type_id = false)]
	[Flags]
	public enum SqlIdentifierStyle {
		LOWER_CASE,
		UPPER_CASE
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_OPERATOR_TYPE_", has_type_id = false)]
	public enum SqlOperatorType {
		AND,
		OR,
		EQ,
		IS,
		LIKE,
		BETWEEN,
		GT,
		LT,
		GEQ,
		LEQ,
		DIFF,
		REGEXP,
		REGEXP_CI,
		NOT_REGEXP,
		NOT_REGEXP_CI,
		SIMILAR,
		ISNULL,
		ISNOTNULL,
		NOT,
		IN,
		NOTIN,
		CONCAT,
		PLUS,
		MINUS,
		STAR,
		DIV,
		REM,
		BITAND,
		BITOR,
		BITNOT,
		ILIKE,
		NOTLIKE,
		NOTILIKE
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_PARSER_", has_type_id = false)]
	public enum SqlParserError {
		SYNTAX_ERROR,
		OVERFLOW_ERROR,
		EMPTY_SQL_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_PARSER_FLAVOUR_", has_type_id = false)]
	public enum SqlParserFlavour {
		STANDARD,
		SQLITE,
		MYSQL,
		ORACLE,
		POSTGRESQL
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_PARSER_MODE_", has_type_id = false)]
	public enum SqlParserMode {
		PARSE,
		DELIMIT
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_SELECT_JOIN_", has_type_id = false)]
	public enum SqlSelectJoinType {
		CROSS,
		NATURAL,
		INNER,
		LEFT,
		RIGHT,
		FULL;
		[Version (replacement = "SqlSelectJoin.type_to_string")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_STATEMENT_COMPOUND_", has_type_id = false)]
	public enum SqlStatementCompoundType {
		UNION,
		UNION_ALL,
		INTERSECT,
		INTERSECT_ALL,
		EXCEPT,
		EXCEPT_ALL
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_STATEMENT_", has_type_id = false)]
	public enum SqlStatementType {
		SELECT,
		INSERT,
		UPDATE,
		DELETE,
		COMPOUND,
		BEGIN,
		ROLLBACK,
		COMMIT,
		SAVEPOINT,
		ROLLBACK_SAVEPOINT,
		DELETE_SAVEPOINT,
		UNKNOWN,
		NONE;
		[Version (replacement = "SqlStatement.type_to_string")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_STATEMENT_", has_type_id = false)]
	public enum StatementError {
		PARSE_ERROR,
		SYNTAX_ERROR,
		NO_CNC_ERROR,
		CNC_CLOSED_ERROR,
		EXEC_ERROR,
		PARAM_TYPE_ERROR,
		PARAM_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_STATEMENT_MODEL_", has_type_id = false)]
	[Flags]
	public enum StatementModelUsage {
		RANDOM_ACCESS,
		CURSOR_FORWARD,
		CURSOR_BACKWARD,
		CURSOR,
		ALLOW_NOPARAM,
		OFFLINE
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_STATEMENT_SQL_", has_type_id = false)]
	[Flags]
	public enum StatementSqlFlag {
		PARAMS_AS_VALUES,
		PRETTY,
		PARAMS_LONG,
		PARAMS_SHORT,
		PARAMS_AS_COLON,
		PARAMS_AS_DOLLAR,
		PARAMS_AS_QMARK,
		PARAMS_AS_UQMARK,
		TIMEZONE_TO_GMT
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_TRANSACTION_ISOLATION_", has_type_id = false)]
	public enum TransactionIsolation {
		SERVER_DEFAULT,
		READ_COMMITTED,
		READ_UNCOMMITTED,
		REPEATABLE_READ,
		SERIALIZABLE
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_TRANSACTION_STATUS_EVENT_", has_type_id = false)]
	public enum TransactionStatusEventType {
		SAVEPOINT,
		SQL,
		SUB_TRANSACTION
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_TRANSACTION_STATUS_STATE_", has_type_id = false)]
	public enum TransactionStatusState {
		OK,
		FAILED
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_TREE_UNKNOWN_", has_type_id = false)]
	public enum TreeError {
		[CCode (cname = "GDA_TREE_UNKNOWN_ERROR")]
		TREE_UNKNOWN_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_TREE_MANAGER_UNKNOWN_", has_type_id = false)]
	public enum TreeManagerError {
		[CCode (cname = "GDA_TREE_MANAGER_UNKNOWN_ERROR")]
		TREE_MANAGER_UNKNOWN_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_TREE_NODE_UNKNOWN_", has_type_id = false)]
	public enum TreeNodeError {
		[CCode (cname = "GDA_TREE_NODE_UNKNOWN_ERROR")]
		TREE_NODE_UNKNOWN_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_VALUE_ATTR_", has_type_id = false)]
	[Flags]
	public enum ValueAttribute {
		NONE,
		IS_NULL,
		CAN_BE_NULL,
		IS_DEFAULT,
		CAN_BE_DEFAULT,
		IS_UNCHANGED,
		DATA_NON_VALID,
		HAS_VALUE_ORIG,
		NO_MODIF,
		READ_ONLY
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_XA_TRANSACTION_", has_type_id = false)]
	public enum XaTransactionError {
		ALREADY_REGISTERED_ERROR,
		DTP_NOT_SUPPORTED_ERROR,
		CONNECTION_BRANCH_LENGTH_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_XA_", has_type_id = false)]
	public enum XaType {
		START,
		END,
		PREPARE,
		COMMIT,
		ROLLBACK,
		RECOVER
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_MODEL_", has_type_id = false)]
	public errordomain DataModelError {
		ROW_OUT_OF_RANGE_ERROR,
		COLUMN_OUT_OF_RANGE_ERROR,
		VALUES_LIST_ERROR,
		VALUE_TYPE_ERROR,
		ROW_NOT_FOUND_ERROR,
		ACCESS_ERROR,
		FEATURE_NON_SUPPORTED_ERROR,
		FILE_EXIST_ERROR,
		XML_FORMAT_ERROR,
		TRUNCATED_ERROR,
		INVALID,
		OTHER_ERROR;
		[Version (replacement = "DataModel.error_quark")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DDL_MODIFIABLE_", has_type_id = false)]
	public errordomain DdlModifiableError {
		NOT_IMPLEMENTED,
		CONNECTION_NOT_OPENED,
		MISSED_DATA;
		[Version (replacement = "DdlModifiable.error_quark")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_PROVIDER_META_", has_type_id = false)]
	public errordomain ProviderMetaError {
		NO_CONNECTION_ERROR,
		QUERY_ERROR;
		[Version (replacement = "ProviderMeta.error_quark")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_", has_type_id = false)]
	public errordomain SqlError {
		STRUCTURE_CONTENTS_ERROR,
		MALFORMED_IDENTIFIER_ERROR,
		MISSING_IDENTIFIER_ERROR,
		VALIDATION_ERROR;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_WORKER_", has_type_id = false)]
	public errordomain WorkerError {
		INTER_THREAD_ERROR,
		JOB_NOT_FOUND_ERROR,
		JOB_QUEUED_ERROR,
		JOB_BEING_PROCESSED_ERROR,
		JOB_PROCESSED_ERROR,
		JOB_CANCELLED_ERROR,
		THREAD_KILLED;
		[Version (replacement = "Worker.error_quark")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate void ConnectionOpenFunc (Gda.Connection cnc, uint job_id, bool result, GLib.Error error, void* data);
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate bool SqlForeachFunc (Gda.SqlAnyPart part, void* data) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate bool SqlReservedKeywordsFunc (string word);
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate Gda.TreeNode TreeManagerNodeFunc (Gda.TreeManager manager, Gda.TreeNode? parent, string? name);
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate GLib.SList<weak Gda.TreeNode> TreeManagerNodesFunc (Gda.TreeManager manager, Gda.TreeNode? node, GLib.SList<Gda.TreeNode> children_nodes, out bool out_error) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h", instance_pos = 4.9)]
	public delegate void WorkerCallback (Gda.Worker worker, uint job_id, void* result_data, GLib.Error error);
	[CCode (cheader_filename = "libgda/libgda.h", instance_pos = 0.9)]
	public delegate void* WorkerFunc () throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h", cname = "GDA_ATTRIBUTE_AUTO_INCREMENT")]
	public const string ATTRIBUTE_AUTO_INCREMENT;
	[CCode (cheader_filename = "libgda/libgda.h", cname = "GDA_ATTRIBUTE_DESCRIPTION")]
	public const string ATTRIBUTE_DESCRIPTION;
	[CCode (cheader_filename = "libgda/libgda.h", cname = "GDA_ATTRIBUTE_IS_DEFAULT")]
	public const string ATTRIBUTE_IS_DEFAULT;
	[CCode (cheader_filename = "libgda/libgda.h", cname = "GDA_ATTRIBUTE_NAME")]
	public const string ATTRIBUTE_NAME;
	[CCode (cheader_filename = "libgda/libgda.h", cname = "GDA_ATTRIBUTE_NUMERIC_PRECISION")]
	public const string ATTRIBUTE_NUMERIC_PRECISION;
	[CCode (cheader_filename = "libgda/libgda.h", cname = "GDA_ATTRIBUTE_NUMERIC_SCALE")]
	public const string ATTRIBUTE_NUMERIC_SCALE;
	[CCode (cheader_filename = "libgda/libgda.h", cname = "GDA_ATTRIBUTE_TREE_NODE_UNKNOWN_CHILDREN")]
	public const string ATTRIBUTE_TREE_NODE_UNKNOWN_CHILDREN;
	[CCode (cheader_filename = "libgda/libgda.h", cname = "GDA_EXTRA_AUTO_INCREMENT")]
	public const string EXTRA_AUTO_INCREMENT;
	[CCode (cheader_filename = "libgda/libgda.h", cname = "GDA_SQLSTATE_GENERAL_ERROR")]
	public const string SQLSTATE_GENERAL_ERROR;
	[CCode (cheader_filename = "libgda/libgda.h", cname = "GDA_SQLSTATE_NO_ERROR")]
	public const string SQLSTATE_NO_ERROR;
	[CCode (cheader_filename = "libgda/libgda.h", cname = "GDA_TIMEZONE_INVALID")]
	public const int TIMEZONE_INVALID;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static string? alphanum_to_text (string text);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "libgda/libgda.h")]
	public static string[]? completion_list_get (Gda.Connection cnc, string sql, int start, int end);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool compute_dml_statements (Gda.Connection cnc, Gda.Statement select_stmt, bool require_pk, out Gda.Statement? insert_stmt, out Gda.Statement? update_stmt, out Gda.Statement? delete_stmt) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static Gda.SqlStatement? compute_select_statement_from_update (Gda.Statement update_stmt) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static Gda.SqlExpr? compute_unique_table_row_condition (Gda.SqlStatementSelect stsel, Gda.MetaTable mtable, bool require_pk) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (since = "4.0.3")]
	public static Gda.SqlExpr? compute_unique_table_row_condition_with_cnc (Gda.Connection? cnc, Gda.SqlStatementSelect stsel, Gda.MetaTable mtable, bool require_pk) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (replacement = "DataHandler.get_default", since = "4.2.3")]
	public static Gda.DataHandler data_handler_get_default (GLib.Type for_type);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.DateTime date_time_copy (GLib.DateTime ts);
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (replacement = "Default.escape_string")]
	public static string? default_escape_string (string string);
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (replacement = "Default.unescape_string")]
	public static string? default_unescape_string (string string);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void dsn_split (string string, string out_dsn, string out_username, string out_password);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Type g_type_from_string (string str);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string g_type_to_string (GLib.Type type);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool identifier_equal (string id1, string id2);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static uint identifier_hash (string id);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void log_disable ();
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void log_enable ();
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool log_is_enabled ();
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (since = "5.2")]
	public static bool parse_formatted_date (GLib.Date gdate, string value, GLib.DateDMY first, GLib.DateDMY second, GLib.DateDMY third, char sep);
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (since = "6.0")]
	public static Gda.Time parse_formatted_time (string value, char sep);
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (since = "5.2")]
	public static GLib.DateTime? parse_formatted_timestamp (string value, GLib.DateDMY first, GLib.DateDMY second, GLib.DateDMY third, char sep);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool parse_iso8601_date (GLib.Date gdate, string value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static Gda.Time parse_iso8601_time (string value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (since = "4.2.9")]
	public static Gda.SqlStatement? rewrite_sql_statement_for_null_parameters (owned Gda.SqlStatement sqlst, Gda.Set @params, out bool out_modified) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (since = "4.2.9")]
	public static bool rewrite_statement_for_null_parameters (Gda.Statement stmt, Gda.Set @params, out Gda.Statement? out_stmt) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool rfc1738_decode (string string);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static string? rfc1738_encode (string string);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static Gda.Statement select_alter_select_for_empty (Gda.Statement stmt) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (since = "5.0")]
	public static string sql_identifier_force_quotes (string str);
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (since = "5.0")]
	public static string sql_identifier_prepare_for_compare (string str);
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (since = "4.0.3")]
	public static string? sql_identifier_quote (string id, Gda.Connection? cnc, Gda.ServerProvider? prov, bool meta_store_convention, bool force_quotes);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "libgda/libgda.h")]
	public static string[]? sql_identifier_split (string id);
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (replacement = "SqlOperation.operator_from_string")]
	public static Gda.SqlOperatorType sql_operation_operator_from_string (string op);
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (replacement = "SqlOperation.operator_to_string")]
	public static unowned string sql_operation_operator_to_string (Gda.SqlOperatorType op);
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (replacement = "SqlStatement.string_to_type")]
	public static Gda.SqlStatementType sql_statement_string_to_type (string type);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static string sql_value_stringify (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static Gda.Binary string_to_binary (string? str);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static Gda.Blob string_to_blob (string str);
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (replacement = "Text.to_alphanum")]
	public static string text_to_alphanum (string text);
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (since = "4.2.6")]
	public static bool utility_check_data_model_v (Gda.DataModel model, [CCode (array_length_cname = "nbcols", array_length_pos = 1.5)] GLib.Type[] types);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool utility_data_model_dump_data_to_xml (Gda.DataModel model, [CCode (type = "xmlNodePtr")] Xml.Node* parent, [CCode (array_length_cname = "nb_cols", array_length_pos = 3.5)] int[]? cols, [CCode (array_length_cname = "nb_rows", array_length_pos = 4.5)] int[]? rows, bool use_col_ids);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string? utility_data_model_find_column_description (Gda.DataSelect model, string field_name);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool utility_holder_load_attributes (Gda.Holder holder, [CCode (type = "xmlNodePtr")] Xml.Node* node, GLib.SList<Gda.DataModel>? sources) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static int value_compare (GLib.Value value1, GLib.Value value2);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value? value_copy (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static int value_differ (GLib.Value value1, GLib.Value value2);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_free (owned GLib.Value? value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.Binary value_get_binary (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.Blob value_get_blob (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.GeometricPoint value_get_geometric_point (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.MetaStoreChange value_get_meta_store_change (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.Numeric value_get_numeric (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static short value_get_short (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.Time value_get_time (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static ushort value_get_ushort (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool value_is_null (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool value_is_number (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value? value_new (GLib.Type type);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value? value_new_binary (owned uint8 val, long size);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value? value_new_blob (uint8 val, long size);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value? value_new_blob_from_file (string filename);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value? value_new_date_time_from_timet (time_t val);
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (since = "4.2.9")]
	public static GLib.Value? value_new_default (string? default_val);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value? value_new_from_string (string as_string, GLib.Type type);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value? value_new_from_xml ([CCode (type = "const xmlNodePtr")] Xml.Node node);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value? value_new_null ();
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (since = "6.0")]
	public static GLib.Value? value_new_time_from_timet (time_t val);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_reset_with_type (GLib.Value value, GLib.Type type);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_binary (GLib.Value value, Gda.Binary binary);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_blob (GLib.Value value, Gda.Blob blob);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool value_set_from_string (GLib.Value value, string as_string, GLib.Type type);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool value_set_from_value (GLib.Value value, GLib.Value from);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_geometric_point (GLib.Value value, Gda.GeometricPoint val);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_meta_store_change (GLib.Value value, Gda.MetaStoreChange change);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_null (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_numeric (GLib.Value value, Gda.Numeric val);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_short (GLib.Value value, short val);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_time (GLib.Value value, Gda.Time val);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_ushort (GLib.Value value, ushort val);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static string value_stringify (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_take_binary (GLib.Value value, owned Gda.Binary binary);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_take_blob (GLib.Value value, owned Gda.Blob blob);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static string value_to_xml_string (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Version (replacement = "Worker.new_unique")]
	public static Gda.Worker worker_new_unique (Gda.Worker location, bool allow_destroy);
}
