/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.store.IndexIntervalManager;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.NodeStoreLarge;
import com.amazon.randomcutforest.tree.NodeStoreMedium;
import com.amazon.randomcutforest.tree.NodeStoreSmall;
import java.util.Stack;

public abstract class AbstractNodeStore {
    public static int Null = -1;
    public static boolean DEFAULT_STORE_PARENT = false;
    protected final int capacity;
    protected final float[] cutValue;
    protected IndexIntervalManager freeNodeManager;

    public AbstractNodeStore(Builder<?> builder) {
        this.capacity = builder.capacity;
        if (builder.leftIndex == null) {
            this.freeNodeManager = new IndexIntervalManager(this.capacity);
        }
        this.cutValue = builder.cutValues != null ? builder.cutValues : new float[this.capacity];
    }

    protected abstract int addNode(Stack<int[]> var1, float[] var2, long var3, int var5, int var6, int var7, int var8, float var9, BoundingBox var10);

    public boolean isLeaf(int index) {
        return index > this.capacity;
    }

    public boolean isInternal(int index) {
        return index < this.capacity && index >= 0;
    }

    public abstract void assignInPartialTree(int var1, float[] var2, int var3);

    public abstract int getLeftIndex(int var1);

    public abstract int getRightIndex(int var1);

    public abstract int getParentIndex(int var1);

    public abstract void setRoot(int var1);

    protected abstract void decreaseMassOfInternalNode(int var1);

    protected abstract void increaseMassOfInternalNode(int var1);

    protected void manageInternalNodesPartial(Stack<int[]> path) {
        while (!path.isEmpty()) {
            int index = path.pop()[0];
            this.increaseMassOfInternalNode(index);
        }
    }

    public Stack<int[]> getPath(int root, float[] point, boolean verbose) {
        int node = root;
        Stack<int[]> answer = new Stack<int[]>();
        answer.push(new int[]{root, this.capacity});
        while (this.isInternal(node)) {
            double y = this.getCutValue(node);
            if (this.leftOf(node, point)) {
                answer.push(new int[]{this.getLeftIndex(node), this.getRightIndex(node)});
                node = this.getLeftIndex(node);
                continue;
            }
            answer.push(new int[]{this.getRightIndex(node), this.getLeftIndex(node)});
            node = this.getRightIndex(node);
        }
        return answer;
    }

    public abstract void deleteInternalNode(int var1);

    public abstract int getMass(int var1);

    protected boolean leftOf(float cutValue, int cutDimension, float[] point) {
        return point[cutDimension] <= cutValue;
    }

    public boolean leftOf(int node, float[] point) {
        int cutDimension = this.getCutDimension(node);
        return this.leftOf(this.cutValue[node], cutDimension, point);
    }

    public int getSibling(int node, int parent) {
        int sibling = this.getLeftIndex(parent);
        if (node == sibling) {
            sibling = this.getRightIndex(parent);
        }
        return sibling;
    }

    public abstract void spliceEdge(int var1, int var2, int var3);

    public abstract void replaceParentBySibling(int var1, int var2, int var3);

    public abstract int getCutDimension(int var1);

    public double getCutValue(int index) {
        return this.cutValue[index];
    }

    protected boolean toLeft(float[] point, int currentNodeOffset) {
        return point[this.getCutDimension(currentNodeOffset)] <= this.cutValue[currentNodeOffset];
    }

    public abstract int[] getCutDimension();

    public abstract int[] getRightIndex();

    public abstract int[] getLeftIndex();

    public float[] getCutValues() {
        return this.cutValue;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int size() {
        return this.capacity - this.freeNodeManager.size();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>> {
        protected int capacity;
        protected int[] leftIndex;
        protected int[] rightIndex;
        protected int[] cutDimension;
        protected float[] cutValues;
        protected boolean storeParent = DEFAULT_STORE_PARENT;
        protected int dimension;
        protected int root;

        public T capacity(int capacity) {
            this.capacity = capacity;
            return (T)this;
        }

        public T dimension(int dimension) {
            this.dimension = dimension;
            return (T)this;
        }

        public T useRoot(int root) {
            this.root = root;
            return (T)this;
        }

        public T leftIndex(int[] leftIndex) {
            this.leftIndex = leftIndex;
            return (T)this;
        }

        public T rightIndex(int[] rightIndex) {
            this.rightIndex = rightIndex;
            return (T)this;
        }

        public T cutDimension(int[] cutDimension) {
            this.cutDimension = cutDimension;
            return (T)this;
        }

        public T cutValues(float[] cutValues) {
            this.cutValues = cutValues;
            return (T)this;
        }

        public T storeParent(boolean storeParent) {
            this.storeParent = storeParent;
            return (T)this;
        }

        public AbstractNodeStore build() {
            if (this.leftIndex == null) {
                CommonUtils.checkArgument(this.rightIndex == null, " incorrect option of right indices");
                CommonUtils.checkArgument(this.cutValues == null, "incorrect option of cut values");
                CommonUtils.checkArgument(this.cutDimension == null, " incorrect option of cut dimensions");
            } else {
                CommonUtils.checkArgument(this.rightIndex.length == this.capacity, " incorrect length of right indices");
                CommonUtils.checkArgument(this.cutValues.length == this.capacity, "incorrect length of cut values");
                CommonUtils.checkArgument(this.cutDimension.length == this.capacity, " incorrect length of cut dimensions");
            }
            if (this.capacity < 256 && this.dimension <= 256) {
                return new NodeStoreSmall(this);
            }
            if (this.capacity < 65535 && this.dimension <= 65535) {
                return new NodeStoreMedium(this);
            }
            return new NodeStoreLarge(this);
        }
    }
}

