"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.oaepHashSupported = void 0;
/* oaepHash support was added in Node.js v12.9.1 (https://github.com/nodejs/node/pull/28335)
 * However, the integration tests need to be able to verify functionality on other versions.
 * There are no constants to sniff,
 * and looking at the version would not catch back-ports.
 * So I simply try the function.
 * However there is a rub as the test might seem backwards.
 * Sending an invalid hash to the version that supports oaepHash will throw an error.
 * But sending an invalid hash to a version that does not support oaepHash will be ignored.
 */
const material_management_node_1 = require("@aws-crypto/material-management-node");
const crypto_1 = require("crypto");
exports.oaepHashSupported = (function () {
    const key = '-----BEGIN PUBLIC KEY-----\nMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAs7RoNYEPAIws89VV+kra\nrVv/4wbdmUAaAKWgWuxZi5na9GJSmnhCkqyLRm7wPbQY4LCoa5/IMUxkHLsYDPdu\nudY0Qm0GcoxOlvJKHYo4RjF7HyiS34D6dvyO4Gd3aq0mZHoxSGCxW/7hf03wEMzc\niVJXWHXhaI0lD6nrzIEgLrE4L+3V2LeAQjvZsTKd+bYMqeZOL2syiVVIAU8POwAG\nGVBroJoveFm/SUp6lCiN0M2kTeyQA2ax3QTtZSAa8nwrI7U52XOzVmdMicJsy2Pg\nuW98te3MuODdK24yNkHIkYameP/Umf/SJshUJQd5a/TUp3XE+HhOWAumx22tIDlC\nvZS11cuk2fp0WeHUnXaC19N5qWKfvHEKSugzty/z3lGP7ItFhrF2X1qJHeAAsL11\nkjo6Lc48KsE1vKvbnW4VLyB3wdNiVvmUNO29tPXwaR0Q5Gbr3jk3nUzdkEHouHWQ\n41lubOHCCBN3V13mh/MgtNhESHjfmmOnh54ErD9saA1d7CjTf8g2wqmjEqvGSW6N\nq7zhcWR2tp1olflS7oHzul4/I3hnkfL6Kb2xAWWaQKvg3mtsY2OPlzFEP0tR5UcH\nPfp5CeS1Xzg7hN6vRICW6m4l3u2HJFld2akDMm1vnSz8RCbPW7jp7YBxUkWJmypM\ntG7Yv2aGZXGbUtM8o1cZarECAwEAAQ==\n-----END PUBLIC KEY-----';
    const oaepHash = 'i_am_not_valid';
    try {
        // @ts-ignore
        (0, crypto_1.publicEncrypt)({ key, padding: crypto_1.constants.RSA_PKCS1_OAEP_PADDING, oaepHash }, Buffer.from([1, 2, 3, 4]));
        /* See note above,
         * only versions that support oaepHash will respond.
         * So the only way I can get here is if the option was ignored.
         */
        return false;
    }
    catch (ex) {
        if (ex instanceof material_management_node_1.NotSupported) {
            (0, material_management_node_1.needs)(ex.code === 'ERR_OSSL_EVP_INVALID_DIGEST', 'Unexpected error testing oaepHash.');
            return true;
        }
        return Error('Unexpected error testing oaepHash.');
    }
})();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib2FlcF9oYXNoX3N1cHBvcnRlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9vYWVwX2hhc2hfc3VwcG9ydGVkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSxvRUFBb0U7QUFDcEUsc0NBQXNDOzs7QUFFdEM7Ozs7Ozs7O0dBUUc7QUFFSCxtRkFBMEU7QUFFMUUsbUNBQWlEO0FBRXBDLFFBQUEsaUJBQWlCLEdBQUcsQ0FBQztJQUNoQyxNQUFNLEdBQUcsR0FDUCw4eUJBQTh5QixDQUFBO0lBRWh6QixNQUFNLFFBQVEsR0FBRyxnQkFBZ0IsQ0FBQTtJQUNqQyxJQUFJO1FBQ0YsYUFBYTtRQUNiLElBQUEsc0JBQWEsRUFDWCxFQUFFLEdBQUcsRUFBRSxPQUFPLEVBQUUsa0JBQVMsQ0FBQyxzQkFBc0IsRUFBRSxRQUFRLEVBQUUsRUFDNUQsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQzFCLENBQUE7UUFDRDs7O1dBR0c7UUFDSCxPQUFPLEtBQUssQ0FBQTtLQUNiO0lBQUMsT0FBTyxFQUFFLEVBQUU7UUFDWCxJQUFJLEVBQUUsWUFBWSx1Q0FBWSxFQUFFO1lBQzlCLElBQUEsZ0NBQUssRUFDSCxFQUFFLENBQUMsSUFBSSxLQUFLLDZCQUE2QixFQUN6QyxvQ0FBb0MsQ0FDckMsQ0FBQTtZQUNELE9BQU8sSUFBSSxDQUFBO1NBQ1o7UUFDRCxPQUFPLEtBQUssQ0FBQyxvQ0FBb0MsQ0FBQyxDQUFBO0tBQ25EO0FBQ0gsQ0FBQyxDQUFDLEVBQUUsQ0FBQSJ9