/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { OuiMarkdownEditor } from './markdown_editor';
export { getDefaultOuiMarkdownParsingPlugins, getDefaultOuiMarkdownProcessingPlugins, getDefaultOuiMarkdownUiPlugins } from './plugins/markdown_default_plugins';
export { OuiMarkdownContext } from './markdown_context';
export { OuiMarkdownFormat } from './markdown_format';
export {} from './markdown_types';
/* OUI -> EUI Aliases: Build-Time */

export { EuiMarkdownEditor } from '../../eui_components/markdown_editor/markdown_editor';
/* OUI -> EUI Aliases: Build-Time */

export { getDefaultEuiMarkdownParsingPlugins, getDefaultEuiMarkdownProcessingPlugins, getDefaultEuiMarkdownUiPlugins } from '../../eui_components/markdown_editor/plugins/markdown_default_plugins';
/* OUI -> EUI Aliases: Build-Time */

export { EuiMarkdownContext } from '../../eui_components/markdown_editor/markdown_context';
/* OUI -> EUI Aliases: Build-Time */

export { EuiMarkdownFormat } from '../../eui_components/markdown_editor/markdown_format';
/* OUI -> EUI Aliases: Build-Time */

export {} from '../../eui_components/markdown_editor/markdown_types';