/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.security.ssl.config.Certificate;
import org.opensearch.security.ssl.config.KeyStoreConfiguration;
import org.opensearch.security.ssl.config.SslParameters;
import org.opensearch.security.ssl.config.TrustStoreConfiguration;

public class SslConfiguration {
    private static final Logger LOGGER = LogManager.getLogger(SslConfiguration.class);
    private final SslParameters sslParameters;
    private final TrustStoreConfiguration trustStoreConfiguration;
    private final KeyStoreConfiguration keyStoreConfiguration;

    public SslConfiguration(SslParameters sslParameters, TrustStoreConfiguration trustStoreConfiguration, KeyStoreConfiguration keyStoreConfiguration) {
        this.sslParameters = sslParameters;
        this.trustStoreConfiguration = trustStoreConfiguration;
        this.keyStoreConfiguration = keyStoreConfiguration;
    }

    public List<Path> dependentFiles() {
        return Stream.concat(this.keyStoreConfiguration.files().stream(), Stream.of(this.trustStoreConfiguration.file())).collect(Collectors.toList());
    }

    public List<Certificate> certificates() {
        return Stream.concat(this.trustStoreConfiguration.loadCertificates().stream(), this.keyStoreConfiguration.loadCertificates().stream()).collect(Collectors.toList());
    }

    public SslParameters sslParameters() {
        return this.sslParameters;
    }

    SslContext buildServerSslContext(boolean validateCertificates) {
        try {
            return AccessController.doPrivileged(() -> SslContextBuilder.forServer((KeyManagerFactory)this.keyStoreConfiguration.createKeyManagerFactory(validateCertificates)).sslProvider(this.sslParameters.provider()).clientAuth(this.sslParameters.clientAuth()).protocols(this.sslParameters.allowedProtocols().toArray(new String[0])).ciphers(this.sslParameters.allowedCiphers()).sessionCacheSize(0L).sessionTimeout(0L).applicationProtocolConfig(ApplicationProtocolConfig.DISABLED).trustManager(this.trustStoreConfiguration.createTrustManagerFactory(validateCertificates)).build());
        }
        catch (PrivilegedActionException e) {
            throw new OpenSearchException("Failed to build server SSL context", (Throwable)e, new Object[0]);
        }
    }

    SslContext buildClientSslContext(boolean validateCertificates) {
        try {
            return AccessController.doPrivileged(() -> SslContextBuilder.forClient().sslProvider(this.sslParameters.provider()).protocols(this.sslParameters.allowedProtocols()).ciphers(this.sslParameters.allowedCiphers()).applicationProtocolConfig(ApplicationProtocolConfig.DISABLED).sessionCacheSize(0L).sessionTimeout(0L).sslProvider(this.sslParameters.provider()).keyManager(this.keyStoreConfiguration.createKeyManagerFactory(validateCertificates)).trustManager(this.trustStoreConfiguration.createTrustManagerFactory(validateCertificates)).build());
        }
        catch (PrivilegedActionException e) {
            throw new OpenSearchException("Failed to build client SSL context", (Throwable)e, new Object[0]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SslConfiguration that = (SslConfiguration)o;
        return Objects.equals(this.sslParameters, that.sslParameters) && Objects.equals(this.trustStoreConfiguration, that.trustStoreConfiguration) && Objects.equals(this.keyStoreConfiguration, that.keyStoreConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.sslParameters, this.trustStoreConfiguration, this.keyStoreConfiguration);
    }
}

