/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.command;

import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Parser;
import net.sourceforge.plantuml.klimt.creole.command.Command;
import net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.style.ISkinSimple;

public class CommandCreoleSprite
implements Command {
    private static final Pattern2 pattern = MyPattern.cmpile("^(\\<\\$([-\\p{L}0-9_/]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,color[= :](?:#[0-9a-fA-F]{6}|\\w+))?\\}?)?\\>)");

    @Override
    public String startingChars() {
        return "<";
    }

    private CommandCreoleSprite() {
    }

    public static Command create() {
        return new CommandCreoleSprite();
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m4 = pattern.matcher(line);
        if (!m4.find()) {
            return 0;
        }
        return m4.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m4 = pattern.matcher(line);
        if (!m4.find()) {
            throw new IllegalStateException();
        }
        String src = m4.group(2);
        double scale = Parser.getScale(m4.group(3), 1.0);
        String colorName = Parser.getColor(m4.group(3));
        HColor color = null;
        if (colorName != null) {
            ISkinSimple skinParam = stripe.getSkinParam();
            color = skinParam.getIHtmlColorSet().getColorOrWhite(colorName);
        }
        stripe.addSprite(src, scale, color);
        return line.substring(m4.group(1).length());
    }
}

