/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.utils.Log;

public class PngSizer {
    public static BufferedImage process(BufferedImage im, int minsize) {
        if (minsize != Integer.MAX_VALUE) {
            return PngSizer.resize(im, minsize);
        }
        return im;
    }

    private static BufferedImage resize(BufferedImage im, int minsize) {
        Log.info("Resizing file to " + minsize);
        if (im.getWidth() >= minsize) {
            return im;
        }
        BufferedImage newIm = new BufferedImage(minsize, im.getHeight(), 1);
        Graphics2D g2d = newIm.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, newIm.getWidth(), newIm.getHeight());
        int delta = (minsize - im.getWidth()) / 2;
        g2d.drawImage((Image)im, delta, 0, null);
        g2d.dispose();
        return newIm;
    }
}

