/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.dot.DotSplines;
import net.sourceforge.plantuml.dot.Graphviz;
import net.sourceforge.plantuml.dot.GraphvizUtils;
import net.sourceforge.plantuml.dot.GraphvizVersion;
import net.sourceforge.plantuml.dot.GraphvizVersions;
import net.sourceforge.plantuml.dot.ProcessState;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.Moveable;
import net.sourceforge.plantuml.klimt.geom.Rankdir;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.skin.PragmaKey;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.svek.BaseFile;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.EmptySvgException;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekEdge;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.SvgResult;
import net.sourceforge.plantuml.svek.YDelta;
import net.sourceforge.plantuml.utils.Position;
import net.sourceforge.plantuml.vizjs.GraphvizJs;
import net.sourceforge.plantuml.vizjs.GraphvizJsRuntimeException;

public final class DotStringFactory
implements Moveable {
    private final UmlDiagramType umlDiagramType;
    private final ISkinParam skinParam;
    private final Bibliotekon bibliotekon;
    private final Cluster root;
    private GraphvizVersion graphvizVersion;

    public DotStringFactory(Bibliotekon bibliotekon, Cluster root, UmlDiagramType umlDiagramType, ISkinParam skinParam) {
        this.bibliotekon = bibliotekon;
        this.skinParam = skinParam;
        this.umlDiagramType = umlDiagramType;
        this.root = root;
    }

    private double getHorizontalDzeta(StringBounder stringBounder) {
        double max = 0.0;
        for (SvekEdge l : this.getBibliotekon().allLines()) {
            double c = l.getHorizontalDzeta(stringBounder);
            if (!(c > max)) continue;
            max = c;
        }
        return max / 10.0;
    }

    public Bibliotekon getBibliotekon() {
        return this.bibliotekon;
    }

    private double getVerticalDzeta(StringBounder stringBounder) {
        double max = 0.0;
        for (SvekEdge l : this.getBibliotekon().allLines()) {
            double c = l.getVerticalDzeta(stringBounder);
            if (!(c > max)) continue;
            max = c;
        }
        if (this.root.diagram.getPragma().isTrue(PragmaKey.KERMOR)) {
            return max / 100.0;
        }
        return max / 10.0;
    }

    private String createDotString(StringBounder stringBounder, DotMode dotMode, String ... dotStrings) {
        StringBuilder sb = new StringBuilder();
        double nodesep = this.getHorizontalDzeta(stringBounder);
        if (nodesep < (double)this.getMinNodeSep()) {
            nodesep = this.getMinNodeSep();
        }
        if (this.skinParam.getNodesep() != 0.0) {
            nodesep = this.skinParam.getNodesep();
        }
        String nodesepInches = SvekUtils.pixelToInches(nodesep);
        double ranksep = this.getVerticalDzeta(stringBounder);
        if (ranksep < (double)this.getMinRankSep()) {
            ranksep = this.getMinRankSep();
        }
        if (this.skinParam.getRanksep() != 0.0) {
            ranksep = this.skinParam.getRanksep();
        }
        String ranksepInches = SvekUtils.pixelToInches(ranksep);
        sb.append("digraph unix {");
        SvekUtils.println(sb);
        for (String s2 : dotStrings) {
            if (s2.startsWith("ranksep")) {
                sb.append("ranksep=" + ranksepInches + ";");
            } else if (s2.startsWith("nodesep")) {
                sb.append("nodesep=" + nodesepInches + ";");
            } else {
                sb.append(s2);
            }
            SvekUtils.println(sb);
        }
        sb.append("remincross=true;");
        SvekUtils.println(sb);
        sb.append("searchsize=500;");
        SvekUtils.println(sb);
        DotSplines dotSplines = this.skinParam.getDotSplines();
        if (dotSplines == DotSplines.POLYLINE) {
            sb.append("splines=polyline;");
            SvekUtils.println(sb);
        } else if (dotSplines == DotSplines.ORTHO) {
            sb.append("splines=ortho;");
            sb.append("forcelabels=true;");
            SvekUtils.println(sb);
        }
        if (this.skinParam.getRankdir() == Rankdir.LEFT_TO_RIGHT) {
            sb.append("rankdir=LR;");
            SvekUtils.println(sb);
        }
        this.manageMinMaxCluster(sb);
        if (this.root.diagram.getPragma().isTrue(PragmaKey.KERMOR)) {
            for (SvekEdge line : this.getBibliotekon().lines0()) {
                line.appendLine(this.getGraphvizVersion(), sb, dotMode, dotSplines);
            }
            for (SvekEdge line : this.getBibliotekon().lines1()) {
                line.appendLine(this.getGraphvizVersion(), sb, dotMode, dotSplines);
            }
            this.root.printCluster3_forKermor(sb, this.getBibliotekon().allLines(), stringBounder, dotMode, this.getGraphvizVersion(), this.umlDiagramType);
        } else {
            this.root.printCluster1(sb, this.getBibliotekon().allLines(), stringBounder);
            for (SvekEdge line : this.getBibliotekon().lines0()) {
                line.appendLine(this.getGraphvizVersion(), sb, dotMode, dotSplines);
            }
            this.root.printCluster2(sb, this.getBibliotekon().allLines(), stringBounder, dotMode, this.getGraphvizVersion(), this.umlDiagramType);
            for (SvekEdge line : this.getBibliotekon().lines1()) {
                line.appendLine(this.getGraphvizVersion(), sb, dotMode, dotSplines);
            }
        }
        SvekUtils.println(sb);
        sb.append("}");
        return sb.toString();
    }

    private void manageMinMaxCluster(StringBuilder sb) {
        ArrayList<String> minPointCluster = new ArrayList<String>();
        ArrayList<String> maxPointCluster = new ArrayList<String>();
        for (Cluster cluster : this.getBibliotekon().allCluster()) {
            String maxPoint;
            String minPoint = cluster.getMinPoint(this.umlDiagramType);
            if (minPoint != null) {
                minPointCluster.add(minPoint);
            }
            if ((maxPoint = cluster.getMaxPoint(this.umlDiagramType)) == null) continue;
            maxPointCluster.add(maxPoint);
        }
        if (minPointCluster.size() > 0) {
            sb.append("{rank=min;");
            for (String s2 : minPointCluster) {
                sb.append(s2);
                sb.append(" [shape=point,width=.01,label=\"\"]");
                sb.append(";");
            }
            sb.append("}");
            SvekUtils.println(sb);
        }
        if (maxPointCluster.size() > 0) {
            sb.append("{rank=max;");
            for (String s2 : maxPointCluster) {
                sb.append(s2);
                sb.append(" [shape=point,width=.01,label=\"\"]");
                sb.append(";");
            }
            sb.append("}");
            SvekUtils.println(sb);
        }
    }

    private int getMinRankSep() {
        if (this.umlDiagramType == UmlDiagramType.ACTIVITY) {
            return 40;
        }
        if (this.root.diagram.getPragma().isTrue(PragmaKey.KERMOR)) {
            return 40;
        }
        return 60;
    }

    private int getMinNodeSep() {
        if (this.umlDiagramType == UmlDiagramType.ACTIVITY) {
            return 20;
        }
        return 35;
    }

    public GraphvizVersion getGraphvizVersion() {
        if (this.graphvizVersion == null) {
            this.graphvizVersion = this.getGraphvizVersionInternal();
        }
        return this.graphvizVersion;
    }

    private GraphvizVersion getGraphvizVersionInternal() {
        Graphviz graphviz = GraphvizUtils.create(this.skinParam, "foo;", "svg");
        if (graphviz instanceof GraphvizJs) {
            return GraphvizJs.getGraphvizVersion(false);
        }
        File f = graphviz.getDotExe();
        return GraphvizVersions.getInstance().getVersion(f);
    }

    public String getSvg(StringBounder stringBounder, DotMode dotMode, BaseFile basefile, String[] dotOptions) throws IOException {
        ByteArrayOutputStream baos;
        block5: {
            String dotString = this.createDotString(stringBounder, dotMode, dotOptions);
            if (basefile != null) {
                SFile f = basefile.getTraceFile("svek.dot");
                SvekUtils.traceString(f, dotString);
            }
            Graphviz graphviz = GraphvizUtils.create(this.skinParam, dotString, "svg");
            baos = new ByteArrayOutputStream();
            try {
                ProcessState state = graphviz.createFile3(baos);
                baos.close();
                if (state.differs(ProcessState.TERMINATED_OK())) {
                    throw new IllegalStateException("Timeout4 " + state, state.getCause());
                }
            }
            catch (GraphvizJsRuntimeException e) {
                System.err.println("GraphvizJsRuntimeException");
                this.graphvizVersion = GraphvizJs.getGraphvizVersion(true);
                dotString = this.createDotString(stringBounder, dotMode, dotOptions);
                graphviz = GraphvizUtils.create(this.skinParam, dotString, "svg");
                baos = new ByteArrayOutputStream();
                ProcessState state = graphviz.createFile3(baos);
                baos.close();
                if (!state.differs(ProcessState.TERMINATED_OK())) break block5;
                throw new IllegalStateException("Timeout4 " + state, state.getCause());
            }
        }
        byte[] result = baos.toByteArray();
        String s2 = new String(result, StandardCharsets.UTF_8);
        if (basefile != null) {
            SFile f = basefile.getTraceFile("svek.svg");
            SvekUtils.traceString(f, s2);
        }
        return s2;
    }

    public boolean illegalDotExe() {
        Graphviz graphviz = GraphvizUtils.create(this.skinParam, "svg", new String[0]);
        if (graphviz instanceof GraphvizJs) {
            return false;
        }
        File dotExe = graphviz.getDotExe();
        return dotExe == null || !dotExe.isFile() || !dotExe.canRead();
    }

    public File getDotExe() {
        Graphviz graphviz = GraphvizUtils.create(this.skinParam, "svg", new String[0]);
        return graphviz.getDotExe();
    }

    public void solve(String svg) throws IOException, InterruptedException {
        List<XPoint2D> points;
        int idx;
        if (svg.length() == 0) {
            throw new EmptySvgException();
        }
        Pattern pGraph = Pattern.compile("(?m)\\<svg\\s+width=\"(\\d+)pt\"\\s+height=\"(\\d+)pt\"");
        Matcher mGraph = pGraph.matcher(svg);
        if (!mGraph.find()) {
            throw new IllegalStateException();
        }
        int fullHeight = Integer.parseInt(mGraph.group(2));
        YDelta move = new YDelta(fullHeight);
        SvgResult svgResult = new SvgResult(svg, move);
        for (SvekNode node : this.getBibliotekon().allNodes()) {
            idx = svg.indexOf("<title>" + node.getUid() + "</title>");
            if (node.getType() == ShapeType.RECTANGLE || node.getType() == ShapeType.RECTANGLE_HTML_FOR_PORTS || node.getType() == ShapeType.RECTANGLE_WITH_CIRCLE_INSIDE || node.getType() == ShapeType.FOLDER || node.getType() == ShapeType.DIAMOND || node.getType() == ShapeType.RECTANGLE_PORT) {
                List<XPoint2D> points2 = svgResult.substring(idx).extractList("points=\"");
                XPoint2D min2 = SvekUtils.getMinXY(points2);
                node.moveDelta(min2.getX(), min2.getY());
                continue;
            }
            if (node.getType() == ShapeType.ROUND_RECTANGLE) {
                int idx2 = svg.indexOf("d=\"", idx + 1);
                idx = svg.indexOf("points=\"", idx + 1);
                if (idx2 != -1 && (idx == -1 || idx2 < idx)) {
                    points = svgResult.substring(idx2).extractList("d=\"");
                } else {
                    points = svgResult.substring(idx).extractList("points=\"");
                    for (int i = 0; i < 3; ++i) {
                        idx = svg.indexOf("points=\"", idx + 1);
                        points.addAll(svgResult.substring(idx).extractList("points=\""));
                    }
                }
                XPoint2D min3 = SvekUtils.getMinXY(points);
                node.moveDelta(min3.getX(), min3.getY());
                continue;
            }
            if (node.getType() == ShapeType.OCTAGON || node.getType() == ShapeType.HEXAGON) {
                int starting = idx = svg.indexOf("points=\"", idx + 1);
                points = svgResult.substring(starting).extractList("points=\"");
                XPoint2D min4 = SvekUtils.getMinXY(points);
                node.moveDelta(min4.getX(), min4.getY());
                node.setPolygon(min4.getX(), min4.getY(), points);
                continue;
            }
            if (node.getType() == ShapeType.CIRCLE || node.getType() == ShapeType.OVAL) {
                double cx = SvekUtils.getValue(svg, idx, "cx");
                double cy = SvekUtils.getValue(svg, idx, "cy") + (double)fullHeight;
                double rx = SvekUtils.getValue(svg, idx, "rx");
                double ry = SvekUtils.getValue(svg, idx, "ry");
                node.moveDelta(cx - rx, cy - ry);
                continue;
            }
            throw new IllegalStateException(node.getType().toString() + " " + node.getUid());
        }
        for (Cluster cluster : this.getBibliotekon().allCluster()) {
            if (cluster.getGroup().isPacked()) continue;
            int starting = idx = this.getClusterIndex(svg, cluster.getColor());
            points = svgResult.substring(starting).extractList("points=\"");
            XPoint2D min5 = SvekUtils.getMinXY(points);
            XPoint2D max = SvekUtils.getMaxXY(points);
            cluster.setPosition(min5, max);
            if (cluster.getTitleAndAttributeWidth() == 0 || cluster.getTitleAndAttributeHeight() == 0) continue;
            idx = this.getClusterIndex(svg, cluster.getTitleColor());
            List<XPoint2D> pointsTitle = svgResult.substring(idx).extractList("points=\"");
            cluster.setTitlePosition(SvekUtils.getMinXY(pointsTitle));
            if (!this.root.diagram.getPragma().isTrue(PragmaKey.KERMOR)) continue;
            if (cluster.getGroup().getNotes(Position.TOP).size() > 0) {
                List<XPoint2D> noteUp = svgResult.substring(this.getClusterIndex(svg, cluster.getColorNoteTop())).extractList("points=\"");
                cluster.setNoteTopPosition(SvekUtils.getMinXY(noteUp));
            }
            if (cluster.getGroup().getNotes(Position.BOTTOM).size() <= 0) continue;
            List<XPoint2D> noteBottom = svgResult.substring(this.getClusterIndex(svg, cluster.getColorNoteBottom())).extractList("points=\"");
            cluster.setNoteBottomPosition(SvekUtils.getMinXY(noteBottom));
        }
        for (SvekEdge line : this.getBibliotekon().allLines()) {
            line.solveLine(svgResult);
        }
        for (SvekEdge line : this.getBibliotekon().allLines()) {
            line.manageCollision(this.getBibliotekon().allNodes());
        }
    }

    private int getClusterIndex(String svg, int colorInt) {
        String colorString = StringUtils.goLowerCase(StringUtils.sharp000000(colorInt));
        String keyTitle1 = "=\"" + colorString + "\"";
        int idx = svg.indexOf(keyTitle1);
        if (idx == -1) {
            String keyTitle2 = "stroke:" + colorString + ";";
            idx = svg.indexOf(keyTitle2);
        }
        if (idx == -1) {
            throw new IllegalStateException("Cannot find color " + colorString);
        }
        return idx;
    }

    @Override
    public void moveDelta(double deltaX, double deltaY) {
        for (SvekNode sh : this.getBibliotekon().allNodes()) {
            sh.moveDelta(deltaX, deltaY);
        }
        for (SvekEdge line : this.getBibliotekon().allLines()) {
            line.moveDelta(deltaX, deltaY);
        }
        for (Cluster cl : this.getBibliotekon().allCluster()) {
            cl.moveDelta(deltaX, deltaY);
        }
    }
}

