/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class TeXLongNumber
extends AbstractTeXObject
implements TeXNumber {
    private long value;

    public TeXLongNumber() {
        this(0L);
    }

    public TeXLongNumber(long l) {
        this.value = l;
    }

    public TeXLongNumber(TeXParser teXParser, String string) throws TeXSyntaxException {
        try {
            this.value = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TeXSyntaxException((Throwable)numberFormatException, teXParser, "tex.error.number_expected", string);
        }
    }

    @Override
    public Object clone() {
        return new TeXLongNumber(this.value);
    }

    @Override
    public boolean isDataObject() {
        return true;
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.getValue();
    }

    @Override
    public int getValue() {
        return (int)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public void setValue(long l) {
        this.value = l;
    }

    public void setValue(double d) {
        this.value = (long)d;
    }

    public void setValue(float f) {
        this.value = (long)f;
    }

    @Override
    public void multiply(int n) {
        this.value *= (long)n;
    }

    @Override
    public void divide(int n) {
        this.value /= (long)n;
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        if (numerical instanceof TeXNumber) {
            this.advance((TeXNumber)numerical);
        } else {
            this.value += (long)numerical.number(teXParser);
        }
    }

    public void advance(TeXNumber teXNumber) throws TeXSyntaxException {
        this.value += teXNumber.longValue();
    }

    public void advance() {
        ++this.value;
    }

    public void add(long l) {
        this.value += l;
    }

    public void subtract(long l) {
        this.value -= l;
    }

    public void multiple(long l) {
        this.value *= l;
    }

    public void divide(long l) {
        this.value /= l;
    }

    @Override
    public String format() {
        return "" + this.value;
    }

    public String toString() {
        return String.format("%s[value=%f]", this.getClass().getSimpleName(), this.value);
    }

    @Override
    public String toString(TeXParser teXParser) {
        return "" + this.value;
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return teXParser.string(this.toString(teXParser));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.getListener().getWriteable().write("" + this.value);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }
}

