/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.CsvList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.datatool.DataBase;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolHeader;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import com.dickimawbooks.texparserlib.latex.latex3.SequenceCommand;
import com.dickimawbooks.texparserlib.latex.latex3.TokenListCommand;
import java.io.IOException;
import java.util.Vector;

public class DTLdisplaydb
extends Command {
    protected boolean isLong;
    protected DataToolSty sty;

    public DTLdisplaydb(DataToolSty dataToolSty) {
        this("DTLdisplaydb", false, dataToolSty);
    }

    public DTLdisplaydb(String string, boolean bl, DataToolSty dataToolSty) {
        super(string);
        this.isLong = bl;
        this.sty = dataToolSty;
    }

    @Override
    public Object clone() {
        return new DTLdisplaydb(this.getName(), this.isLong, this.sty);
    }

    protected TeXObjectList construct(String string, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        TokenListCommand tokenListCommand;
        Object object;
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        DataBase dataBase = this.sty.getDataBase(string);
        int n = dataBase.getRowCount();
        int n2 = dataBase.getColumnCount();
        teXParser.putControlSequence(true, new TextualContentCommand("dtldbname", string));
        TokenListCommand tokenListCommand2 = new TokenListCommand("l__datatool_content_tl");
        teXParser.putControlSequence(true, tokenListCommand2);
        TokenListCommand tokenListCommand3 = new TokenListCommand("l__datatool_align_tl");
        teXParser.putControlSequence(true, tokenListCommand3);
        TokenListCommand tokenListCommand4 = new TokenListCommand("l__datatool_row_tl");
        teXParser.putControlSequence(true, tokenListCommand4);
        TokenListCommand tokenListCommand5 = new TokenListCommand("l__datatool_tmpb_tl");
        SequenceCommand sequenceCommand = laTeXParserListener.getSequenceCommand("l__datatool_only_columns_seq", teXObjectList);
        if (sequenceCommand == null) {
            sequenceCommand = new SequenceCommand("l__datatool_only_columns_seq");
        }
        if (!sequenceCommand.isEmpty()) {
            for (int i = 0; i < sequenceCommand.size(); ++i) {
                TeXObject teXObject2 = sequenceCommand.get(i);
                object = TeXParserUtils.toNumerical(teXObject2, teXParser, teXObjectList);
                sequenceCommand.set(i, (TeXObject)object);
            }
        } else {
            SequenceCommand sequenceCommand2 = laTeXParserListener.getSequenceCommand("l__datatool_only_keys_seq", teXObjectList);
            if (sequenceCommand2 != null && !sequenceCommand2.isEmpty()) {
                for (int i = 0; i < sequenceCommand2.size(); ++i) {
                    String string2 = teXParser.expandToString(sequenceCommand2.get(i), teXObjectList);
                    object = dataBase.getHeader(string2);
                    int n3 = ((DataToolHeader)object).getColumnIndex();
                    sequenceCommand.append(new UserNumber(n3));
                }
            } else {
                TeXObject teXObject3;
                int n4;
                Vector<Integer> vector = null;
                sequenceCommand2 = laTeXParserListener.getSequenceCommand("l__datatool_omit_columns_seq", teXObjectList);
                if (sequenceCommand2 != null && !sequenceCommand2.isEmpty()) {
                    vector = new Vector<Integer>(sequenceCommand2.size());
                    for (n4 = 0; n4 < sequenceCommand2.size(); ++n4) {
                        object = sequenceCommand2.get(n4);
                        teXObject3 = TeXParserUtils.toNumerical((TeXObject)object, teXParser, teXObjectList);
                        vector.add(teXObject3.number(teXParser));
                    }
                } else {
                    sequenceCommand2 = laTeXParserListener.getSequenceCommand("l__datatool_omit_keys_seq", teXObjectList);
                    if (sequenceCommand2 != null && !sequenceCommand2.isEmpty()) {
                        for (n4 = 0; n4 < sequenceCommand2.size(); ++n4) {
                            object = teXParser.expandToString(sequenceCommand2.get(n4), teXObjectList);
                            teXObject3 = dataBase.getHeader((String)object);
                            int n5 = ((DataToolHeader)teXObject3).getColumnIndex();
                            vector.add(n5);
                        }
                    }
                }
                for (n4 = 1; n4 <= n2; ++n4) {
                    if (vector != null && vector.contains(n4)) continue;
                    sequenceCommand.append(new UserNumber(n4));
                }
            }
        }
        if (sequenceCommand.isEmpty()) {
            throw new LaTeXSyntaxException(teXParser, "datatool.no.columns", string);
        }
        teXParser.putControlSequence(true, new SequenceCommand("l__datatool_column_indexes_seq", sequenceCommand));
        teXParser.getSettings().localSetRegister("l__datatool_max_cols_int", new UserNumber(sequenceCommand.size()));
        NumericRegister numericRegister = teXParser.getSettings().getNumericRegister("l__datatool_max_cols_int");
        teXParser.getSettings().localSetRegister("dtlcolumnnum", UserNumber.ZERO);
        teXParser.getSettings().localSetRegister("dtlrownum", UserNumber.ZERO);
        NumericRegister numericRegister2 = teXParser.getSettings().getNumericRegister("dtlcolumnnum");
        object = teXParser.getSettings().getNumericRegister("dtlrownum");
        teXParser.getSettings().localSetRegister("l__datatool_row_idx_int", UserNumber.ZERO);
        NumericRegister numericRegister3 = teXParser.getSettings().getNumericRegister("l__datatool_row_idx_int");
        TokenListCommand tokenListCommand6 = laTeXParserListener.getTokenListCommand("l__datatool_user_align_tl", teXObjectList);
        if (!tokenListCommand6.isEmpty()) {
            teXParser.putControlSequence(true, new TokenListCommand("l__datatool_align_tl", tokenListCommand6));
        }
        if ((tokenListCommand = laTeXParserListener.getTokenListCommand("l__datatool_user_header_tl", teXObjectList)).isEmpty()) {
            if (!TeXParserUtils.isTrue("l_datatool_include_header_bool", teXParser)) {
                tokenListCommand = new TokenListCommand("l__datatool_user_header_tl", TeXParserUtils.createStack(teXParser, TokenListCommand.EMPTY));
                teXParser.putControlSequence(true, tokenListCommand);
            }
        } else {
            teXParser.putControlSequence(true, new TokenListCommand("l__datatool_row_tl", tokenListCommand));
        }
        if (tokenListCommand6.isEmpty() || tokenListCommand.isEmpty()) {
            for (int i = 0; i < sequenceCommand.size(); ++i) {
                teXObject = TeXParserUtils.toNumerical(sequenceCommand.get(i), teXParser, teXObjectList);
                int n6 = teXObject.number(teXParser);
                numericRegister2.advance(teXParser, UserNumber.ONE);
                DataToolHeader dataToolHeader = dataBase.getHeader(n6);
                TeXNumber teXNumber = dataToolHeader.getNumericalType(teXParser);
                TeXObjectList teXObjectList2 = laTeXParserListener.createStack();
                if (tokenListCommand6.isEmpty()) {
                    teXObjectList2.add(laTeXParserListener.getControlSequence("dtladdalign"));
                    teXObjectList2.add(tokenListCommand3);
                    teXObjectList2.add(teXNumber);
                    teXObjectList2.add(numericRegister2);
                    teXObjectList2.add(numericRegister);
                    TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
                }
                if (!tokenListCommand.isEmpty()) continue;
                if (!tokenListCommand4.isEmpty()) {
                    tokenListCommand4.append(laTeXParserListener.getTab());
                }
                tokenListCommand5.clear();
                teXObjectList2.add(laTeXParserListener.getControlSequence("dtladdheaderalign"));
                teXObjectList2.add(tokenListCommand5);
                teXObjectList2.add(teXNumber);
                teXObjectList2.add(numericRegister2);
                teXObjectList2.add(numericRegister);
                TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
                TeXObjectList teXObjectList3 = laTeXParserListener.createStack();
                teXObjectList3.add(laTeXParserListener.getControlSequence("dtlcolumnheader"));
                Group group = laTeXParserListener.createGroup();
                teXObjectList3.add(group);
                group.addAll(tokenListCommand5.getContent());
                TeXObject teXObject4 = dataToolHeader.getTitle();
                if (teXObject4 == null) {
                    teXObjectList3.add(laTeXParserListener.createGroup(dataToolHeader.getColumnLabel()));
                } else {
                    group = laTeXParserListener.createGroup();
                    teXObjectList3.add(group);
                    group.add((TeXObject)teXObject4.clone(), true);
                }
                tokenListCommand4.rightConcat(teXObjectList3.expandonce(teXParser, teXObjectList));
            }
        }
        TeXObjectList teXObjectList4 = laTeXParserListener.createStack();
        if (!this.isLong) {
            teXObjectList4.add(laTeXParserListener.getControlSequence("DTLdisplaydbAddBegin"));
            teXObjectList4.add(tokenListCommand2);
            teXObjectList4.add(tokenListCommand3);
            teXObject = laTeXParserListener.createGroup();
            if (!tokenListCommand4.isEmpty()) {
                ((Vector)((Object)teXObject)).addAll(tokenListCommand4.getContent());
            }
            teXObjectList4.add(teXObject);
        }
        TeXParserUtils.process(teXObjectList4, teXParser, teXObjectList);
        for (int i = 1; i <= n; ++i) {
            numericRegister3.setValue(teXParser, new UserNumber(i));
            teXObjectList4.add(laTeXParserListener.getControlSequence("__datatool_if_display_row:nNT"));
            teXObjectList4.add(numericRegister3);
            teXObjectList4.add(tokenListCommand2);
            teXObjectList4.add(TeXParserUtils.createGroup(teXParser, laTeXParserListener.getControlSequence("__datatool_display_db_row:Nn"), tokenListCommand2, numericRegister3));
            TeXParserUtils.process(teXObjectList4, teXParser, teXObjectList);
        }
        if (!this.isLong) {
            teXObjectList4.add(laTeXParserListener.getControlSequence("DTLdisplaydbAddEnd"));
            teXObjectList4.add(tokenListCommand2);
        }
        TeXParserUtils.process(teXObjectList4, teXParser, teXObjectList);
        ControlSequence controlSequence = laTeXParserListener.getControlSequence("l__datatool_pre_display_tl");
        if (controlSequence.isEmpty()) {
            return tokenListCommand2.getContent();
        }
        teXObjectList4.add(controlSequence);
        teXObjectList4.addAll(tokenListCommand2.getContent());
        return teXObjectList4;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        boolean bl = this.isLong ? true : this.popModifier(teXParser, teXObjectList, 42) == 42;
        TeXObject teXObject = this.popOptArg(teXParser, teXObjectList);
        String string = this.popLabelString(teXParser, teXObjectList);
        if (this.sty.dbExists(string)) {
            TeXObjectList teXObjectList2;
            teXParser.startGroup();
            if (bl) {
                if (teXObject != null && !teXObject.isEmpty()) {
                    this.sty.processDisplayKeys(teXObject, teXObjectList);
                }
            } else {
                if (teXObject == null || teXObject.isEmpty()) {
                    teXParser.putControlSequence(true, new SequenceCommand("l__datatool_omit_columns_seq"));
                } else {
                    teXObjectList2 = TeXParserUtils.toCsvList(teXObject, teXParser);
                    teXParser.putControlSequence(true, SequenceCommand.createFromClist(teXParser, "l__datatool_omit_columns_seq", (CsvList)teXObjectList2));
                }
                teXParser.putControlSequence(true, new SequenceCommand("l__datatool_only_columns_seq"));
                teXParser.putControlSequence(true, new SequenceCommand("l__datatool_only_keys_seq"));
                teXParser.putControlSequence(true, new SequenceCommand("l__datatool_omit_keys_seq"));
            }
            teXObjectList2 = this.construct(string, teXParser, teXObjectList);
            teXParser.endGroup();
            return teXObjectList2;
        }
        throw new LaTeXSyntaxException(teXParser, "datatool.db_doesnt_exist", string);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList);
    }
}

