/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.CaseChange;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import java.io.IOException;

public class GlsXtrHierName
extends AbstractGlsCommand {
    protected CaseChange caseChange;
    protected boolean caseChangeRootOnly = false;

    public GlsXtrHierName(GlossariesSty glossariesSty) {
        this("glsxtrhiername", CaseChange.NO_CHANGE, false, glossariesSty);
    }

    public GlsXtrHierName(String string, CaseChange caseChange, boolean bl, GlossariesSty glossariesSty) {
        super(string, glossariesSty);
        this.caseChange = caseChange;
        this.caseChangeRootOnly = bl;
    }

    @Override
    public Object clone() {
        return new GlsXtrHierName(this.name, this.caseChange, this.caseChangeRootOnly, this.sty);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        GlsLabel glsLabel = this.popEntryLabel(teXParser, teXObjectList);
        TeXObjectList teXObjectList2 = teXParser.getListener().createStack();
        this.addEntry(glsLabel.getEntry(), teXObjectList2, teXParser, teXObjectList);
        return teXObjectList2;
    }

    protected void addEntry(GlossaryEntry glossaryEntry, TeXObjectList teXObjectList, TeXParser teXParser, TeXObjectList teXObjectList2) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        if (glossaryEntry != null) {
            String string;
            GlossaryEntry glossaryEntry2 = glossaryEntry.getParent(teXObjectList2);
            boolean bl = glossaryEntry.hasField("short");
            if (!teXObjectList.isEmpty()) {
                teXObjectList.push(teXParserListener.getControlSequence("glsxtrhiernamesep"));
            }
            if (glossaryEntry2 != null && this.caseChangeRootOnly) {
                string = bl ? "glsfmtshort" : "glsfmtname";
            } else {
                switch (this.caseChange) {
                    case SENTENCE: {
                        string = bl ? "Glsfmtshort" : "Glsfmtname";
                        break;
                    }
                    case TO_UPPER: {
                        string = bl ? "GLSfmtshort" : "GLSfmtname";
                        break;
                    }
                    default: {
                        string = bl ? "glsfmtshort" : "glsfmtname";
                    }
                }
            }
            teXObjectList.push(teXParserListener.createGroup(glossaryEntry.getLabel()));
            teXObjectList.push(teXParserListener.getControlSequence(string));
            if (glossaryEntry2 != null) {
                this.addEntry(glossaryEntry2, teXObjectList, teXParser, teXObjectList2);
            }
        }
    }
}

