// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATtiny212.atdf, see http://packs.download.atmel.com/

//go:build avr && attiny212

// Device information for the ATtiny212.
package avr

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATtiny212"
	ARCH   = "AVR8X"
	FAMILY = "AVR TINY"
)

// Interrupts
const (
	IRQ_RESET       = 0  //
	IRQ_CRCSCAN_NMI = 1  //
	IRQ_BOD_VLM     = 2  //
	IRQ_PORTA_PORT  = 3  //
	IRQ_RTC_CNT     = 6  //
	IRQ_RTC_PIT     = 7  //
	IRQ_TCA0_LUNF   = 8  //
	IRQ_TCA0_OVF    = 8  //
	IRQ_TCA0_HUNF   = 9  //
	IRQ_TCA0_LCMP0  = 10 //
	IRQ_TCA0_CMP0   = 10 //
	IRQ_TCA0_CMP1   = 11 //
	IRQ_TCA0_LCMP1  = 11 //
	IRQ_TCA0_CMP2   = 12 //
	IRQ_TCA0_LCMP2  = 12 //
	IRQ_TCB0_INT    = 13 //
	IRQ_TCD0_OVF    = 14 //
	IRQ_TCD0_TRIG   = 15 //
	IRQ_AC0_AC      = 16 //
	IRQ_ADC0_RESRDY = 17 //
	IRQ_ADC0_WCOMP  = 18 //
	IRQ_TWI0_TWIS   = 19 //
	IRQ_TWI0_TWIM   = 20 //
	IRQ_SPI0_INT    = 21 //
	IRQ_USART0_RXC  = 22 //
	IRQ_USART0_DRE  = 23 //
	IRQ_USART0_TXC  = 24 //
	IRQ_NVMCTRL_EE  = 25 //
	IRQ_max         = 25 // Highest interrupt number on this device.
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export __vector_RESET
//go:interrupt
func interruptRESET() {
	callHandlers(IRQ_RESET)
}

//export __vector_CRCSCAN_NMI
//go:interrupt
func interruptCRCSCAN_NMI() {
	callHandlers(IRQ_CRCSCAN_NMI)
}

//export __vector_BOD_VLM
//go:interrupt
func interruptBOD_VLM() {
	callHandlers(IRQ_BOD_VLM)
}

//export __vector_PORTA_PORT
//go:interrupt
func interruptPORTA_PORT() {
	callHandlers(IRQ_PORTA_PORT)
}

//export __vector_RTC_CNT
//go:interrupt
func interruptRTC_CNT() {
	callHandlers(IRQ_RTC_CNT)
}

//export __vector_RTC_PIT
//go:interrupt
func interruptRTC_PIT() {
	callHandlers(IRQ_RTC_PIT)
}

//export __vector_TCA0_LUNF
//go:interrupt
func interruptTCA0_LUNF() {
	callHandlers(IRQ_TCA0_LUNF)
}

//export __vector_TCA0_OVF
//go:interrupt
func interruptTCA0_OVF() {
	callHandlers(IRQ_TCA0_OVF)
}

//export __vector_TCA0_HUNF
//go:interrupt
func interruptTCA0_HUNF() {
	callHandlers(IRQ_TCA0_HUNF)
}

//export __vector_TCA0_LCMP0
//go:interrupt
func interruptTCA0_LCMP0() {
	callHandlers(IRQ_TCA0_LCMP0)
}

//export __vector_TCA0_CMP0
//go:interrupt
func interruptTCA0_CMP0() {
	callHandlers(IRQ_TCA0_CMP0)
}

//export __vector_TCA0_CMP1
//go:interrupt
func interruptTCA0_CMP1() {
	callHandlers(IRQ_TCA0_CMP1)
}

//export __vector_TCA0_LCMP1
//go:interrupt
func interruptTCA0_LCMP1() {
	callHandlers(IRQ_TCA0_LCMP1)
}

//export __vector_TCA0_CMP2
//go:interrupt
func interruptTCA0_CMP2() {
	callHandlers(IRQ_TCA0_CMP2)
}

//export __vector_TCA0_LCMP2
//go:interrupt
func interruptTCA0_LCMP2() {
	callHandlers(IRQ_TCA0_LCMP2)
}

//export __vector_TCB0_INT
//go:interrupt
func interruptTCB0_INT() {
	callHandlers(IRQ_TCB0_INT)
}

//export __vector_TCD0_OVF
//go:interrupt
func interruptTCD0_OVF() {
	callHandlers(IRQ_TCD0_OVF)
}

//export __vector_TCD0_TRIG
//go:interrupt
func interruptTCD0_TRIG() {
	callHandlers(IRQ_TCD0_TRIG)
}

//export __vector_AC0_AC
//go:interrupt
func interruptAC0_AC() {
	callHandlers(IRQ_AC0_AC)
}

//export __vector_ADC0_RESRDY
//go:interrupt
func interruptADC0_RESRDY() {
	callHandlers(IRQ_ADC0_RESRDY)
}

//export __vector_ADC0_WCOMP
//go:interrupt
func interruptADC0_WCOMP() {
	callHandlers(IRQ_ADC0_WCOMP)
}

//export __vector_TWI0_TWIS
//go:interrupt
func interruptTWI0_TWIS() {
	callHandlers(IRQ_TWI0_TWIS)
}

//export __vector_TWI0_TWIM
//go:interrupt
func interruptTWI0_TWIM() {
	callHandlers(IRQ_TWI0_TWIM)
}

//export __vector_SPI0_INT
//go:interrupt
func interruptSPI0_INT() {
	callHandlers(IRQ_SPI0_INT)
}

//export __vector_USART0_RXC
//go:interrupt
func interruptUSART0_RXC() {
	callHandlers(IRQ_USART0_RXC)
}

//export __vector_USART0_DRE
//go:interrupt
func interruptUSART0_DRE() {
	callHandlers(IRQ_USART0_DRE)
}

//export __vector_USART0_TXC
//go:interrupt
func interruptUSART0_TXC() {
	callHandlers(IRQ_USART0_TXC)
}

//export __vector_NVMCTRL_EE
//go:interrupt
func interruptNVMCTRL_EE() {
	callHandlers(IRQ_NVMCTRL_EE)
}

// Peripherals instances.
var (
	AC0     = (*AC_Type)(unsafe.Pointer(uintptr(0x670)))
	ADC0    = (*ADC_Type)(unsafe.Pointer(uintptr(0x600)))
	BOD     = (*BOD_Type)(unsafe.Pointer(uintptr(0x80)))
	CCL     = (*CCL_Type)(unsafe.Pointer(uintptr(0x1c0)))
	CLKCTRL = (*CLKCTRL_Type)(unsafe.Pointer(uintptr(0x60)))
	CPU     = (*CPU_Type)(unsafe.Pointer(uintptr(0x30)))
	CPUINT  = (*CPUINT_Type)(unsafe.Pointer(uintptr(0x110)))
	CRCSCAN = (*CRCSCAN_Type)(unsafe.Pointer(uintptr(0x120)))
	DAC0    = (*DAC_Type)(unsafe.Pointer(uintptr(0x680)))
	EVSYS   = (*EVSYS_Type)(unsafe.Pointer(uintptr(0x180)))
	FUSE    = (*FUSE_Type)(unsafe.Pointer(uintptr(0x1280)))
	GPIO    = (*GPIO_Type)(unsafe.Pointer(uintptr(0x1c)))
	LOCKBIT = (*LOCKBIT_Type)(unsafe.Pointer(uintptr(0x128a)))
	NVMCTRL = (*NVMCTRL_Type)(unsafe.Pointer(uintptr(0x1000)))
	PORTA   = (*PORT_Type)(unsafe.Pointer(uintptr(0x400)))
	PORTMUX = (*PORTMUX_Type)(unsafe.Pointer(uintptr(0x200)))
	RSTCTRL = (*RSTCTRL_Type)(unsafe.Pointer(uintptr(0x40)))
	RTC     = (*RTC_Type)(unsafe.Pointer(uintptr(0x140)))
	SIGROW  = (*SIGROW_Type)(unsafe.Pointer(uintptr(0x1100)))
	SLPCTRL = (*SLPCTRL_Type)(unsafe.Pointer(uintptr(0x50)))
	SPI0    = (*SPI_Type)(unsafe.Pointer(uintptr(0x820)))
	SYSCFG  = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0xf00)))
	TCA0    = (*TCA_Type)(unsafe.Pointer(uintptr(0xa00)))
	TCB0    = (*TCB_Type)(unsafe.Pointer(uintptr(0xa40)))
	TCD0    = (*TCD_Type)(unsafe.Pointer(uintptr(0xa80)))
	TWI0    = (*TWI_Type)(unsafe.Pointer(uintptr(0x810)))
	USART0  = (*USART_Type)(unsafe.Pointer(uintptr(0x800)))
	USERROW = (*USERROW_Type)(unsafe.Pointer(uintptr(0x1300)))
	VPORTA  = (*VPORT_Type)(unsafe.Pointer(uintptr(0x0)))
	VPORTB  = (*VPORT_Type)(unsafe.Pointer(uintptr(0x4)))
	VPORTC  = (*VPORT_Type)(unsafe.Pointer(uintptr(0x8)))
	VREF    = (*VREF_Type)(unsafe.Pointer(uintptr(0xa0)))
	WDT     = (*WDT_Type)(unsafe.Pointer(uintptr(0x100)))
)

// Peripheral type definitions.

type AC_Type struct {
	CTRLA    volatile.Register8 // Control A
	_        [1]volatile.Register8
	MUXCTRLA volatile.Register8 // Mux Control A
	_        [3]volatile.Register8
	INTCTRL  volatile.Register8 // Interrupt Control
	STATUS   volatile.Register8 // Status
}

type ADC_Type struct {
	CTRLA    volatile.Register8 // Control A
	CTRLB    volatile.Register8 // Control B
	CTRLC    volatile.Register8 // Control C
	CTRLD    volatile.Register8 // Control D
	CTRLE    volatile.Register8 // Control E
	SAMPCTRL volatile.Register8 // Sample Control
	MUXPOS   volatile.Register8 // Positive mux input
	_        [1]volatile.Register8
	COMMAND  volatile.Register8 // Command
	EVCTRL   volatile.Register8 // Event Control
	INTCTRL  volatile.Register8 // Interrupt Control
	INTFLAGS volatile.Register8 // Interrupt Flags
	DBGCTRL  volatile.Register8 // Debug Control
	TEMP     volatile.Register8 // Temporary Data
	_        [2]volatile.Register8
	RESL     volatile.Register8 // ADC Accumulator Result (lower bits)
	RESH     volatile.Register8 // ADC Accumulator Result (upper bits)
	WINLTL   volatile.Register8 // Window comparator low threshold (lower bits)
	WINLTH   volatile.Register8 // Window comparator low threshold (upper bits)
	WINHTL   volatile.Register8 // Window comparator high threshold (lower bits)
	WINHTH   volatile.Register8 // Window comparator high threshold (upper bits)
	CALIB    volatile.Register8 // Calibration
}

type BOD_Type struct {
	CTRLA    volatile.Register8 // Control A
	CTRLB    volatile.Register8 // Control B
	_        [6]volatile.Register8
	VLMCTRLA volatile.Register8 // Voltage level monitor Control
	INTCTRL  volatile.Register8 // Voltage level monitor interrupt Control
	INTFLAGS volatile.Register8 // Voltage level monitor interrupt Flags
	STATUS   volatile.Register8 // Voltage level monitor status
}

type CCL_Type struct {
	CTRLA     volatile.Register8 // Control Register A
	SEQCTRL0  volatile.Register8 // Sequential Control 0
	_         [3]volatile.Register8
	LUT0CTRLA volatile.Register8 // LUT Control 0 A
	LUT0CTRLB volatile.Register8 // LUT Control 0 B
	LUT0CTRLC volatile.Register8 // LUT Control 0 C
	TRUTH0    volatile.Register8 // Truth 0
	LUT1CTRLA volatile.Register8 // LUT Control 1 A
	LUT1CTRLB volatile.Register8 // LUT Control 1 B
	LUT1CTRLC volatile.Register8 // LUT Control 1 C
	TRUTH1    volatile.Register8 // Truth 1
}

type CLKCTRL_Type struct {
	MCLKCTRLA    volatile.Register8 // MCLK Control A
	MCLKCTRLB    volatile.Register8 // MCLK Control B
	MCLKLOCK     volatile.Register8 // MCLK Lock
	MCLKSTATUS   volatile.Register8 // MCLK Status
	_            [12]volatile.Register8
	OSC20MCTRLA  volatile.Register8 // OSC20M Control A
	OSC20MCALIBA volatile.Register8 // OSC20M Calibration A
	OSC20MCALIBB volatile.Register8 // OSC20M Calibration B
	_            [5]volatile.Register8
	OSC32KCTRLA  volatile.Register8 // OSC32K Control A
}

type CPU_Type struct {
	_    [4]volatile.Register8
	CCP  volatile.Register8 // Configuration Change Protection
	_    [8]volatile.Register8
	SPL  volatile.Register8 // Stack Pointer Low
	SPH  volatile.Register8 // Stack Pointer High
	SREG volatile.Register8 // Status Register
}

type CPUINT_Type struct {
	CTRLA   volatile.Register8 // Control A
	STATUS  volatile.Register8 // Status
	LVL0PRI volatile.Register8 // Interrupt Level 0 Priority
	LVL1VEC volatile.Register8 // Interrupt Level 1 Priority Vector
}

type CRCSCAN_Type struct {
	CTRLA  volatile.Register8 // Control A
	CTRLB  volatile.Register8 // Control B
	STATUS volatile.Register8 // Status
}

type DAC_Type struct {
	CTRLA volatile.Register8 // Control Register A
	DATA  volatile.Register8 // DATA Register
}

type EVSYS_Type struct {
	ASYNCSTROBE volatile.Register8 // Asynchronous Channel Strobe
	SYNCSTROBE  volatile.Register8 // Synchronous Channel Strobe
	ASYNCCH0    volatile.Register8 // Asynchronous Channel 0 Generator Selection
	ASYNCCH1    volatile.Register8 // Asynchronous Channel 1 Generator Selection
	ASYNCCH2    volatile.Register8 // Asynchronous Channel 2 Generator Selection
	ASYNCCH3    volatile.Register8 // Asynchronous Channel 3 Generator Selection
	_           [4]volatile.Register8
	SYNCCH0     volatile.Register8 // Synchronous Channel 0 Generator Selection
	SYNCCH1     volatile.Register8 // Synchronous Channel 1 Generator Selection
	_           [6]volatile.Register8
	ASYNCUSER0  volatile.Register8 // Asynchronous User Ch 0 Input Selection - TCB0
	ASYNCUSER1  volatile.Register8 // Asynchronous User Ch 1 Input Selection - ADC0
	ASYNCUSER2  volatile.Register8 // Asynchronous User Ch 2 Input Selection - CCL LUT0 Event 0
	ASYNCUSER3  volatile.Register8 // Asynchronous User Ch 3 Input Selection - CCL LUT1 Event 0
	ASYNCUSER4  volatile.Register8 // Asynchronous User Ch 4 Input Selection - CCL LUT0 Event 1
	ASYNCUSER5  volatile.Register8 // Asynchronous User Ch 5 Input Selection - CCL LUT1 Event 1
	ASYNCUSER6  volatile.Register8 // Asynchronous User Ch 6 Input Selection - TCD0 Event 0
	ASYNCUSER7  volatile.Register8 // Asynchronous User Ch 7 Input Selection - TCD0 Event 1
	ASYNCUSER8  volatile.Register8 // Asynchronous User Ch 8 Input Selection - Event Out 0
	ASYNCUSER9  volatile.Register8 // Asynchronous User Ch 9 Input Selection - Event Out 1
	ASYNCUSER10 volatile.Register8 // Asynchronous User Ch 10 Input Selection - Event Out 2
	_           [5]volatile.Register8
	SYNCUSER0   volatile.Register8 // Synchronous User Ch 0 Input Selection - TCA0
	SYNCUSER1   volatile.Register8 // Synchronous User Ch 1 Input Selection - USART0
}

type FUSE_Type struct {
	WDTCFG  volatile.Register8 // Watchdog Configuration
	BODCFG  volatile.Register8 // BOD Configuration
	OSCCFG  volatile.Register8 // Oscillator Configuration
	_       [1]volatile.Register8
	TCD0CFG volatile.Register8 // TCD0 Configuration
	SYSCFG0 volatile.Register8 // System Configuration 0
	SYSCFG1 volatile.Register8 // System Configuration 1
	APPEND  volatile.Register8 // Application Code Section End
	BOOTEND volatile.Register8 // Boot Section End
}

type GPIO_Type struct {
	GPIOR0 volatile.Register8 // General Purpose IO Register 0
	GPIOR1 volatile.Register8 // General Purpose IO Register 1
	GPIOR2 volatile.Register8 // General Purpose IO Register 2
	GPIOR3 volatile.Register8 // General Purpose IO Register 3
}

type LOCKBIT_Type struct {
	LOCKBIT volatile.Register8 // Lock bits
}

type NVMCTRL_Type struct {
	CTRLA    volatile.Register8 // Control A
	CTRLB    volatile.Register8 // Control B
	STATUS   volatile.Register8 // Status
	INTCTRL  volatile.Register8 // Interrupt Control
	INTFLAGS volatile.Register8 // Interrupt Flags
	_        [1]volatile.Register8
	DATAL    volatile.Register8 // Data (lower bits)
	DATAH    volatile.Register8 // Data (upper bits)
	ADDRL    volatile.Register8 // Address (lower bits)
	ADDRH    volatile.Register8 // Address (upper bits)
}

type PORT_Type struct {
	DIR      volatile.Register8 // Data Direction
	DIRSET   volatile.Register8 // Data Direction Set
	DIRCLR   volatile.Register8 // Data Direction Clear
	DIRTGL   volatile.Register8 // Data Direction Toggle
	OUT      volatile.Register8 // Output Value
	OUTSET   volatile.Register8 // Output Value Set
	OUTCLR   volatile.Register8 // Output Value Clear
	OUTTGL   volatile.Register8 // Output Value Toggle
	IN       volatile.Register8 // Input Value
	INTFLAGS volatile.Register8 // Interrupt Flags
	_        [6]volatile.Register8
	PIN0CTRL volatile.Register8 // Pin 0 Control
	PIN1CTRL volatile.Register8 // Pin 1 Control
	PIN2CTRL volatile.Register8 // Pin 2 Control
	PIN3CTRL volatile.Register8 // Pin 3 Control
	PIN4CTRL volatile.Register8 // Pin 4 Control
	PIN5CTRL volatile.Register8 // Pin 5 Control
	PIN6CTRL volatile.Register8 // Pin 6 Control
	PIN7CTRL volatile.Register8 // Pin 7 Control
}

type PORTMUX_Type struct {
	CTRLA volatile.Register8 // Port Multiplexer Control A
	CTRLB volatile.Register8 // Port Multiplexer Control B
	CTRLC volatile.Register8 // Port Multiplexer Control C
	CTRLD volatile.Register8 // Port Multiplexer Control D
}

type RSTCTRL_Type struct {
	RSTFR volatile.Register8 // Reset Flags
	SWRR  volatile.Register8 // Software Reset
}

type RTC_Type struct {
	CTRLA       volatile.Register8 // Control A
	STATUS      volatile.Register8 // Status
	INTCTRL     volatile.Register8 // Interrupt Control
	INTFLAGS    volatile.Register8 // Interrupt Flags
	TEMP        volatile.Register8 // Temporary
	DBGCTRL     volatile.Register8 // Debug control
	_           [1]volatile.Register8
	CLKSEL      volatile.Register8 // Clock Select
	CNTL        volatile.Register8 // Counter (lower bits)
	CNTH        volatile.Register8 // Counter (upper bits)
	PERL        volatile.Register8 // Period (lower bits)
	PERH        volatile.Register8 // Period (upper bits)
	CMPL        volatile.Register8 // Compare (lower bits)
	CMPH        volatile.Register8 // Compare (upper bits)
	_           [2]volatile.Register8
	PITCTRLA    volatile.Register8 // PIT Control A
	PITSTATUS   volatile.Register8 // PIT Status
	PITINTCTRL  volatile.Register8 // PIT Interrupt Control
	PITINTFLAGS volatile.Register8 // PIT Interrupt Flags
	_           [1]volatile.Register8
	PITDBGCTRL  volatile.Register8 // PIT Debug control
}

type SIGROW_Type struct {
	DEVICEID0  volatile.Register8 // Device ID Byte 0
	DEVICEID1  volatile.Register8 // Device ID Byte 1
	DEVICEID2  volatile.Register8 // Device ID Byte 2
	SERNUM0    volatile.Register8 // Serial Number Byte 0
	SERNUM1    volatile.Register8 // Serial Number Byte 1
	SERNUM2    volatile.Register8 // Serial Number Byte 2
	SERNUM3    volatile.Register8 // Serial Number Byte 3
	SERNUM4    volatile.Register8 // Serial Number Byte 4
	SERNUM5    volatile.Register8 // Serial Number Byte 5
	SERNUM6    volatile.Register8 // Serial Number Byte 6
	SERNUM7    volatile.Register8 // Serial Number Byte 7
	SERNUM8    volatile.Register8 // Serial Number Byte 8
	SERNUM9    volatile.Register8 // Serial Number Byte 9
	_          [19]volatile.Register8
	TEMPSENSE0 volatile.Register8 // Temperature Sensor Calibration Byte 0
	TEMPSENSE1 volatile.Register8 // Temperature Sensor Calibration Byte 1
	OSC16ERR3V volatile.Register8 // OSC16 error at 3V
	OSC16ERR5V volatile.Register8 // OSC16 error at 5V
	OSC20ERR3V volatile.Register8 // OSC20 error at 3V
	OSC20ERR5V volatile.Register8 // OSC20 error at 5V
}

type SLPCTRL_Type struct {
	CTRLA volatile.Register8 // Control
}

type SPI_Type struct {
	CTRLA    volatile.Register8 // Control A
	CTRLB    volatile.Register8 // Control B
	INTCTRL  volatile.Register8 // Interrupt Control
	INTFLAGS volatile.Register8 // Interrupt Flags
	DATA     volatile.Register8 // Data
}

type SYSCFG_Type struct {
	_      [1]volatile.Register8
	REVID  volatile.Register8 // Revision ID
	EXTBRK volatile.Register8 // External Break
}

type TCA_SINGLE_Type struct {
	CTRLA    volatile.Register8 // Control A
	CTRLB    volatile.Register8 // Control B
	CTRLC    volatile.Register8 // Control C
	CTRLD    volatile.Register8 // Control D
	CTRLECLR volatile.Register8 // Control E Clear
	CTRLESET volatile.Register8 // Control E Set
	CTRLFCLR volatile.Register8 // Control F Clear
	CTRLFSET volatile.Register8 // Control F Set
	_        [1]volatile.Register8
	EVCTRL   volatile.Register8 // Event Control
	INTCTRL  volatile.Register8 // Interrupt Control
	INTFLAGS volatile.Register8 // Interrupt Flags
	_        [2]volatile.Register8
	DBGCTRL  volatile.Register8 // Degbug Control
	TEMP     volatile.Register8 // Temporary data for 16-bit Access
	_        [16]volatile.Register8
	CNTL     volatile.Register8 // Count (lower bits)
	CNTH     volatile.Register8 // Count (upper bits)
	_        [4]volatile.Register8
	PERL     volatile.Register8 // Period (lower bits)
	PERH     volatile.Register8 // Period (upper bits)
	CMP0L    volatile.Register8 // Compare 0 (lower bits)
	CMP0H    volatile.Register8 // Compare 0 (upper bits)
	CMP1L    volatile.Register8 // Compare 1 (lower bits)
	CMP1H    volatile.Register8 // Compare 1 (upper bits)
	CMP2L    volatile.Register8 // Compare 2 (lower bits)
	CMP2H    volatile.Register8 // Compare 2 (upper bits)
	_        [8]volatile.Register8
	PERBUFL  volatile.Register8 // Period Buffer (lower bits)
	PERBUFH  volatile.Register8 // Period Buffer (upper bits)
	CMP0BUFL volatile.Register8 // Compare 0 Buffer (lower bits)
	CMP0BUFH volatile.Register8 // Compare 0 Buffer (upper bits)
	CMP1BUFL volatile.Register8 // Compare 1 Buffer (lower bits)
	CMP1BUFH volatile.Register8 // Compare 1 Buffer (upper bits)
	CMP2BUFL volatile.Register8 // Compare 2 Buffer (lower bits)
	CMP2BUFH volatile.Register8 // Compare 2 Buffer (upper bits)
}

type TCA_SPLIT_Type struct {
	CTRLA    volatile.Register8 // Control A
	CTRLB    volatile.Register8 // Control B
	CTRLC    volatile.Register8 // Control C
	CTRLD    volatile.Register8 // Control D
	CTRLECLR volatile.Register8 // Control E Clear
	CTRLESET volatile.Register8 // Control E Set
	_        [4]volatile.Register8
	INTCTRL  volatile.Register8 // Interrupt Control
	INTFLAGS volatile.Register8 // Interrupt Flags
	_        [2]volatile.Register8
	DBGCTRL  volatile.Register8 // Degbug Control
	_        [17]volatile.Register8
	LCNT     volatile.Register8 // Low Count
	HCNT     volatile.Register8 // High Count
	_        [4]volatile.Register8
	LPER     volatile.Register8 // Low Period
	HPER     volatile.Register8 // High Period
	LCMP0    volatile.Register8 // Low Compare
	HCMP0    volatile.Register8 // High Compare
	LCMP1    volatile.Register8 // Low Compare
	HCMP1    volatile.Register8 // High Compare
	LCMP2    volatile.Register8 // Low Compare
	HCMP2    volatile.Register8 // High Compare
}

type TCA_Type struct {
}

type TCB_Type struct {
	CTRLA    volatile.Register8 // Control A
	CTRLB    volatile.Register8 // Control Register B
	_        [2]volatile.Register8
	EVCTRL   volatile.Register8 // Event Control
	INTCTRL  volatile.Register8 // Interrupt Control
	INTFLAGS volatile.Register8 // Interrupt Flags
	STATUS   volatile.Register8 // Status
	DBGCTRL  volatile.Register8 // Debug Control
	TEMP     volatile.Register8 // Temporary Value
	CNTL     volatile.Register8 // Count (lower bits)
	CNTH     volatile.Register8 // Count (upper bits)
	CCMPL    volatile.Register8 // Compare or Capture (lower bits)
	CCMPH    volatile.Register8 // Compare or Capture (upper bits)
}

type TCD_Type struct {
	CTRLA      volatile.Register8 // Control A
	CTRLB      volatile.Register8 // Control B
	CTRLC      volatile.Register8 // Control C
	CTRLD      volatile.Register8 // Control D
	CTRLE      volatile.Register8 // Control E
	_          [3]volatile.Register8
	EVCTRLA    volatile.Register8 // EVCTRLA
	EVCTRLB    volatile.Register8 // EVCTRLB
	_          [2]volatile.Register8
	INTCTRL    volatile.Register8 // Interrupt Control
	INTFLAGS   volatile.Register8 // Interrupt Flags
	STATUS     volatile.Register8 // Status
	_          [1]volatile.Register8
	INPUTCTRLA volatile.Register8 // Input Control A
	INPUTCTRLB volatile.Register8 // Input Control B
	FAULTCTRL  volatile.Register8 // Fault Control
	_          [1]volatile.Register8
	DLYCTRL    volatile.Register8 // Delay Control
	DLYVAL     volatile.Register8 // Delay value
	_          [2]volatile.Register8
	DITCTRL    volatile.Register8 // Dither Control A
	DITVAL     volatile.Register8 // Dither value
	_          [4]volatile.Register8
	DBGCTRL    volatile.Register8 // Debug Control
	_          [3]volatile.Register8
	CAPTUREAL  volatile.Register8 // Capture A (lower bits)
	CAPTUREAH  volatile.Register8 // Capture A (upper bits)
	CAPTUREBL  volatile.Register8 // Capture B (lower bits)
	CAPTUREBH  volatile.Register8 // Capture B (upper bits)
	_          [2]volatile.Register8
	CMPASETL   volatile.Register8 // Compare A Set (lower bits)
	CMPASETH   volatile.Register8 // Compare A Set (upper bits)
	CMPACLRL   volatile.Register8 // Compare A Clear (lower bits)
	CMPACLRH   volatile.Register8 // Compare A Clear (upper bits)
	CMPBSETL   volatile.Register8 // Compare B Set (lower bits)
	CMPBSETH   volatile.Register8 // Compare B Set (upper bits)
	CMPBCLRL   volatile.Register8 // Compare B Clear (lower bits)
	CMPBCLRH   volatile.Register8 // Compare B Clear (upper bits)
}

type TWI_Type struct {
	CTRLA     volatile.Register8 // Control A
	_         [1]volatile.Register8
	DBGCTRL   volatile.Register8 // Debug Control Register
	MCTRLA    volatile.Register8 // Master Control A
	MCTRLB    volatile.Register8 // Master Control B
	MSTATUS   volatile.Register8 // Master Status
	MBAUD     volatile.Register8 // Master Baurd Rate Control
	MADDR     volatile.Register8 // Master Address
	MDATA     volatile.Register8 // Master Data
	SCTRLA    volatile.Register8 // Slave Control A
	SCTRLB    volatile.Register8 // Slave Control B
	SSTATUS   volatile.Register8 // Slave Status
	SADDR     volatile.Register8 // Slave Address
	SDATA     volatile.Register8 // Slave Data
	SADDRMASK volatile.Register8 // Slave Address Mask
}

type USART_Type struct {
	RXDATAL  volatile.Register8 // Receive Data Low Byte
	RXDATAH  volatile.Register8 // Receive Data High Byte
	TXDATAL  volatile.Register8 // Transmit Data Low Byte
	TXDATAH  volatile.Register8 // Transmit Data High Byte
	STATUS   volatile.Register8 // Status
	CTRLA    volatile.Register8 // Control A
	CTRLB    volatile.Register8 // Control B
	CTRLC    volatile.Register8 // Control C
	BAUDL    volatile.Register8 // Baud Rate (lower bits)
	BAUDH    volatile.Register8 // Baud Rate (upper bits)
	_        [1]volatile.Register8
	DBGCTRL  volatile.Register8 // Debug Control
	EVCTRL   volatile.Register8 // Event Control
	TXPLCTRL volatile.Register8 // IRCOM Transmitter Pulse Length Control
	RXPLCTRL volatile.Register8 // IRCOM Receiver Pulse Length Control
}

type USERROW_Type struct {
	USERROW0  volatile.Register8 // User Row Byte 0
	USERROW1  volatile.Register8 // User Row Byte 1
	USERROW2  volatile.Register8 // User Row Byte 2
	USERROW3  volatile.Register8 // User Row Byte 3
	USERROW4  volatile.Register8 // User Row Byte 4
	USERROW5  volatile.Register8 // User Row Byte 5
	USERROW6  volatile.Register8 // User Row Byte 6
	USERROW7  volatile.Register8 // User Row Byte 7
	USERROW8  volatile.Register8 // User Row Byte 8
	USERROW9  volatile.Register8 // User Row Byte 9
	USERROW10 volatile.Register8 // User Row Byte 10
	USERROW11 volatile.Register8 // User Row Byte 11
	USERROW12 volatile.Register8 // User Row Byte 12
	USERROW13 volatile.Register8 // User Row Byte 13
	USERROW14 volatile.Register8 // User Row Byte 14
	USERROW15 volatile.Register8 // User Row Byte 15
	USERROW16 volatile.Register8 // User Row Byte 16
	USERROW17 volatile.Register8 // User Row Byte 17
	USERROW18 volatile.Register8 // User Row Byte 18
	USERROW19 volatile.Register8 // User Row Byte 19
	USERROW20 volatile.Register8 // User Row Byte 20
	USERROW21 volatile.Register8 // User Row Byte 21
	USERROW22 volatile.Register8 // User Row Byte 22
	USERROW23 volatile.Register8 // User Row Byte 23
	USERROW24 volatile.Register8 // User Row Byte 24
	USERROW25 volatile.Register8 // User Row Byte 25
	USERROW26 volatile.Register8 // User Row Byte 26
	USERROW27 volatile.Register8 // User Row Byte 27
	USERROW28 volatile.Register8 // User Row Byte 28
	USERROW29 volatile.Register8 // User Row Byte 29
	USERROW30 volatile.Register8 // User Row Byte 30
	USERROW31 volatile.Register8 // User Row Byte 31
}

type VPORT_Type struct {
	DIR      volatile.Register8 // Data Direction
	OUT      volatile.Register8 // Output Value
	IN       volatile.Register8 // Input Value
	INTFLAGS volatile.Register8 // Interrupt Flags
}

type VREF_Type struct {
	CTRLA volatile.Register8 // Control A
	CTRLB volatile.Register8 // Control B
}

type WDT_Type struct {
	CTRLA  volatile.Register8 // Control A
	STATUS volatile.Register8 // Status
}

// Bitfields for AC: Analog Comparator
const (
	// CTRLA: Control A
	AC_CTRLA_ENABLE       = 0x1  // Enable
	AC_CTRLA_ENABLE_Msk   = 0x1  // Enable
	AC_CTRLA_HYSMODE0     = 0x2  // Hysteresis Mode
	AC_CTRLA_HYSMODE1     = 0x4  // Hysteresis Mode
	AC_CTRLA_HYSMODE_Msk  = 0x6  // Hysteresis Mode
	AC_CTRLA_INTMODE0     = 0x10 // Interrupt Mode
	AC_CTRLA_INTMODE1     = 0x20 // Interrupt Mode
	AC_CTRLA_INTMODE_Msk  = 0x30 // Interrupt Mode
	AC_CTRLA_LPMODE       = 0x8  // Low Power Mode
	AC_CTRLA_LPMODE_Msk   = 0x8  // Low Power Mode
	AC_CTRLA_OUTEN        = 0x40 // Output Buffer Enable
	AC_CTRLA_OUTEN_Msk    = 0x40 // Output Buffer Enable
	AC_CTRLA_RUNSTDBY     = 0x80 // Run in Standby Mode
	AC_CTRLA_RUNSTDBY_Msk = 0x80 // Run in Standby Mode

	// MUXCTRLA: Mux Control A
	AC_MUXCTRLA_INVERT     = 0x80 // Invert AC Output
	AC_MUXCTRLA_INVERT_Msk = 0x80 // Invert AC Output
	AC_MUXCTRLA_MUXNEG0    = 0x1  // Negative Input MUX Selection
	AC_MUXCTRLA_MUXNEG1    = 0x2  // Negative Input MUX Selection
	AC_MUXCTRLA_MUXNEG_Msk = 0x3  // Negative Input MUX Selection
	AC_MUXCTRLA_MUXPOS0    = 0x8  // Positive Input MUX Selection
	AC_MUXCTRLA_MUXPOS1    = 0x10 // Positive Input MUX Selection
	AC_MUXCTRLA_MUXPOS_Msk = 0x18 // Positive Input MUX Selection

	// INTCTRL: Interrupt Control
	AC_INTCTRL_CMP     = 0x1 // Analog Comparator 0 Interrupt Enable
	AC_INTCTRL_CMP_Msk = 0x1 // Analog Comparator 0 Interrupt Enable

	// STATUS: Status
	AC_STATUS_CMP       = 0x1  // Analog Comparator Interrupt Flag
	AC_STATUS_CMP_Msk   = 0x1  // Analog Comparator Interrupt Flag
	AC_STATUS_STATE     = 0x10 // Analog Comparator State
	AC_STATUS_STATE_Msk = 0x10 // Analog Comparator State
)

// Bitfields for ADC: Analog to Digital Converter
const (
	// CTRLA: Control A
	ADC_CTRLA_ENABLE      = 0x1  // ADC Enable
	ADC_CTRLA_ENABLE_Msk  = 0x1  // ADC Enable
	ADC_CTRLA_FREERUN     = 0x2  // ADC Freerun mode
	ADC_CTRLA_FREERUN_Msk = 0x2  // ADC Freerun mode
	ADC_CTRLA_RESSEL      = 0x4  // ADC Resolution
	ADC_CTRLA_RESSEL_Msk  = 0x4  // ADC Resolution
	ADC_CTRLA_RUNSTBY     = 0x80 // Run standby mode
	ADC_CTRLA_RUNSTBY_Msk = 0x80 // Run standby mode

	// CTRLB: Control B
	ADC_CTRLB_SAMPNUM0    = 0x1 // Accumulation Samples
	ADC_CTRLB_SAMPNUM1    = 0x2 // Accumulation Samples
	ADC_CTRLB_SAMPNUM2    = 0x4 // Accumulation Samples
	ADC_CTRLB_SAMPNUM_Msk = 0x7 // Accumulation Samples

	// CTRLC: Control C
	ADC_CTRLC_PRESC0      = 0x1  // Clock Pre-scaler
	ADC_CTRLC_PRESC1      = 0x2  // Clock Pre-scaler
	ADC_CTRLC_PRESC2      = 0x4  // Clock Pre-scaler
	ADC_CTRLC_PRESC_Msk   = 0x7  // Clock Pre-scaler
	ADC_CTRLC_REFSEL0     = 0x10 // Reference Selection
	ADC_CTRLC_REFSEL1     = 0x20 // Reference Selection
	ADC_CTRLC_REFSEL_Msk  = 0x30 // Reference Selection
	ADC_CTRLC_SAMPCAP     = 0x40 // Sample Capacitance Selection
	ADC_CTRLC_SAMPCAP_Msk = 0x40 // Sample Capacitance Selection

	// CTRLD: Control D
	ADC_CTRLD_ASDV        = 0x10 // Automatic Sampling Delay Variation
	ADC_CTRLD_ASDV_Msk    = 0x10 // Automatic Sampling Delay Variation
	ADC_CTRLD_INITDLY0    = 0x20 // Initial Delay Selection
	ADC_CTRLD_INITDLY1    = 0x40 // Initial Delay Selection
	ADC_CTRLD_INITDLY2    = 0x80 // Initial Delay Selection
	ADC_CTRLD_INITDLY_Msk = 0xe0 // Initial Delay Selection
	ADC_CTRLD_SAMPDLY0    = 0x1  // Sampling Delay Selection
	ADC_CTRLD_SAMPDLY1    = 0x2  // Sampling Delay Selection
	ADC_CTRLD_SAMPDLY2    = 0x4  // Sampling Delay Selection
	ADC_CTRLD_SAMPDLY3    = 0x8  // Sampling Delay Selection
	ADC_CTRLD_SAMPDLY_Msk = 0xf  // Sampling Delay Selection

	// CTRLE: Control E
	ADC_CTRLE_WINCM0    = 0x1 // Window Comparator Mode
	ADC_CTRLE_WINCM1    = 0x2 // Window Comparator Mode
	ADC_CTRLE_WINCM2    = 0x4 // Window Comparator Mode
	ADC_CTRLE_WINCM_Msk = 0x7 // Window Comparator Mode

	// SAMPCTRL: Sample Control
	ADC_SAMPCTRL_SAMPLEN0    = 0x1  // Sample lenght
	ADC_SAMPCTRL_SAMPLEN1    = 0x2  // Sample lenght
	ADC_SAMPCTRL_SAMPLEN2    = 0x4  // Sample lenght
	ADC_SAMPCTRL_SAMPLEN3    = 0x8  // Sample lenght
	ADC_SAMPCTRL_SAMPLEN4    = 0x10 // Sample lenght
	ADC_SAMPCTRL_SAMPLEN_Msk = 0x1f // Sample lenght

	// MUXPOS: Positive mux input
	ADC_MUXPOS_MUXPOS0    = 0x1  // Analog Channel Selection Bits
	ADC_MUXPOS_MUXPOS1    = 0x2  // Analog Channel Selection Bits
	ADC_MUXPOS_MUXPOS2    = 0x4  // Analog Channel Selection Bits
	ADC_MUXPOS_MUXPOS3    = 0x8  // Analog Channel Selection Bits
	ADC_MUXPOS_MUXPOS4    = 0x10 // Analog Channel Selection Bits
	ADC_MUXPOS_MUXPOS_Msk = 0x1f // Analog Channel Selection Bits

	// COMMAND: Command
	ADC_COMMAND_STCONV     = 0x1 // Start Conversion Operation
	ADC_COMMAND_STCONV_Msk = 0x1 // Start Conversion Operation

	// EVCTRL: Event Control
	ADC_EVCTRL_STARTEI     = 0x1 // Start Event Input Enable
	ADC_EVCTRL_STARTEI_Msk = 0x1 // Start Event Input Enable

	// INTCTRL: Interrupt Control
	ADC_INTCTRL_RESRDY     = 0x1 // Result Ready Interrupt Enable
	ADC_INTCTRL_RESRDY_Msk = 0x1 // Result Ready Interrupt Enable
	ADC_INTCTRL_WCMP       = 0x2 // Window Comparator Interrupt Enable
	ADC_INTCTRL_WCMP_Msk   = 0x2 // Window Comparator Interrupt Enable

	// INTFLAGS: Interrupt Flags
	ADC_INTFLAGS_RESRDY     = 0x1 // Result Ready Flag
	ADC_INTFLAGS_RESRDY_Msk = 0x1 // Result Ready Flag
	ADC_INTFLAGS_WCMP       = 0x2 // Window Comparator Flag
	ADC_INTFLAGS_WCMP_Msk   = 0x2 // Window Comparator Flag

	// DBGCTRL: Debug Control
	ADC_DBGCTRL_DBGRUN     = 0x1 // Debug run
	ADC_DBGCTRL_DBGRUN_Msk = 0x1 // Debug run

	// TEMP: Temporary Data
	ADC_TEMP_TEMP0    = 0x1  // Temporary
	ADC_TEMP_TEMP1    = 0x2  // Temporary
	ADC_TEMP_TEMP2    = 0x4  // Temporary
	ADC_TEMP_TEMP3    = 0x8  // Temporary
	ADC_TEMP_TEMP4    = 0x10 // Temporary
	ADC_TEMP_TEMP5    = 0x20 // Temporary
	ADC_TEMP_TEMP6    = 0x40 // Temporary
	ADC_TEMP_TEMP7    = 0x80 // Temporary
	ADC_TEMP_TEMP_Msk = 0xff // Temporary

	// CALIB: Calibration
	ADC_CALIB_DUTYCYC     = 0x1 // Duty Cycle
	ADC_CALIB_DUTYCYC_Msk = 0x1 // Duty Cycle
)

// Bitfields for BOD: Bod interface
const (
	// CTRLA: Control A
	BOD_CTRLA_ACTIVE0      = 0x4  // Operation in active mode
	BOD_CTRLA_ACTIVE1      = 0x8  // Operation in active mode
	BOD_CTRLA_ACTIVE_Msk   = 0xc  // Operation in active mode
	BOD_CTRLA_SAMPFREQ     = 0x10 // Sample frequency
	BOD_CTRLA_SAMPFREQ_Msk = 0x10 // Sample frequency
	BOD_CTRLA_SLEEP0       = 0x1  // Operation in sleep mode
	BOD_CTRLA_SLEEP1       = 0x2  // Operation in sleep mode
	BOD_CTRLA_SLEEP_Msk    = 0x3  // Operation in sleep mode

	// CTRLB: Control B
	BOD_CTRLB_LVL0    = 0x1 // Bod level
	BOD_CTRLB_LVL1    = 0x2 // Bod level
	BOD_CTRLB_LVL2    = 0x4 // Bod level
	BOD_CTRLB_LVL_Msk = 0x7 // Bod level

	// VLMCTRLA: Voltage level monitor Control
	BOD_VLMCTRLA_VLMLVL0    = 0x1 // voltage level monitor level
	BOD_VLMCTRLA_VLMLVL1    = 0x2 // voltage level monitor level
	BOD_VLMCTRLA_VLMLVL_Msk = 0x3 // voltage level monitor level

	// INTCTRL: Voltage level monitor interrupt Control
	BOD_INTCTRL_VLMCFG0    = 0x2 // Configuration
	BOD_INTCTRL_VLMCFG1    = 0x4 // Configuration
	BOD_INTCTRL_VLMCFG_Msk = 0x6 // Configuration
	BOD_INTCTRL_VLMIE      = 0x1 // voltage level monitor interrrupt enable
	BOD_INTCTRL_VLMIE_Msk  = 0x1 // voltage level monitor interrrupt enable

	// INTFLAGS: Voltage level monitor interrupt Flags
	BOD_INTFLAGS_VLMIF     = 0x1 // Voltage level monitor interrupt flag
	BOD_INTFLAGS_VLMIF_Msk = 0x1 // Voltage level monitor interrupt flag

	// STATUS: Voltage level monitor status
	BOD_STATUS_VLMS     = 0x1 // Voltage level monitor status
	BOD_STATUS_VLMS_Msk = 0x1 // Voltage level monitor status
)

// Bitfields for CCL: Configurable Custom Logic
const (
	// CTRLA: Control Register A
	CCL_CTRLA_ENABLE       = 0x1  // Enable
	CCL_CTRLA_ENABLE_Msk   = 0x1  // Enable
	CCL_CTRLA_RUNSTDBY     = 0x40 // Run in Standby
	CCL_CTRLA_RUNSTDBY_Msk = 0x40 // Run in Standby

	// SEQCTRL0: Sequential Control 0
	CCL_SEQCTRL0_SEQSEL0    = 0x1 // Sequential Selection
	CCL_SEQCTRL0_SEQSEL1    = 0x2 // Sequential Selection
	CCL_SEQCTRL0_SEQSEL2    = 0x4 // Sequential Selection
	CCL_SEQCTRL0_SEQSEL_Msk = 0x7 // Sequential Selection

	// LUT0CTRLA: LUT Control 0 A
	CCL_LUT0CTRLA_CLKSRC      = 0x40 // Clock Source Selection
	CCL_LUT0CTRLA_CLKSRC_Msk  = 0x40 // Clock Source Selection
	CCL_LUT0CTRLA_EDGEDET     = 0x80 // Edge Detection Enable
	CCL_LUT0CTRLA_EDGEDET_Msk = 0x80 // Edge Detection Enable
	CCL_LUT0CTRLA_ENABLE      = 0x1  // LUT Enable
	CCL_LUT0CTRLA_ENABLE_Msk  = 0x1  // LUT Enable
	CCL_LUT0CTRLA_FILTSEL0    = 0x10 // Filter Selection
	CCL_LUT0CTRLA_FILTSEL1    = 0x20 // Filter Selection
	CCL_LUT0CTRLA_FILTSEL_Msk = 0x30 // Filter Selection
	CCL_LUT0CTRLA_OUTEN       = 0x8  // Output Enable
	CCL_LUT0CTRLA_OUTEN_Msk   = 0x8  // Output Enable

	// LUT0CTRLB: LUT Control 0 B
	CCL_LUT0CTRLB_INSEL00    = 0x1  // LUT Input 0 Source Selection
	CCL_LUT0CTRLB_INSEL01    = 0x2  // LUT Input 0 Source Selection
	CCL_LUT0CTRLB_INSEL02    = 0x4  // LUT Input 0 Source Selection
	CCL_LUT0CTRLB_INSEL03    = 0x8  // LUT Input 0 Source Selection
	CCL_LUT0CTRLB_INSEL0_Msk = 0xf  // LUT Input 0 Source Selection
	CCL_LUT0CTRLB_INSEL10    = 0x10 // LUT Input 1 Source Selection
	CCL_LUT0CTRLB_INSEL11    = 0x20 // LUT Input 1 Source Selection
	CCL_LUT0CTRLB_INSEL12    = 0x40 // LUT Input 1 Source Selection
	CCL_LUT0CTRLB_INSEL13    = 0x80 // LUT Input 1 Source Selection
	CCL_LUT0CTRLB_INSEL1_Msk = 0xf0 // LUT Input 1 Source Selection

	// LUT0CTRLC: LUT Control 0 C
	CCL_LUT0CTRLC_INSEL20    = 0x1 // LUT Input 2 Source Selection
	CCL_LUT0CTRLC_INSEL21    = 0x2 // LUT Input 2 Source Selection
	CCL_LUT0CTRLC_INSEL22    = 0x4 // LUT Input 2 Source Selection
	CCL_LUT0CTRLC_INSEL23    = 0x8 // LUT Input 2 Source Selection
	CCL_LUT0CTRLC_INSEL2_Msk = 0xf // LUT Input 2 Source Selection

	// LUT1CTRLA: LUT Control 1 A
	CCL_LUT1CTRLA_CLKSRC      = 0x40 // Clock Source Selection
	CCL_LUT1CTRLA_CLKSRC_Msk  = 0x40 // Clock Source Selection
	CCL_LUT1CTRLA_EDGEDET     = 0x80 // Edge Detection Enable
	CCL_LUT1CTRLA_EDGEDET_Msk = 0x80 // Edge Detection Enable
	CCL_LUT1CTRLA_ENABLE      = 0x1  // LUT Enable
	CCL_LUT1CTRLA_ENABLE_Msk  = 0x1  // LUT Enable
	CCL_LUT1CTRLA_FILTSEL0    = 0x10 // Filter Selection
	CCL_LUT1CTRLA_FILTSEL1    = 0x20 // Filter Selection
	CCL_LUT1CTRLA_FILTSEL_Msk = 0x30 // Filter Selection
	CCL_LUT1CTRLA_OUTEN       = 0x8  // Output Enable
	CCL_LUT1CTRLA_OUTEN_Msk   = 0x8  // Output Enable

	// LUT1CTRLB: LUT Control 1 B
	CCL_LUT1CTRLB_INSEL00    = 0x1  // LUT Input 0 Source Selection
	CCL_LUT1CTRLB_INSEL01    = 0x2  // LUT Input 0 Source Selection
	CCL_LUT1CTRLB_INSEL02    = 0x4  // LUT Input 0 Source Selection
	CCL_LUT1CTRLB_INSEL03    = 0x8  // LUT Input 0 Source Selection
	CCL_LUT1CTRLB_INSEL0_Msk = 0xf  // LUT Input 0 Source Selection
	CCL_LUT1CTRLB_INSEL10    = 0x10 // LUT Input 1 Source Selection
	CCL_LUT1CTRLB_INSEL11    = 0x20 // LUT Input 1 Source Selection
	CCL_LUT1CTRLB_INSEL12    = 0x40 // LUT Input 1 Source Selection
	CCL_LUT1CTRLB_INSEL13    = 0x80 // LUT Input 1 Source Selection
	CCL_LUT1CTRLB_INSEL1_Msk = 0xf0 // LUT Input 1 Source Selection

	// LUT1CTRLC: LUT Control 1 C
	CCL_LUT1CTRLC_INSEL20    = 0x1 // LUT Input 2 Source Selection
	CCL_LUT1CTRLC_INSEL21    = 0x2 // LUT Input 2 Source Selection
	CCL_LUT1CTRLC_INSEL22    = 0x4 // LUT Input 2 Source Selection
	CCL_LUT1CTRLC_INSEL23    = 0x8 // LUT Input 2 Source Selection
	CCL_LUT1CTRLC_INSEL2_Msk = 0xf // LUT Input 2 Source Selection
)

// Bitfields for CLKCTRL: Clock controller
const (
	// MCLKCTRLA: MCLK Control A
	CLKCTRL_MCLKCTRLA_CLKOUT     = 0x80 // System clock out
	CLKCTRL_MCLKCTRLA_CLKOUT_Msk = 0x80 // System clock out
	CLKCTRL_MCLKCTRLA_CLKSEL0    = 0x1  // clock select
	CLKCTRL_MCLKCTRLA_CLKSEL1    = 0x2  // clock select
	CLKCTRL_MCLKCTRLA_CLKSEL_Msk = 0x3  // clock select

	// MCLKCTRLB: MCLK Control B
	CLKCTRL_MCLKCTRLB_PDIV0    = 0x2  // Prescaler division
	CLKCTRL_MCLKCTRLB_PDIV1    = 0x4  // Prescaler division
	CLKCTRL_MCLKCTRLB_PDIV2    = 0x8  // Prescaler division
	CLKCTRL_MCLKCTRLB_PDIV3    = 0x10 // Prescaler division
	CLKCTRL_MCLKCTRLB_PDIV_Msk = 0x1e // Prescaler division
	CLKCTRL_MCLKCTRLB_PEN      = 0x1  // Prescaler enable
	CLKCTRL_MCLKCTRLB_PEN_Msk  = 0x1  // Prescaler enable

	// MCLKLOCK: MCLK Lock
	CLKCTRL_MCLKLOCK_LOCKEN     = 0x1 // lock ebable
	CLKCTRL_MCLKLOCK_LOCKEN_Msk = 0x1 // lock ebable

	// MCLKSTATUS: MCLK Status
	CLKCTRL_MCLKSTATUS_EXTS         = 0x80 // External Clock status
	CLKCTRL_MCLKSTATUS_EXTS_Msk     = 0x80 // External Clock status
	CLKCTRL_MCLKSTATUS_OSC20MS      = 0x10 // 20MHz oscillator status
	CLKCTRL_MCLKSTATUS_OSC20MS_Msk  = 0x10 // 20MHz oscillator status
	CLKCTRL_MCLKSTATUS_OSC32KS      = 0x20 // 32KHz oscillator status
	CLKCTRL_MCLKSTATUS_OSC32KS_Msk  = 0x20 // 32KHz oscillator status
	CLKCTRL_MCLKSTATUS_SOSC         = 0x1  // System Oscillator changing
	CLKCTRL_MCLKSTATUS_SOSC_Msk     = 0x1  // System Oscillator changing
	CLKCTRL_MCLKSTATUS_XOSC32KS     = 0x40 // 32.768 kHz Crystal Oscillator status
	CLKCTRL_MCLKSTATUS_XOSC32KS_Msk = 0x40 // 32.768 kHz Crystal Oscillator status

	// OSC20MCTRLA: OSC20M Control A
	CLKCTRL_OSC20MCTRLA_RUNSTDBY     = 0x2 // Run standby
	CLKCTRL_OSC20MCTRLA_RUNSTDBY_Msk = 0x2 // Run standby

	// OSC20MCALIBA: OSC20M Calibration A
	CLKCTRL_OSC20MCALIBA_CALSEL20M0    = 0x40 // Calibration freq select
	CLKCTRL_OSC20MCALIBA_CALSEL20M1    = 0x80 // Calibration freq select
	CLKCTRL_OSC20MCALIBA_CALSEL20M_Msk = 0xc0 // Calibration freq select
	CLKCTRL_OSC20MCALIBA_CAL20M0       = 0x1  // Calibration
	CLKCTRL_OSC20MCALIBA_CAL20M1       = 0x2  // Calibration
	CLKCTRL_OSC20MCALIBA_CAL20M2       = 0x4  // Calibration
	CLKCTRL_OSC20MCALIBA_CAL20M3       = 0x8  // Calibration
	CLKCTRL_OSC20MCALIBA_CAL20M4       = 0x10 // Calibration
	CLKCTRL_OSC20MCALIBA_CAL20M5       = 0x20 // Calibration
	CLKCTRL_OSC20MCALIBA_CAL20M_Msk    = 0x3f // Calibration

	// OSC20MCALIBB: OSC20M Calibration B
	CLKCTRL_OSC20MCALIBB_LOCK           = 0x80 // Lock
	CLKCTRL_OSC20MCALIBB_LOCK_Msk       = 0x80 // Lock
	CLKCTRL_OSC20MCALIBB_TEMPCAL20M0    = 0x1  // Oscillator temperature coefficient
	CLKCTRL_OSC20MCALIBB_TEMPCAL20M1    = 0x2  // Oscillator temperature coefficient
	CLKCTRL_OSC20MCALIBB_TEMPCAL20M2    = 0x4  // Oscillator temperature coefficient
	CLKCTRL_OSC20MCALIBB_TEMPCAL20M3    = 0x8  // Oscillator temperature coefficient
	CLKCTRL_OSC20MCALIBB_TEMPCAL20M_Msk = 0xf  // Oscillator temperature coefficient

	// OSC32KCTRLA: OSC32K Control A
	CLKCTRL_OSC32KCTRLA_RUNSTDBY     = 0x2 // Run standby
	CLKCTRL_OSC32KCTRLA_RUNSTDBY_Msk = 0x2 // Run standby
)

// Bitfields for CPU: CPU
const (
	// CCP: Configuration Change Protection
	CPU_CCP_CCP0    = 0x1  // CCP signature
	CPU_CCP_CCP1    = 0x2  // CCP signature
	CPU_CCP_CCP2    = 0x4  // CCP signature
	CPU_CCP_CCP3    = 0x8  // CCP signature
	CPU_CCP_CCP4    = 0x10 // CCP signature
	CPU_CCP_CCP5    = 0x20 // CCP signature
	CPU_CCP_CCP6    = 0x40 // CCP signature
	CPU_CCP_CCP7    = 0x80 // CCP signature
	CPU_CCP_CCP_Msk = 0xff // CCP signature

	// SREG: Status Register
	CPU_SREG_C     = 0x1  // Carry Flag
	CPU_SREG_C_Msk = 0x1  // Carry Flag
	CPU_SREG_H     = 0x20 // Half Carry Flag
	CPU_SREG_H_Msk = 0x20 // Half Carry Flag
	CPU_SREG_I     = 0x80 // Global Interrupt Enable Flag
	CPU_SREG_I_Msk = 0x80 // Global Interrupt Enable Flag
	CPU_SREG_N     = 0x4  // Negative Flag
	CPU_SREG_N_Msk = 0x4  // Negative Flag
	CPU_SREG_S     = 0x10 // N Exclusive Or V Flag
	CPU_SREG_S_Msk = 0x10 // N Exclusive Or V Flag
	CPU_SREG_T     = 0x40 // Transfer Bit
	CPU_SREG_T_Msk = 0x40 // Transfer Bit
	CPU_SREG_V     = 0x8  // Two's Complement Overflow Flag
	CPU_SREG_V_Msk = 0x8  // Two's Complement Overflow Flag
	CPU_SREG_Z     = 0x2  // Zero Flag
	CPU_SREG_Z_Msk = 0x2  // Zero Flag
)

// Bitfields for CPUINT: Interrupt Controller
const (
	// CTRLA: Control A
	CPUINT_CTRLA_CVT        = 0x20 // Compact Vector Table
	CPUINT_CTRLA_CVT_Msk    = 0x20 // Compact Vector Table
	CPUINT_CTRLA_IVSEL      = 0x40 // Interrupt Vector Select
	CPUINT_CTRLA_IVSEL_Msk  = 0x40 // Interrupt Vector Select
	CPUINT_CTRLA_LVL0RR     = 0x1  // Round-robin Scheduling Enable
	CPUINT_CTRLA_LVL0RR_Msk = 0x1  // Round-robin Scheduling Enable

	// STATUS: Status
	CPUINT_STATUS_LVL0EX     = 0x1  // Level 0 Interrupt Executing
	CPUINT_STATUS_LVL0EX_Msk = 0x1  // Level 0 Interrupt Executing
	CPUINT_STATUS_LVL1EX     = 0x2  // Level 1 Interrupt Executing
	CPUINT_STATUS_LVL1EX_Msk = 0x2  // Level 1 Interrupt Executing
	CPUINT_STATUS_NMIEX      = 0x80 // Non-maskable Interrupt Executing
	CPUINT_STATUS_NMIEX_Msk  = 0x80 // Non-maskable Interrupt Executing

	// LVL0PRI: Interrupt Level 0 Priority
	CPUINT_LVL0PRI_LVL0PRI0    = 0x1  // Interrupt Level Priority
	CPUINT_LVL0PRI_LVL0PRI1    = 0x2  // Interrupt Level Priority
	CPUINT_LVL0PRI_LVL0PRI2    = 0x4  // Interrupt Level Priority
	CPUINT_LVL0PRI_LVL0PRI3    = 0x8  // Interrupt Level Priority
	CPUINT_LVL0PRI_LVL0PRI4    = 0x10 // Interrupt Level Priority
	CPUINT_LVL0PRI_LVL0PRI5    = 0x20 // Interrupt Level Priority
	CPUINT_LVL0PRI_LVL0PRI6    = 0x40 // Interrupt Level Priority
	CPUINT_LVL0PRI_LVL0PRI7    = 0x80 // Interrupt Level Priority
	CPUINT_LVL0PRI_LVL0PRI_Msk = 0xff // Interrupt Level Priority

	// LVL1VEC: Interrupt Level 1 Priority Vector
	CPUINT_LVL1VEC_LVL1VEC0    = 0x1  // Interrupt Vector with High Priority
	CPUINT_LVL1VEC_LVL1VEC1    = 0x2  // Interrupt Vector with High Priority
	CPUINT_LVL1VEC_LVL1VEC2    = 0x4  // Interrupt Vector with High Priority
	CPUINT_LVL1VEC_LVL1VEC3    = 0x8  // Interrupt Vector with High Priority
	CPUINT_LVL1VEC_LVL1VEC4    = 0x10 // Interrupt Vector with High Priority
	CPUINT_LVL1VEC_LVL1VEC5    = 0x20 // Interrupt Vector with High Priority
	CPUINT_LVL1VEC_LVL1VEC6    = 0x40 // Interrupt Vector with High Priority
	CPUINT_LVL1VEC_LVL1VEC7    = 0x80 // Interrupt Vector with High Priority
	CPUINT_LVL1VEC_LVL1VEC_Msk = 0xff // Interrupt Vector with High Priority
)

// Bitfields for CRCSCAN: CRCSCAN
const (
	// CTRLA: Control A
	CRCSCAN_CTRLA_ENABLE     = 0x1  // Enable CRC scan
	CRCSCAN_CTRLA_ENABLE_Msk = 0x1  // Enable CRC scan
	CRCSCAN_CTRLA_NMIEN      = 0x2  // Enable NMI Trigger
	CRCSCAN_CTRLA_NMIEN_Msk  = 0x2  // Enable NMI Trigger
	CRCSCAN_CTRLA_RESET      = 0x80 // Reset CRC scan
	CRCSCAN_CTRLA_RESET_Msk  = 0x80 // Reset CRC scan

	// CTRLB: Control B
	CRCSCAN_CTRLB_MODE0    = 0x10 // CRC Flash Access Mode
	CRCSCAN_CTRLB_MODE1    = 0x20 // CRC Flash Access Mode
	CRCSCAN_CTRLB_MODE_Msk = 0x30 // CRC Flash Access Mode
	CRCSCAN_CTRLB_SRC0     = 0x1  // CRC Source
	CRCSCAN_CTRLB_SRC1     = 0x2  // CRC Source
	CRCSCAN_CTRLB_SRC_Msk  = 0x3  // CRC Source

	// STATUS: Status
	CRCSCAN_STATUS_BUSY     = 0x1 // CRC Busy
	CRCSCAN_STATUS_BUSY_Msk = 0x1 // CRC Busy
	CRCSCAN_STATUS_OK       = 0x2 // CRC Ok
	CRCSCAN_STATUS_OK_Msk   = 0x2 // CRC Ok
)

// Bitfields for DAC: Digital to Analog Converter
const (
	// CTRLA: Control Register A
	DAC_CTRLA_ENABLE       = 0x1  // DAC Enable
	DAC_CTRLA_ENABLE_Msk   = 0x1  // DAC Enable
	DAC_CTRLA_OUTEN        = 0x40 // Output Buffer Enable
	DAC_CTRLA_OUTEN_Msk    = 0x40 // Output Buffer Enable
	DAC_CTRLA_RUNSTDBY     = 0x80 // Run in Standby Mode
	DAC_CTRLA_RUNSTDBY_Msk = 0x80 // Run in Standby Mode
)

// Bitfields for EVSYS: Event System
const (
	// ASYNCCH0: Asynchronous Channel 0 Generator Selection
	EVSYS_ASYNCCH0_ASYNCCH00    = 0x1  // Asynchronous Channel 0 Generator Selection
	EVSYS_ASYNCCH0_ASYNCCH01    = 0x2  // Asynchronous Channel 0 Generator Selection
	EVSYS_ASYNCCH0_ASYNCCH02    = 0x4  // Asynchronous Channel 0 Generator Selection
	EVSYS_ASYNCCH0_ASYNCCH03    = 0x8  // Asynchronous Channel 0 Generator Selection
	EVSYS_ASYNCCH0_ASYNCCH04    = 0x10 // Asynchronous Channel 0 Generator Selection
	EVSYS_ASYNCCH0_ASYNCCH05    = 0x20 // Asynchronous Channel 0 Generator Selection
	EVSYS_ASYNCCH0_ASYNCCH06    = 0x40 // Asynchronous Channel 0 Generator Selection
	EVSYS_ASYNCCH0_ASYNCCH07    = 0x80 // Asynchronous Channel 0 Generator Selection
	EVSYS_ASYNCCH0_ASYNCCH0_Msk = 0xff // Asynchronous Channel 0 Generator Selection

	// ASYNCCH1: Asynchronous Channel 1 Generator Selection
	EVSYS_ASYNCCH1_ASYNCCH10    = 0x1  // Asynchronous Channel 1 Generator Selection
	EVSYS_ASYNCCH1_ASYNCCH11    = 0x2  // Asynchronous Channel 1 Generator Selection
	EVSYS_ASYNCCH1_ASYNCCH12    = 0x4  // Asynchronous Channel 1 Generator Selection
	EVSYS_ASYNCCH1_ASYNCCH13    = 0x8  // Asynchronous Channel 1 Generator Selection
	EVSYS_ASYNCCH1_ASYNCCH14    = 0x10 // Asynchronous Channel 1 Generator Selection
	EVSYS_ASYNCCH1_ASYNCCH15    = 0x20 // Asynchronous Channel 1 Generator Selection
	EVSYS_ASYNCCH1_ASYNCCH16    = 0x40 // Asynchronous Channel 1 Generator Selection
	EVSYS_ASYNCCH1_ASYNCCH17    = 0x80 // Asynchronous Channel 1 Generator Selection
	EVSYS_ASYNCCH1_ASYNCCH1_Msk = 0xff // Asynchronous Channel 1 Generator Selection

	// ASYNCCH2: Asynchronous Channel 2 Generator Selection
	EVSYS_ASYNCCH2_ASYNCCH20    = 0x1  // Asynchronous Channel 2 Generator Selection
	EVSYS_ASYNCCH2_ASYNCCH21    = 0x2  // Asynchronous Channel 2 Generator Selection
	EVSYS_ASYNCCH2_ASYNCCH22    = 0x4  // Asynchronous Channel 2 Generator Selection
	EVSYS_ASYNCCH2_ASYNCCH23    = 0x8  // Asynchronous Channel 2 Generator Selection
	EVSYS_ASYNCCH2_ASYNCCH24    = 0x10 // Asynchronous Channel 2 Generator Selection
	EVSYS_ASYNCCH2_ASYNCCH25    = 0x20 // Asynchronous Channel 2 Generator Selection
	EVSYS_ASYNCCH2_ASYNCCH26    = 0x40 // Asynchronous Channel 2 Generator Selection
	EVSYS_ASYNCCH2_ASYNCCH27    = 0x80 // Asynchronous Channel 2 Generator Selection
	EVSYS_ASYNCCH2_ASYNCCH2_Msk = 0xff // Asynchronous Channel 2 Generator Selection

	// ASYNCCH3: Asynchronous Channel 3 Generator Selection
	EVSYS_ASYNCCH3_ASYNCCH30    = 0x1  // Asynchronous Channel 3 Generator Selection
	EVSYS_ASYNCCH3_ASYNCCH31    = 0x2  // Asynchronous Channel 3 Generator Selection
	EVSYS_ASYNCCH3_ASYNCCH32    = 0x4  // Asynchronous Channel 3 Generator Selection
	EVSYS_ASYNCCH3_ASYNCCH33    = 0x8  // Asynchronous Channel 3 Generator Selection
	EVSYS_ASYNCCH3_ASYNCCH34    = 0x10 // Asynchronous Channel 3 Generator Selection
	EVSYS_ASYNCCH3_ASYNCCH35    = 0x20 // Asynchronous Channel 3 Generator Selection
	EVSYS_ASYNCCH3_ASYNCCH36    = 0x40 // Asynchronous Channel 3 Generator Selection
	EVSYS_ASYNCCH3_ASYNCCH37    = 0x80 // Asynchronous Channel 3 Generator Selection
	EVSYS_ASYNCCH3_ASYNCCH3_Msk = 0xff // Asynchronous Channel 3 Generator Selection

	// SYNCCH0: Synchronous Channel 0 Generator Selection
	EVSYS_SYNCCH0_SYNCCH00    = 0x1  // Synchronous Channel 0 Generator Selection
	EVSYS_SYNCCH0_SYNCCH01    = 0x2  // Synchronous Channel 0 Generator Selection
	EVSYS_SYNCCH0_SYNCCH02    = 0x4  // Synchronous Channel 0 Generator Selection
	EVSYS_SYNCCH0_SYNCCH03    = 0x8  // Synchronous Channel 0 Generator Selection
	EVSYS_SYNCCH0_SYNCCH04    = 0x10 // Synchronous Channel 0 Generator Selection
	EVSYS_SYNCCH0_SYNCCH05    = 0x20 // Synchronous Channel 0 Generator Selection
	EVSYS_SYNCCH0_SYNCCH06    = 0x40 // Synchronous Channel 0 Generator Selection
	EVSYS_SYNCCH0_SYNCCH07    = 0x80 // Synchronous Channel 0 Generator Selection
	EVSYS_SYNCCH0_SYNCCH0_Msk = 0xff // Synchronous Channel 0 Generator Selection

	// SYNCCH1: Synchronous Channel 1 Generator Selection
	EVSYS_SYNCCH1_SYNCCH10    = 0x1  // Synchronous Channel 1 Generator Selection
	EVSYS_SYNCCH1_SYNCCH11    = 0x2  // Synchronous Channel 1 Generator Selection
	EVSYS_SYNCCH1_SYNCCH12    = 0x4  // Synchronous Channel 1 Generator Selection
	EVSYS_SYNCCH1_SYNCCH13    = 0x8  // Synchronous Channel 1 Generator Selection
	EVSYS_SYNCCH1_SYNCCH14    = 0x10 // Synchronous Channel 1 Generator Selection
	EVSYS_SYNCCH1_SYNCCH15    = 0x20 // Synchronous Channel 1 Generator Selection
	EVSYS_SYNCCH1_SYNCCH16    = 0x40 // Synchronous Channel 1 Generator Selection
	EVSYS_SYNCCH1_SYNCCH17    = 0x80 // Synchronous Channel 1 Generator Selection
	EVSYS_SYNCCH1_SYNCCH1_Msk = 0xff // Synchronous Channel 1 Generator Selection

	// ASYNCUSER0: Asynchronous User Ch 0 Input Selection - TCB0
	EVSYS_ASYNCUSER0_ASYNCUSER00    = 0x1  // Asynchronous User Ch 0 Input Selection - TCB0
	EVSYS_ASYNCUSER0_ASYNCUSER01    = 0x2  // Asynchronous User Ch 0 Input Selection - TCB0
	EVSYS_ASYNCUSER0_ASYNCUSER02    = 0x4  // Asynchronous User Ch 0 Input Selection - TCB0
	EVSYS_ASYNCUSER0_ASYNCUSER03    = 0x8  // Asynchronous User Ch 0 Input Selection - TCB0
	EVSYS_ASYNCUSER0_ASYNCUSER04    = 0x10 // Asynchronous User Ch 0 Input Selection - TCB0
	EVSYS_ASYNCUSER0_ASYNCUSER05    = 0x20 // Asynchronous User Ch 0 Input Selection - TCB0
	EVSYS_ASYNCUSER0_ASYNCUSER06    = 0x40 // Asynchronous User Ch 0 Input Selection - TCB0
	EVSYS_ASYNCUSER0_ASYNCUSER07    = 0x80 // Asynchronous User Ch 0 Input Selection - TCB0
	EVSYS_ASYNCUSER0_ASYNCUSER0_Msk = 0xff // Asynchronous User Ch 0 Input Selection - TCB0

	// ASYNCUSER1: Asynchronous User Ch 1 Input Selection - ADC0
	EVSYS_ASYNCUSER1_ASYNCUSER10    = 0x1  // Asynchronous User Ch 1 Input Selection - ADC0
	EVSYS_ASYNCUSER1_ASYNCUSER11    = 0x2  // Asynchronous User Ch 1 Input Selection - ADC0
	EVSYS_ASYNCUSER1_ASYNCUSER12    = 0x4  // Asynchronous User Ch 1 Input Selection - ADC0
	EVSYS_ASYNCUSER1_ASYNCUSER13    = 0x8  // Asynchronous User Ch 1 Input Selection - ADC0
	EVSYS_ASYNCUSER1_ASYNCUSER14    = 0x10 // Asynchronous User Ch 1 Input Selection - ADC0
	EVSYS_ASYNCUSER1_ASYNCUSER15    = 0x20 // Asynchronous User Ch 1 Input Selection - ADC0
	EVSYS_ASYNCUSER1_ASYNCUSER16    = 0x40 // Asynchronous User Ch 1 Input Selection - ADC0
	EVSYS_ASYNCUSER1_ASYNCUSER17    = 0x80 // Asynchronous User Ch 1 Input Selection - ADC0
	EVSYS_ASYNCUSER1_ASYNCUSER1_Msk = 0xff // Asynchronous User Ch 1 Input Selection - ADC0

	// ASYNCUSER2: Asynchronous User Ch 2 Input Selection - CCL LUT0 Event 0
	EVSYS_ASYNCUSER2_ASYNCUSER20    = 0x1  // Asynchronous User Ch 2 Input Selection - CCL LUT0 Event 0
	EVSYS_ASYNCUSER2_ASYNCUSER21    = 0x2  // Asynchronous User Ch 2 Input Selection - CCL LUT0 Event 0
	EVSYS_ASYNCUSER2_ASYNCUSER22    = 0x4  // Asynchronous User Ch 2 Input Selection - CCL LUT0 Event 0
	EVSYS_ASYNCUSER2_ASYNCUSER23    = 0x8  // Asynchronous User Ch 2 Input Selection - CCL LUT0 Event 0
	EVSYS_ASYNCUSER2_ASYNCUSER24    = 0x10 // Asynchronous User Ch 2 Input Selection - CCL LUT0 Event 0
	EVSYS_ASYNCUSER2_ASYNCUSER25    = 0x20 // Asynchronous User Ch 2 Input Selection - CCL LUT0 Event 0
	EVSYS_ASYNCUSER2_ASYNCUSER26    = 0x40 // Asynchronous User Ch 2 Input Selection - CCL LUT0 Event 0
	EVSYS_ASYNCUSER2_ASYNCUSER27    = 0x80 // Asynchronous User Ch 2 Input Selection - CCL LUT0 Event 0
	EVSYS_ASYNCUSER2_ASYNCUSER2_Msk = 0xff // Asynchronous User Ch 2 Input Selection - CCL LUT0 Event 0

	// ASYNCUSER3: Asynchronous User Ch 3 Input Selection - CCL LUT1 Event 0
	EVSYS_ASYNCUSER3_ASYNCUSER30    = 0x1  // Asynchronous User Ch 3 Input Selection - CCL LUT1 Event 0
	EVSYS_ASYNCUSER3_ASYNCUSER31    = 0x2  // Asynchronous User Ch 3 Input Selection - CCL LUT1 Event 0
	EVSYS_ASYNCUSER3_ASYNCUSER32    = 0x4  // Asynchronous User Ch 3 Input Selection - CCL LUT1 Event 0
	EVSYS_ASYNCUSER3_ASYNCUSER33    = 0x8  // Asynchronous User Ch 3 Input Selection - CCL LUT1 Event 0
	EVSYS_ASYNCUSER3_ASYNCUSER34    = 0x10 // Asynchronous User Ch 3 Input Selection - CCL LUT1 Event 0
	EVSYS_ASYNCUSER3_ASYNCUSER35    = 0x20 // Asynchronous User Ch 3 Input Selection - CCL LUT1 Event 0
	EVSYS_ASYNCUSER3_ASYNCUSER36    = 0x40 // Asynchronous User Ch 3 Input Selection - CCL LUT1 Event 0
	EVSYS_ASYNCUSER3_ASYNCUSER37    = 0x80 // Asynchronous User Ch 3 Input Selection - CCL LUT1 Event 0
	EVSYS_ASYNCUSER3_ASYNCUSER3_Msk = 0xff // Asynchronous User Ch 3 Input Selection - CCL LUT1 Event 0

	// ASYNCUSER4: Asynchronous User Ch 4 Input Selection - CCL LUT0 Event 1
	EVSYS_ASYNCUSER4_ASYNCUSER40    = 0x1  // synchronous User Ch 4 Input Selection - CCL LUT0 Event 1
	EVSYS_ASYNCUSER4_ASYNCUSER41    = 0x2  // synchronous User Ch 4 Input Selection - CCL LUT0 Event 1
	EVSYS_ASYNCUSER4_ASYNCUSER42    = 0x4  // synchronous User Ch 4 Input Selection - CCL LUT0 Event 1
	EVSYS_ASYNCUSER4_ASYNCUSER43    = 0x8  // synchronous User Ch 4 Input Selection - CCL LUT0 Event 1
	EVSYS_ASYNCUSER4_ASYNCUSER44    = 0x10 // synchronous User Ch 4 Input Selection - CCL LUT0 Event 1
	EVSYS_ASYNCUSER4_ASYNCUSER45    = 0x20 // synchronous User Ch 4 Input Selection - CCL LUT0 Event 1
	EVSYS_ASYNCUSER4_ASYNCUSER46    = 0x40 // synchronous User Ch 4 Input Selection - CCL LUT0 Event 1
	EVSYS_ASYNCUSER4_ASYNCUSER47    = 0x80 // synchronous User Ch 4 Input Selection - CCL LUT0 Event 1
	EVSYS_ASYNCUSER4_ASYNCUSER4_Msk = 0xff // synchronous User Ch 4 Input Selection - CCL LUT0 Event 1

	// ASYNCUSER5: Asynchronous User Ch 5 Input Selection - CCL LUT1 Event 1
	EVSYS_ASYNCUSER5_ASYNCUSER50    = 0x1  // Asynchronous User Ch 5 Input Selection - CCL LUT1 Event 1
	EVSYS_ASYNCUSER5_ASYNCUSER51    = 0x2  // Asynchronous User Ch 5 Input Selection - CCL LUT1 Event 1
	EVSYS_ASYNCUSER5_ASYNCUSER52    = 0x4  // Asynchronous User Ch 5 Input Selection - CCL LUT1 Event 1
	EVSYS_ASYNCUSER5_ASYNCUSER53    = 0x8  // Asynchronous User Ch 5 Input Selection - CCL LUT1 Event 1
	EVSYS_ASYNCUSER5_ASYNCUSER54    = 0x10 // Asynchronous User Ch 5 Input Selection - CCL LUT1 Event 1
	EVSYS_ASYNCUSER5_ASYNCUSER55    = 0x20 // Asynchronous User Ch 5 Input Selection - CCL LUT1 Event 1
	EVSYS_ASYNCUSER5_ASYNCUSER56    = 0x40 // Asynchronous User Ch 5 Input Selection - CCL LUT1 Event 1
	EVSYS_ASYNCUSER5_ASYNCUSER57    = 0x80 // Asynchronous User Ch 5 Input Selection - CCL LUT1 Event 1
	EVSYS_ASYNCUSER5_ASYNCUSER5_Msk = 0xff // Asynchronous User Ch 5 Input Selection - CCL LUT1 Event 1

	// ASYNCUSER6: Asynchronous User Ch 6 Input Selection - TCD0 Event 0
	EVSYS_ASYNCUSER6_ASYNCUSER60    = 0x1  // Asynchronous User Ch 6 Input Selection - TCD0 Event 0
	EVSYS_ASYNCUSER6_ASYNCUSER61    = 0x2  // Asynchronous User Ch 6 Input Selection - TCD0 Event 0
	EVSYS_ASYNCUSER6_ASYNCUSER62    = 0x4  // Asynchronous User Ch 6 Input Selection - TCD0 Event 0
	EVSYS_ASYNCUSER6_ASYNCUSER63    = 0x8  // Asynchronous User Ch 6 Input Selection - TCD0 Event 0
	EVSYS_ASYNCUSER6_ASYNCUSER64    = 0x10 // Asynchronous User Ch 6 Input Selection - TCD0 Event 0
	EVSYS_ASYNCUSER6_ASYNCUSER65    = 0x20 // Asynchronous User Ch 6 Input Selection - TCD0 Event 0
	EVSYS_ASYNCUSER6_ASYNCUSER66    = 0x40 // Asynchronous User Ch 6 Input Selection - TCD0 Event 0
	EVSYS_ASYNCUSER6_ASYNCUSER67    = 0x80 // Asynchronous User Ch 6 Input Selection - TCD0 Event 0
	EVSYS_ASYNCUSER6_ASYNCUSER6_Msk = 0xff // Asynchronous User Ch 6 Input Selection - TCD0 Event 0

	// ASYNCUSER7: Asynchronous User Ch 7 Input Selection - TCD0 Event 1
	EVSYS_ASYNCUSER7_ASYNCUSER70    = 0x1  // Asynchronous User Ch 7 Input Selection - TCD0 Event 1
	EVSYS_ASYNCUSER7_ASYNCUSER71    = 0x2  // Asynchronous User Ch 7 Input Selection - TCD0 Event 1
	EVSYS_ASYNCUSER7_ASYNCUSER72    = 0x4  // Asynchronous User Ch 7 Input Selection - TCD0 Event 1
	EVSYS_ASYNCUSER7_ASYNCUSER73    = 0x8  // Asynchronous User Ch 7 Input Selection - TCD0 Event 1
	EVSYS_ASYNCUSER7_ASYNCUSER74    = 0x10 // Asynchronous User Ch 7 Input Selection - TCD0 Event 1
	EVSYS_ASYNCUSER7_ASYNCUSER75    = 0x20 // Asynchronous User Ch 7 Input Selection - TCD0 Event 1
	EVSYS_ASYNCUSER7_ASYNCUSER76    = 0x40 // Asynchronous User Ch 7 Input Selection - TCD0 Event 1
	EVSYS_ASYNCUSER7_ASYNCUSER77    = 0x80 // Asynchronous User Ch 7 Input Selection - TCD0 Event 1
	EVSYS_ASYNCUSER7_ASYNCUSER7_Msk = 0xff // Asynchronous User Ch 7 Input Selection - TCD0 Event 1

	// ASYNCUSER8: Asynchronous User Ch 8 Input Selection - Event Out 0
	EVSYS_ASYNCUSER8_ASYNCUSER80    = 0x1  // Asynchronous User Ch 8 Input Selection - Event Out 0
	EVSYS_ASYNCUSER8_ASYNCUSER81    = 0x2  // Asynchronous User Ch 8 Input Selection - Event Out 0
	EVSYS_ASYNCUSER8_ASYNCUSER82    = 0x4  // Asynchronous User Ch 8 Input Selection - Event Out 0
	EVSYS_ASYNCUSER8_ASYNCUSER83    = 0x8  // Asynchronous User Ch 8 Input Selection - Event Out 0
	EVSYS_ASYNCUSER8_ASYNCUSER84    = 0x10 // Asynchronous User Ch 8 Input Selection - Event Out 0
	EVSYS_ASYNCUSER8_ASYNCUSER85    = 0x20 // Asynchronous User Ch 8 Input Selection - Event Out 0
	EVSYS_ASYNCUSER8_ASYNCUSER86    = 0x40 // Asynchronous User Ch 8 Input Selection - Event Out 0
	EVSYS_ASYNCUSER8_ASYNCUSER87    = 0x80 // Asynchronous User Ch 8 Input Selection - Event Out 0
	EVSYS_ASYNCUSER8_ASYNCUSER8_Msk = 0xff // Asynchronous User Ch 8 Input Selection - Event Out 0

	// ASYNCUSER9: Asynchronous User Ch 9 Input Selection - Event Out 1
	EVSYS_ASYNCUSER9_ASYNCUSER90    = 0x1  // Asynchronous User Ch 9 Input Selection - Event Out 1
	EVSYS_ASYNCUSER9_ASYNCUSER91    = 0x2  // Asynchronous User Ch 9 Input Selection - Event Out 1
	EVSYS_ASYNCUSER9_ASYNCUSER92    = 0x4  // Asynchronous User Ch 9 Input Selection - Event Out 1
	EVSYS_ASYNCUSER9_ASYNCUSER93    = 0x8  // Asynchronous User Ch 9 Input Selection - Event Out 1
	EVSYS_ASYNCUSER9_ASYNCUSER94    = 0x10 // Asynchronous User Ch 9 Input Selection - Event Out 1
	EVSYS_ASYNCUSER9_ASYNCUSER95    = 0x20 // Asynchronous User Ch 9 Input Selection - Event Out 1
	EVSYS_ASYNCUSER9_ASYNCUSER96    = 0x40 // Asynchronous User Ch 9 Input Selection - Event Out 1
	EVSYS_ASYNCUSER9_ASYNCUSER97    = 0x80 // Asynchronous User Ch 9 Input Selection - Event Out 1
	EVSYS_ASYNCUSER9_ASYNCUSER9_Msk = 0xff // Asynchronous User Ch 9 Input Selection - Event Out 1

	// ASYNCUSER10: Asynchronous User Ch 10 Input Selection - Event Out 2
	EVSYS_ASYNCUSER10_ASYNCUSER100    = 0x1  // Asynchronous User Ch 10 Input Selection - Event Out 2
	EVSYS_ASYNCUSER10_ASYNCUSER101    = 0x2  // Asynchronous User Ch 10 Input Selection - Event Out 2
	EVSYS_ASYNCUSER10_ASYNCUSER102    = 0x4  // Asynchronous User Ch 10 Input Selection - Event Out 2
	EVSYS_ASYNCUSER10_ASYNCUSER103    = 0x8  // Asynchronous User Ch 10 Input Selection - Event Out 2
	EVSYS_ASYNCUSER10_ASYNCUSER104    = 0x10 // Asynchronous User Ch 10 Input Selection - Event Out 2
	EVSYS_ASYNCUSER10_ASYNCUSER105    = 0x20 // Asynchronous User Ch 10 Input Selection - Event Out 2
	EVSYS_ASYNCUSER10_ASYNCUSER106    = 0x40 // Asynchronous User Ch 10 Input Selection - Event Out 2
	EVSYS_ASYNCUSER10_ASYNCUSER107    = 0x80 // Asynchronous User Ch 10 Input Selection - Event Out 2
	EVSYS_ASYNCUSER10_ASYNCUSER10_Msk = 0xff // Asynchronous User Ch 10 Input Selection - Event Out 2

	// SYNCUSER0: Synchronous User Ch 0 Input Selection - TCA0
	EVSYS_SYNCUSER0_SYNCUSER00    = 0x1  // Synchronous User Ch 0 Input Selection - TCA0
	EVSYS_SYNCUSER0_SYNCUSER01    = 0x2  // Synchronous User Ch 0 Input Selection - TCA0
	EVSYS_SYNCUSER0_SYNCUSER02    = 0x4  // Synchronous User Ch 0 Input Selection - TCA0
	EVSYS_SYNCUSER0_SYNCUSER03    = 0x8  // Synchronous User Ch 0 Input Selection - TCA0
	EVSYS_SYNCUSER0_SYNCUSER04    = 0x10 // Synchronous User Ch 0 Input Selection - TCA0
	EVSYS_SYNCUSER0_SYNCUSER05    = 0x20 // Synchronous User Ch 0 Input Selection - TCA0
	EVSYS_SYNCUSER0_SYNCUSER06    = 0x40 // Synchronous User Ch 0 Input Selection - TCA0
	EVSYS_SYNCUSER0_SYNCUSER07    = 0x80 // Synchronous User Ch 0 Input Selection - TCA0
	EVSYS_SYNCUSER0_SYNCUSER0_Msk = 0xff // Synchronous User Ch 0 Input Selection - TCA0

	// SYNCUSER1: Synchronous User Ch 1 Input Selection - USART0
	EVSYS_SYNCUSER1_SYNCUSER10    = 0x1  // Synchronous User Ch 1 Input Selection - USART0
	EVSYS_SYNCUSER1_SYNCUSER11    = 0x2  // Synchronous User Ch 1 Input Selection - USART0
	EVSYS_SYNCUSER1_SYNCUSER12    = 0x4  // Synchronous User Ch 1 Input Selection - USART0
	EVSYS_SYNCUSER1_SYNCUSER13    = 0x8  // Synchronous User Ch 1 Input Selection - USART0
	EVSYS_SYNCUSER1_SYNCUSER14    = 0x10 // Synchronous User Ch 1 Input Selection - USART0
	EVSYS_SYNCUSER1_SYNCUSER15    = 0x20 // Synchronous User Ch 1 Input Selection - USART0
	EVSYS_SYNCUSER1_SYNCUSER16    = 0x40 // Synchronous User Ch 1 Input Selection - USART0
	EVSYS_SYNCUSER1_SYNCUSER17    = 0x80 // Synchronous User Ch 1 Input Selection - USART0
	EVSYS_SYNCUSER1_SYNCUSER1_Msk = 0xff // Synchronous User Ch 1 Input Selection - USART0
)

// Bitfields for FUSE: Fuses
const (
	// WDTCFG: Watchdog Configuration
	FUSE_WDTCFG_PERIOD0    = 0x1  // Watchdog Timeout Period
	FUSE_WDTCFG_PERIOD1    = 0x2  // Watchdog Timeout Period
	FUSE_WDTCFG_PERIOD2    = 0x4  // Watchdog Timeout Period
	FUSE_WDTCFG_PERIOD3    = 0x8  // Watchdog Timeout Period
	FUSE_WDTCFG_PERIOD_Msk = 0xf  // Watchdog Timeout Period
	FUSE_WDTCFG_WINDOW0    = 0x10 // Watchdog Window Timeout Period
	FUSE_WDTCFG_WINDOW1    = 0x20 // Watchdog Window Timeout Period
	FUSE_WDTCFG_WINDOW2    = 0x40 // Watchdog Window Timeout Period
	FUSE_WDTCFG_WINDOW3    = 0x80 // Watchdog Window Timeout Period
	FUSE_WDTCFG_WINDOW_Msk = 0xf0 // Watchdog Window Timeout Period

	// BODCFG: BOD Configuration
	FUSE_BODCFG_ACTIVE0      = 0x4  // BOD Operation in Active Mode
	FUSE_BODCFG_ACTIVE1      = 0x8  // BOD Operation in Active Mode
	FUSE_BODCFG_ACTIVE_Msk   = 0xc  // BOD Operation in Active Mode
	FUSE_BODCFG_LVL0         = 0x20 // BOD Level
	FUSE_BODCFG_LVL1         = 0x40 // BOD Level
	FUSE_BODCFG_LVL2         = 0x80 // BOD Level
	FUSE_BODCFG_LVL_Msk      = 0xe0 // BOD Level
	FUSE_BODCFG_SAMPFREQ     = 0x10 // BOD Sample Frequency
	FUSE_BODCFG_SAMPFREQ_Msk = 0x10 // BOD Sample Frequency
	FUSE_BODCFG_SLEEP0       = 0x1  // BOD Operation in Sleep Mode
	FUSE_BODCFG_SLEEP1       = 0x2  // BOD Operation in Sleep Mode
	FUSE_BODCFG_SLEEP_Msk    = 0x3  // BOD Operation in Sleep Mode

	// OSCCFG: Oscillator Configuration
	FUSE_OSCCFG_FREQSEL0    = 0x1  // Frequency Select
	FUSE_OSCCFG_FREQSEL1    = 0x2  // Frequency Select
	FUSE_OSCCFG_FREQSEL_Msk = 0x3  // Frequency Select
	FUSE_OSCCFG_OSCLOCK     = 0x80 // Oscillator Lock
	FUSE_OSCCFG_OSCLOCK_Msk = 0x80 // Oscillator Lock

	// TCD0CFG: TCD0 Configuration
	FUSE_TCD0CFG_CMPA       = 0x1  // Compare A Default Output Value
	FUSE_TCD0CFG_CMPA_Msk   = 0x1  // Compare A Default Output Value
	FUSE_TCD0CFG_CMPAEN     = 0x10 // Compare A Output Enable
	FUSE_TCD0CFG_CMPAEN_Msk = 0x10 // Compare A Output Enable
	FUSE_TCD0CFG_CMPB       = 0x2  // Compare B Default Output Value
	FUSE_TCD0CFG_CMPB_Msk   = 0x2  // Compare B Default Output Value
	FUSE_TCD0CFG_CMPBEN     = 0x20 // Compare B Output Enable
	FUSE_TCD0CFG_CMPBEN_Msk = 0x20 // Compare B Output Enable
	FUSE_TCD0CFG_CMPC       = 0x4  // Compare C Default Output Value
	FUSE_TCD0CFG_CMPC_Msk   = 0x4  // Compare C Default Output Value
	FUSE_TCD0CFG_CMPCEN     = 0x40 // Compare C Output Enable
	FUSE_TCD0CFG_CMPCEN_Msk = 0x40 // Compare C Output Enable
	FUSE_TCD0CFG_CMPD       = 0x8  // Compare D Default Output Value
	FUSE_TCD0CFG_CMPD_Msk   = 0x8  // Compare D Default Output Value
	FUSE_TCD0CFG_CMPDEN     = 0x80 // Compare D Output Enable
	FUSE_TCD0CFG_CMPDEN_Msk = 0x80 // Compare D Output Enable

	// SYSCFG0: System Configuration 0
	FUSE_SYSCFG0_CRCSRC0       = 0x40 // CRC Source
	FUSE_SYSCFG0_CRCSRC1       = 0x80 // CRC Source
	FUSE_SYSCFG0_CRCSRC_Msk    = 0xc0 // CRC Source
	FUSE_SYSCFG0_EESAVE        = 0x1  // EEPROM Save
	FUSE_SYSCFG0_EESAVE_Msk    = 0x1  // EEPROM Save
	FUSE_SYSCFG0_RSTPINCFG0    = 0x4  // Reset Pin Configuration
	FUSE_SYSCFG0_RSTPINCFG1    = 0x8  // Reset Pin Configuration
	FUSE_SYSCFG0_RSTPINCFG_Msk = 0xc  // Reset Pin Configuration

	// SYSCFG1: System Configuration 1
	FUSE_SYSCFG1_SUT0    = 0x1 // Startup Time
	FUSE_SYSCFG1_SUT1    = 0x2 // Startup Time
	FUSE_SYSCFG1_SUT2    = 0x4 // Startup Time
	FUSE_SYSCFG1_SUT_Msk = 0x7 // Startup Time
)

// Bitfields for LOCKBIT: Lockbit
const (
	// LOCKBIT: Lock bits
	LOCKBIT_LOCKBIT_LB0    = 0x1  // Lock Bits
	LOCKBIT_LOCKBIT_LB1    = 0x2  // Lock Bits
	LOCKBIT_LOCKBIT_LB2    = 0x4  // Lock Bits
	LOCKBIT_LOCKBIT_LB3    = 0x8  // Lock Bits
	LOCKBIT_LOCKBIT_LB4    = 0x10 // Lock Bits
	LOCKBIT_LOCKBIT_LB5    = 0x20 // Lock Bits
	LOCKBIT_LOCKBIT_LB6    = 0x40 // Lock Bits
	LOCKBIT_LOCKBIT_LB7    = 0x80 // Lock Bits
	LOCKBIT_LOCKBIT_LB_Msk = 0xff // Lock Bits
)

// Bitfields for NVMCTRL: Non-volatile Memory Controller
const (
	// CTRLA: Control A
	NVMCTRL_CTRLA_CMD0    = 0x1 // Command
	NVMCTRL_CTRLA_CMD1    = 0x2 // Command
	NVMCTRL_CTRLA_CMD2    = 0x4 // Command
	NVMCTRL_CTRLA_CMD_Msk = 0x7 // Command

	// CTRLB: Control B
	NVMCTRL_CTRLB_APCWP        = 0x1 // Application code write protect
	NVMCTRL_CTRLB_APCWP_Msk    = 0x1 // Application code write protect
	NVMCTRL_CTRLB_BOOTLOCK     = 0x2 // Boot Lock
	NVMCTRL_CTRLB_BOOTLOCK_Msk = 0x2 // Boot Lock

	// STATUS: Status
	NVMCTRL_STATUS_EEBUSY      = 0x2 // EEPROM busy
	NVMCTRL_STATUS_EEBUSY_Msk  = 0x2 // EEPROM busy
	NVMCTRL_STATUS_FBUSY       = 0x1 // Flash busy
	NVMCTRL_STATUS_FBUSY_Msk   = 0x1 // Flash busy
	NVMCTRL_STATUS_WRERROR     = 0x4 // Write error
	NVMCTRL_STATUS_WRERROR_Msk = 0x4 // Write error

	// INTCTRL: Interrupt Control
	NVMCTRL_INTCTRL_EEREADY     = 0x1 // EEPROM Ready
	NVMCTRL_INTCTRL_EEREADY_Msk = 0x1 // EEPROM Ready

	// INTFLAGS: Interrupt Flags
	NVMCTRL_INTFLAGS_EEREADY     = 0x1 // EEPROM Ready
	NVMCTRL_INTFLAGS_EEREADY_Msk = 0x1 // EEPROM Ready
)

// Bitfields for PORT: I/O Ports
const (
	// INTFLAGS: Interrupt Flags
	PORT_INTFLAGS_INT0    = 0x1  // Pin Interrupt
	PORT_INTFLAGS_INT1    = 0x2  // Pin Interrupt
	PORT_INTFLAGS_INT2    = 0x4  // Pin Interrupt
	PORT_INTFLAGS_INT3    = 0x8  // Pin Interrupt
	PORT_INTFLAGS_INT4    = 0x10 // Pin Interrupt
	PORT_INTFLAGS_INT5    = 0x20 // Pin Interrupt
	PORT_INTFLAGS_INT6    = 0x40 // Pin Interrupt
	PORT_INTFLAGS_INT7    = 0x80 // Pin Interrupt
	PORT_INTFLAGS_INT_Msk = 0xff // Pin Interrupt

	// PIN0CTRL: Pin 0 Control
	PORT_PIN0CTRL_INVEN        = 0x80 // Inverted I/O Enable
	PORT_PIN0CTRL_INVEN_Msk    = 0x80 // Inverted I/O Enable
	PORT_PIN0CTRL_ISC0         = 0x1  // Input/Sense Configuration
	PORT_PIN0CTRL_ISC1         = 0x2  // Input/Sense Configuration
	PORT_PIN0CTRL_ISC2         = 0x4  // Input/Sense Configuration
	PORT_PIN0CTRL_ISC_Msk      = 0x7  // Input/Sense Configuration
	PORT_PIN0CTRL_PULLUPEN     = 0x8  // Pullup enable
	PORT_PIN0CTRL_PULLUPEN_Msk = 0x8  // Pullup enable

	// PIN1CTRL: Pin 1 Control
	PORT_PIN1CTRL_INVEN        = 0x80 // Inverted I/O Enable
	PORT_PIN1CTRL_INVEN_Msk    = 0x80 // Inverted I/O Enable
	PORT_PIN1CTRL_ISC0         = 0x1  // Input/Sense Configuration
	PORT_PIN1CTRL_ISC1         = 0x2  // Input/Sense Configuration
	PORT_PIN1CTRL_ISC2         = 0x4  // Input/Sense Configuration
	PORT_PIN1CTRL_ISC_Msk      = 0x7  // Input/Sense Configuration
	PORT_PIN1CTRL_PULLUPEN     = 0x8  // Pullup enable
	PORT_PIN1CTRL_PULLUPEN_Msk = 0x8  // Pullup enable

	// PIN2CTRL: Pin 2 Control
	PORT_PIN2CTRL_INVEN        = 0x80 // Inverted I/O Enable
	PORT_PIN2CTRL_INVEN_Msk    = 0x80 // Inverted I/O Enable
	PORT_PIN2CTRL_ISC0         = 0x1  // Input/Sense Configuration
	PORT_PIN2CTRL_ISC1         = 0x2  // Input/Sense Configuration
	PORT_PIN2CTRL_ISC2         = 0x4  // Input/Sense Configuration
	PORT_PIN2CTRL_ISC_Msk      = 0x7  // Input/Sense Configuration
	PORT_PIN2CTRL_PULLUPEN     = 0x8  // Pullup enable
	PORT_PIN2CTRL_PULLUPEN_Msk = 0x8  // Pullup enable

	// PIN3CTRL: Pin 3 Control
	PORT_PIN3CTRL_INVEN        = 0x80 // Inverted I/O Enable
	PORT_PIN3CTRL_INVEN_Msk    = 0x80 // Inverted I/O Enable
	PORT_PIN3CTRL_ISC0         = 0x1  // Input/Sense Configuration
	PORT_PIN3CTRL_ISC1         = 0x2  // Input/Sense Configuration
	PORT_PIN3CTRL_ISC2         = 0x4  // Input/Sense Configuration
	PORT_PIN3CTRL_ISC_Msk      = 0x7  // Input/Sense Configuration
	PORT_PIN3CTRL_PULLUPEN     = 0x8  // Pullup enable
	PORT_PIN3CTRL_PULLUPEN_Msk = 0x8  // Pullup enable

	// PIN4CTRL: Pin 4 Control
	PORT_PIN4CTRL_INVEN        = 0x80 // Inverted I/O Enable
	PORT_PIN4CTRL_INVEN_Msk    = 0x80 // Inverted I/O Enable
	PORT_PIN4CTRL_ISC0         = 0x1  // Input/Sense Configuration
	PORT_PIN4CTRL_ISC1         = 0x2  // Input/Sense Configuration
	PORT_PIN4CTRL_ISC2         = 0x4  // Input/Sense Configuration
	PORT_PIN4CTRL_ISC_Msk      = 0x7  // Input/Sense Configuration
	PORT_PIN4CTRL_PULLUPEN     = 0x8  // Pullup enable
	PORT_PIN4CTRL_PULLUPEN_Msk = 0x8  // Pullup enable

	// PIN5CTRL: Pin 5 Control
	PORT_PIN5CTRL_INVEN        = 0x80 // Inverted I/O Enable
	PORT_PIN5CTRL_INVEN_Msk    = 0x80 // Inverted I/O Enable
	PORT_PIN5CTRL_ISC0         = 0x1  // Input/Sense Configuration
	PORT_PIN5CTRL_ISC1         = 0x2  // Input/Sense Configuration
	PORT_PIN5CTRL_ISC2         = 0x4  // Input/Sense Configuration
	PORT_PIN5CTRL_ISC_Msk      = 0x7  // Input/Sense Configuration
	PORT_PIN5CTRL_PULLUPEN     = 0x8  // Pullup enable
	PORT_PIN5CTRL_PULLUPEN_Msk = 0x8  // Pullup enable

	// PIN6CTRL: Pin 6 Control
	PORT_PIN6CTRL_INVEN        = 0x80 // Inverted I/O Enable
	PORT_PIN6CTRL_INVEN_Msk    = 0x80 // Inverted I/O Enable
	PORT_PIN6CTRL_ISC0         = 0x1  // Input/Sense Configuration
	PORT_PIN6CTRL_ISC1         = 0x2  // Input/Sense Configuration
	PORT_PIN6CTRL_ISC2         = 0x4  // Input/Sense Configuration
	PORT_PIN6CTRL_ISC_Msk      = 0x7  // Input/Sense Configuration
	PORT_PIN6CTRL_PULLUPEN     = 0x8  // Pullup enable
	PORT_PIN6CTRL_PULLUPEN_Msk = 0x8  // Pullup enable

	// PIN7CTRL: Pin 7 Control
	PORT_PIN7CTRL_INVEN        = 0x80 // Inverted I/O Enable
	PORT_PIN7CTRL_INVEN_Msk    = 0x80 // Inverted I/O Enable
	PORT_PIN7CTRL_ISC0         = 0x1  // Input/Sense Configuration
	PORT_PIN7CTRL_ISC1         = 0x2  // Input/Sense Configuration
	PORT_PIN7CTRL_ISC2         = 0x4  // Input/Sense Configuration
	PORT_PIN7CTRL_ISC_Msk      = 0x7  // Input/Sense Configuration
	PORT_PIN7CTRL_PULLUPEN     = 0x8  // Pullup enable
	PORT_PIN7CTRL_PULLUPEN_Msk = 0x8  // Pullup enable
)

// Bitfields for PORTMUX: Port Multiplexer
const (
	// CTRLA: Port Multiplexer Control A
	PORTMUX_CTRLA_EVOUT0     = 0x1  // Event Output 0
	PORTMUX_CTRLA_EVOUT0_Msk = 0x1  // Event Output 0
	PORTMUX_CTRLA_EVOUT1     = 0x2  // Event Output 1
	PORTMUX_CTRLA_EVOUT1_Msk = 0x2  // Event Output 1
	PORTMUX_CTRLA_EVOUT2     = 0x4  // Event Output 2
	PORTMUX_CTRLA_EVOUT2_Msk = 0x4  // Event Output 2
	PORTMUX_CTRLA_LUT0       = 0x10 // Configurable Custom Logic LUT0
	PORTMUX_CTRLA_LUT0_Msk   = 0x10 // Configurable Custom Logic LUT0
	PORTMUX_CTRLA_LUT1       = 0x20 // Configurable Custom Logic LUT1
	PORTMUX_CTRLA_LUT1_Msk   = 0x20 // Configurable Custom Logic LUT1

	// CTRLB: Port Multiplexer Control B
	PORTMUX_CTRLB_SPI0       = 0x4  // Port Multiplexer SPI0
	PORTMUX_CTRLB_SPI0_Msk   = 0x4  // Port Multiplexer SPI0
	PORTMUX_CTRLB_TWI0       = 0x10 // Port Multiplexer TWI0
	PORTMUX_CTRLB_TWI0_Msk   = 0x10 // Port Multiplexer TWI0
	PORTMUX_CTRLB_USART0     = 0x1  // Port Multiplexer USART0
	PORTMUX_CTRLB_USART0_Msk = 0x1  // Port Multiplexer USART0

	// CTRLC: Port Multiplexer Control C
	PORTMUX_CTRLC_TCA00     = 0x1 // Port Multiplexer TCA0 Output 0
	PORTMUX_CTRLC_TCA00_Msk = 0x1 // Port Multiplexer TCA0 Output 0
	PORTMUX_CTRLC_TCA01     = 0x2 // Port Multiplexer TCA0 output 1
	PORTMUX_CTRLC_TCA01_Msk = 0x2 // Port Multiplexer TCA0 output 1
	PORTMUX_CTRLC_TCA02     = 0x4 // Port Multiplexer TCA0 Output 2
	PORTMUX_CTRLC_TCA02_Msk = 0x4 // Port Multiplexer TCA0 Output 2
	PORTMUX_CTRLC_TCA03     = 0x8 // Port Multiplexer TCA0 Output 3
	PORTMUX_CTRLC_TCA03_Msk = 0x8 // Port Multiplexer TCA0 Output 3

	// CTRLD: Port Multiplexer Control D
	PORTMUX_CTRLD_TCB0     = 0x1 // Port Multiplexer TCB
	PORTMUX_CTRLD_TCB0_Msk = 0x1 // Port Multiplexer TCB
)

// Bitfields for RSTCTRL: Reset controller
const (
	// RSTFR: Reset Flags
	RSTCTRL_RSTFR_BORF       = 0x2  // Brown out detector Reset flag
	RSTCTRL_RSTFR_BORF_Msk   = 0x2  // Brown out detector Reset flag
	RSTCTRL_RSTFR_EXTRF      = 0x4  // External Reset flag
	RSTCTRL_RSTFR_EXTRF_Msk  = 0x4  // External Reset flag
	RSTCTRL_RSTFR_PORF       = 0x1  // Power on Reset flag
	RSTCTRL_RSTFR_PORF_Msk   = 0x1  // Power on Reset flag
	RSTCTRL_RSTFR_SWRF       = 0x10 // Software Reset flag
	RSTCTRL_RSTFR_SWRF_Msk   = 0x10 // Software Reset flag
	RSTCTRL_RSTFR_UPDIRF     = 0x20 // UPDI Reset flag
	RSTCTRL_RSTFR_UPDIRF_Msk = 0x20 // UPDI Reset flag
	RSTCTRL_RSTFR_WDRF       = 0x8  // Watch dog Reset flag
	RSTCTRL_RSTFR_WDRF_Msk   = 0x8  // Watch dog Reset flag

	// SWRR: Software Reset
	RSTCTRL_SWRR_SWRE     = 0x1 // Software reset enable
	RSTCTRL_SWRR_SWRE_Msk = 0x1 // Software reset enable
)

// Bitfields for RTC: Real-Time Counter
const (
	// CTRLA: Control A
	RTC_CTRLA_PRESCALER0    = 0x8  // Prescaling Factor
	RTC_CTRLA_PRESCALER1    = 0x10 // Prescaling Factor
	RTC_CTRLA_PRESCALER2    = 0x20 // Prescaling Factor
	RTC_CTRLA_PRESCALER3    = 0x40 // Prescaling Factor
	RTC_CTRLA_PRESCALER_Msk = 0x78 // Prescaling Factor
	RTC_CTRLA_RTCEN         = 0x1  // Enable
	RTC_CTRLA_RTCEN_Msk     = 0x1  // Enable
	RTC_CTRLA_RUNSTDBY      = 0x80 // Run In Standby
	RTC_CTRLA_RUNSTDBY_Msk  = 0x80 // Run In Standby

	// STATUS: Status
	RTC_STATUS_CMPBUSY       = 0x8 // Comparator Synchronization Busy Flag
	RTC_STATUS_CMPBUSY_Msk   = 0x8 // Comparator Synchronization Busy Flag
	RTC_STATUS_CNTBUSY       = 0x2 // Count Synchronization Busy Flag
	RTC_STATUS_CNTBUSY_Msk   = 0x2 // Count Synchronization Busy Flag
	RTC_STATUS_CTRLABUSY     = 0x1 // CTRLA Synchronization Busy Flag
	RTC_STATUS_CTRLABUSY_Msk = 0x1 // CTRLA Synchronization Busy Flag
	RTC_STATUS_PERBUSY       = 0x4 // Period Synchronization Busy Flag
	RTC_STATUS_PERBUSY_Msk   = 0x4 // Period Synchronization Busy Flag

	// INTCTRL: Interrupt Control
	RTC_INTCTRL_CMP     = 0x2 // Compare Match Interrupt enable
	RTC_INTCTRL_CMP_Msk = 0x2 // Compare Match Interrupt enable
	RTC_INTCTRL_OVF     = 0x1 // Overflow Interrupt enable
	RTC_INTCTRL_OVF_Msk = 0x1 // Overflow Interrupt enable

	// INTFLAGS: Interrupt Flags
	RTC_INTFLAGS_CMP     = 0x2 // Compare Match Interrupt
	RTC_INTFLAGS_CMP_Msk = 0x2 // Compare Match Interrupt
	RTC_INTFLAGS_OVF     = 0x1 // Overflow Interrupt Flag
	RTC_INTFLAGS_OVF_Msk = 0x1 // Overflow Interrupt Flag

	// DBGCTRL: Debug control
	RTC_DBGCTRL_DBGRUN     = 0x1 // Run in debug
	RTC_DBGCTRL_DBGRUN_Msk = 0x1 // Run in debug

	// CLKSEL: Clock Select
	RTC_CLKSEL_CLKSEL0    = 0x1 // Clock Select
	RTC_CLKSEL_CLKSEL1    = 0x2 // Clock Select
	RTC_CLKSEL_CLKSEL_Msk = 0x3 // Clock Select

	// PITCTRLA: PIT Control A
	RTC_PITCTRLA_PERIOD0    = 0x8  // Period
	RTC_PITCTRLA_PERIOD1    = 0x10 // Period
	RTC_PITCTRLA_PERIOD2    = 0x20 // Period
	RTC_PITCTRLA_PERIOD3    = 0x40 // Period
	RTC_PITCTRLA_PERIOD_Msk = 0x78 // Period
	RTC_PITCTRLA_PITEN      = 0x1  // Enable
	RTC_PITCTRLA_PITEN_Msk  = 0x1  // Enable

	// PITSTATUS: PIT Status
	RTC_PITSTATUS_CTRLBUSY     = 0x1 // CTRLA Synchronization Busy Flag
	RTC_PITSTATUS_CTRLBUSY_Msk = 0x1 // CTRLA Synchronization Busy Flag

	// PITINTCTRL: PIT Interrupt Control
	RTC_PITINTCTRL_PI     = 0x1 // Periodic Interrupt
	RTC_PITINTCTRL_PI_Msk = 0x1 // Periodic Interrupt

	// PITINTFLAGS: PIT Interrupt Flags
	RTC_PITINTFLAGS_PI     = 0x1 // Periodic Interrupt
	RTC_PITINTFLAGS_PI_Msk = 0x1 // Periodic Interrupt

	// PITDBGCTRL: PIT Debug control
	RTC_PITDBGCTRL_DBGRUN     = 0x1 // Run in debug
	RTC_PITDBGCTRL_DBGRUN_Msk = 0x1 // Run in debug
)

// Bitfields for SLPCTRL: Sleep Controller
const (
	// CTRLA: Control
	SLPCTRL_CTRLA_SEN       = 0x1 // Sleep enable
	SLPCTRL_CTRLA_SEN_Msk   = 0x1 // Sleep enable
	SLPCTRL_CTRLA_SMODE0    = 0x2 // Sleep mode
	SLPCTRL_CTRLA_SMODE1    = 0x4 // Sleep mode
	SLPCTRL_CTRLA_SMODE_Msk = 0x6 // Sleep mode
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// CTRLA: Control A
	SPI_CTRLA_CLK2X      = 0x10 // Enable Double Speed
	SPI_CTRLA_CLK2X_Msk  = 0x10 // Enable Double Speed
	SPI_CTRLA_DORD       = 0x40 // Data Order Setting
	SPI_CTRLA_DORD_Msk   = 0x40 // Data Order Setting
	SPI_CTRLA_ENABLE     = 0x1  // Enable Module
	SPI_CTRLA_ENABLE_Msk = 0x1  // Enable Module
	SPI_CTRLA_MASTER     = 0x20 // Master Operation Enable
	SPI_CTRLA_MASTER_Msk = 0x20 // Master Operation Enable
	SPI_CTRLA_PRESC0     = 0x2  // Prescaler
	SPI_CTRLA_PRESC1     = 0x4  // Prescaler
	SPI_CTRLA_PRESC_Msk  = 0x6  // Prescaler

	// CTRLB: Control B
	SPI_CTRLB_BUFEN     = 0x80 // Buffer Mode Enable
	SPI_CTRLB_BUFEN_Msk = 0x80 // Buffer Mode Enable
	SPI_CTRLB_BUFWR     = 0x40 // Buffer Write Mode
	SPI_CTRLB_BUFWR_Msk = 0x40 // Buffer Write Mode
	SPI_CTRLB_MODE0     = 0x1  // SPI Mode
	SPI_CTRLB_MODE1     = 0x2  // SPI Mode
	SPI_CTRLB_MODE_Msk  = 0x3  // SPI Mode
	SPI_CTRLB_SSD       = 0x4  // Slave Select Disable
	SPI_CTRLB_SSD_Msk   = 0x4  // Slave Select Disable

	// INTCTRL: Interrupt Control
	SPI_INTCTRL_DREIE     = 0x20 // Data Register Empty Interrupt Enable
	SPI_INTCTRL_DREIE_Msk = 0x20 // Data Register Empty Interrupt Enable
	SPI_INTCTRL_IE        = 0x1  // Interrupt Enable
	SPI_INTCTRL_IE_Msk    = 0x1  // Interrupt Enable
	SPI_INTCTRL_RXCIE     = 0x80 // Receive Complete Interrupt Enable
	SPI_INTCTRL_RXCIE_Msk = 0x80 // Receive Complete Interrupt Enable
	SPI_INTCTRL_SSIE      = 0x10 // Slave Select Trigger Interrupt Enable
	SPI_INTCTRL_SSIE_Msk  = 0x10 // Slave Select Trigger Interrupt Enable
	SPI_INTCTRL_TXCIE     = 0x40 // Transfer Complete Interrupt Enable
	SPI_INTCTRL_TXCIE_Msk = 0x40 // Transfer Complete Interrupt Enable
)

// Bitfields for SYSCFG: System Configuration Registers
const (
	// EXTBRK: External Break
	SYSCFG_EXTBRK_ENEXTBRK     = 0x1 // External break enable
	SYSCFG_EXTBRK_ENEXTBRK_Msk = 0x1 // External break enable
)

// Bitfields for TCA_SINGLE: 16-bit Timer/Counter Type A - Single Mode
const (
	// CTRLA: Control A
	TCA_SINGLE_CTRLA_CLKSEL0    = 0x2 // Clock Selection
	TCA_SINGLE_CTRLA_CLKSEL1    = 0x4 // Clock Selection
	TCA_SINGLE_CTRLA_CLKSEL2    = 0x8 // Clock Selection
	TCA_SINGLE_CTRLA_CLKSEL_Msk = 0xe // Clock Selection
	TCA_SINGLE_CTRLA_ENABLE     = 0x1 // Module Enable
	TCA_SINGLE_CTRLA_ENABLE_Msk = 0x1 // Module Enable

	// CTRLB: Control B
	TCA_SINGLE_CTRLB_ALUPD      = 0x8  // Auto Lock Update
	TCA_SINGLE_CTRLB_ALUPD_Msk  = 0x8  // Auto Lock Update
	TCA_SINGLE_CTRLB_CMP0EN     = 0x10 // Compare 0 Enable
	TCA_SINGLE_CTRLB_CMP0EN_Msk = 0x10 // Compare 0 Enable
	TCA_SINGLE_CTRLB_CMP1EN     = 0x20 // Compare 1 Enable
	TCA_SINGLE_CTRLB_CMP1EN_Msk = 0x20 // Compare 1 Enable
	TCA_SINGLE_CTRLB_CMP2EN     = 0x40 // Compare 2 Enable
	TCA_SINGLE_CTRLB_CMP2EN_Msk = 0x40 // Compare 2 Enable
	TCA_SINGLE_CTRLB_WGMODE0    = 0x1  // Waveform generation mode
	TCA_SINGLE_CTRLB_WGMODE1    = 0x2  // Waveform generation mode
	TCA_SINGLE_CTRLB_WGMODE2    = 0x4  // Waveform generation mode
	TCA_SINGLE_CTRLB_WGMODE_Msk = 0x7  // Waveform generation mode

	// CTRLC: Control C
	TCA_SINGLE_CTRLC_CMP0OV     = 0x1 // Compare 0 Waveform Output Value
	TCA_SINGLE_CTRLC_CMP0OV_Msk = 0x1 // Compare 0 Waveform Output Value
	TCA_SINGLE_CTRLC_CMP1OV     = 0x2 // Compare 1 Waveform Output Value
	TCA_SINGLE_CTRLC_CMP1OV_Msk = 0x2 // Compare 1 Waveform Output Value
	TCA_SINGLE_CTRLC_CMP2OV     = 0x4 // Compare 2 Waveform Output Value
	TCA_SINGLE_CTRLC_CMP2OV_Msk = 0x4 // Compare 2 Waveform Output Value

	// CTRLD: Control D
	TCA_SINGLE_CTRLD_SPLITM     = 0x1 // Split Mode Enable
	TCA_SINGLE_CTRLD_SPLITM_Msk = 0x1 // Split Mode Enable

	// CTRLECLR: Control E Clear
	TCA_SINGLE_CTRLECLR_CMD0     = 0x4 // Command
	TCA_SINGLE_CTRLECLR_CMD1     = 0x8 // Command
	TCA_SINGLE_CTRLECLR_CMD_Msk  = 0xc // Command
	TCA_SINGLE_CTRLECLR_DIR      = 0x1 // Direction
	TCA_SINGLE_CTRLECLR_DIR_Msk  = 0x1 // Direction
	TCA_SINGLE_CTRLECLR_LUPD     = 0x2 // Lock Update
	TCA_SINGLE_CTRLECLR_LUPD_Msk = 0x2 // Lock Update

	// CTRLESET: Control E Set
	TCA_SINGLE_CTRLESET_CMD0     = 0x4 // Command
	TCA_SINGLE_CTRLESET_CMD1     = 0x8 // Command
	TCA_SINGLE_CTRLESET_CMD_Msk  = 0xc // Command
	TCA_SINGLE_CTRLESET_DIR      = 0x1 // Direction
	TCA_SINGLE_CTRLESET_DIR_Msk  = 0x1 // Direction
	TCA_SINGLE_CTRLESET_LUPD     = 0x2 // Lock Update
	TCA_SINGLE_CTRLESET_LUPD_Msk = 0x2 // Lock Update

	// CTRLFCLR: Control F Clear
	TCA_SINGLE_CTRLFCLR_CMP0BV     = 0x2 // Compare 0 Buffer Valid
	TCA_SINGLE_CTRLFCLR_CMP0BV_Msk = 0x2 // Compare 0 Buffer Valid
	TCA_SINGLE_CTRLFCLR_CMP1BV     = 0x4 // Compare 1 Buffer Valid
	TCA_SINGLE_CTRLFCLR_CMP1BV_Msk = 0x4 // Compare 1 Buffer Valid
	TCA_SINGLE_CTRLFCLR_CMP2BV     = 0x8 // Compare 2 Buffer Valid
	TCA_SINGLE_CTRLFCLR_CMP2BV_Msk = 0x8 // Compare 2 Buffer Valid
	TCA_SINGLE_CTRLFCLR_PERBV      = 0x1 // Period Buffer Valid
	TCA_SINGLE_CTRLFCLR_PERBV_Msk  = 0x1 // Period Buffer Valid

	// CTRLFSET: Control F Set
	TCA_SINGLE_CTRLFSET_CMP0BV     = 0x2 // Compare 0 Buffer Valid
	TCA_SINGLE_CTRLFSET_CMP0BV_Msk = 0x2 // Compare 0 Buffer Valid
	TCA_SINGLE_CTRLFSET_CMP1BV     = 0x4 // Compare 1 Buffer Valid
	TCA_SINGLE_CTRLFSET_CMP1BV_Msk = 0x4 // Compare 1 Buffer Valid
	TCA_SINGLE_CTRLFSET_CMP2BV     = 0x8 // Compare 2 Buffer Valid
	TCA_SINGLE_CTRLFSET_CMP2BV_Msk = 0x8 // Compare 2 Buffer Valid
	TCA_SINGLE_CTRLFSET_PERBV      = 0x1 // Period Buffer Valid
	TCA_SINGLE_CTRLFSET_PERBV_Msk  = 0x1 // Period Buffer Valid

	// EVCTRL: Event Control
	TCA_SINGLE_EVCTRL_CNTEI     = 0x1 // Count on Event Input
	TCA_SINGLE_EVCTRL_CNTEI_Msk = 0x1 // Count on Event Input
	TCA_SINGLE_EVCTRL_EVACT0    = 0x2 // Event Action
	TCA_SINGLE_EVCTRL_EVACT1    = 0x4 // Event Action
	TCA_SINGLE_EVCTRL_EVACT_Msk = 0x6 // Event Action

	// INTCTRL: Interrupt Control
	TCA_SINGLE_INTCTRL_CMP0     = 0x10 // Compare 0 Interrupt
	TCA_SINGLE_INTCTRL_CMP0_Msk = 0x10 // Compare 0 Interrupt
	TCA_SINGLE_INTCTRL_CMP1     = 0x20 // Compare 1 Interrupt
	TCA_SINGLE_INTCTRL_CMP1_Msk = 0x20 // Compare 1 Interrupt
	TCA_SINGLE_INTCTRL_CMP2     = 0x40 // Compare 2 Interrupt
	TCA_SINGLE_INTCTRL_CMP2_Msk = 0x40 // Compare 2 Interrupt
	TCA_SINGLE_INTCTRL_OVF      = 0x1  // Overflow Interrupt
	TCA_SINGLE_INTCTRL_OVF_Msk  = 0x1  // Overflow Interrupt

	// INTFLAGS: Interrupt Flags
	TCA_SINGLE_INTFLAGS_CMP0     = 0x10 // Compare 0 Interrupt
	TCA_SINGLE_INTFLAGS_CMP0_Msk = 0x10 // Compare 0 Interrupt
	TCA_SINGLE_INTFLAGS_CMP1     = 0x20 // Compare 1 Interrupt
	TCA_SINGLE_INTFLAGS_CMP1_Msk = 0x20 // Compare 1 Interrupt
	TCA_SINGLE_INTFLAGS_CMP2     = 0x40 // Compare 2 Interrupt
	TCA_SINGLE_INTFLAGS_CMP2_Msk = 0x40 // Compare 2 Interrupt
	TCA_SINGLE_INTFLAGS_OVF      = 0x1  // Overflow Interrupt
	TCA_SINGLE_INTFLAGS_OVF_Msk  = 0x1  // Overflow Interrupt

	// DBGCTRL: Degbug Control
	TCA_SINGLE_DBGCTRL_DBGRUN     = 0x1 // Debug Run
	TCA_SINGLE_DBGCTRL_DBGRUN_Msk = 0x1 // Debug Run
)

// Bitfields for TCA_SPLIT: 16-bit Timer/Counter Type A - Split Mode
const (
	// CTRLA: Control A
	TCA_SPLIT_CTRLA_CLKSEL0    = 0x2 // Clock Selection
	TCA_SPLIT_CTRLA_CLKSEL1    = 0x4 // Clock Selection
	TCA_SPLIT_CTRLA_CLKSEL2    = 0x8 // Clock Selection
	TCA_SPLIT_CTRLA_CLKSEL_Msk = 0xe // Clock Selection
	TCA_SPLIT_CTRLA_ENABLE     = 0x1 // Module Enable
	TCA_SPLIT_CTRLA_ENABLE_Msk = 0x1 // Module Enable

	// CTRLB: Control B
	TCA_SPLIT_CTRLB_HCMP0EN     = 0x10 // High Compare 0 Enable
	TCA_SPLIT_CTRLB_HCMP0EN_Msk = 0x10 // High Compare 0 Enable
	TCA_SPLIT_CTRLB_HCMP1EN     = 0x20 // High Compare 1 Enable
	TCA_SPLIT_CTRLB_HCMP1EN_Msk = 0x20 // High Compare 1 Enable
	TCA_SPLIT_CTRLB_HCMP2EN     = 0x40 // High Compare 2 Enable
	TCA_SPLIT_CTRLB_HCMP2EN_Msk = 0x40 // High Compare 2 Enable
	TCA_SPLIT_CTRLB_LCMP0EN     = 0x1  // Low Compare 0 Enable
	TCA_SPLIT_CTRLB_LCMP0EN_Msk = 0x1  // Low Compare 0 Enable
	TCA_SPLIT_CTRLB_LCMP1EN     = 0x2  // Low Compare 1 Enable
	TCA_SPLIT_CTRLB_LCMP1EN_Msk = 0x2  // Low Compare 1 Enable
	TCA_SPLIT_CTRLB_LCMP2EN     = 0x4  // Low Compare 2 Enable
	TCA_SPLIT_CTRLB_LCMP2EN_Msk = 0x4  // Low Compare 2 Enable

	// CTRLC: Control C
	TCA_SPLIT_CTRLC_HCMP0OV     = 0x10 // High Compare 0 Output Value
	TCA_SPLIT_CTRLC_HCMP0OV_Msk = 0x10 // High Compare 0 Output Value
	TCA_SPLIT_CTRLC_HCMP1OV     = 0x20 // High Compare 1 Output Value
	TCA_SPLIT_CTRLC_HCMP1OV_Msk = 0x20 // High Compare 1 Output Value
	TCA_SPLIT_CTRLC_HCMP2OV     = 0x40 // High Compare 2 Output Value
	TCA_SPLIT_CTRLC_HCMP2OV_Msk = 0x40 // High Compare 2 Output Value
	TCA_SPLIT_CTRLC_LCMP0OV     = 0x1  // Low Compare 0 Output Value
	TCA_SPLIT_CTRLC_LCMP0OV_Msk = 0x1  // Low Compare 0 Output Value
	TCA_SPLIT_CTRLC_LCMP1OV     = 0x2  // Low Compare 1 Output Value
	TCA_SPLIT_CTRLC_LCMP1OV_Msk = 0x2  // Low Compare 1 Output Value
	TCA_SPLIT_CTRLC_LCMP2OV     = 0x4  // Low Compare 2 Output Value
	TCA_SPLIT_CTRLC_LCMP2OV_Msk = 0x4  // Low Compare 2 Output Value

	// CTRLD: Control D
	TCA_SPLIT_CTRLD_SPLITM     = 0x1 // Split Mode Enable
	TCA_SPLIT_CTRLD_SPLITM_Msk = 0x1 // Split Mode Enable

	// CTRLECLR: Control E Clear
	TCA_SPLIT_CTRLECLR_CMD0    = 0x4 // Command
	TCA_SPLIT_CTRLECLR_CMD1    = 0x8 // Command
	TCA_SPLIT_CTRLECLR_CMD_Msk = 0xc // Command

	// CTRLESET: Control E Set
	TCA_SPLIT_CTRLESET_CMD0    = 0x4 // Command
	TCA_SPLIT_CTRLESET_CMD1    = 0x8 // Command
	TCA_SPLIT_CTRLESET_CMD_Msk = 0xc // Command

	// INTCTRL: Interrupt Control
	TCA_SPLIT_INTCTRL_HUNF      = 0x2  // High Underflow Interrupt Enable
	TCA_SPLIT_INTCTRL_HUNF_Msk  = 0x2  // High Underflow Interrupt Enable
	TCA_SPLIT_INTCTRL_LCMP0     = 0x10 // Low Compare 0 Interrupt Enable
	TCA_SPLIT_INTCTRL_LCMP0_Msk = 0x10 // Low Compare 0 Interrupt Enable
	TCA_SPLIT_INTCTRL_LCMP1     = 0x20 // Low Compare 1 Interrupt Enable
	TCA_SPLIT_INTCTRL_LCMP1_Msk = 0x20 // Low Compare 1 Interrupt Enable
	TCA_SPLIT_INTCTRL_LCMP2     = 0x40 // Low Compare 2 Interrupt Enable
	TCA_SPLIT_INTCTRL_LCMP2_Msk = 0x40 // Low Compare 2 Interrupt Enable
	TCA_SPLIT_INTCTRL_LUNF      = 0x1  // Low Underflow Interrupt Enable
	TCA_SPLIT_INTCTRL_LUNF_Msk  = 0x1  // Low Underflow Interrupt Enable

	// INTFLAGS: Interrupt Flags
	TCA_SPLIT_INTFLAGS_HUNF      = 0x2  // High Underflow Interrupt Flag
	TCA_SPLIT_INTFLAGS_HUNF_Msk  = 0x2  // High Underflow Interrupt Flag
	TCA_SPLIT_INTFLAGS_LCMP0     = 0x10 // Low Compare 2 Interrupt Flag
	TCA_SPLIT_INTFLAGS_LCMP0_Msk = 0x10 // Low Compare 2 Interrupt Flag
	TCA_SPLIT_INTFLAGS_LCMP1     = 0x20 // Low Compare 1 Interrupt Flag
	TCA_SPLIT_INTFLAGS_LCMP1_Msk = 0x20 // Low Compare 1 Interrupt Flag
	TCA_SPLIT_INTFLAGS_LCMP2     = 0x40 // Low Compare 0 Interrupt Flag
	TCA_SPLIT_INTFLAGS_LCMP2_Msk = 0x40 // Low Compare 0 Interrupt Flag
	TCA_SPLIT_INTFLAGS_LUNF      = 0x1  // Low Underflow Interrupt Flag
	TCA_SPLIT_INTFLAGS_LUNF_Msk  = 0x1  // Low Underflow Interrupt Flag

	// DBGCTRL: Degbug Control
	TCA_SPLIT_DBGCTRL_DBGRUN     = 0x1 // Debug Run
	TCA_SPLIT_DBGCTRL_DBGRUN_Msk = 0x1 // Debug Run
)

// Bitfields for TCB: 16-bit Timer Type B
const (
	// CTRLA: Control A
	TCB_CTRLA_CLKSEL0      = 0x2  // Clock Select
	TCB_CTRLA_CLKSEL1      = 0x4  // Clock Select
	TCB_CTRLA_CLKSEL_Msk   = 0x6  // Clock Select
	TCB_CTRLA_ENABLE       = 0x1  // Enable
	TCB_CTRLA_ENABLE_Msk   = 0x1  // Enable
	TCB_CTRLA_RUNSTDBY     = 0x40 // Run Standby
	TCB_CTRLA_RUNSTDBY_Msk = 0x40 // Run Standby
	TCB_CTRLA_SYNCUPD      = 0x10 // Synchronize Update
	TCB_CTRLA_SYNCUPD_Msk  = 0x10 // Synchronize Update

	// CTRLB: Control Register B
	TCB_CTRLB_ASYNC        = 0x40 // Asynchronous Enable
	TCB_CTRLB_ASYNC_Msk    = 0x40 // Asynchronous Enable
	TCB_CTRLB_CCMPEN       = 0x10 // Pin Output Enable
	TCB_CTRLB_CCMPEN_Msk   = 0x10 // Pin Output Enable
	TCB_CTRLB_CCMPINIT     = 0x20 // Pin Initial State
	TCB_CTRLB_CCMPINIT_Msk = 0x20 // Pin Initial State
	TCB_CTRLB_CNTMODE0     = 0x1  // Timer Mode
	TCB_CTRLB_CNTMODE1     = 0x2  // Timer Mode
	TCB_CTRLB_CNTMODE2     = 0x4  // Timer Mode
	TCB_CTRLB_CNTMODE_Msk  = 0x7  // Timer Mode

	// EVCTRL: Event Control
	TCB_EVCTRL_CAPTEI     = 0x1  // Event Input Enable
	TCB_EVCTRL_CAPTEI_Msk = 0x1  // Event Input Enable
	TCB_EVCTRL_EDGE       = 0x10 // Event Edge
	TCB_EVCTRL_EDGE_Msk   = 0x10 // Event Edge
	TCB_EVCTRL_FILTER     = 0x40 // Input Capture Noise Cancellation Filter
	TCB_EVCTRL_FILTER_Msk = 0x40 // Input Capture Noise Cancellation Filter

	// INTCTRL: Interrupt Control
	TCB_INTCTRL_CAPT     = 0x1 // Capture or Timeout
	TCB_INTCTRL_CAPT_Msk = 0x1 // Capture or Timeout

	// INTFLAGS: Interrupt Flags
	TCB_INTFLAGS_CAPT     = 0x1 // Capture or Timeout
	TCB_INTFLAGS_CAPT_Msk = 0x1 // Capture or Timeout

	// STATUS: Status
	TCB_STATUS_RUN     = 0x1 // Run
	TCB_STATUS_RUN_Msk = 0x1 // Run

	// DBGCTRL: Debug Control
	TCB_DBGCTRL_DBGRUN     = 0x1 // Debug Run
	TCB_DBGCTRL_DBGRUN_Msk = 0x1 // Debug Run
)

// Bitfields for TCD: Timer Counter D
const (
	// CTRLA: Control A
	TCD_CTRLA_CLKSEL0      = 0x20 // clock select
	TCD_CTRLA_CLKSEL1      = 0x40 // clock select
	TCD_CTRLA_CLKSEL_Msk   = 0x60 // clock select
	TCD_CTRLA_CNTPRES0     = 0x8  // counter prescaler
	TCD_CTRLA_CNTPRES1     = 0x10 // counter prescaler
	TCD_CTRLA_CNTPRES_Msk  = 0x18 // counter prescaler
	TCD_CTRLA_ENABLE       = 0x1  // Enable
	TCD_CTRLA_ENABLE_Msk   = 0x1  // Enable
	TCD_CTRLA_SYNCPRES0    = 0x2  // Syncronization prescaler
	TCD_CTRLA_SYNCPRES1    = 0x4  // Syncronization prescaler
	TCD_CTRLA_SYNCPRES_Msk = 0x6  // Syncronization prescaler

	// CTRLB: Control B
	TCD_CTRLB_WGMODE0    = 0x1 // Waveform generation mode
	TCD_CTRLB_WGMODE1    = 0x2 // Waveform generation mode
	TCD_CTRLB_WGMODE_Msk = 0x3 // Waveform generation mode

	// CTRLC: Control C
	TCD_CTRLC_AUPDATE     = 0x2  // Auto update
	TCD_CTRLC_AUPDATE_Msk = 0x2  // Auto update
	TCD_CTRLC_CMPCSEL     = 0x40 // Compare C output select
	TCD_CTRLC_CMPCSEL_Msk = 0x40 // Compare C output select
	TCD_CTRLC_CMPDSEL     = 0x80 // Compare D output select
	TCD_CTRLC_CMPDSEL_Msk = 0x80 // Compare D output select
	TCD_CTRLC_CMPOVR      = 0x1  // Compare output value override
	TCD_CTRLC_CMPOVR_Msk  = 0x1  // Compare output value override
	TCD_CTRLC_FIFTY       = 0x8  // Fifty percent waveform
	TCD_CTRLC_FIFTY_Msk   = 0x8  // Fifty percent waveform

	// CTRLD: Control D
	TCD_CTRLD_CMPAVAL0    = 0x1  // Compare A value
	TCD_CTRLD_CMPAVAL1    = 0x2  // Compare A value
	TCD_CTRLD_CMPAVAL2    = 0x4  // Compare A value
	TCD_CTRLD_CMPAVAL3    = 0x8  // Compare A value
	TCD_CTRLD_CMPAVAL_Msk = 0xf  // Compare A value
	TCD_CTRLD_CMPBVAL0    = 0x10 // Compare B value
	TCD_CTRLD_CMPBVAL1    = 0x20 // Compare B value
	TCD_CTRLD_CMPBVAL2    = 0x40 // Compare B value
	TCD_CTRLD_CMPBVAL3    = 0x80 // Compare B value
	TCD_CTRLD_CMPBVAL_Msk = 0xf0 // Compare B value

	// CTRLE: Control E
	TCD_CTRLE_DISEOC        = 0x80 // Disable at end of cycle
	TCD_CTRLE_DISEOC_Msk    = 0x80 // Disable at end of cycle
	TCD_CTRLE_RESTART       = 0x4  // Restart strobe
	TCD_CTRLE_RESTART_Msk   = 0x4  // Restart strobe
	TCD_CTRLE_SCAPTUREA     = 0x8  // Software Capture A Strobe
	TCD_CTRLE_SCAPTUREA_Msk = 0x8  // Software Capture A Strobe
	TCD_CTRLE_SCAPTUREB     = 0x10 // Software Capture B Strobe
	TCD_CTRLE_SCAPTUREB_Msk = 0x10 // Software Capture B Strobe
	TCD_CTRLE_SYNC          = 0x2  // synchronize strobe
	TCD_CTRLE_SYNC_Msk      = 0x2  // synchronize strobe
	TCD_CTRLE_SYNCEOC       = 0x1  // synchronize end of cycle strobe
	TCD_CTRLE_SYNCEOC_Msk   = 0x1  // synchronize end of cycle strobe

	// EVCTRLA: EVCTRLA
	TCD_EVCTRLA_ACTION     = 0x4  // event action
	TCD_EVCTRLA_ACTION_Msk = 0x4  // event action
	TCD_EVCTRLA_CFG0       = 0x40 // event config
	TCD_EVCTRLA_CFG1       = 0x80 // event config
	TCD_EVCTRLA_CFG_Msk    = 0xc0 // event config
	TCD_EVCTRLA_EDGE       = 0x10 // edge select
	TCD_EVCTRLA_EDGE_Msk   = 0x10 // edge select
	TCD_EVCTRLA_TRIGEI     = 0x1  // Trigger event enable
	TCD_EVCTRLA_TRIGEI_Msk = 0x1  // Trigger event enable

	// EVCTRLB: EVCTRLB
	TCD_EVCTRLB_ACTION     = 0x4  // event action
	TCD_EVCTRLB_ACTION_Msk = 0x4  // event action
	TCD_EVCTRLB_CFG0       = 0x40 // event config
	TCD_EVCTRLB_CFG1       = 0x80 // event config
	TCD_EVCTRLB_CFG_Msk    = 0xc0 // event config
	TCD_EVCTRLB_EDGE       = 0x10 // edge select
	TCD_EVCTRLB_EDGE_Msk   = 0x10 // edge select
	TCD_EVCTRLB_TRIGEI     = 0x1  // Trigger event enable
	TCD_EVCTRLB_TRIGEI_Msk = 0x1  // Trigger event enable

	// INTCTRL: Interrupt Control
	TCD_INTCTRL_OVF       = 0x1 // Overflow interrupt enable
	TCD_INTCTRL_OVF_Msk   = 0x1 // Overflow interrupt enable
	TCD_INTCTRL_TRIGA     = 0x4 // Trigger A interrupt enable
	TCD_INTCTRL_TRIGA_Msk = 0x4 // Trigger A interrupt enable
	TCD_INTCTRL_TRIGB     = 0x8 // Trigger B interrupt enable
	TCD_INTCTRL_TRIGB_Msk = 0x8 // Trigger B interrupt enable

	// INTFLAGS: Interrupt Flags
	TCD_INTFLAGS_OVF       = 0x1 // Overflow interrupt enable
	TCD_INTFLAGS_OVF_Msk   = 0x1 // Overflow interrupt enable
	TCD_INTFLAGS_TRIGA     = 0x4 // Trigger A interrupt enable
	TCD_INTFLAGS_TRIGA_Msk = 0x4 // Trigger A interrupt enable
	TCD_INTFLAGS_TRIGB     = 0x8 // Trigger B interrupt enable
	TCD_INTFLAGS_TRIGB_Msk = 0x8 // Trigger B interrupt enable

	// STATUS: Status
	TCD_STATUS_CMDRDY      = 0x2  // Command ready
	TCD_STATUS_CMDRDY_Msk  = 0x2  // Command ready
	TCD_STATUS_ENRDY       = 0x1  // Enable ready
	TCD_STATUS_ENRDY_Msk   = 0x1  // Enable ready
	TCD_STATUS_PWMACTA     = 0x40 // PWM activity on A
	TCD_STATUS_PWMACTA_Msk = 0x40 // PWM activity on A
	TCD_STATUS_PWMACTB     = 0x80 // PWM activity on B
	TCD_STATUS_PWMACTB_Msk = 0x80 // PWM activity on B

	// INPUTCTRLA: Input Control A
	TCD_INPUTCTRLA_INPUTMODE0    = 0x1 // Input mode
	TCD_INPUTCTRLA_INPUTMODE1    = 0x2 // Input mode
	TCD_INPUTCTRLA_INPUTMODE2    = 0x4 // Input mode
	TCD_INPUTCTRLA_INPUTMODE3    = 0x8 // Input mode
	TCD_INPUTCTRLA_INPUTMODE_Msk = 0xf // Input mode

	// INPUTCTRLB: Input Control B
	TCD_INPUTCTRLB_INPUTMODE0    = 0x1 // Input mode
	TCD_INPUTCTRLB_INPUTMODE1    = 0x2 // Input mode
	TCD_INPUTCTRLB_INPUTMODE2    = 0x4 // Input mode
	TCD_INPUTCTRLB_INPUTMODE3    = 0x8 // Input mode
	TCD_INPUTCTRLB_INPUTMODE_Msk = 0xf // Input mode

	// FAULTCTRL: Fault Control
	TCD_FAULTCTRL_CMPA       = 0x1  // Compare A value
	TCD_FAULTCTRL_CMPA_Msk   = 0x1  // Compare A value
	TCD_FAULTCTRL_CMPAEN     = 0x10 // Compare A enable
	TCD_FAULTCTRL_CMPAEN_Msk = 0x10 // Compare A enable
	TCD_FAULTCTRL_CMPB       = 0x2  // Compare B value
	TCD_FAULTCTRL_CMPB_Msk   = 0x2  // Compare B value
	TCD_FAULTCTRL_CMPBEN     = 0x20 // Compare B enable
	TCD_FAULTCTRL_CMPBEN_Msk = 0x20 // Compare B enable
	TCD_FAULTCTRL_CMPC       = 0x4  // Compare C value
	TCD_FAULTCTRL_CMPC_Msk   = 0x4  // Compare C value
	TCD_FAULTCTRL_CMPCEN     = 0x40 // Compare C enable
	TCD_FAULTCTRL_CMPCEN_Msk = 0x40 // Compare C enable
	TCD_FAULTCTRL_CMPD       = 0x8  // Compare D vaule
	TCD_FAULTCTRL_CMPD_Msk   = 0x8  // Compare D vaule
	TCD_FAULTCTRL_CMPDEN     = 0x80 // Compare D enable
	TCD_FAULTCTRL_CMPDEN_Msk = 0x80 // Compare D enable

	// DLYCTRL: Delay Control
	TCD_DLYCTRL_DLYPRESC0    = 0x10 // Delay prescaler
	TCD_DLYCTRL_DLYPRESC1    = 0x20 // Delay prescaler
	TCD_DLYCTRL_DLYPRESC_Msk = 0x30 // Delay prescaler
	TCD_DLYCTRL_DLYSEL0      = 0x1  // Delay select
	TCD_DLYCTRL_DLYSEL1      = 0x2  // Delay select
	TCD_DLYCTRL_DLYSEL_Msk   = 0x3  // Delay select
	TCD_DLYCTRL_DLYTRIG0     = 0x4  // Delay trigger
	TCD_DLYCTRL_DLYTRIG1     = 0x8  // Delay trigger
	TCD_DLYCTRL_DLYTRIG_Msk  = 0xc  // Delay trigger

	// DLYVAL: Delay value
	TCD_DLYVAL_DLYVAL0    = 0x1  // Delay value
	TCD_DLYVAL_DLYVAL1    = 0x2  // Delay value
	TCD_DLYVAL_DLYVAL2    = 0x4  // Delay value
	TCD_DLYVAL_DLYVAL3    = 0x8  // Delay value
	TCD_DLYVAL_DLYVAL4    = 0x10 // Delay value
	TCD_DLYVAL_DLYVAL5    = 0x20 // Delay value
	TCD_DLYVAL_DLYVAL6    = 0x40 // Delay value
	TCD_DLYVAL_DLYVAL7    = 0x80 // Delay value
	TCD_DLYVAL_DLYVAL_Msk = 0xff // Delay value

	// DITCTRL: Dither Control A
	TCD_DITCTRL_DITHERSEL0    = 0x1 // dither select
	TCD_DITCTRL_DITHERSEL1    = 0x2 // dither select
	TCD_DITCTRL_DITHERSEL_Msk = 0x3 // dither select

	// DITVAL: Dither value
	TCD_DITVAL_DITHER0    = 0x1 // Dither value
	TCD_DITVAL_DITHER1    = 0x2 // Dither value
	TCD_DITVAL_DITHER2    = 0x4 // Dither value
	TCD_DITVAL_DITHER3    = 0x8 // Dither value
	TCD_DITVAL_DITHER_Msk = 0xf // Dither value

	// DBGCTRL: Debug Control
	TCD_DBGCTRL_DBGRUN       = 0x1 // Debug run
	TCD_DBGCTRL_DBGRUN_Msk   = 0x1 // Debug run
	TCD_DBGCTRL_FAULTDET     = 0x4 // Fault detection
	TCD_DBGCTRL_FAULTDET_Msk = 0x4 // Fault detection
)

// Bitfields for TWI: Two-Wire Interface
const (
	// CTRLA: Control A
	TWI_CTRLA_FMPEN        = 0x2  // FM Plus Enable
	TWI_CTRLA_FMPEN_Msk    = 0x2  // FM Plus Enable
	TWI_CTRLA_SDAHOLD0     = 0x4  // SDA Hold Time
	TWI_CTRLA_SDAHOLD1     = 0x8  // SDA Hold Time
	TWI_CTRLA_SDAHOLD_Msk  = 0xc  // SDA Hold Time
	TWI_CTRLA_SDASETUP     = 0x10 // SDA Setup Time
	TWI_CTRLA_SDASETUP_Msk = 0x10 // SDA Setup Time

	// DBGCTRL: Debug Control Register
	TWI_DBGCTRL_DBGRUN     = 0x1 // Debug Run
	TWI_DBGCTRL_DBGRUN_Msk = 0x1 // Debug Run

	// MCTRLA: Master Control A
	TWI_MCTRLA_ENABLE      = 0x1  // Enable TWI Master
	TWI_MCTRLA_ENABLE_Msk  = 0x1  // Enable TWI Master
	TWI_MCTRLA_QCEN        = 0x10 // Quick Command Enable
	TWI_MCTRLA_QCEN_Msk    = 0x10 // Quick Command Enable
	TWI_MCTRLA_RIEN        = 0x80 // Read Interrupt Enable
	TWI_MCTRLA_RIEN_Msk    = 0x80 // Read Interrupt Enable
	TWI_MCTRLA_SMEN        = 0x2  // Smart Mode Enable
	TWI_MCTRLA_SMEN_Msk    = 0x2  // Smart Mode Enable
	TWI_MCTRLA_TIMEOUT0    = 0x4  // Inactive Bus Timeout
	TWI_MCTRLA_TIMEOUT1    = 0x8  // Inactive Bus Timeout
	TWI_MCTRLA_TIMEOUT_Msk = 0xc  // Inactive Bus Timeout
	TWI_MCTRLA_WIEN        = 0x40 // Write Interrupt Enable
	TWI_MCTRLA_WIEN_Msk    = 0x40 // Write Interrupt Enable

	// MCTRLB: Master Control B
	TWI_MCTRLB_ACKACT     = 0x4 // Acknowledge Action
	TWI_MCTRLB_ACKACT_Msk = 0x4 // Acknowledge Action
	TWI_MCTRLB_FLUSH      = 0x8 // Flush
	TWI_MCTRLB_FLUSH_Msk  = 0x8 // Flush
	TWI_MCTRLB_MCMD0      = 0x1 // Command
	TWI_MCTRLB_MCMD1      = 0x2 // Command
	TWI_MCTRLB_MCMD_Msk   = 0x3 // Command

	// MSTATUS: Master Status
	TWI_MSTATUS_ARBLOST      = 0x8  // Arbitration Lost
	TWI_MSTATUS_ARBLOST_Msk  = 0x8  // Arbitration Lost
	TWI_MSTATUS_BUSERR       = 0x4  // Bus Error
	TWI_MSTATUS_BUSERR_Msk   = 0x4  // Bus Error
	TWI_MSTATUS_BUSSTATE0    = 0x1  // Bus State
	TWI_MSTATUS_BUSSTATE1    = 0x2  // Bus State
	TWI_MSTATUS_BUSSTATE_Msk = 0x3  // Bus State
	TWI_MSTATUS_CLKHOLD      = 0x20 // Clock Hold
	TWI_MSTATUS_CLKHOLD_Msk  = 0x20 // Clock Hold
	TWI_MSTATUS_RIF          = 0x80 // Read Interrupt Flag
	TWI_MSTATUS_RIF_Msk      = 0x80 // Read Interrupt Flag
	TWI_MSTATUS_RXACK        = 0x10 // Received Acknowledge
	TWI_MSTATUS_RXACK_Msk    = 0x10 // Received Acknowledge
	TWI_MSTATUS_WIF          = 0x40 // Write Interrupt Flag
	TWI_MSTATUS_WIF_Msk      = 0x40 // Write Interrupt Flag

	// SCTRLA: Slave Control A
	TWI_SCTRLA_APIEN      = 0x40 // Address/Stop Interrupt Enable
	TWI_SCTRLA_APIEN_Msk  = 0x40 // Address/Stop Interrupt Enable
	TWI_SCTRLA_DIEN       = 0x80 // Data Interrupt Enable
	TWI_SCTRLA_DIEN_Msk   = 0x80 // Data Interrupt Enable
	TWI_SCTRLA_ENABLE     = 0x1  // Enable TWI Slave
	TWI_SCTRLA_ENABLE_Msk = 0x1  // Enable TWI Slave
	TWI_SCTRLA_PIEN       = 0x20 // Stop Interrupt Enable
	TWI_SCTRLA_PIEN_Msk   = 0x20 // Stop Interrupt Enable
	TWI_SCTRLA_PMEN       = 0x4  // Promiscuous Mode Enable
	TWI_SCTRLA_PMEN_Msk   = 0x4  // Promiscuous Mode Enable
	TWI_SCTRLA_SMEN       = 0x2  // Smart Mode Enable
	TWI_SCTRLA_SMEN_Msk   = 0x2  // Smart Mode Enable

	// SCTRLB: Slave Control B
	TWI_SCTRLB_ACKACT     = 0x4 // Acknowledge Action
	TWI_SCTRLB_ACKACT_Msk = 0x4 // Acknowledge Action
	TWI_SCTRLB_SCMD0      = 0x1 // Command
	TWI_SCTRLB_SCMD1      = 0x2 // Command
	TWI_SCTRLB_SCMD_Msk   = 0x3 // Command

	// SSTATUS: Slave Status
	TWI_SSTATUS_AP          = 0x1  // Slave Address or Stop
	TWI_SSTATUS_AP_Msk      = 0x1  // Slave Address or Stop
	TWI_SSTATUS_APIF        = 0x40 // Address/Stop Interrupt Flag
	TWI_SSTATUS_APIF_Msk    = 0x40 // Address/Stop Interrupt Flag
	TWI_SSTATUS_BUSERR      = 0x4  // Bus Error
	TWI_SSTATUS_BUSERR_Msk  = 0x4  // Bus Error
	TWI_SSTATUS_CLKHOLD     = 0x20 // Clock Hold
	TWI_SSTATUS_CLKHOLD_Msk = 0x20 // Clock Hold
	TWI_SSTATUS_COLL        = 0x8  // Collision
	TWI_SSTATUS_COLL_Msk    = 0x8  // Collision
	TWI_SSTATUS_DIF         = 0x80 // Data Interrupt Flag
	TWI_SSTATUS_DIF_Msk     = 0x80 // Data Interrupt Flag
	TWI_SSTATUS_DIR         = 0x2  // Read/Write Direction
	TWI_SSTATUS_DIR_Msk     = 0x2  // Read/Write Direction
	TWI_SSTATUS_RXACK       = 0x10 // Received Acknowledge
	TWI_SSTATUS_RXACK_Msk   = 0x10 // Received Acknowledge

	// SADDRMASK: Slave Address Mask
	TWI_SADDRMASK_ADDREN       = 0x1  // Address Enable
	TWI_SADDRMASK_ADDREN_Msk   = 0x1  // Address Enable
	TWI_SADDRMASK_ADDRMASK0    = 0x2  // Address Mask
	TWI_SADDRMASK_ADDRMASK1    = 0x4  // Address Mask
	TWI_SADDRMASK_ADDRMASK2    = 0x8  // Address Mask
	TWI_SADDRMASK_ADDRMASK3    = 0x10 // Address Mask
	TWI_SADDRMASK_ADDRMASK4    = 0x20 // Address Mask
	TWI_SADDRMASK_ADDRMASK5    = 0x40 // Address Mask
	TWI_SADDRMASK_ADDRMASK6    = 0x80 // Address Mask
	TWI_SADDRMASK_ADDRMASK_Msk = 0xfe // Address Mask
)

// Bitfields for USART: Universal Synchronous and Asynchronous Receiver and Transmitter
const (
	// RXDATAL: Receive Data Low Byte
	USART_RXDATAL_DATA0    = 0x1  // RX Data
	USART_RXDATAL_DATA1    = 0x2  // RX Data
	USART_RXDATAL_DATA2    = 0x4  // RX Data
	USART_RXDATAL_DATA3    = 0x8  // RX Data
	USART_RXDATAL_DATA4    = 0x10 // RX Data
	USART_RXDATAL_DATA5    = 0x20 // RX Data
	USART_RXDATAL_DATA6    = 0x40 // RX Data
	USART_RXDATAL_DATA7    = 0x80 // RX Data
	USART_RXDATAL_DATA_Msk = 0xff // RX Data

	// RXDATAH: Receive Data High Byte
	USART_RXDATAH_BUFOVF     = 0x40 // Buffer Overflow
	USART_RXDATAH_BUFOVF_Msk = 0x40 // Buffer Overflow
	USART_RXDATAH_DATA8      = 0x1  // Receiver Data Register
	USART_RXDATAH_DATA8_Msk  = 0x1  // Receiver Data Register
	USART_RXDATAH_FERR       = 0x4  // Frame Error
	USART_RXDATAH_FERR_Msk   = 0x4  // Frame Error
	USART_RXDATAH_PERR       = 0x2  // Parity Error
	USART_RXDATAH_PERR_Msk   = 0x2  // Parity Error
	USART_RXDATAH_RXCIF      = 0x80 // Receive Complete Interrupt Flag
	USART_RXDATAH_RXCIF_Msk  = 0x80 // Receive Complete Interrupt Flag

	// TXDATAL: Transmit Data Low Byte
	USART_TXDATAL_DATA0    = 0x1  // Transmit Data Register
	USART_TXDATAL_DATA1    = 0x2  // Transmit Data Register
	USART_TXDATAL_DATA2    = 0x4  // Transmit Data Register
	USART_TXDATAL_DATA3    = 0x8  // Transmit Data Register
	USART_TXDATAL_DATA4    = 0x10 // Transmit Data Register
	USART_TXDATAL_DATA5    = 0x20 // Transmit Data Register
	USART_TXDATAL_DATA6    = 0x40 // Transmit Data Register
	USART_TXDATAL_DATA7    = 0x80 // Transmit Data Register
	USART_TXDATAL_DATA_Msk = 0xff // Transmit Data Register

	// TXDATAH: Transmit Data High Byte
	USART_TXDATAH_DATA8     = 0x1 // Transmit Data Register (CHSIZE=9bit)
	USART_TXDATAH_DATA8_Msk = 0x1 // Transmit Data Register (CHSIZE=9bit)

	// STATUS: Status
	USART_STATUS_BDF       = 0x2  // Break Detected Flag
	USART_STATUS_BDF_Msk   = 0x2  // Break Detected Flag
	USART_STATUS_DREIF     = 0x20 // Data Register Empty Flag
	USART_STATUS_DREIF_Msk = 0x20 // Data Register Empty Flag
	USART_STATUS_ISFIF     = 0x8  // Inconsistent Sync Field Interrupt Flag
	USART_STATUS_ISFIF_Msk = 0x8  // Inconsistent Sync Field Interrupt Flag
	USART_STATUS_RXCIF     = 0x80 // Receive Complete Interrupt Flag
	USART_STATUS_RXCIF_Msk = 0x80 // Receive Complete Interrupt Flag
	USART_STATUS_RXSIF     = 0x10 // Receive Start Interrupt
	USART_STATUS_RXSIF_Msk = 0x10 // Receive Start Interrupt
	USART_STATUS_TXCIF     = 0x40 // Transmit Interrupt Flag
	USART_STATUS_TXCIF_Msk = 0x40 // Transmit Interrupt Flag
	USART_STATUS_WFB       = 0x1  // Wait For Break
	USART_STATUS_WFB_Msk   = 0x1  // Wait For Break

	// CTRLA: Control A
	USART_CTRLA_ABEIE     = 0x4  // Auto-baud Error Interrupt Enable
	USART_CTRLA_ABEIE_Msk = 0x4  // Auto-baud Error Interrupt Enable
	USART_CTRLA_DREIE     = 0x20 // Data Register Empty Interrupt Enable
	USART_CTRLA_DREIE_Msk = 0x20 // Data Register Empty Interrupt Enable
	USART_CTRLA_LBME      = 0x8  // Loop-back Mode Enable
	USART_CTRLA_LBME_Msk  = 0x8  // Loop-back Mode Enable
	USART_CTRLA_RS4850    = 0x1  // RS485 Mode internal transmitter
	USART_CTRLA_RS4851    = 0x2  // RS485 Mode internal transmitter
	USART_CTRLA_RS485_Msk = 0x3  // RS485 Mode internal transmitter
	USART_CTRLA_RXCIE     = 0x80 // Receive Complete Interrupt Enable
	USART_CTRLA_RXCIE_Msk = 0x80 // Receive Complete Interrupt Enable
	USART_CTRLA_RXSIE     = 0x10 // Receiver Start Frame Interrupt Enable
	USART_CTRLA_RXSIE_Msk = 0x10 // Receiver Start Frame Interrupt Enable
	USART_CTRLA_TXCIE     = 0x40 // Transmit Complete Interrupt Enable
	USART_CTRLA_TXCIE_Msk = 0x40 // Transmit Complete Interrupt Enable

	// CTRLB: Control B
	USART_CTRLB_MPCM       = 0x1  // Multi-processor Communication Mode
	USART_CTRLB_MPCM_Msk   = 0x1  // Multi-processor Communication Mode
	USART_CTRLB_ODME       = 0x8  // Open Drain Mode Enable
	USART_CTRLB_ODME_Msk   = 0x8  // Open Drain Mode Enable
	USART_CTRLB_RXEN       = 0x80 // Reciever enable
	USART_CTRLB_RXEN_Msk   = 0x80 // Reciever enable
	USART_CTRLB_RXMODE0    = 0x2  // Receiver Mode
	USART_CTRLB_RXMODE1    = 0x4  // Receiver Mode
	USART_CTRLB_RXMODE_Msk = 0x6  // Receiver Mode
	USART_CTRLB_SFDEN      = 0x10 // Start Frame Detection Enable
	USART_CTRLB_SFDEN_Msk  = 0x10 // Start Frame Detection Enable
	USART_CTRLB_TXEN       = 0x40 // Transmitter Enable
	USART_CTRLB_TXEN_Msk   = 0x40 // Transmitter Enable

	// DBGCTRL: Debug Control
	USART_DBGCTRL_ABMBP      = 0x80 // Autobaud majority voter bypass
	USART_DBGCTRL_ABMBP_Msk  = 0x80 // Autobaud majority voter bypass
	USART_DBGCTRL_DBGRUN     = 0x1  // Debug Run
	USART_DBGCTRL_DBGRUN_Msk = 0x1  // Debug Run

	// EVCTRL: Event Control
	USART_EVCTRL_IREI     = 0x1 // IrDA Event Input Enable
	USART_EVCTRL_IREI_Msk = 0x1 // IrDA Event Input Enable

	// TXPLCTRL: IRCOM Transmitter Pulse Length Control
	USART_TXPLCTRL_TXPL0    = 0x1  // Transmit pulse length
	USART_TXPLCTRL_TXPL1    = 0x2  // Transmit pulse length
	USART_TXPLCTRL_TXPL2    = 0x4  // Transmit pulse length
	USART_TXPLCTRL_TXPL3    = 0x8  // Transmit pulse length
	USART_TXPLCTRL_TXPL4    = 0x10 // Transmit pulse length
	USART_TXPLCTRL_TXPL5    = 0x20 // Transmit pulse length
	USART_TXPLCTRL_TXPL6    = 0x40 // Transmit pulse length
	USART_TXPLCTRL_TXPL7    = 0x80 // Transmit pulse length
	USART_TXPLCTRL_TXPL_Msk = 0xff // Transmit pulse length

	// RXPLCTRL: IRCOM Receiver Pulse Length Control
	USART_RXPLCTRL_RXPL0    = 0x1  // Receiver Pulse Lenght
	USART_RXPLCTRL_RXPL1    = 0x2  // Receiver Pulse Lenght
	USART_RXPLCTRL_RXPL2    = 0x4  // Receiver Pulse Lenght
	USART_RXPLCTRL_RXPL3    = 0x8  // Receiver Pulse Lenght
	USART_RXPLCTRL_RXPL4    = 0x10 // Receiver Pulse Lenght
	USART_RXPLCTRL_RXPL5    = 0x20 // Receiver Pulse Lenght
	USART_RXPLCTRL_RXPL6    = 0x40 // Receiver Pulse Lenght
	USART_RXPLCTRL_RXPL_Msk = 0x7f // Receiver Pulse Lenght
)

// Bitfields for VPORT: Virtual Ports
const (
	// INTFLAGS: Interrupt Flags
	VPORT_INTFLAGS_INT0    = 0x1  // Pin Interrupt
	VPORT_INTFLAGS_INT1    = 0x2  // Pin Interrupt
	VPORT_INTFLAGS_INT2    = 0x4  // Pin Interrupt
	VPORT_INTFLAGS_INT3    = 0x8  // Pin Interrupt
	VPORT_INTFLAGS_INT4    = 0x10 // Pin Interrupt
	VPORT_INTFLAGS_INT5    = 0x20 // Pin Interrupt
	VPORT_INTFLAGS_INT6    = 0x40 // Pin Interrupt
	VPORT_INTFLAGS_INT7    = 0x80 // Pin Interrupt
	VPORT_INTFLAGS_INT_Msk = 0xff // Pin Interrupt
)

// Bitfields for VREF: Voltage reference
const (
	// CTRLA: Control A
	VREF_CTRLA_ADC0REFSEL0    = 0x10 // ADC0 reference select
	VREF_CTRLA_ADC0REFSEL1    = 0x20 // ADC0 reference select
	VREF_CTRLA_ADC0REFSEL2    = 0x40 // ADC0 reference select
	VREF_CTRLA_ADC0REFSEL_Msk = 0x70 // ADC0 reference select
	VREF_CTRLA_DAC0REFSEL0    = 0x1  // DAC0/AC0 reference select
	VREF_CTRLA_DAC0REFSEL1    = 0x2  // DAC0/AC0 reference select
	VREF_CTRLA_DAC0REFSEL2    = 0x4  // DAC0/AC0 reference select
	VREF_CTRLA_DAC0REFSEL_Msk = 0x7  // DAC0/AC0 reference select

	// CTRLB: Control B
	VREF_CTRLB_ADC0REFEN     = 0x2 // ADC0 reference enable
	VREF_CTRLB_ADC0REFEN_Msk = 0x2 // ADC0 reference enable
	VREF_CTRLB_DAC0REFEN     = 0x1 // DAC0/AC0 reference enable
	VREF_CTRLB_DAC0REFEN_Msk = 0x1 // DAC0/AC0 reference enable
)

// Bitfields for WDT: Watch-Dog Timer
const (
	// CTRLA: Control A
	WDT_CTRLA_PERIOD0    = 0x1  // Period
	WDT_CTRLA_PERIOD1    = 0x2  // Period
	WDT_CTRLA_PERIOD2    = 0x4  // Period
	WDT_CTRLA_PERIOD3    = 0x8  // Period
	WDT_CTRLA_PERIOD_Msk = 0xf  // Period
	WDT_CTRLA_WINDOW0    = 0x10 // Window
	WDT_CTRLA_WINDOW1    = 0x20 // Window
	WDT_CTRLA_WINDOW2    = 0x40 // Window
	WDT_CTRLA_WINDOW3    = 0x80 // Window
	WDT_CTRLA_WINDOW_Msk = 0xf0 // Window

	// STATUS: Status
	WDT_STATUS_LOCK         = 0x80 // Lock enable
	WDT_STATUS_LOCK_Msk     = 0x80 // Lock enable
	WDT_STATUS_SYNCBUSY     = 0x1  // Syncronization busy
	WDT_STATUS_SYNCBUSY_Msk = 0x1  // Syncronization busy
)
