"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decorateHover = decorateHover;
const utils_1 = require("../utils");
const sveltekit_1 = require("./sveltekit");
function decorateHover(ls, info, ts, logger) {
    const getQuickInfoAtPosition = ls.getQuickInfoAtPosition;
    ls.getQuickInfoAtPosition = (fileName, position) => {
        const result = (0, sveltekit_1.getVirtualLS)(fileName, info, ts);
        if (!result)
            return getQuickInfoAtPosition(fileName, position);
        const { languageService, toOriginalPos, toVirtualPos } = result;
        const virtualPos = toVirtualPos(position);
        const quickInfo = languageService.getQuickInfoAtPosition(fileName, virtualPos);
        if (!quickInfo)
            return quickInfo;
        const source = languageService.getProgram()?.getSourceFile(fileName);
        const node = source && (0, utils_1.findNodeAtPosition)(source, virtualPos);
        if (node && (0, utils_1.isTopLevelExport)(ts, node, source) && ts.isIdentifier(node)) {
            const name = node.text;
            if (name in sveltekit_1.kitExports && !quickInfo.documentation?.length) {
                quickInfo.documentation = sveltekit_1.kitExports[name].documentation;
            }
        }
        return {
            ...quickInfo,
            textSpan: { ...quickInfo.textSpan, start: toOriginalPos(quickInfo.textSpan.start).pos }
        };
    };
}
//# sourceMappingURL=hover.js.map