﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/redshift/Redshift_EXPORTS.h>
#include <aws/redshift/model/AttributeValueTarget.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace Redshift {
namespace Model {

/**
 * <p>A name value pair that describes an aspect of an account. </p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AccountAttribute">AWS
 * API Reference</a></p>
 */
class AccountAttribute {
 public:
  AWS_REDSHIFT_API AccountAttribute() = default;
  AWS_REDSHIFT_API AccountAttribute(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_REDSHIFT_API AccountAttribute& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_REDSHIFT_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_REDSHIFT_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The name of the attribute.</p>
   */
  inline const Aws::String& GetAttributeName() const { return m_attributeName; }
  inline bool AttributeNameHasBeenSet() const { return m_attributeNameHasBeenSet; }
  template <typename AttributeNameT = Aws::String>
  void SetAttributeName(AttributeNameT&& value) {
    m_attributeNameHasBeenSet = true;
    m_attributeName = std::forward<AttributeNameT>(value);
  }
  template <typename AttributeNameT = Aws::String>
  AccountAttribute& WithAttributeName(AttributeNameT&& value) {
    SetAttributeName(std::forward<AttributeNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of attribute values.</p>
   */
  inline const Aws::Vector<AttributeValueTarget>& GetAttributeValues() const { return m_attributeValues; }
  inline bool AttributeValuesHasBeenSet() const { return m_attributeValuesHasBeenSet; }
  template <typename AttributeValuesT = Aws::Vector<AttributeValueTarget>>
  void SetAttributeValues(AttributeValuesT&& value) {
    m_attributeValuesHasBeenSet = true;
    m_attributeValues = std::forward<AttributeValuesT>(value);
  }
  template <typename AttributeValuesT = Aws::Vector<AttributeValueTarget>>
  AccountAttribute& WithAttributeValues(AttributeValuesT&& value) {
    SetAttributeValues(std::forward<AttributeValuesT>(value));
    return *this;
  }
  template <typename AttributeValuesT = AttributeValueTarget>
  AccountAttribute& AddAttributeValues(AttributeValuesT&& value) {
    m_attributeValuesHasBeenSet = true;
    m_attributeValues.emplace_back(std::forward<AttributeValuesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_attributeName;

  Aws::Vector<AttributeValueTarget> m_attributeValues;
  bool m_attributeNameHasBeenSet = false;
  bool m_attributeValuesHasBeenSet = false;
};

}  // namespace Model
}  // namespace Redshift
}  // namespace Aws
