﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/organizations/Organizations_EXPORTS.h>
#include <aws/organizations/model/HandshakePartyType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Organizations {
namespace Model {

/**
 * <p>Contains details for a participant in a handshake.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/HandshakeParty">AWS
 * API Reference</a></p>
 */
class HandshakeParty {
 public:
  AWS_ORGANIZATIONS_API HandshakeParty() = default;
  AWS_ORGANIZATIONS_API HandshakeParty(Aws::Utils::Json::JsonView jsonValue);
  AWS_ORGANIZATIONS_API HandshakeParty& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_ORGANIZATIONS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>ID for the participant: Acccount ID, organization ID, or email address.</p>
   * <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake
   * ID string requires "h-" followed by from 8 to 32 lowercase letters or
   * digits.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  HandshakeParty& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of ID for the participant.</p>
   */
  inline HandshakePartyType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(HandshakePartyType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline HandshakeParty& WithType(HandshakePartyType value) {
    SetType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  HandshakePartyType m_type{HandshakePartyType::NOT_SET};
  bool m_idHasBeenSet = false;
  bool m_typeHasBeenSet = false;
};

}  // namespace Model
}  // namespace Organizations
}  // namespace Aws
