/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRCreator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class UIWidgets {
    private static final Log log = Log.getLog(UIWidgets.class);

    public static Combo createDelimiterCombo(Composite group, String label, String[] options, String defDelimiter, boolean multiDelims) {
        UIUtils.createControlLabel(group, label);
        Combo combo = new Combo(group, 2052);
        combo.setLayoutData((Object)new GridData(768));
        for (String option : options) {
            combo.add(CommonUtils.escapeDisplayString((String)option));
        }
        if (!multiDelims) {
            if (!ArrayUtils.contains((Object[])options, (Object)defDelimiter)) {
                combo.add(CommonUtils.escapeDisplayString((String)defDelimiter));
            }
            String[] items = combo.getItems();
            int itemsLength = items.length;
            for (int i = 0; i < itemsLength; ++i) {
                String delim = CommonUtils.unescapeDisplayString((String)items[i]);
                if (!delim.equals(defDelimiter)) continue;
                combo.select(i);
                break;
            }
        } else {
            combo.setText(CommonUtils.escapeDisplayString((String)defDelimiter));
        }
        return combo;
    }

    public static void fillDefaultTableContextMenu(IContributionManager menu, final Table table) {
        if (table.getColumnCount() > 1) {
            menu.add((IAction)new Action(NLS.bind((String)UIMessages.utils_actions_copy_label, (Object)table.getColumn(0).getText())){

                public void run() {
                    StringBuilder text = new StringBuilder();
                    for (TableItem item : table.getSelection()) {
                        if (!text.isEmpty()) {
                            text.append("\n");
                        }
                        text.append(item.getText(0));
                    }
                    if (text.isEmpty()) {
                        return;
                    }
                    UIUtils.setClipboardContents(table.getDisplay(), (Transfer)TextTransfer.getInstance(), text.toString());
                }
            });
        }
        menu.add((IAction)new Action(UIMessages.utils_actions_copy_all_label){

            public void run() {
                StringBuilder text = new StringBuilder();
                int columnCount = table.getColumnCount();
                for (TableItem item : table.getSelection()) {
                    if (!text.isEmpty()) {
                        text.append("\n");
                    }
                    if (columnCount > 0) {
                        for (int i = 0; i < columnCount; ++i) {
                            if (i > 0) {
                                text.append("\t");
                            }
                            text.append(item.getText(i));
                        }
                        continue;
                    }
                    text.append(item.getText());
                }
                if (text.isEmpty()) {
                    return;
                }
                UIUtils.setClipboardContents(table.getDisplay(), (Transfer)TextTransfer.getInstance(), text.toString());
            }
        });
    }

    public static void fillDefaultTreeContextMenu(IContributionManager menu, final Tree tree) {
        if (tree.getColumnCount() > 1) {
            menu.add((IAction)new Action("Copy " + tree.getColumn(0).getText()){

                public void run() {
                    StringBuilder text = new StringBuilder();
                    for (TreeItem item : tree.getSelection()) {
                        if (!text.isEmpty()) {
                            text.append("\n");
                        }
                        text.append(item.getText(0));
                    }
                    if (text.isEmpty()) {
                        return;
                    }
                    UIUtils.setClipboardContents(tree.getDisplay(), (Transfer)TextTransfer.getInstance(), text.toString());
                }
            });
        }
        menu.add((IAction)new Action(UIMessages.utils_actions_copy_all_label){

            public void run() {
                StringBuilder text = new StringBuilder();
                int columnCount = tree.getColumnCount();
                for (TreeItem item : tree.getSelection()) {
                    if (!text.isEmpty()) {
                        text.append("\n");
                    }
                    if (columnCount > 0) {
                        for (int i = 0; i < columnCount; ++i) {
                            if (i > 0) {
                                text.append("\t");
                            }
                            text.append(item.getText(i));
                        }
                        continue;
                    }
                    text.append(item.getText());
                }
                if (text.isEmpty()) {
                    return;
                }
                UIUtils.setClipboardContents(tree.getDisplay(), (Transfer)TextTransfer.getInstance(), text.toString());
            }
        });
    }

    public static void createTableContextMenu(@NotNull Table table, @Nullable DBRCreator<Boolean, IContributionManager> menuCreator) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(manager -> {
            if (menuCreator != null && !((Boolean)menuCreator.createObject((Object)menuMgr)).booleanValue()) {
                return;
            }
            UIWidgets.fillDefaultTableContextMenu((IContributionManager)manager, table);
        });
        menuMgr.setRemoveAllWhenShown(true);
        table.setMenu(menuMgr.createContextMenu((Control)table));
        table.addDisposeListener(e -> menuMgr.dispose());
    }

    public static void setControlContextMenu(Control control, IMenuListener menuListener) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(menuListener);
        menuMgr.setRemoveAllWhenShown(true);
        control.setMenu(menuMgr.createContextMenu(control));
        control.addDisposeListener(e -> menuMgr.dispose());
    }
}

