/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.syntax;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.properties.HasModifiers;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import com.tngtech.archunit.lang.conditions.ArchPredicates;

class SyntaxPredicates {
    SyntaxPredicates() {
    }

    static DescribedPredicate<HasName> haveNameNotMatching(String regex) {
        return ArchPredicates.have(DescribedPredicate.not(HasName.Predicates.nameMatching(regex)).as("name not matching '%s'", regex));
    }

    static DescribedPredicate<JavaClass> haveSimpleNameNotStartingWith(String prefix) {
        return ArchPredicates.have(DescribedPredicate.not(JavaClass.Predicates.simpleNameStartingWith(prefix)).as("simple name not starting with '%s'", prefix));
    }

    static DescribedPredicate<JavaClass> haveSimpleNameNotContaining(String infix) {
        return ArchPredicates.have(DescribedPredicate.not(JavaClass.Predicates.simpleNameContaining(infix)).as("simple name not containing '%s'", infix));
    }

    static DescribedPredicate<JavaClass> haveSimpleNameNotEndingWith(String suffix) {
        return ArchPredicates.have(DescribedPredicate.not(JavaClass.Predicates.simpleNameEndingWith(suffix)).as("simple name not ending with '%s'", suffix));
    }

    static DescribedPredicate<HasModifiers> arePublic() {
        return HasModifiers.Predicates.modifier(JavaModifier.PUBLIC).as("are public", new Object[0]);
    }

    static DescribedPredicate<HasModifiers> areNotPublic() {
        return DescribedPredicate.not(HasModifiers.Predicates.modifier(JavaModifier.PUBLIC)).as("are not public", new Object[0]);
    }

    static DescribedPredicate<HasModifiers> areProtected() {
        return HasModifiers.Predicates.modifier(JavaModifier.PROTECTED).as("are protected", new Object[0]);
    }

    static DescribedPredicate<HasModifiers> areNotProtected() {
        return DescribedPredicate.not(HasModifiers.Predicates.modifier(JavaModifier.PROTECTED)).as("are not protected", new Object[0]);
    }

    static DescribedPredicate<HasModifiers> arePackagePrivate() {
        return DescribedPredicate.not(HasModifiers.Predicates.modifier(JavaModifier.PUBLIC).or(HasModifiers.Predicates.modifier(JavaModifier.PROTECTED).or(HasModifiers.Predicates.modifier(JavaModifier.PRIVATE)))).as("are package private", new Object[0]);
    }

    static DescribedPredicate<HasModifiers> areNotPackagePrivate() {
        return HasModifiers.Predicates.modifier(JavaModifier.PUBLIC).or(HasModifiers.Predicates.modifier(JavaModifier.PROTECTED).or(HasModifiers.Predicates.modifier(JavaModifier.PRIVATE))).as("are not package private", new Object[0]);
    }

    static DescribedPredicate<HasModifiers> arePrivate() {
        return HasModifiers.Predicates.modifier(JavaModifier.PRIVATE).as("are private", new Object[0]);
    }

    static DescribedPredicate<HasModifiers> areNotPrivate() {
        return DescribedPredicate.not(HasModifiers.Predicates.modifier(JavaModifier.PRIVATE)).as("are not private", new Object[0]);
    }

    static DescribedPredicate<HasModifiers> areStatic() {
        return HasModifiers.Predicates.modifier(JavaModifier.STATIC).as("are static", new Object[0]);
    }

    static DescribedPredicate<HasModifiers> areNotStatic() {
        return DescribedPredicate.not(HasModifiers.Predicates.modifier(JavaModifier.STATIC)).as("are not static", new Object[0]);
    }

    static DescribedPredicate<HasModifiers> areFinal() {
        return HasModifiers.Predicates.modifier(JavaModifier.FINAL).as("are final", new Object[0]);
    }

    static DescribedPredicate<HasModifiers> areNotFinal() {
        return DescribedPredicate.not(HasModifiers.Predicates.modifier(JavaModifier.FINAL)).as("are not final", new Object[0]);
    }

    static DescribedPredicate<HasName> haveFullyQualifiedName(String name) {
        return ArchPredicates.have(ArchConditions.fullyQualifiedName(name));
    }

    static DescribedPredicate<HasName> doNotHaveFullyQualifiedName(String name) {
        return DescribedPredicate.doNot(ArchPredicates.have(ArchConditions.fullyQualifiedName(name)));
    }

    static DescribedPredicate<JavaClass> haveSimpleName(String name) {
        return ArchPredicates.have(JavaClass.Predicates.simpleName(name));
    }

    static DescribedPredicate<JavaClass> doNotHaveSimpleName(String name) {
        return DescribedPredicate.doNot(ArchPredicates.have(JavaClass.Predicates.simpleName(name)));
    }

    static DescribedPredicate<HasModifiers> haveModifier(JavaModifier modifier) {
        return ArchPredicates.have(HasModifiers.Predicates.modifier(modifier));
    }

    static DescribedPredicate<HasModifiers> doNotHaveModifier(JavaModifier modifier) {
        return DescribedPredicate.doNot(ArchPredicates.have(HasModifiers.Predicates.modifier(modifier)));
    }
}

