/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util;

import java.util.ArrayList;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static final Object[] add(Object[] objects, Object object, Object[] newObjects) {
        System.arraycopy(objects, 0, newObjects, 0, objects.length);
        newObjects[objects.length] = object;
        return newObjects;
    }

    public static final byte[] part(byte[] array, int offset, int length) {
        byte[] b = new byte[length];
        System.arraycopy(array, offset, b, 0, length);
        return b;
    }

    public static final int countNotNull(Object[] objects) {
        int count = 0;
        int i = 0;
        while (i < objects.length) {
            if (objects[i] != null) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static final int findSmallest(double[] items) {
        int index = 0;
        int i = 1;
        while (i < items.length) {
            if (items[i] < items[index]) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static final int findSmallest(int[] items) {
        int index = 0;
        int i = 1;
        while (i < items.length) {
            if (items[i] < items[index]) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static final int findLargest(float[] items) {
        int index = 0;
        int i = 1;
        while (i < items.length) {
            if (items[i] > items[index]) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static float[] toFloatArray(int[] values) {
        float[] floatValues = new float[values.length];
        int i = 0;
        while (i < values.length) {
            floatValues[i] = values[i];
            ++i;
        }
        return floatValues;
    }

    public static final int indexOf(int[] array, int value) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(byte[] array, byte value) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final String[] append(String[] a1, String[] a2) {
        String[] n = new String[a1.length + a2.length];
        System.arraycopy(a1, 0, n, 0, a1.length);
        System.arraycopy(a2, 0, n, a1.length, a2.length);
        return n;
    }

    public static final Object[] append(Object[] a1, Object[] a2, Object[] out) {
        System.arraycopy(a1, 0, out, 0, a1.length);
        System.arraycopy(a2, 0, out, a1.length, a2.length);
        return out;
    }

    public static boolean equal(int[] a, int aOffset, int[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equal(byte[] a, int aOffset, byte[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean contains(short[] a, short v) {
        int i = 0;
        while (i < a.length) {
            if (a[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int[] range(int start, int length, int step) {
        int[] a = new int[length];
        int i = 0;
        while (i < length) {
            a[i] = start + step * i;
            ++i;
        }
        return a;
    }

    public static boolean containsEqual(Object[] values, Object value) {
        return ArrayUtil.indexOfEqual(values, value) != -1;
    }

    public static boolean contains(Object[] values, Object value) {
        return ArrayUtil.indexOf(values, value) != -1;
    }

    public static int indexOf(Object[] values, Object value) {
        int i = 0;
        while (i < values.length) {
            if (values[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(Object[] values, Object value, int startIndex, int length) {
        int i = startIndex;
        while (i < length) {
            if (values[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfEqual(Object[] values, Object value) {
        int i = 0;
        while (i < values.length) {
            if (values[i].equals(value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Object[] remove(Object[] values, Object value, Object[] newValues) {
        int index = ArrayUtil.indexOf(values, value);
        if (index == -1) {
            index = values.length;
        }
        System.arraycopy(values, 0, newValues, 0, index);
        System.arraycopy(values, index + 1, newValues, index, newValues.length - index);
        return newValues;
    }

    public static String toString(int[] a) {
        StringBuffer b = new StringBuffer(a.length * 4);
        int i = 0;
        while (i < a.length) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(a[i]);
            ++i;
        }
        return b.toString();
    }

    public static int[] part(int[] values, int start, int length) {
        int[] a = new int[length];
        System.arraycopy(values, start, a, 0, length);
        return a;
    }

    public static int sum(int[] values) {
        int sum = 0;
        int i = 0;
        while (i < values.length) {
            sum += values[i];
            ++i;
        }
        return sum;
    }

    public static int count(int[] values, int value) {
        int count = 0;
        int i = 0;
        while (i < values.length) {
            if (values[i] == value) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int count(boolean[] values, boolean value) {
        int count = 0;
        int i = 0;
        while (i < values.length) {
            if (values[i] == value) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int findLargest(int[] items) {
        int index = 0;
        int i = 1;
        while (i < items.length) {
            if (items[i] > items[index]) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int[] toIntArray(ArrayList items) {
        int[] result = new int[items.size()];
        int i = 0;
        while (i < items.size()) {
            result[i] = ((Number)items.get(i)).intValue();
            ++i;
        }
        return result;
    }

    public static boolean[] toBooleanArray(ArrayList items) {
        boolean[] result = new boolean[items.size()];
        int i = 0;
        while (i < items.size()) {
            result[i] = (Boolean)items.get(i);
            ++i;
        }
        return result;
    }
}

