/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseGridShorthandSetter;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;

class GridShorthandSetter
extends BaseGridShorthandSetter {
    private final String[] subproperties = new String[]{"grid-template-columns", "grid-template-rows", "grid-template-areas", "grid-auto-rows", "grid-auto-columns", "grid-auto-flow"};

    GridShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "grid");
    }

    @Override
    protected String[] getShorthandSubproperties() {
        return this.subproperties;
    }

    @Override
    public short assignSubproperties() {
        byte kwscan = this.scanForCssWideKeywords(this.currentValue);
        if (kwscan == 1) {
            return 0;
        }
        if (kwscan == 2) {
            return 2;
        }
        this.setSubpropertiesToDefault();
        if (this.isNoneDeclaration()) {
            this.appendValueItemString("none");
            this.flush();
        } else if (this.fullSyntax()) {
            this.flush();
        } else {
            return 2;
        }
        return 0;
    }

    @Override
    protected void setSubpropertiesToDefault() {
        String[] subp;
        for (String pname : subp = this.getShorthandSubproperties()) {
            this.setPropertyToDefault(pname);
        }
    }

    boolean fullSyntax() {
        StyleValue value;
        boolean setTemplateAreas = false;
        boolean gridAutoRows = false;
        LexicalUnit fullValue = this.currentValue;
        ValueList gridTemplateRows = ValueList.createWSValueList();
        ValueList gridTemplateAreas = ValueList.createWSValueList();
        ValueList lineNames = null;
        byte ret = this.isAutoflowOrDenseKeyword();
        if (ret == -1) {
            return false;
        }
        if (ret != 0) {
            gridAutoRows = true;
            if (ret == 2) {
                this.setGridAutoFlow("row", true);
            } else {
                this.setGridAutoFlow("row", false);
            }
        }
        boolean missSlash = true;
        LexicalUnit.LexicalType lasttype = LexicalUnit.LexicalType.UNKNOWN;
        block5: do {
            LexicalUnit.LexicalType type = this.currentValue.getLexicalUnitType();
            switch (type) {
                case LEFT_BRACKET: {
                    LexicalUnit nlu;
                    ValueFactory.ListValueItem item;
                    if (lasttype == LexicalUnit.LexicalType.STRING) {
                        gridTemplateRows.add(GridShorthandSetter.createAutoValue());
                    }
                    if ((item = this.valueFactory.parseBracketList(nlu = this.currentValue.getNextLexicalUnit(), this.styleDeclaration, true)) != null) {
                        ValueList newLineNames = item.getCSSValue();
                        if (lineNames == null) {
                            lineNames = newLineNames;
                            gridTemplateRows.add(lineNames);
                        } else {
                            lineNames.addAll(newLineNames);
                        }
                        this.appendValueItemString(newLineNames);
                        this.currentValue = item.getNextLexicalUnit();
                        lasttype = type;
                        break;
                    }
                    this.currentValue = nlu.getNextLexicalUnit();
                    break;
                }
                case STRING: {
                    if (lasttype == LexicalUnit.LexicalType.STRING) {
                        gridTemplateRows.add(GridShorthandSetter.createAutoValue());
                    }
                    setTemplateAreas = true;
                    lineNames = null;
                    if (this.currentValue.getStringValue().length() == 0) {
                        this.syntaxError("Found an empty areas string.");
                        return false;
                    }
                    value = this.createCSSValue();
                    gridTemplateAreas.add(value);
                    this.appendValueItemString(value);
                    lasttype = type;
                    break;
                }
                case OPERATOR_SLASH: {
                    if (lasttype != LexicalUnit.LexicalType.UNKNOWN) {
                        this.currentValue = this.currentValue.getNextLexicalUnit();
                        if (this.currentValue != null) {
                            String property;
                            this.getValueItemBuffer().append(" /");
                            this.getValueItemBufferMini().append('/');
                            ret = this.isAutoflowOrDenseKeyword();
                            if (ret == -1) {
                                return false;
                            }
                            if (ret != 0) {
                                property = "grid-auto-columns";
                                if (ret == 2) {
                                    this.setGridAutoFlow("column", true);
                                } else {
                                    this.setGridAutoFlow("column", false);
                                }
                                if (gridAutoRows) {
                                    this.syntaxError("Found two auto-flow declarations: " + BaseCSSStyleDeclaration.lexicalUnitToString(fullValue));
                                    return false;
                                }
                            } else {
                                property = "grid-template-columns";
                            }
                            value = this.valueFactory.createCSSValue(this.currentValue, this.styleDeclaration);
                            value = this.subpropertyValue(value);
                            this.setSubpropertyValue(property, value);
                            this.appendValueItemString(value);
                            missSlash = false;
                            break block5;
                        }
                        this.syntaxError("Unexpected end of declaration after slash '/' in " + BaseCSSStyleDeclaration.lexicalUnitToString(fullValue));
                    }
                    return false;
                }
                default: {
                    if (setTemplateAreas && type == LexicalUnit.LexicalType.FUNCTION && "repeat".equalsIgnoreCase(this.currentValue.getFunctionName())) {
                        this.syntaxError("This syntax does not allow repeat(): " + BaseCSSStyleDeclaration.lexicalUnitToString(fullValue));
                        return false;
                    }
                    lineNames = null;
                    value = this.createCSSValue();
                    gridTemplateRows.add(value);
                    this.appendValueItemString(value);
                    lasttype = type;
                }
            }
        } while (this.currentValue != null);
        if (!setTemplateAreas && missSlash) {
            String message = "Not a correct rows / columns syntax: " + BaseCSSStyleDeclaration.lexicalUnitToString(fullValue);
            this.syntaxError(message);
            return false;
        }
        if (gridTemplateRows.getLength() != 0) {
            if (!GridShorthandSetter.isAutoOnly(gridTemplateRows)) {
                String property = gridAutoRows ? "grid-auto-rows" : "grid-template-rows";
                value = gridTemplateRows.getLength() != 1 ? gridTemplateRows : gridTemplateRows.item(0);
                this.setSubpropertyValue(property, value);
            } else {
                this.setSubpropertyValue("grid-template-rows", gridTemplateRows.item(0));
            }
        } else if (setTemplateAreas) {
            IdentifierValue auto = new IdentifierValue("auto");
            auto.setSubproperty(true);
            this.setSubpropertyValue("grid-template-rows", auto);
        }
        if (gridTemplateAreas.getLength() != 0) {
            value = gridTemplateAreas.getLength() != 1 ? gridTemplateAreas : gridTemplateAreas.item(0);
            this.setSubpropertyValue("grid-template-areas", value);
        }
        return true;
    }

    private void setGridAutoFlow(String ident, boolean dense) {
        StyleValue value;
        IdentifierValue cssident = new IdentifierValue(ident);
        cssident.setSubproperty(true);
        if (!dense) {
            value = cssident;
        } else {
            IdentifierValue cssdense = new IdentifierValue("dense");
            cssdense.setSubproperty(true);
            ValueList list = ValueList.createWSValueList();
            list.add(cssident);
            list.add(cssdense);
            value = list;
        }
        this.setSubpropertyValue("grid-auto-flow", value);
    }

    private byte isAutoflowOrDenseKeyword() {
        int ret = 0;
        if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
            StringBuilder buf;
            String sv = this.currentValue.getStringValue();
            if ("auto-flow".equalsIgnoreCase(sv)) {
                buf = this.getValueItemBuffer();
                if (buf.length() != 0) {
                    buf.append(' ');
                }
                this.currentValue = this.currentValue.getNextLexicalUnit();
                if (this.currentValue != null && this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && "dense".equalsIgnoreCase(this.currentValue.getStringValue())) {
                    this.appendValueItemString("auto-flow dense");
                    ret = 2;
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                } else {
                    this.appendValueItemString("auto-flow");
                    ret = 1;
                }
            }
            if ("dense".equalsIgnoreCase(sv)) {
                buf = this.getValueItemBuffer();
                if (buf.length() != 0) {
                    buf.append(' ');
                    this.getValueItemBufferMini().append(' ');
                }
                this.currentValue = this.currentValue.getNextLexicalUnit();
                if (this.currentValue != null && this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && "auto-flow".equalsIgnoreCase(this.currentValue.getStringValue())) {
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                    this.appendValueItemString("auto-flow dense");
                    ret = 2;
                } else {
                    ret = -1;
                }
            }
        }
        return (byte)ret;
    }
}

