---
stage: none
group: Tutorials
info: For assistance with this tutorials page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
description: AIネイティブな機能とワークフロー。
title: 'チュートリアル: GitLab Duo'
---

GitLabのAIネイティブな機能を使用して、ソフトウェア開発ライフサイクル全体のワークフローを強化します。

## GitLab Duo Agentic Chat (Agentic) {#ask-gitlab-duo-chat-agentic}

インタラクティブにチャットして、すぐにフィードバックを得られます。

| トピック | 説明 | 初心者向け | 試してみる |
|-------|-------------|--------------------|------------|
| [はじめに](https://about.gitlab.com/blog/getting-started-with-gitlab-duo-agentic-chat/) | Agentic Chatを使用するように設定し、一般的なユースケースを試してください。 | {{< icon name="star" >}} | [インターフェース](https://gitlab.navattic.com/duo-agentic-chat) |
| [GitLab Duo](../user/gitlab_duo/tutorials/fix_code_python_shop.md)を使用してウェブアプリケーションを作成する | Chatとコード提案を使用して、Pythonウェブアプリケーションをビルドします。 | {{< icon name="star" >}} | |
| [GitLab Duoを使用してWebアプリケーションを修正する](../user/gitlab_duo/tutorials/duo_python_fix_errors.md) | ウェブアプリケーションのテストケースを作成して実行し、エラー処理とデータの検証を実装します。 | | |

## エージェントとフローの操作 {#work-with-agents-and-flows}

AIアシスタントをデプロイしてタスクを完了し、複雑なワークフローを処理します。

| トピック | 説明 | 初心者向け | 試してみる |
|-------|-------------|--------------------|------------|
| [エージェントについて: 基本、カスタム、および外部](https://about.gitlab.com/blog/understanding-agents-foundational-custom-external/) | さまざまな種類のエージェントの機能を理解し、独自のカスタムエージェントを作成します。 | {{< icon name="star" >}} | [カスタムエージェントを設定する](https://gitlab.navattic.com/custom-agents)|
| [フローについて: マルチエージェントワークフロー](https://about.gitlab.com/blog/understanding-flows-multi-agent-workflows/) | フローの種類について学び、独自のカスタムフローを作成します。 | {{< icon name="star" >}} | [カスタムフローを設定する](https://gitlab.navattic.com/custom-flows)|

## 拡張とインテグレーション {#extend-and-integrate}

外部ツールと接続して、GitLab Duoの機能を拡張します。

| トピック | 説明 | 初心者向け | 試してみる |
|-------|-------------|--------------------|------------|
| [Model Context Protocol](https://about.gitlab.com/blog/duo-agent-platform-with-mcp/)インテグレーション | MCPがGitLab Duoの機能を外部ソースに接続し、AIツールをGitLabインスタンスに接続するのにどのように役立つかをご覧ください。 | | [クライアントワークフロー](https://gitlab.navattic.com/mcp)と[サーバーワークフロー](https://gitlab.navattic.com/gitlab-mcp-server)をご覧ください|
