---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密のシークレットまたはトークンMailgunプライベートAPIトークンの公開'
---

## 説明 {#description}

応答本文には、MailgunプライベートAPIトークンのパターンに一致するコンテンツが含まれていることが判明しました。このキーを使用すると、さまざまなAPIエンドポイントを介して、また送信ドメインに対して、読み取り、書き込み、および削除操作を実行できます。このキーにアクセスできる悪意のある攻撃者は、制限なしにMailgunにAPIリクエストを実行できます。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできるようになる可能性があります。

## 修正 {#remediation}

キーの漏洩に関するセキュリティインシデントの処理に関する一般的なガイダンスについては、[認証情報のインターネットへの公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)に関するGitLabドキュメントを参照してください。

プライベートAPIトークンをローテーションするには:

- Mailgunアカウントにサインインし、ダッシュボード（<https://app.mailgun.com/>）にアクセスします。
- 右上側で、アカウントプロファイルを選択し、[APIセキュリティ]を選択します
- 識別されたキーを見つけて、ごみ箱アイコンを選択します
- ごみ箱アイコンを選択できない場合は、まず[新しいキーを追加]を選択して新しいキーを生成する必要があります
- プロンプトが表示されたら、[APIキーの削除]ダイアログで[削除]を選択します

詳細については、[MailgunのAPIキーに関するドキュメント](https://documentation.mailgun.com/docs/mailgun/user-manual/get-started/#primary-account-api-key)を参照してください。

## 詳細 {#details}

| ID | 集約 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.74 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
