---
stage: Fulfillment
group: Subscription Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Choose the right GitLab subscription for your needs.
title: GitLab plans
---

To choose the right GitLab subscription, select an offering and a tier.

## Choose an offering

Choose which GitLab offering suits your needs:

- GitLab.com: The GitLab software-as-a-service offering.
  You don't need to install anything to use GitLab.com, you only need to
  [sign up](https://gitlab.com/users/sign_up) and start using GitLab straight away.
  The subscription applies to a top-level group namespace.
  You cannot apply a subscription to a personal namespace.
- [GitLab Dedicated](gitlab_dedicated/_index.md): A single-tenant SaaS service for highly regulated and large enterprises.
- GitLab Self-Managed: Install, administer, and maintain your own GitLab instance.
  The subscription provides the same set of features for all users.

> [!note]
> Subscriptions cannot be transferred between GitLab.com and GitLab Self-Managed.
> If you want to switch to a different GitLab offering, you must purchase and apply a new subscription.

## Choose a subscription tier

Pricing is [tier-based](https://about.gitlab.com/pricing/), allowing you to choose
the features that fit your budget.

For more details, see [a comparison of features available in each tier](https://about.gitlab.com/pricing/feature-comparison/).

## Choose a subscription add-on

An add-on is an additional paid feature or service that you can purchase on top of an existing
GitLab subscription. Add-ons provide extra functionality or resources to enhance your GitLab
experience.

You can purchase the following add-ons:

- [GitLab Duo](subscription-add-ons.md): Get access to AI-native features like Code Suggestions,
  GitLab Duo Chat, and more.
- [Enterprise Agile Planning](manage_users_and_seats.md#enterprise-agile-planning): Increase collaboration between
  technical and non-technical teams on a single platform. Non-engineering team members can participate in planning,
  measure impact with Value Stream Analytics, and gain visibility into software development velocity.
- [Storage](../user/storage_usage_quotas.md#purchase-more-storage): Buy more storage when you exceed your
  free 10 GiB storage quota.
- [Compute minutes](gitlab_com/compute_minutes.md): Buy additional compute minutes when your
  plan exceeds its allocated amount and you need to continue running automated
  builds, tests, and deployments without interruption.

Some add-ons are only available to specific subscription tiers and offerings.

## Contact Support

- See the tiers of [GitLab Support](https://about.gitlab.com/support/).
- [Submit a request](https://support.gitlab.com/hc/en-us/requests/new) through the Support Portal.

We also encourage all users to search our project trackers for known issues and existing feature requests in the [GitLab project](https://gitlab.com/gitlab-org/gitlab/-/issues/).

These issues are the best avenue for getting updates on specific product plans and for communicating directly with the relevant GitLab team members.
