/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.A4;
import javajs.util.BS;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.render.MeshRenderer;
import org.jmol.render.ShapeRenderer;
import org.jmol.renderbio.BioShapeRenderer;
import org.jmol.shape.Mesh;
import org.jmol.shapebio.BioShape;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.Normix;

public class BioMeshRenderer
extends MeshRenderer {
    private Mesh[] meshes;
    private boolean[] meshReady;
    private BS bsRenderMesh;
    private BioShapeRenderer bsr;
    private boolean doCap0;
    private boolean doCap1;
    private static final int ABSOLUTE_MIN_MESH_SIZE = 3;
    private static final int MIN_MESH_RENDER_SIZE = 8;
    private P3[] controlHermites;
    private V3[] wingHermites;
    private P3[] radiusHermites;
    private V3 norm = new V3();
    private final V3 wing = new V3();
    private final V3 wing1 = new V3();
    private final V3 wingT = new V3();
    private final A4 aa = new A4();
    private final P3 pt = new P3();
    private final P3 pt1 = new P3();
    private final P3 ptPrev = new P3();
    private final P3 ptNext = new P3();
    private final M3 mat = new M3();
    private static final int MODE_TUBE = 0;
    private static final int MODE_FLAT = 1;
    private static final int MODE_ELLIPTICAL = 2;
    private static final int MODE_NONELLIPTICAL = 3;
    private BS bsTemp;
    private final V3 norml = new V3();

    @Override
    protected boolean render() {
        return false;
    }

    public void initialize(ShapeRenderer bsr, BioShape bioShape, int monomerCount) {
        this.bsr = (BioShapeRenderer)bsr;
        this.bsRenderMesh = BS.newN(monomerCount);
        this.meshReady = bioShape.meshReady;
        this.meshes = bioShape.meshes;
    }

    private void renderBioMesh(Mesh mesh) {
        if (mesh.normalsTemp != null) {
            mesh.setNormixes(mesh.normalsTemp);
            mesh.normalsTemp = null;
        } else if (mesh.normixes == null) {
            mesh.initialize(1073741958, null, null);
        }
        this.renderMesh2(mesh);
    }

    public void setFancyRibbon(int i) {
        try {
            if (!(this.meshes[i] != null && this.meshReady[i] || this.createMesh(i, this.bsr.madBeg, this.bsr.madMid, this.bsr.madEnd, this.bsr.aspectRatio, this.bsr.isNucleic ? 4 : 7))) {
                return;
            }
            this.meshes[i].setColix(this.bsr.colix);
            this.meshes[i].setColixBack(this.bsr.colixBack);
            this.bsRenderMesh.set(i);
        }
        catch (Exception e) {
            this.bsRenderMesh.clear(i);
            this.meshes[i] = null;
            Logger.error("render mesh error hermiteRibbon: " + e.toString());
        }
    }

    public boolean setFancyConic(int i, int tension) {
        try {
            if (!(this.meshes[i] != null && this.meshReady[i] || this.createMesh(i, this.bsr.madBeg, this.bsr.madMid, this.bsr.madEnd, 1.0f, tension))) {
                return false;
            }
            this.meshes[i].setColix(this.bsr.colix);
            this.bsRenderMesh.set(i);
            return true;
        }
        catch (Exception e) {
            this.bsRenderMesh.clear(i);
            this.meshes[i] = null;
            Logger.error("render mesh error hermiteConic: " + e.toString());
            return false;
        }
    }

    public void setFancyArrowHead(int i) {
        try {
            this.doCap0 = true;
            this.doCap1 = false;
            if (!(this.meshes[i] != null && this.meshReady[i] || this.createMesh(i, (int)Math.floor((double)this.bsr.madBeg * 1.2), (int)Math.floor((double)this.bsr.madBeg * 0.6), 0, this.bsr.aspectRatio == 1.0f ? this.bsr.aspectRatio : this.bsr.aspectRatio / 2.0f, 7))) {
                return;
            }
            this.meshes[i].setColix(this.bsr.colix);
            this.bsRenderMesh.set(i);
            return;
        }
        catch (Exception e) {
            this.bsRenderMesh.clear(i);
            this.meshes[i] = null;
            Logger.error("render mesh error hermiteArrowHead: " + e.toString());
            return;
        }
    }

    private boolean createMesh(int i, int madBeg, int madMid, int madEnd, float aspectRatio, int tension) {
        boolean variableRadius;
        this.bsr.setNeighbors(i);
        P3[] cp = this.bsr.controlPoints;
        if (cp[i].distanceSquared(cp[this.bsr.iNext]) == 0.0f) {
            return false;
        }
        boolean isEccentric = aspectRatio != 1.0f && this.bsr.wingVectors != null;
        boolean isFlatMesh = aspectRatio == 0.0f;
        boolean isElliptical = this.bsr.cartoonsFancy || this.bsr.hermiteLevel >= 6;
        int nHermites = (this.bsr.hermiteLevel + 1) * 2 + 1;
        int nPer = isFlatMesh ? 4 : (this.bsr.hermiteLevel + 1) * 4 - 2;
        float angle = (float)(isFlatMesh ? Math.PI / (double)(nPer - 1) : Math.PI * 2 / (double)nPer);
        Mesh mesh = this.meshes[i] = new Mesh().mesh1(this.vwr, "mesh_" + this.shapeID + "_" + i, (short)0, i);
        boolean bl = variableRadius = madBeg != madMid || madMid != madEnd;
        if (this.controlHermites == null || this.controlHermites.length < nHermites + 1) {
            this.controlHermites = new P3[nHermites + 1];
        }
        GData.getHermiteList(tension, cp[this.bsr.iPrev], cp[i], cp[this.bsr.iNext], cp[this.bsr.iNext2], cp[this.bsr.iNext3], this.controlHermites, 0, nHermites, true);
        if (this.wingHermites == null || this.wingHermites.length < nHermites + 1) {
            this.wingHermites = new V3[nHermites + 1];
        }
        this.wing.setT(this.bsr.wingVectors[this.bsr.iPrev]);
        if (madEnd == 0) {
            this.wing.scale(2.0f);
        }
        GData.getHermiteList(tension, this.wing, this.bsr.wingVectors[i], this.bsr.wingVectors[this.bsr.iNext], this.bsr.wingVectors[this.bsr.iNext2], this.bsr.wingVectors[this.bsr.iNext3], this.wingHermites, 0, nHermites, false);
        float radius1 = (float)madBeg / 2000.0f;
        float radius2 = (float)madMid / 2000.0f;
        float radius3 = (float)madEnd / 2000.0f;
        if (variableRadius) {
            if (this.radiusHermites == null || this.radiusHermites.length < (nHermites + 1 >> 1) + 1) {
                this.radiusHermites = new P3[(nHermites + 1 >> 1) + 1];
            }
            this.ptPrev.set(radius1, radius1, 0.0f);
            this.pt.set(radius1, radius2, 0.0f);
            this.pt1.set(radius2, radius3, 0.0f);
            this.ptNext.set(radius3, radius3, 0.0f);
            GData.getHermiteList(4, this.ptPrev, this.pt, this.pt1, this.ptNext, this.ptNext, this.radiusHermites, 0, nHermites + 1 >> 1, true);
        }
        int nPoints = 0;
        int iMid = nHermites >> 1;
        int kpt1 = (nPer + 2) / 4;
        int kpt2 = (3 * nPer + 2) / 4;
        int mode = !isEccentric ? 0 : (isFlatMesh ? 1 : (isElliptical ? 2 : 3));
        boolean useMat = mode == 0 || mode == 3;
        for (int p = 0; p < nHermites; ++p) {
            this.norm.sub2(this.controlHermites[p + 1], this.controlHermites[p]);
            float scale = !variableRadius ? radius1 : (p < iMid ? this.radiusHermites[p].x : this.radiusHermites[p - iMid].y);
            this.wing.setT(this.wingHermites[p]);
            this.wing1.setT(this.wing);
            switch (mode) {
                case 1: {
                    break;
                }
                case 2: {
                    this.wing1.cross(this.norm, this.wing);
                    this.wing1.normalize();
                    this.wing1.scale(this.wing.length() / aspectRatio);
                    break;
                }
                case 3: {
                    this.wing.scale(2.0f / aspectRatio);
                    this.wing1.sub(this.wing);
                    break;
                }
                case 0: {
                    this.wing.cross(this.wing, this.norm);
                    this.wing.normalize();
                }
            }
            this.wing.scale(scale);
            this.wing1.scale(scale);
            if (useMat) {
                this.aa.setVA(this.norm, angle);
                this.mat.setAA(this.aa);
            }
            this.pt1.setT(this.controlHermites[p]);
            float theta = isFlatMesh ? 0.0f : angle;
            int k = 0;
            while (k < nPer) {
                if (useMat && k > 0) {
                    this.mat.rotate(this.wing);
                }
                switch (mode) {
                    case 1: {
                        this.wingT.setT(this.wing1);
                        this.wingT.scale((float)Math.cos(theta));
                        break;
                    }
                    case 2: {
                        this.wingT.setT(this.wing1);
                        this.wingT.scale((float)Math.sin(theta));
                        this.wingT.scaleAdd2((float)Math.cos(theta), this.wing, this.wingT);
                        break;
                    }
                    case 3: {
                        this.wingT.setT(this.wing);
                        if (k == kpt1 || k == kpt2) {
                            this.wing1.scale(-1.0f);
                        }
                        this.wingT.add(this.wing1);
                        break;
                    }
                    case 0: {
                        this.wingT.setT(this.wing);
                    }
                }
                this.pt.add2(this.pt1, this.wingT);
                mesh.addV(this.pt, true);
                ++k;
                theta += angle;
            }
            if (p > 0) {
                int nLast = isFlatMesh ? nPer - 1 : nPer;
                for (int k2 = 0; k2 < nLast; ++k2) {
                    int a = nPoints - nPer + k2;
                    int b = nPoints - nPer + (k2 + 1) % nPer;
                    int c = nPoints + (k2 + 1) % nPer;
                    int d = nPoints + k2;
                    if (k2 < nLast / 2) {
                        mesh.addQuad(a, b, c, d);
                        continue;
                    }
                    mesh.addQuad(b, c, d, a);
                }
            }
            nPoints += nPer;
        }
        if (!isFlatMesh) {
            int nPointsPreCap = nPoints;
            if (this.doCap0) {
                T3[] vs = mesh.getVertices();
                for (int l = 0; l < nPer; ++l) {
                    mesh.addV(vs[l], true);
                }
                nPoints += nPer;
                int k = this.bsr.hermiteLevel * 2;
                while (--k >= 0) {
                    mesh.addQuad(nPoints - nPer + k + 2, nPoints - nPer + k + 1, nPoints - nPer + (nPer - k) % nPer, nPoints - k - 1);
                }
            }
            if (this.doCap1) {
                T3[] vs = mesh.getVertices();
                for (int l = 0; l < nPer; ++l) {
                    mesh.addV(vs[nPointsPreCap - nPer + l], true);
                }
                nPoints += nPer;
                int k = this.bsr.hermiteLevel * 2;
                while (--k >= 0) {
                    mesh.addQuad(nPoints - k - 1, nPoints - nPer + (nPer - k) % nPer, nPoints - nPer + k + 1, nPoints - nPer + k + 2);
                }
            }
        }
        this.meshReady[i] = true;
        this.adjustCartoonSeamNormals(i, nPer);
        mesh.setVisibilityFlags(1);
        return true;
    }

    void adjustCartoonSeamNormals(int i, int nPer) {
        if (this.bsTemp == null) {
            this.bsTemp = Normix.newVertexBitSet();
        }
        if (i == this.bsr.iNext - 1 && this.bsr.iNext < this.bsr.monomerCount && this.bsr.monomers[i].getStrucNo() == this.bsr.monomers[this.bsr.iNext].getStrucNo() && this.meshReady[i] && this.meshReady[this.bsr.iNext]) {
            try {
                V3[] normals2 = this.meshes[this.bsr.iNext].getNormalsTemp();
                V3[] normals = this.meshes[i].getNormalsTemp();
                int normixCount = normals.length;
                if (this.doCap0) {
                    normixCount -= nPer;
                }
                for (int j = 1; j <= nPer; ++j) {
                    this.norml.add2(normals[normixCount - j], normals2[nPer - j]);
                    this.norml.normalize();
                    normals[normixCount - j].setT(this.norml);
                    normals2[nPer - j].setT(this.norml);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void renderMeshes() {
        if (this.bsRenderMesh.isEmpty()) {
            return;
        }
        this.setColix(this.bsr.colix);
        int i = this.bsRenderMesh.nextSetBit(0);
        while (i >= 0) {
            this.renderBioMesh(this.meshes[i]);
            i = this.bsRenderMesh.nextSetBit(i + 1);
        }
    }

    public void initBS() {
        this.bsRenderMesh.clearAll();
    }

    public boolean check(boolean doCap0, boolean doCap1) {
        this.doCap0 = doCap0;
        this.doCap1 = doCap1;
        return this.exportType == 1 || this.checkDiameter(this.bsr.diameterBeg) || this.checkDiameter(this.bsr.diameterMid) || this.checkDiameter(this.bsr.diameterEnd);
    }

    private boolean checkDiameter(int d) {
        return this.bsr.isHighRes && d > 3 || d >= 8;
    }
}

