/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import javajs.util.SB;
import org.jmol.c.CBK;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolChimeMessenger;
import org.jmol.viewer.StatusManager;
import org.jmol.viewer.Viewer;

public class ChimeMessenger
implements JmolChimeMessenger {
    private Viewer vwr;

    @Override
    public JmolChimeMessenger set(Viewer vwr) {
        this.vwr = vwr;
        return this;
    }

    @Override
    public String getInfoXYZ(Atom a) {
        String group3 = a.getGroup3(true);
        int chainID = a.group.chain.chainID;
        return "Atom: " + (group3 == null ? a.getElementSymbol() : a.getAtomName()) + " " + a.getAtomNumber() + (group3 != null && group3.length() > 0 ? (a.isHetero() ? " Hetero: " : " Group: ") + group3 + " " + a.getResno() + (chainID != 0 && chainID != 32 ? " Chain: " + a.group.chain.getIDStr() : "") : "") + " Model: " + a.getModelNumber() + " Coordinates: " + a.x + " " + a.y + " " + a.z;
    }

    @Override
    public void showHash(SB outputBuffer, String s) {
        if (s == null) {
            return;
        }
        if (outputBuffer == null) {
            if (!this.vwr.isPrintOnly) {
                Logger.warn(s);
            }
            this.vwr.scriptStatus(s);
        } else {
            outputBuffer.append(s).appendC('\n');
        }
    }

    @Override
    public void reportSelection(int n) {
        this.vwr.reportSelection((n == 0 ? "No atoms" : (n == 1 ? "1 atom" : n + " atoms")) + " selected!");
    }

    @Override
    public void update(String msg) {
        msg = msg == null ? "script <exiting>" : "Requesting " + msg;
        this.vwr.scriptStatus(msg);
    }

    @Override
    public String scriptCompleted(StatusManager sm, String statusMessage, String strErrorMessageUntranslated) {
        Object[] data = new Object[]{null, "script <exiting>", statusMessage, -1, strErrorMessageUntranslated};
        if (sm.notifyEnabled(CBK.SCRIPT)) {
            sm.cbl.notifyCallback(CBK.SCRIPT, data);
        }
        sm.processScript(data);
        return "Jmol script completed.";
    }

    @Override
    public void getAllChimeInfo(SB sb) {
        int nHetero = 0;
        int nH = -1;
        int nS = 0;
        int nT = 0;
        ModelSet ms = this.vwr.ms;
        if (ms.haveBioModels) {
            int n = 0;
            Model[] models = ms.am;
            int modelCount = ms.mc;
            int ac = ms.ac;
            Atom[] atoms = ms.at;
            sb.append("\nMolecule name ....... " + ms.getInfoM("COMPND"));
            sb.append("\nSecondary Structure . PDB Data Records");
            sb.append("\nBrookhaven Code ..... " + ms.modelSetName);
            int i = modelCount;
            while (--i >= 0) {
                n += models[i].getChainCount(false);
            }
            sb.append("\nNumber of Chains .... " + n);
            int ng = 0;
            int ngHetero = 0;
            Hashtable<Group, Boolean> map = new Hashtable<Group, Boolean>();
            int lastid = -1;
            nH = 0;
            int i2 = ac;
            while (--i2 >= 0) {
                int id;
                Group g;
                Atom a = atoms[i2];
                if (a == null) continue;
                boolean isHetero = a.isHetero();
                if (isHetero) {
                    ++nHetero;
                }
                if (!map.containsKey(g = a.group)) {
                    map.put(g, Boolean.TRUE);
                    if (isHetero) {
                        ++ngHetero;
                    } else {
                        ++ng;
                    }
                }
                if (a.mi != 0 || (id = g.getStrucNo()) == lastid || id == 0) continue;
                lastid = id;
                switch (g.getProteinStructureType()) {
                    case HELIX: {
                        ++nH;
                        break;
                    }
                    case SHEET: {
                        ++nS;
                        break;
                    }
                    case TURN: {
                        ++nT;
                    }
                }
            }
            sb.append("\nNumber of Groups .... " + ng);
            if (ngHetero > 0) {
                sb.append(" (" + ngHetero + ")");
            }
        }
        sb.append("\nNumber of Atoms ..... " + (ms.ac - nHetero));
        if (nHetero > 0) {
            sb.append(" (" + nHetero + ")");
        }
        sb.append("\nNumber of Bonds ..... " + ms.bondCount);
        sb.append("\nNumber of Models ...... " + ms.mc);
        if (nH >= 0) {
            sb.append("\nNumber of Helices ... " + nH);
            sb.append("\nNumber of Strands ... " + nS);
            sb.append("\nNumber of Turns ..... " + nT);
        }
    }
}

