/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class StandardAclRecordIterator
implements Iterator<List<ApiMessageAndVersion>> {
    private static final int DEFAULT_MAX_RECORDS_IN_BATCH = 10;
    private final Iterator<StandardAclWithId> iterator;
    private final int maxRecordsInBatch;

    public StandardAclRecordIterator(Iterator<StandardAclWithId> iterator) {
        this(iterator, 10);
    }

    public StandardAclRecordIterator(Iterator<StandardAclWithId> iterator, int maxRecordsInBatch) {
        this.iterator = iterator;
        this.maxRecordsInBatch = maxRecordsInBatch;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<ApiMessageAndVersion> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ArrayList<ApiMessageAndVersion> result = new ArrayList<ApiMessageAndVersion>(10);
        for (int i = 0; i < this.maxRecordsInBatch && this.iterator.hasNext(); ++i) {
            StandardAclWithId aclWithId = this.iterator.next();
            result.add(new ApiMessageAndVersion((ApiMessage)aclWithId.toRecord(), 0));
        }
        return result;
    }
}

