/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.dialect.function.json.JsonValueFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.sql.ast.tree.expression.JsonValueEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonValueErrorBehavior;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerJsonValueFunction
extends JsonValueFunction {
    public SQLServerJsonValueFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true, false);
    }

    @Override
    protected void render(SqlAppender sqlAppender, JsonValueFunction.JsonValueArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        if (arguments.errorBehavior() != null && arguments.errorBehavior() != JsonValueErrorBehavior.ERROR) {
            throw new QueryException("Can't emulate on error clause on SQL server");
        }
        sqlAppender.appendSql("(select v from openjson(");
        arguments.jsonDocument().accept(walker);
        sqlAppender.appendSql(") with (v ");
        if (arguments.returningType() != null) {
            arguments.returningType().accept(walker);
        } else {
            sqlAppender.appendSql("nvarchar(max)");
        }
        sqlAppender.appendSql(' ');
        JsonPathPassingClause passingClause = arguments.passingClause();
        if (arguments.emptyBehavior() != null && arguments.emptyBehavior() != JsonValueEmptyBehavior.NULL) {
            if (passingClause != null) {
                JsonPathHelper.appendInlinedJsonPathIncludingPassingClause(sqlAppender, "strict ", arguments.jsonPath(), passingClause, walker);
            } else {
                walker.getSessionFactory().getJdbcServices().getDialect().appendLiteral(sqlAppender, "strict " + String.valueOf(walker.getLiteralValue(arguments.jsonPath())));
            }
        } else if (passingClause != null) {
            JsonPathHelper.appendInlinedJsonPathIncludingPassingClause(sqlAppender, "", arguments.jsonPath(), passingClause, walker);
        } else {
            arguments.jsonPath().accept(walker);
        }
        sqlAppender.appendSql("))");
    }
}

