/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.xml;

import java.util.List;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmNamedExpression;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.AliasedExpression;
import org.hibernate.type.BindingContext;
import org.hibernate.type.descriptor.jdbc.XmlHelper;
import org.hibernate.type.spi.TypeConfiguration;

public class XmlForestFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public XmlForestFunction(TypeConfiguration typeConfiguration) {
        super("xmlforest", FunctionKind.NORMAL, StandardArgumentsValidators.composite(StandardArgumentsValidators.min(1), new ArgumentsValidator(){

            @Override
            public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, BindingContext bindingContext) {
                for (int i = 0; i < arguments.size(); ++i) {
                    SqmTypedNode<?> sqmTypedNode = arguments.get(i);
                    if (!(sqmTypedNode instanceof SqmNamedExpression)) {
                        throw new FunctionArgumentException(String.format("Parameter %d of function 'xmlforest()' is not named", i));
                    }
                    SqmNamedExpression namedExpression = (SqmNamedExpression)sqmTypedNode;
                    if (XmlHelper.isValidXmlName(namedExpression.getName())) continue;
                    throw new FunctionArgumentException(String.format("Invalid XML element name passed to 'xmlforest()': %s", namedExpression.getName()));
                }
            }
        }), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(String.class, 2009)), null);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("xmlforest");
        int separator = 40;
        for (SqlAstNode sqlAstNode : sqlAstArguments) {
            sqlAppender.appendSql((char)separator);
            if (sqlAstNode instanceof AliasedExpression) {
                AliasedExpression aliasedExpression = (AliasedExpression)sqlAstNode;
                aliasedExpression.getExpression().accept(walker);
                sqlAppender.appendSql(" as ");
                sqlAppender.appendDoubleQuoteEscapedString(aliasedExpression.getAlias());
            } else {
                sqlAstNode.accept(walker);
            }
            separator = 44;
        }
        sqlAppender.appendSql(')');
    }
}

