/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.membership.role;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.membership.CommonLDAPGroupMapper;
import org.keycloak.storage.ldap.mappers.membership.CommonLDAPGroupMapperConfig;
import org.keycloak.storage.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.storage.ldap.mappers.membership.UserRolesRetrieveStrategy;
import org.keycloak.storage.ldap.mappers.membership.role.RoleLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.membership.role.RoleMapperConfig;
import org.keycloak.storage.user.SynchronizationResult;

public class RoleLDAPStorageMapper
extends AbstractLDAPStorageMapper
implements CommonLDAPGroupMapper {
    private static final Logger logger = Logger.getLogger(RoleLDAPStorageMapper.class);
    private final RoleMapperConfig config;
    private final RoleLDAPStorageMapperFactory factory;

    public RoleLDAPStorageMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider, RoleLDAPStorageMapperFactory factory) {
        super(mapperModel, ldapProvider);
        this.config = new RoleMapperConfig(mapperModel);
        this.factory = factory;
    }

    @Override
    public LDAPQuery createLDAPGroupQuery() {
        return this.createRoleQuery(false);
    }

    @Override
    public CommonLDAPGroupMapperConfig getConfig() {
        return this.config;
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
        LDAPGroupMapperMode mode = this.config.getMode();
        if (mode == LDAPGroupMapperMode.IMPORT && isCreate) {
            List<LDAPObject> ldapRoles = this.getLDAPRoleMappings(ldapUser);
            String roleNameAttr = this.config.getRoleNameLdapAttribute();
            RoleContainerModel roleContainer = this.getTargetRoleContainer(realm);
            if (roleContainer == null) {
                logger.warnf("Ignored client role grant for federation mapper '%s' as client not found: '%s'", (Object)this.mapperModel.getName(), (Object)this.config.getClientId());
                return;
            }
            for (LDAPObject ldapRole : ldapRoles) {
                String roleName = ldapRole.getAttributeAsString(roleNameAttr);
                RoleModel role = roleContainer.getRole(roleName);
                if (role == null) {
                    role = roleContainer.addRole(roleName);
                }
                logger.debugf("Granting role [%s] to user [%s] during import from LDAP", (Object)roleName, (Object)user.getUsername());
                user.grantRole(role);
            }
        }
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
    }

    @Override
    public SynchronizationResult syncDataFromFederationProviderToKeycloak(RealmModel realm) {
        SynchronizationResult syncResult = new SynchronizationResult(){

            public String getStatus() {
                return String.format("%d imported roles, %d roles already exists in Keycloak", this.getAdded(), this.getUpdated());
            }
        };
        logger.debugf("Syncing roles from LDAP into Keycloak DB. Mapper is [%s], LDAP provider is [%s]", (Object)this.mapperModel.getName(), (Object)this.ldapProvider.getModel().getName());
        RoleContainerModel roleContainer = this.getTargetRoleContainer(realm);
        if (roleContainer == null) {
            logger.warnf("Ignored sync for federation mapper '%s' as client not found: '%s'", (Object)this.mapperModel.getName(), (Object)this.config.getClientId());
            return syncResult;
        }
        try (LDAPQuery ldapRoleQuery = this.createRoleQuery(false);){
            List<LDAPObject> ldapRoles = LDAPUtils.loadAllLDAPObjects(ldapRoleQuery, this.ldapProvider);
            String rolesRdnAttr = this.config.getRoleNameLdapAttribute();
            for (LDAPObject ldapRole : ldapRoles) {
                String roleName = ldapRole.getAttributeAsString(rolesRdnAttr);
                if (roleContainer.getRole(roleName) == null) {
                    logger.debugf("Syncing role [%s] from LDAP to keycloak DB", (Object)roleName);
                    roleContainer.addRole(roleName);
                    syncResult.increaseAdded();
                    continue;
                }
                syncResult.increaseUpdated();
            }
            Iterator<LDAPObject> iterator = syncResult;
            return iterator;
        }
    }

    @Override
    public SynchronizationResult syncDataFromKeycloakToFederationProvider(RealmModel realm) {
        SynchronizationResult syncResult = new SynchronizationResult(){

            public String getStatus() {
                return String.format("%d roles imported to LDAP, %d roles already existed in LDAP", this.getAdded(), this.getUpdated());
            }
        };
        if (this.config.getMode() != LDAPGroupMapperMode.LDAP_ONLY) {
            logger.warnf("Ignored sync for federation mapper '%s' as it's mode is '%s'", (Object)this.mapperModel.getName(), (Object)this.config.getMode().toString());
            return syncResult;
        }
        logger.debugf("Syncing roles from Keycloak into LDAP. Mapper is [%s], LDAP provider is [%s]", (Object)this.mapperModel.getName(), (Object)this.ldapProvider.getModel().getName());
        RoleContainerModel roleContainer = this.getTargetRoleContainer(realm);
        if (roleContainer == null) {
            logger.warnf("Ignored sync for federation mapper '%s' as client not found: '%s'", (Object)this.mapperModel.getName(), (Object)this.config.getClientId());
            return syncResult;
        }
        try (LDAPQuery ldapQuery = this.createRoleQuery(false);){
            List<LDAPObject> ldapRoles = LDAPUtils.loadAllLDAPObjects(ldapQuery, this.ldapProvider);
            HashSet<String> ldapRoleNames = new HashSet<String>();
            String rolesRdnAttr = this.config.getRoleNameLdapAttribute();
            for (LDAPObject ldapRole : ldapRoles) {
                String roleName2 = ldapRole.getAttributeAsString(rolesRdnAttr);
                ldapRoleNames.add(roleName2);
            }
            Stream keycloakRoles = roleContainer.getRolesStream();
            Consumer<String> syncRoleFromKCToLDAP = roleName -> {
                if (ldapRoleNames.contains(roleName)) {
                    syncResult.increaseUpdated();
                } else {
                    logger.debugf("Syncing role [%s] from Keycloak to LDAP", roleName);
                    this.createLDAPRole((String)roleName);
                    syncResult.increaseAdded();
                }
            };
            keycloakRoles.map(RoleModel::getName).forEach(syncRoleFromKCToLDAP);
            SynchronizationResult synchronizationResult = syncResult;
            return synchronizationResult;
        }
    }

    public LDAPQuery createRoleQuery(boolean includeMemberAttribute) {
        LDAPQuery ldapQuery = new LDAPQuery(this.ldapProvider);
        ldapQuery.setSearchScope(this.ldapProvider.getLdapIdentityStore().getConfig().getSearchScope());
        String rolesDn = this.config.getRolesDn();
        ldapQuery.setSearchDn(rolesDn);
        Collection<String> roleObjectClasses = this.config.getRoleObjectClasses(this.ldapProvider);
        ldapQuery.addObjectClasses(roleObjectClasses);
        String rolesRdnAttr = this.config.getRoleNameLdapAttribute();
        String customFilter = this.config.getCustomLdapFilter();
        if (customFilter != null && customFilter.trim().length() > 0) {
            Condition customFilterCondition = new LDAPQueryConditionsBuilder().addCustomLDAPFilter(customFilter);
            ldapQuery.addWhereCondition(customFilterCondition);
        }
        ldapQuery.addReturningLdapAttribute(rolesRdnAttr);
        if (includeMemberAttribute) {
            String membershipAttr = this.config.getMembershipLdapAttribute();
            ldapQuery.addReturningLdapAttribute(membershipAttr);
        }
        return ldapQuery;
    }

    protected RoleContainerModel getTargetRoleContainer(RealmModel realm) {
        boolean realmRolesMapping = this.config.isRealmRolesMapping();
        if (realmRolesMapping) {
            return realm;
        }
        String clientId = this.config.getClientId();
        if (clientId == null) {
            throw new ModelException("Using client roles mapping is requested, but parameter client.id not found!");
        }
        ClientModel client = realm.getClientByClientId(clientId);
        if (client == null) {
            logger.warnf("Cannot find requested client with clientId '%s' in federation mapper '%s'", (Object)clientId, (Object)this.mapperModel.getName());
        }
        return client;
    }

    public LDAPObject createLDAPRole(String roleName) {
        LDAPObject ldapRole = LDAPUtils.createLDAPGroup(this.ldapProvider, roleName, this.config.getRoleNameLdapAttribute(), this.config.getRoleObjectClasses(this.ldapProvider), this.config.getRelativeCreateDn() + this.config.getRolesDn(), Collections.emptyMap(), this.config.getMembershipLdapAttribute());
        logger.debugf("Creating role [%s] to LDAP with DN [%s]", (Object)roleName, (Object)ldapRole.getDn().toString());
        return ldapRole;
    }

    public void addRoleMappingInLDAP(String roleName, LDAPObject ldapUser) {
        LDAPObject ldapRole = this.loadLDAPRoleByName(roleName);
        if (ldapRole == null) {
            ldapRole = this.createLDAPRole(roleName);
        }
        String membershipUserAttrName = this.getMembershipUserLdapAttribute();
        LDAPUtils.addMember(this.ldapProvider, this.config.getMembershipTypeLdapAttribute(), this.config.getMembershipLdapAttribute(), membershipUserAttrName, ldapRole, ldapUser);
    }

    public void deleteRoleMappingInLDAP(LDAPObject ldapUser, LDAPObject ldapRole) {
        String membershipUserAttrName = this.getMembershipUserLdapAttribute();
        LDAPUtils.deleteMember(this.ldapProvider, this.config.getMembershipTypeLdapAttribute(), this.config.getMembershipLdapAttribute(), membershipUserAttrName, ldapRole, ldapUser);
    }

    public LDAPObject loadLDAPRoleByName(String roleName) {
        try (LDAPQuery ldapQuery = this.createRoleQuery(true);){
            Condition roleNameCondition = new LDAPQueryConditionsBuilder().equal(this.config.getRoleNameLdapAttribute(), roleName);
            ldapQuery.addWhereCondition(roleNameCondition);
            LDAPObject lDAPObject = ldapQuery.getFirstResult();
            return lDAPObject;
        }
    }

    protected List<LDAPObject> getLDAPRoleMappings(LDAPObject ldapUser) {
        String strategyKey = this.config.getUserRolesRetrieveStrategy();
        UserRolesRetrieveStrategy strategy = this.factory.getUserRolesRetrieveStrategy(strategyKey);
        LDAPConfig ldapConfig = this.ldapProvider.getLdapIdentityStore().getConfig();
        return strategy.getLDAPRoleMappings(this, ldapUser, ldapConfig);
    }

    @Override
    public UserModel proxy(LDAPObject ldapUser, UserModel delegate, RealmModel realm) {
        LDAPGroupMapperMode mode = this.config.getMode();
        if (mode == LDAPGroupMapperMode.IMPORT) {
            return delegate;
        }
        RoleContainerModel targetRoleContainer = this.getTargetRoleContainer(realm);
        if (targetRoleContainer == null) {
            return delegate;
        }
        return new LDAPRoleMappingsUserDelegate(realm, delegate, ldapUser, targetRoleContainer);
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
        String strategyKey = this.config.getUserRolesRetrieveStrategy();
        UserRolesRetrieveStrategy strategy = this.factory.getUserRolesRetrieveStrategy(strategyKey);
        strategy.beforeUserLDAPQuery(this, query);
    }

    protected String getMembershipUserLdapAttribute() {
        LDAPConfig ldapConfig = this.ldapProvider.getLdapIdentityStore().getConfig();
        return this.config.getMembershipUserLdapAttribute(ldapConfig);
    }

    public LDAPObject loadRoleGroupByName(String roleName) {
        try (LDAPQuery ldapQuery = this.createRoleQuery(true);){
            Condition roleNameCondition = new LDAPQueryConditionsBuilder().equal(this.config.getRoleNameLdapAttribute(), roleName);
            ldapQuery.addWhereCondition(roleNameCondition);
            LDAPObject lDAPObject = ldapQuery.getFirstResult();
            return lDAPObject;
        }
    }

    @Override
    public List<UserModel> getRoleMembers(RealmModel realm, RoleModel role, int firstResult, int maxResults) {
        if (this.config.getMode() == LDAPGroupMapperMode.IMPORT) {
            return Collections.emptyList();
        }
        LDAPObject ldapGroup = this.loadRoleGroupByName(role.getName());
        if (ldapGroup == null) {
            return Collections.emptyList();
        }
        String strategyKey = this.config.getUserRolesRetrieveStrategy();
        UserRolesRetrieveStrategy strategy = this.factory.getUserRolesRetrieveStrategy(strategyKey);
        return strategy.getLDAPRoleMembers(realm, this, ldapGroup, firstResult, maxResults);
    }

    public class LDAPRoleMappingsUserDelegate
    extends UserModelDelegate {
        private final RealmModel realm;
        private final LDAPObject ldapUser;
        private final RoleContainerModel roleContainer;
        private Set<RoleModel> cachedLDAPRoleMappings;

        public LDAPRoleMappingsUserDelegate(RealmModel realm, UserModel user, LDAPObject ldapUser, RoleContainerModel targetRoleContainer) {
            super(user);
            this.realm = realm;
            this.ldapUser = ldapUser;
            this.roleContainer = targetRoleContainer;
        }

        public Stream<RoleModel> getRealmRoleMappingsStream() {
            if (this.roleContainer.equals((Object)this.realm)) {
                Stream<RoleModel> ldapRoleMappings = this.getLDAPRoleMappingsConverted();
                if (RoleLDAPStorageMapper.this.config.getMode() == LDAPGroupMapperMode.LDAP_ONLY) {
                    return ldapRoleMappings;
                }
                return Stream.concat(ldapRoleMappings, super.getRealmRoleMappingsStream());
            }
            return super.getRealmRoleMappingsStream();
        }

        public Stream<RoleModel> getClientRoleMappingsStream(ClientModel client) {
            if (this.roleContainer.equals((Object)client)) {
                Stream<RoleModel> ldapRoleMappings = this.getLDAPRoleMappingsConverted();
                if (RoleLDAPStorageMapper.this.config.getMode() == LDAPGroupMapperMode.LDAP_ONLY) {
                    return ldapRoleMappings;
                }
                return Stream.concat(ldapRoleMappings, super.getClientRoleMappingsStream(client));
            }
            return super.getClientRoleMappingsStream(client);
        }

        public boolean hasRole(RoleModel role) {
            return RoleUtils.hasRole(this.getRoleMappingsStream(), (RoleModel)role) || RoleUtils.hasRoleFromGroup((Stream)this.getGroupsStream(), (RoleModel)role, (boolean)true);
        }

        public void grantRole(RoleModel role) {
            if (RoleLDAPStorageMapper.this.config.getMode() == LDAPGroupMapperMode.LDAP_ONLY) {
                if (role.getContainer().equals((Object)this.roleContainer)) {
                    this.cachedLDAPRoleMappings = null;
                    RoleLDAPStorageMapper.this.addRoleMappingInLDAP(role.getName(), this.ldapUser);
                } else {
                    super.grantRole(role);
                }
            } else {
                super.grantRole(role);
            }
        }

        public Stream<RoleModel> getRoleMappingsStream() {
            Stream<RoleModel> modelRoleMappings = super.getRoleMappingsStream();
            Stream<RoleModel> ldapRoleMappings = this.getLDAPRoleMappingsConverted();
            if (RoleLDAPStorageMapper.this.config.getMode() == LDAPGroupMapperMode.LDAP_ONLY) {
                modelRoleMappings = modelRoleMappings.filter(role -> !Objects.equals(role.getContainer(), this.roleContainer));
            }
            return Stream.concat(modelRoleMappings, ldapRoleMappings);
        }

        protected Stream<RoleModel> getLDAPRoleMappingsConverted() {
            if (this.cachedLDAPRoleMappings != null) {
                return this.cachedLDAPRoleMappings.stream();
            }
            List<LDAPObject> ldapRoles = RoleLDAPStorageMapper.this.getLDAPRoleMappings(this.ldapUser);
            String roleNameLdapAttr = RoleLDAPStorageMapper.this.config.getRoleNameLdapAttribute();
            this.cachedLDAPRoleMappings = ldapRoles.stream().map(role -> {
                String roleName = role.getAttributeAsString(roleNameLdapAttr);
                RoleModel modelRole = this.roleContainer.getRole(roleName);
                if (modelRole == null) {
                    modelRole = this.roleContainer.addRole(roleName);
                }
                return modelRole;
            }).collect(Collectors.toSet());
            return this.cachedLDAPRoleMappings.stream();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void deleteRoleMapping(RoleModel role) {
            if (role.getContainer().equals((Object)this.roleContainer)) {
                try (LDAPQuery ldapQuery = RoleLDAPStorageMapper.this.createRoleQuery(true);){
                    LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
                    Condition roleNameCondition = conditionsBuilder.equal(RoleLDAPStorageMapper.this.config.getRoleNameLdapAttribute(), role.getName());
                    String membershipUserAttrName = RoleLDAPStorageMapper.this.getMembershipUserLdapAttribute();
                    String membershipUserAttr = LDAPUtils.getMemberValueOfChildObject(this.ldapUser, RoleLDAPStorageMapper.this.config.getMembershipTypeLdapAttribute(), membershipUserAttrName);
                    Condition membershipCondition = conditionsBuilder.equal(RoleLDAPStorageMapper.this.config.getMembershipLdapAttribute(), membershipUserAttr);
                    ldapQuery.addWhereCondition(roleNameCondition).addWhereCondition(membershipCondition);
                    LDAPObject ldapRole = ldapQuery.getFirstResult();
                    if (ldapRole == null) {
                        if (RoleLDAPStorageMapper.this.config.getMode() != LDAPGroupMapperMode.READ_ONLY) return;
                        super.deleteRoleMapping(role);
                        return;
                    }
                    if (RoleLDAPStorageMapper.this.config.getMode() == LDAPGroupMapperMode.READ_ONLY) {
                        throw new ModelException("Not possible to delete LDAP role mappings as mapper mode is READ_ONLY");
                    }
                    this.cachedLDAPRoleMappings = null;
                    RoleLDAPStorageMapper.this.deleteRoleMappingInLDAP(this.ldapUser, ldapRole);
                    return;
                }
            } else {
                super.deleteRoleMapping(role);
            }
        }
    }
}

