/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode;

import io.quarkus.deployment.dev.remote.RemoteDevClient;
import io.quarkus.deployment.dev.remote.RemoteDevClientProvider;
import io.quarkus.runtime.LiveReloadConfig;
import io.quarkus.vertx.http.deployment.devmode.HttpRemoteDevClient;
import io.smallrye.config.SmallRyeConfig;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;

public class HttpRemoteDevClientProvider
implements RemoteDevClientProvider {
    public Optional<RemoteDevClient> getClient() {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        LiveReloadConfig liveReloadConfig = (LiveReloadConfig)config.getConfigMapping(LiveReloadConfig.class);
        if (!liveReloadConfig.url().isPresent()) {
            return Optional.empty();
        }
        if (!liveReloadConfig.password().isPresent()) {
            throw new RuntimeException("Live reload URL set but no password, remote dev requires a password, set quarkus.live-reload.password on both server and client");
        }
        return Optional.of(new HttpRemoteDevClient((String)liveReloadConfig.url().get(), (String)liveReloadConfig.password().get(), liveReloadConfig.connectTimeout(), liveReloadConfig.retryInterval(), liveReloadConfig.retryMaxAttempts()));
    }
}

