/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.MapperTypeSerializer;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.context.PreAuthorizationRequestContext;

public class ClientAttributesCondition
extends AbstractClientPolicyConditionProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(ClientAttributesCondition.class);

    public ClientAttributesCondition(KeycloakSession session) {
        super(session);
    }

    public Class<Configuration> getConditionConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "client-attributes";
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case PRE_AUTHORIZATION_REQUEST: {
                PreAuthorizationRequestContext paContext = (PreAuthorizationRequestContext)context;
                ClientModel client = this.session.getContext().getRealm().getClientByClientId(paContext.getClientId());
                if (this.isAttributesMatched(client)) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
            case AUTHORIZATION_REQUEST: 
            case TOKEN_REQUEST: 
            case TOKEN_RESPONSE: 
            case SERVICE_ACCOUNT_TOKEN_REQUEST: 
            case SERVICE_ACCOUNT_TOKEN_RESPONSE: 
            case TOKEN_REFRESH: 
            case TOKEN_REFRESH_RESPONSE: 
            case TOKEN_REVOKE: 
            case TOKEN_INTROSPECT: 
            case USERINFO_REQUEST: 
            case LOGOUT_REQUEST: 
            case BACKCHANNEL_AUTHENTICATION_REQUEST: 
            case BACKCHANNEL_TOKEN_REQUEST: 
            case BACKCHANNEL_TOKEN_RESPONSE: 
            case PUSHED_AUTHORIZATION_REQUEST: 
            case REGISTERED: 
            case UPDATE: 
            case UPDATED: 
            case TOKEN_EXCHANGE_REQUEST: 
            case JWT_AUTHORIZATION_GRANT: 
            case SAML_AUTHN_REQUEST: 
            case SAML_LOGOUT_REQUEST: {
                if (this.isAttributesMatched(this.session.getContext().getClient())) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private boolean isAttributesMatched(ClientModel client) {
        if (client == null) {
            return false;
        }
        Map<String, List<String>> attributesForMatching = this.getAttributesForMatching();
        if (attributesForMatching == null) {
            return false;
        }
        Map clientAttributes = client.getAttributes();
        if (logger.isTraceEnabled()) {
            clientAttributes.forEach((i, j) -> logger.tracev("client attribute assigned = {0}: {1}", i, j));
            attributesForMatching.forEach((i, j) -> logger.tracev("client attribute for matching = {0}: {1}", i, j));
        }
        return attributesForMatching.entrySet().stream().allMatch(entry -> {
            String key = (String)entry.getKey();
            if (key == null) {
                logger.warnf("Empty key in configuration of client-attributes condition", new Object[0]);
                return false;
            }
            if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) {
                logger.warnf("Empty value in the configuration of client-attributes condition for the attribute %s. This cannot match any client", (Object)key);
                return false;
            }
            if (((List)entry.getValue()).size() > 1) {
                logger.warnf("More values in the configuration of client-attributes condition for the attribute %s. This cannot match any client", (Object)key);
                return false;
            }
            String value = (String)((List)entry.getValue()).get(0);
            return clientAttributes.containsKey(key) && ((String)clientAttributes.get(key)).equals(value);
        });
    }

    private Map<String, List<String>> getAttributesForMatching() {
        if (((Configuration)this.configuration).getAttributes() == null) {
            return null;
        }
        return MapperTypeSerializer.deserialize((String)((Configuration)this.configuration).getAttributes());
    }

    public static class Configuration
    extends ClientPolicyConditionConfigurationRepresentation {
        private String attributes;

        public String getAttributes() {
            return this.attributes;
        }

        public void setAttributes(String attributes) {
            this.attributes = attributes;
        }
    }
}

