/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.Collections;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonNullBehavior;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.type.spi.TypeConfiguration;

public class JsonArrayAggFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    protected final boolean supportsFilter;

    public JsonArrayAggFunction(boolean supportsFilter, TypeConfiguration typeConfiguration) {
        super("json_arrayagg", FunctionKind.ORDERED_SET_AGGREGATE, StandardArgumentsValidators.between(1, 2), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(String.class, 3001)), null);
        this.supportsFilter = supportsFilter;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, null, Collections.emptyList(), returnType, walker);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, List<SortSpecification> withinGroup, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        Expression arg;
        boolean caseWrapper = filter != null && !JsonArrayAggFunction.filterClauseSupported(translator);
        sqlAppender.appendSql("json_arrayagg(");
        SqlAstNode firstArg = sqlAstArguments.get(0);
        JsonNullBehavior nullBehavior = sqlAstArguments.size() > 1 ? (JsonNullBehavior)sqlAstArguments.get(1) : JsonNullBehavior.ABSENT;
        if (firstArg instanceof Distinct) {
            Distinct distinct = (Distinct)firstArg;
            sqlAppender.appendSql("distinct ");
            arg = distinct.getExpression();
        } else {
            arg = (Expression)firstArg;
        }
        if (caseWrapper) {
            if (nullBehavior != JsonNullBehavior.ABSENT) {
                throw new QueryException("Can't emulate json_arrayagg filter clause when using 'null on null' clause.");
            }
            translator.getCurrentClauseStack().push(Clause.WHERE);
            sqlAppender.appendSql("case when ");
            filter.accept(translator);
            translator.getCurrentClauseStack().pop();
            sqlAppender.appendSql(" then ");
            this.renderArgument(sqlAppender, arg, nullBehavior, translator);
            sqlAppender.appendSql(" else null end)");
        } else {
            this.renderArgument(sqlAppender, arg, nullBehavior, translator);
        }
        if (withinGroup != null && !withinGroup.isEmpty()) {
            translator.getCurrentClauseStack().push(Clause.WITHIN_GROUP);
            sqlAppender.appendSql(" order by ");
            withinGroup.get(0).accept(translator);
            for (int i = 1; i < withinGroup.size(); ++i) {
                sqlAppender.appendSql(',');
                withinGroup.get(i).accept(translator);
            }
            translator.getCurrentClauseStack().pop();
        }
        if (nullBehavior == JsonNullBehavior.NULL) {
            sqlAppender.appendSql(" null on null");
        } else {
            sqlAppender.appendSql(" absent on null");
        }
        this.renderReturningClause(sqlAppender, arg, translator);
        sqlAppender.appendSql(')');
        if (!caseWrapper && filter != null) {
            translator.getCurrentClauseStack().push(Clause.WHERE);
            sqlAppender.appendSql(" filter (where ");
            filter.accept(translator);
            sqlAppender.appendSql(')');
            translator.getCurrentClauseStack().pop();
        }
    }

    protected void renderArgument(SqlAppender sqlAppender, Expression arg, JsonNullBehavior nullBehavior, SqlAstTranslator<?> translator) {
        arg.accept(translator);
    }

    protected void renderReturningClause(SqlAppender sqlAppender, Expression arg, SqlAstTranslator<?> translator) {
        sqlAppender.appendSql(" returning ");
        sqlAppender.appendSql(translator.getSessionFactory().getTypeConfiguration().getDdlTypeRegistry().getTypeName(3001, translator.getSessionFactory().getJdbcServices().getDialect()));
    }
}

