/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.listeners;

import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.util.concurrent.BlockingManager;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.listeners.BaseUserSessionExpirationListener;

@Listener(primaryOnly=true)
public class EmbeddedUserSessionExpirationListener
extends BaseUserSessionExpirationListener {
    public EmbeddedUserSessionExpirationListener(KeycloakSessionFactory factory, BlockingManager blockingManager) {
        super(factory, blockingManager);
    }

    @CacheEntryExpired
    public void onSessionExpired(CacheEntryExpiredEvent<?, SessionEntityWrapper<UserSessionEntity>> event) {
        UserSessionEntity entity = (UserSessionEntity)((SessionEntityWrapper)event.getValue()).getEntity();
        this.sendExpirationEvent(entity.getId(), entity.getUser(), entity.getRealmId());
    }
}

