/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.api;

import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.netbeans.modules.docker.api.DockerInstance;

public final class DockerEvent
extends EventObject {
    private final DockerInstance instance;
    private final Status status;
    private final String id;
    private final String from;
    private final long time;

    DockerEvent(DockerInstance instance, Status status, String id, String from, long time) {
        super(instance);
        this.instance = instance;
        this.status = status;
        this.id = id;
        this.from = from;
        this.time = time;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getId() {
        return this.id;
    }

    public String getFrom() {
        return this.from;
    }

    public long getTime() {
        return this.time;
    }

    @Override
    public DockerInstance getSource() {
        return this.instance;
    }

    public boolean equalsIgnoringTime(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockerEvent other = (DockerEvent)obj;
        if (!Objects.equals((Object)this.status, (Object)other.status)) {
            return false;
        }
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return Objects.equals(this.from, other.from);
    }

    @Override
    public String toString() {
        return "DockerEvent{status=" + (Object)((Object)this.status) + ", id=" + this.id + ", from=" + this.from + ", time=" + this.time + '}';
    }

    public int hashCode() {
        int hash = 3;
        hash = 73 * hash + Objects.hashCode((Object)this.status);
        hash = 73 * hash + Objects.hashCode(this.id);
        hash = 73 * hash + Objects.hashCode(this.from);
        hash = 73 * hash + (int)(this.time ^ this.time >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockerEvent other = (DockerEvent)obj;
        if (this.time != other.time) {
            return false;
        }
        if (!Objects.equals((Object)this.status, (Object)other.status)) {
            return false;
        }
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return Objects.equals(this.from, other.from);
    }

    public static enum Status {
        ATTACH("attach", true),
        COMMIT("commit", false),
        COPY("copy", true),
        CREATE("create", true),
        DESTROY("destroy", true),
        DIE("die", true),
        EXEC_CREATE("exec_create", true),
        EXEC_START("exec_start", true),
        EXPORT("export", true),
        KILL("kill", true),
        OOM("oom", true),
        PAUSE("pause", true),
        RENAME("rename", true),
        RESIZE("resize", true),
        RESTART("restart", true),
        START("start", true),
        STOP("stop", true),
        TOP("top", true),
        UNPAUSE("unpause", true),
        DELETE("delete", false),
        IMPORT("import", false),
        PULL("pull", false),
        PUSH("push", false),
        TAG("tag", false),
        UNTAG("untag", false);

        private static final Map<String, Status> VALUES;
        private final String text;
        private final boolean container;

        private Status(String text, boolean container) {
            this.text = text;
            this.container = container;
        }

        public static Status parse(String text) {
            return VALUES.get(text);
        }

        public String getText() {
            return this.text;
        }

        public boolean isContainer() {
            return this.container;
        }

        static {
            VALUES = new HashMap<String, Status>();
            for (Status s : Status.values()) {
                VALUES.put(s.getText(), s);
            }
        }
    }

    public static interface Listener
    extends EventListener {
        public void onEvent(DockerEvent var1);
    }
}

