/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.identity.IdentityAsync;
import com.oracle.bmc.identity.model.AllowedDomainLicenseTypeSummary;
import com.oracle.bmc.identity.model.ApiKey;
import com.oracle.bmc.identity.model.AuthToken;
import com.oracle.bmc.identity.model.AuthenticationPolicy;
import com.oracle.bmc.identity.model.AvailabilityDomain;
import com.oracle.bmc.identity.model.BulkActionResourceTypeCollection;
import com.oracle.bmc.identity.model.BulkEditTagsResourceTypeCollection;
import com.oracle.bmc.identity.model.Compartment;
import com.oracle.bmc.identity.model.CustomerSecretKey;
import com.oracle.bmc.identity.model.CustomerSecretKeySummary;
import com.oracle.bmc.identity.model.DbCredential;
import com.oracle.bmc.identity.model.DbCredentialSummary;
import com.oracle.bmc.identity.model.Domain;
import com.oracle.bmc.identity.model.DomainSummary;
import com.oracle.bmc.identity.model.DynamicGroup;
import com.oracle.bmc.identity.model.FaultDomain;
import com.oracle.bmc.identity.model.Group;
import com.oracle.bmc.identity.model.IamWorkRequest;
import com.oracle.bmc.identity.model.IamWorkRequestErrorSummary;
import com.oracle.bmc.identity.model.IamWorkRequestLogSummary;
import com.oracle.bmc.identity.model.IamWorkRequestSummary;
import com.oracle.bmc.identity.model.IdentityProvider;
import com.oracle.bmc.identity.model.IdentityProviderGroupSummary;
import com.oracle.bmc.identity.model.IdpGroupMapping;
import com.oracle.bmc.identity.model.MfaTotpDevice;
import com.oracle.bmc.identity.model.MfaTotpDeviceSummary;
import com.oracle.bmc.identity.model.NetworkSources;
import com.oracle.bmc.identity.model.NetworkSourcesSummary;
import com.oracle.bmc.identity.model.OAuth2ClientCredential;
import com.oracle.bmc.identity.model.OAuth2ClientCredentialSummary;
import com.oracle.bmc.identity.model.Policy;
import com.oracle.bmc.identity.model.Region;
import com.oracle.bmc.identity.model.RegionSubscription;
import com.oracle.bmc.identity.model.ScimClientCredentials;
import com.oracle.bmc.identity.model.SmtpCredential;
import com.oracle.bmc.identity.model.SmtpCredentialSummary;
import com.oracle.bmc.identity.model.StandardTagNamespaceTemplate;
import com.oracle.bmc.identity.model.StandardTagNamespaceTemplateSummary;
import com.oracle.bmc.identity.model.SwiftPassword;
import com.oracle.bmc.identity.model.Tag;
import com.oracle.bmc.identity.model.TagDefault;
import com.oracle.bmc.identity.model.TagDefaultSummary;
import com.oracle.bmc.identity.model.TagNamespace;
import com.oracle.bmc.identity.model.TagNamespaceSummary;
import com.oracle.bmc.identity.model.TagSummary;
import com.oracle.bmc.identity.model.TaggingWorkRequest;
import com.oracle.bmc.identity.model.TaggingWorkRequestErrorSummary;
import com.oracle.bmc.identity.model.TaggingWorkRequestLogSummary;
import com.oracle.bmc.identity.model.TaggingWorkRequestSummary;
import com.oracle.bmc.identity.model.Tenancy;
import com.oracle.bmc.identity.model.UIPassword;
import com.oracle.bmc.identity.model.UIPasswordInformation;
import com.oracle.bmc.identity.model.User;
import com.oracle.bmc.identity.model.UserGroupMembership;
import com.oracle.bmc.identity.model.WorkRequest;
import com.oracle.bmc.identity.model.WorkRequestSummary;
import com.oracle.bmc.identity.requests.ActivateDomainRequest;
import com.oracle.bmc.identity.requests.ActivateMfaTotpDeviceRequest;
import com.oracle.bmc.identity.requests.AddTagDefaultLockRequest;
import com.oracle.bmc.identity.requests.AddTagNamespaceLockRequest;
import com.oracle.bmc.identity.requests.AddUserToGroupRequest;
import com.oracle.bmc.identity.requests.AssembleEffectiveTagSetRequest;
import com.oracle.bmc.identity.requests.BulkDeleteResourcesRequest;
import com.oracle.bmc.identity.requests.BulkDeleteTagsRequest;
import com.oracle.bmc.identity.requests.BulkEditTagsRequest;
import com.oracle.bmc.identity.requests.BulkMoveResourcesRequest;
import com.oracle.bmc.identity.requests.CascadeDeleteTagNamespaceRequest;
import com.oracle.bmc.identity.requests.ChangeDomainCompartmentRequest;
import com.oracle.bmc.identity.requests.ChangeDomainLicenseTypeRequest;
import com.oracle.bmc.identity.requests.ChangeTagNamespaceCompartmentRequest;
import com.oracle.bmc.identity.requests.CreateAuthTokenRequest;
import com.oracle.bmc.identity.requests.CreateCompartmentRequest;
import com.oracle.bmc.identity.requests.CreateCustomerSecretKeyRequest;
import com.oracle.bmc.identity.requests.CreateDbCredentialRequest;
import com.oracle.bmc.identity.requests.CreateDomainRequest;
import com.oracle.bmc.identity.requests.CreateDynamicGroupRequest;
import com.oracle.bmc.identity.requests.CreateGroupRequest;
import com.oracle.bmc.identity.requests.CreateIdentityProviderRequest;
import com.oracle.bmc.identity.requests.CreateIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.CreateMfaTotpDeviceRequest;
import com.oracle.bmc.identity.requests.CreateNetworkSourceRequest;
import com.oracle.bmc.identity.requests.CreateOAuthClientCredentialRequest;
import com.oracle.bmc.identity.requests.CreateOrResetUIPasswordRequest;
import com.oracle.bmc.identity.requests.CreatePolicyRequest;
import com.oracle.bmc.identity.requests.CreateRegionSubscriptionRequest;
import com.oracle.bmc.identity.requests.CreateSmtpCredentialRequest;
import com.oracle.bmc.identity.requests.CreateSwiftPasswordRequest;
import com.oracle.bmc.identity.requests.CreateTagDefaultRequest;
import com.oracle.bmc.identity.requests.CreateTagNamespaceRequest;
import com.oracle.bmc.identity.requests.CreateTagRequest;
import com.oracle.bmc.identity.requests.CreateUserRequest;
import com.oracle.bmc.identity.requests.DeactivateDomainRequest;
import com.oracle.bmc.identity.requests.DeleteApiKeyRequest;
import com.oracle.bmc.identity.requests.DeleteAuthTokenRequest;
import com.oracle.bmc.identity.requests.DeleteCompartmentRequest;
import com.oracle.bmc.identity.requests.DeleteCustomerSecretKeyRequest;
import com.oracle.bmc.identity.requests.DeleteDbCredentialRequest;
import com.oracle.bmc.identity.requests.DeleteDomainRequest;
import com.oracle.bmc.identity.requests.DeleteDynamicGroupRequest;
import com.oracle.bmc.identity.requests.DeleteGroupRequest;
import com.oracle.bmc.identity.requests.DeleteIdentityProviderRequest;
import com.oracle.bmc.identity.requests.DeleteIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.DeleteMfaTotpDeviceRequest;
import com.oracle.bmc.identity.requests.DeleteNetworkSourceRequest;
import com.oracle.bmc.identity.requests.DeleteOAuthClientCredentialRequest;
import com.oracle.bmc.identity.requests.DeletePolicyRequest;
import com.oracle.bmc.identity.requests.DeleteSmtpCredentialRequest;
import com.oracle.bmc.identity.requests.DeleteSwiftPasswordRequest;
import com.oracle.bmc.identity.requests.DeleteTagDefaultRequest;
import com.oracle.bmc.identity.requests.DeleteTagNamespaceRequest;
import com.oracle.bmc.identity.requests.DeleteTagRequest;
import com.oracle.bmc.identity.requests.DeleteUserRequest;
import com.oracle.bmc.identity.requests.EnableReplicationToRegionRequest;
import com.oracle.bmc.identity.requests.GenerateTotpSeedRequest;
import com.oracle.bmc.identity.requests.GetAuthenticationPolicyRequest;
import com.oracle.bmc.identity.requests.GetCompartmentRequest;
import com.oracle.bmc.identity.requests.GetDomainRequest;
import com.oracle.bmc.identity.requests.GetDynamicGroupRequest;
import com.oracle.bmc.identity.requests.GetGroupRequest;
import com.oracle.bmc.identity.requests.GetIamWorkRequestRequest;
import com.oracle.bmc.identity.requests.GetIdentityProviderRequest;
import com.oracle.bmc.identity.requests.GetIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.GetMfaTotpDeviceRequest;
import com.oracle.bmc.identity.requests.GetNetworkSourceRequest;
import com.oracle.bmc.identity.requests.GetPolicyRequest;
import com.oracle.bmc.identity.requests.GetStandardTagTemplateRequest;
import com.oracle.bmc.identity.requests.GetTagDefaultRequest;
import com.oracle.bmc.identity.requests.GetTagNamespaceRequest;
import com.oracle.bmc.identity.requests.GetTagRequest;
import com.oracle.bmc.identity.requests.GetTaggingWorkRequestRequest;
import com.oracle.bmc.identity.requests.GetTenancyRequest;
import com.oracle.bmc.identity.requests.GetUserGroupMembershipRequest;
import com.oracle.bmc.identity.requests.GetUserRequest;
import com.oracle.bmc.identity.requests.GetUserUIPasswordInformationRequest;
import com.oracle.bmc.identity.requests.GetWorkRequestRequest;
import com.oracle.bmc.identity.requests.ImportStandardTagsRequest;
import com.oracle.bmc.identity.requests.ListAllowedDomainLicenseTypesRequest;
import com.oracle.bmc.identity.requests.ListApiKeysRequest;
import com.oracle.bmc.identity.requests.ListAuthTokensRequest;
import com.oracle.bmc.identity.requests.ListAvailabilityDomainsRequest;
import com.oracle.bmc.identity.requests.ListBulkActionResourceTypesRequest;
import com.oracle.bmc.identity.requests.ListBulkEditTagsResourceTypesRequest;
import com.oracle.bmc.identity.requests.ListCompartmentsRequest;
import com.oracle.bmc.identity.requests.ListCostTrackingTagsRequest;
import com.oracle.bmc.identity.requests.ListCustomerSecretKeysRequest;
import com.oracle.bmc.identity.requests.ListDbCredentialsRequest;
import com.oracle.bmc.identity.requests.ListDomainsRequest;
import com.oracle.bmc.identity.requests.ListDynamicGroupsRequest;
import com.oracle.bmc.identity.requests.ListFaultDomainsRequest;
import com.oracle.bmc.identity.requests.ListGroupsRequest;
import com.oracle.bmc.identity.requests.ListIamWorkRequestErrorsRequest;
import com.oracle.bmc.identity.requests.ListIamWorkRequestLogsRequest;
import com.oracle.bmc.identity.requests.ListIamWorkRequestsRequest;
import com.oracle.bmc.identity.requests.ListIdentityProviderGroupsRequest;
import com.oracle.bmc.identity.requests.ListIdentityProvidersRequest;
import com.oracle.bmc.identity.requests.ListIdpGroupMappingsRequest;
import com.oracle.bmc.identity.requests.ListMfaTotpDevicesRequest;
import com.oracle.bmc.identity.requests.ListNetworkSourcesRequest;
import com.oracle.bmc.identity.requests.ListOAuthClientCredentialsRequest;
import com.oracle.bmc.identity.requests.ListPoliciesRequest;
import com.oracle.bmc.identity.requests.ListRegionSubscriptionsRequest;
import com.oracle.bmc.identity.requests.ListRegionsRequest;
import com.oracle.bmc.identity.requests.ListSmtpCredentialsRequest;
import com.oracle.bmc.identity.requests.ListStandardTagNamespacesRequest;
import com.oracle.bmc.identity.requests.ListSwiftPasswordsRequest;
import com.oracle.bmc.identity.requests.ListTagDefaultsRequest;
import com.oracle.bmc.identity.requests.ListTagNamespacesRequest;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestErrorsRequest;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestLogsRequest;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestsRequest;
import com.oracle.bmc.identity.requests.ListTagsRequest;
import com.oracle.bmc.identity.requests.ListUserGroupMembershipsRequest;
import com.oracle.bmc.identity.requests.ListUsersRequest;
import com.oracle.bmc.identity.requests.ListWorkRequestsRequest;
import com.oracle.bmc.identity.requests.MoveCompartmentRequest;
import com.oracle.bmc.identity.requests.RecoverCompartmentRequest;
import com.oracle.bmc.identity.requests.RemoveTagDefaultLockRequest;
import com.oracle.bmc.identity.requests.RemoveTagNamespaceLockRequest;
import com.oracle.bmc.identity.requests.RemoveUserFromGroupRequest;
import com.oracle.bmc.identity.requests.ResetIdpScimClientRequest;
import com.oracle.bmc.identity.requests.UpdateAuthTokenRequest;
import com.oracle.bmc.identity.requests.UpdateAuthenticationPolicyRequest;
import com.oracle.bmc.identity.requests.UpdateCompartmentRequest;
import com.oracle.bmc.identity.requests.UpdateCustomerSecretKeyRequest;
import com.oracle.bmc.identity.requests.UpdateDomainRequest;
import com.oracle.bmc.identity.requests.UpdateDynamicGroupRequest;
import com.oracle.bmc.identity.requests.UpdateGroupRequest;
import com.oracle.bmc.identity.requests.UpdateIdentityProviderRequest;
import com.oracle.bmc.identity.requests.UpdateIdpGroupMappingRequest;
import com.oracle.bmc.identity.requests.UpdateNetworkSourceRequest;
import com.oracle.bmc.identity.requests.UpdateOAuthClientCredentialRequest;
import com.oracle.bmc.identity.requests.UpdatePolicyRequest;
import com.oracle.bmc.identity.requests.UpdateSmtpCredentialRequest;
import com.oracle.bmc.identity.requests.UpdateSwiftPasswordRequest;
import com.oracle.bmc.identity.requests.UpdateTagDefaultRequest;
import com.oracle.bmc.identity.requests.UpdateTagNamespaceRequest;
import com.oracle.bmc.identity.requests.UpdateTagRequest;
import com.oracle.bmc.identity.requests.UpdateUserCapabilitiesRequest;
import com.oracle.bmc.identity.requests.UpdateUserRequest;
import com.oracle.bmc.identity.requests.UpdateUserStateRequest;
import com.oracle.bmc.identity.requests.UploadApiKeyRequest;
import com.oracle.bmc.identity.responses.ActivateDomainResponse;
import com.oracle.bmc.identity.responses.ActivateMfaTotpDeviceResponse;
import com.oracle.bmc.identity.responses.AddTagDefaultLockResponse;
import com.oracle.bmc.identity.responses.AddTagNamespaceLockResponse;
import com.oracle.bmc.identity.responses.AddUserToGroupResponse;
import com.oracle.bmc.identity.responses.AssembleEffectiveTagSetResponse;
import com.oracle.bmc.identity.responses.BulkDeleteResourcesResponse;
import com.oracle.bmc.identity.responses.BulkDeleteTagsResponse;
import com.oracle.bmc.identity.responses.BulkEditTagsResponse;
import com.oracle.bmc.identity.responses.BulkMoveResourcesResponse;
import com.oracle.bmc.identity.responses.CascadeDeleteTagNamespaceResponse;
import com.oracle.bmc.identity.responses.ChangeDomainCompartmentResponse;
import com.oracle.bmc.identity.responses.ChangeDomainLicenseTypeResponse;
import com.oracle.bmc.identity.responses.ChangeTagNamespaceCompartmentResponse;
import com.oracle.bmc.identity.responses.CreateAuthTokenResponse;
import com.oracle.bmc.identity.responses.CreateCompartmentResponse;
import com.oracle.bmc.identity.responses.CreateCustomerSecretKeyResponse;
import com.oracle.bmc.identity.responses.CreateDbCredentialResponse;
import com.oracle.bmc.identity.responses.CreateDomainResponse;
import com.oracle.bmc.identity.responses.CreateDynamicGroupResponse;
import com.oracle.bmc.identity.responses.CreateGroupResponse;
import com.oracle.bmc.identity.responses.CreateIdentityProviderResponse;
import com.oracle.bmc.identity.responses.CreateIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.CreateMfaTotpDeviceResponse;
import com.oracle.bmc.identity.responses.CreateNetworkSourceResponse;
import com.oracle.bmc.identity.responses.CreateOAuthClientCredentialResponse;
import com.oracle.bmc.identity.responses.CreateOrResetUIPasswordResponse;
import com.oracle.bmc.identity.responses.CreatePolicyResponse;
import com.oracle.bmc.identity.responses.CreateRegionSubscriptionResponse;
import com.oracle.bmc.identity.responses.CreateSmtpCredentialResponse;
import com.oracle.bmc.identity.responses.CreateSwiftPasswordResponse;
import com.oracle.bmc.identity.responses.CreateTagDefaultResponse;
import com.oracle.bmc.identity.responses.CreateTagNamespaceResponse;
import com.oracle.bmc.identity.responses.CreateTagResponse;
import com.oracle.bmc.identity.responses.CreateUserResponse;
import com.oracle.bmc.identity.responses.DeactivateDomainResponse;
import com.oracle.bmc.identity.responses.DeleteApiKeyResponse;
import com.oracle.bmc.identity.responses.DeleteAuthTokenResponse;
import com.oracle.bmc.identity.responses.DeleteCompartmentResponse;
import com.oracle.bmc.identity.responses.DeleteCustomerSecretKeyResponse;
import com.oracle.bmc.identity.responses.DeleteDbCredentialResponse;
import com.oracle.bmc.identity.responses.DeleteDomainResponse;
import com.oracle.bmc.identity.responses.DeleteDynamicGroupResponse;
import com.oracle.bmc.identity.responses.DeleteGroupResponse;
import com.oracle.bmc.identity.responses.DeleteIdentityProviderResponse;
import com.oracle.bmc.identity.responses.DeleteIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.DeleteMfaTotpDeviceResponse;
import com.oracle.bmc.identity.responses.DeleteNetworkSourceResponse;
import com.oracle.bmc.identity.responses.DeleteOAuthClientCredentialResponse;
import com.oracle.bmc.identity.responses.DeletePolicyResponse;
import com.oracle.bmc.identity.responses.DeleteSmtpCredentialResponse;
import com.oracle.bmc.identity.responses.DeleteSwiftPasswordResponse;
import com.oracle.bmc.identity.responses.DeleteTagDefaultResponse;
import com.oracle.bmc.identity.responses.DeleteTagNamespaceResponse;
import com.oracle.bmc.identity.responses.DeleteTagResponse;
import com.oracle.bmc.identity.responses.DeleteUserResponse;
import com.oracle.bmc.identity.responses.EnableReplicationToRegionResponse;
import com.oracle.bmc.identity.responses.GenerateTotpSeedResponse;
import com.oracle.bmc.identity.responses.GetAuthenticationPolicyResponse;
import com.oracle.bmc.identity.responses.GetCompartmentResponse;
import com.oracle.bmc.identity.responses.GetDomainResponse;
import com.oracle.bmc.identity.responses.GetDynamicGroupResponse;
import com.oracle.bmc.identity.responses.GetGroupResponse;
import com.oracle.bmc.identity.responses.GetIamWorkRequestResponse;
import com.oracle.bmc.identity.responses.GetIdentityProviderResponse;
import com.oracle.bmc.identity.responses.GetIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.GetMfaTotpDeviceResponse;
import com.oracle.bmc.identity.responses.GetNetworkSourceResponse;
import com.oracle.bmc.identity.responses.GetPolicyResponse;
import com.oracle.bmc.identity.responses.GetStandardTagTemplateResponse;
import com.oracle.bmc.identity.responses.GetTagDefaultResponse;
import com.oracle.bmc.identity.responses.GetTagNamespaceResponse;
import com.oracle.bmc.identity.responses.GetTagResponse;
import com.oracle.bmc.identity.responses.GetTaggingWorkRequestResponse;
import com.oracle.bmc.identity.responses.GetTenancyResponse;
import com.oracle.bmc.identity.responses.GetUserGroupMembershipResponse;
import com.oracle.bmc.identity.responses.GetUserResponse;
import com.oracle.bmc.identity.responses.GetUserUIPasswordInformationResponse;
import com.oracle.bmc.identity.responses.GetWorkRequestResponse;
import com.oracle.bmc.identity.responses.ImportStandardTagsResponse;
import com.oracle.bmc.identity.responses.ListAllowedDomainLicenseTypesResponse;
import com.oracle.bmc.identity.responses.ListApiKeysResponse;
import com.oracle.bmc.identity.responses.ListAuthTokensResponse;
import com.oracle.bmc.identity.responses.ListAvailabilityDomainsResponse;
import com.oracle.bmc.identity.responses.ListBulkActionResourceTypesResponse;
import com.oracle.bmc.identity.responses.ListBulkEditTagsResourceTypesResponse;
import com.oracle.bmc.identity.responses.ListCompartmentsResponse;
import com.oracle.bmc.identity.responses.ListCostTrackingTagsResponse;
import com.oracle.bmc.identity.responses.ListCustomerSecretKeysResponse;
import com.oracle.bmc.identity.responses.ListDbCredentialsResponse;
import com.oracle.bmc.identity.responses.ListDomainsResponse;
import com.oracle.bmc.identity.responses.ListDynamicGroupsResponse;
import com.oracle.bmc.identity.responses.ListFaultDomainsResponse;
import com.oracle.bmc.identity.responses.ListGroupsResponse;
import com.oracle.bmc.identity.responses.ListIamWorkRequestErrorsResponse;
import com.oracle.bmc.identity.responses.ListIamWorkRequestLogsResponse;
import com.oracle.bmc.identity.responses.ListIamWorkRequestsResponse;
import com.oracle.bmc.identity.responses.ListIdentityProviderGroupsResponse;
import com.oracle.bmc.identity.responses.ListIdentityProvidersResponse;
import com.oracle.bmc.identity.responses.ListIdpGroupMappingsResponse;
import com.oracle.bmc.identity.responses.ListMfaTotpDevicesResponse;
import com.oracle.bmc.identity.responses.ListNetworkSourcesResponse;
import com.oracle.bmc.identity.responses.ListOAuthClientCredentialsResponse;
import com.oracle.bmc.identity.responses.ListPoliciesResponse;
import com.oracle.bmc.identity.responses.ListRegionSubscriptionsResponse;
import com.oracle.bmc.identity.responses.ListRegionsResponse;
import com.oracle.bmc.identity.responses.ListSmtpCredentialsResponse;
import com.oracle.bmc.identity.responses.ListStandardTagNamespacesResponse;
import com.oracle.bmc.identity.responses.ListSwiftPasswordsResponse;
import com.oracle.bmc.identity.responses.ListTagDefaultsResponse;
import com.oracle.bmc.identity.responses.ListTagNamespacesResponse;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestErrorsResponse;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestLogsResponse;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestsResponse;
import com.oracle.bmc.identity.responses.ListTagsResponse;
import com.oracle.bmc.identity.responses.ListUserGroupMembershipsResponse;
import com.oracle.bmc.identity.responses.ListUsersResponse;
import com.oracle.bmc.identity.responses.ListWorkRequestsResponse;
import com.oracle.bmc.identity.responses.MoveCompartmentResponse;
import com.oracle.bmc.identity.responses.RecoverCompartmentResponse;
import com.oracle.bmc.identity.responses.RemoveTagDefaultLockResponse;
import com.oracle.bmc.identity.responses.RemoveTagNamespaceLockResponse;
import com.oracle.bmc.identity.responses.RemoveUserFromGroupResponse;
import com.oracle.bmc.identity.responses.ResetIdpScimClientResponse;
import com.oracle.bmc.identity.responses.UpdateAuthTokenResponse;
import com.oracle.bmc.identity.responses.UpdateAuthenticationPolicyResponse;
import com.oracle.bmc.identity.responses.UpdateCompartmentResponse;
import com.oracle.bmc.identity.responses.UpdateCustomerSecretKeyResponse;
import com.oracle.bmc.identity.responses.UpdateDomainResponse;
import com.oracle.bmc.identity.responses.UpdateDynamicGroupResponse;
import com.oracle.bmc.identity.responses.UpdateGroupResponse;
import com.oracle.bmc.identity.responses.UpdateIdentityProviderResponse;
import com.oracle.bmc.identity.responses.UpdateIdpGroupMappingResponse;
import com.oracle.bmc.identity.responses.UpdateNetworkSourceResponse;
import com.oracle.bmc.identity.responses.UpdateOAuthClientCredentialResponse;
import com.oracle.bmc.identity.responses.UpdatePolicyResponse;
import com.oracle.bmc.identity.responses.UpdateSmtpCredentialResponse;
import com.oracle.bmc.identity.responses.UpdateSwiftPasswordResponse;
import com.oracle.bmc.identity.responses.UpdateTagDefaultResponse;
import com.oracle.bmc.identity.responses.UpdateTagNamespaceResponse;
import com.oracle.bmc.identity.responses.UpdateTagResponse;
import com.oracle.bmc.identity.responses.UpdateUserCapabilitiesResponse;
import com.oracle.bmc.identity.responses.UpdateUserResponse;
import com.oracle.bmc.identity.responses.UpdateUserStateResponse;
import com.oracle.bmc.identity.responses.UploadApiKeyResponse;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityAsyncClient
extends BaseAsyncClient
implements IdentityAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("IDENTITY").serviceEndpointPrefix("identity").serviceEndpointTemplate("https://identity.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(IdentityAsyncClient.class);

    IdentityAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(com.oracle.bmc.Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ActivateDomainResponse> activateDomain(ActivateDomainRequest request, AsyncHandler<ActivateDomainRequest, ActivateDomainResponse> handler) {
        Validate.notBlank((String)request.getDomainId(), (String)"domainId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ActivateDomainResponse::builder).logger(LOG, "activateDomain").serviceDetails("Identity", "ActivateDomain", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Domain/ActivateDomain").method(Method.POST).requestBuilder(ActivateDomainRequest::builder).basePath("/20160918").appendPathParam("domains").appendPathParam(request.getDomainId()).appendPathParam("actions").appendPathParam("activate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", ActivateDomainResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ActivateDomainResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ActivateMfaTotpDeviceResponse> activateMfaTotpDevice(ActivateMfaTotpDeviceRequest request, AsyncHandler<ActivateMfaTotpDeviceRequest, ActivateMfaTotpDeviceResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMfaTotpDeviceId(), (String)"mfaTotpDeviceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getMfaTotpToken(), "mfaTotpToken is required");
        return this.clientCall(request, ActivateMfaTotpDeviceResponse::builder).logger(LOG, "activateMfaTotpDevice").serviceDetails("Identity", "ActivateMfaTotpDevice", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/MfaTotpDeviceSummary/ActivateMfaTotpDevice").method(Method.POST).requestBuilder(ActivateMfaTotpDeviceRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("mfaTotpDevices").appendPathParam(request.getMfaTotpDeviceId()).appendPathParam("actions").appendPathParam("activate").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(MfaTotpDeviceSummary.class, ActivateMfaTotpDeviceResponse.Builder::mfaTotpDeviceSummary).handleResponseHeaderString("opc-request-id", ActivateMfaTotpDeviceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", ActivateMfaTotpDeviceResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<AddTagDefaultLockResponse> addTagDefaultLock(AddTagDefaultLockRequest request, AsyncHandler<AddTagDefaultLockRequest, AddTagDefaultLockResponse> handler) {
        Validate.notBlank((String)request.getTagDefaultId(), (String)"tagDefaultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddLockDetails(), "addLockDetails is required");
        return this.clientCall(request, AddTagDefaultLockResponse::builder).logger(LOG, "addTagDefaultLock").serviceDetails("Identity", "AddTagDefaultLock", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagDefault/AddTagDefaultLock").method(Method.POST).requestBuilder(AddTagDefaultLockRequest::builder).basePath("/20160918").appendPathParam("tagDefaults").appendPathParam(request.getTagDefaultId()).appendPathParam("actions").appendPathParam("addLock").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TagDefault.class, AddTagDefaultLockResponse.Builder::tagDefault).handleResponseHeaderString("opc-request-id", AddTagDefaultLockResponse.Builder::opcRequestId).handleResponseHeaderString("etag", AddTagDefaultLockResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<AddTagNamespaceLockResponse> addTagNamespaceLock(AddTagNamespaceLockRequest request, AsyncHandler<AddTagNamespaceLockRequest, AddTagNamespaceLockResponse> handler) {
        Validate.notBlank((String)request.getTagNamespaceId(), (String)"tagNamespaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddLockDetails(), "addLockDetails is required");
        return this.clientCall(request, AddTagNamespaceLockResponse::builder).logger(LOG, "addTagNamespaceLock").serviceDetails("Identity", "AddTagNamespaceLock", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagNamespace/AddTagNamespaceLock").method(Method.POST).requestBuilder(AddTagNamespaceLockRequest::builder).basePath("/20160918").appendPathParam("tagNamespaces").appendPathParam(request.getTagNamespaceId()).appendPathParam("actions").appendPathParam("addLock").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TagNamespace.class, AddTagNamespaceLockResponse.Builder::tagNamespace).handleResponseHeaderString("opc-request-id", AddTagNamespaceLockResponse.Builder::opcRequestId).handleResponseHeaderString("etag", AddTagNamespaceLockResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<AddUserToGroupResponse> addUserToGroup(AddUserToGroupRequest request, AsyncHandler<AddUserToGroupRequest, AddUserToGroupResponse> handler) {
        Objects.requireNonNull(request.getAddUserToGroupDetails(), "addUserToGroupDetails is required");
        return this.clientCall(request, AddUserToGroupResponse::builder).logger(LOG, "addUserToGroup").serviceDetails("Identity", "AddUserToGroup", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/UserGroupMembership/AddUserToGroup").method(Method.POST).requestBuilder(AddUserToGroupRequest::builder).basePath("/20160918").appendPathParam("userGroupMemberships").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(UserGroupMembership.class, AddUserToGroupResponse.Builder::userGroupMembership).handleResponseHeaderString("opc-request-id", AddUserToGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", AddUserToGroupResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<AssembleEffectiveTagSetResponse> assembleEffectiveTagSet(AssembleEffectiveTagSetRequest request, AsyncHandler<AssembleEffectiveTagSetRequest, AssembleEffectiveTagSetResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, AssembleEffectiveTagSetResponse::builder).logger(LOG, "assembleEffectiveTagSet").serviceDetails("Identity", "AssembleEffectiveTagSet", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagDefault/AssembleEffectiveTagSet").method(Method.GET).requestBuilder(AssembleEffectiveTagSetRequest::builder).basePath("/20160918").appendPathParam("tagDefaults").appendPathParam("actions").appendPathParam("assembleEffectiveTagSet").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(TagDefaultSummary.class, AssembleEffectiveTagSetResponse.Builder::items).handleResponseHeaderString("opc-request-id", AssembleEffectiveTagSetResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", AssembleEffectiveTagSetResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<BulkDeleteResourcesResponse> bulkDeleteResources(BulkDeleteResourcesRequest request, AsyncHandler<BulkDeleteResourcesRequest, BulkDeleteResourcesResponse> handler) {
        Validate.notBlank((String)request.getCompartmentId(), (String)"compartmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBulkDeleteResourcesDetails(), "bulkDeleteResourcesDetails is required");
        return this.clientCall(request, BulkDeleteResourcesResponse::builder).logger(LOG, "bulkDeleteResources").serviceDetails("Identity", "BulkDeleteResources", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Compartment/BulkDeleteResources").method(Method.POST).requestBuilder(BulkDeleteResourcesRequest::builder).basePath("/20160918").appendPathParam("compartments").appendPathParam(request.getCompartmentId()).appendPathParam("actions").appendPathParam("bulkDeleteResources").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", BulkDeleteResourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", BulkDeleteResourcesResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<BulkDeleteTagsResponse> bulkDeleteTags(BulkDeleteTagsRequest request, AsyncHandler<BulkDeleteTagsRequest, BulkDeleteTagsResponse> handler) {
        Objects.requireNonNull(request.getBulkDeleteTagsDetails(), "bulkDeleteTagsDetails is required");
        return this.clientCall(request, BulkDeleteTagsResponse::builder).logger(LOG, "bulkDeleteTags").serviceDetails("Identity", "BulkDeleteTags", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Tag/BulkDeleteTags").method(Method.POST).requestBuilder(BulkDeleteTagsRequest::builder).basePath("/20160918").appendPathParam("tags").appendPathParam("actions").appendPathParam("bulkDelete").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", BulkDeleteTagsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", BulkDeleteTagsResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<BulkEditTagsResponse> bulkEditTags(BulkEditTagsRequest request, AsyncHandler<BulkEditTagsRequest, BulkEditTagsResponse> handler) {
        return this.clientCall(request, BulkEditTagsResponse::builder).logger(LOG, "bulkEditTags").serviceDetails("Identity", "BulkEditTags", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Tag/BulkEditTags").method(Method.POST).requestBuilder(BulkEditTagsRequest::builder).basePath("/20160918").appendPathParam("tags").appendPathParam("actions").appendPathParam("bulkEdit").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", BulkEditTagsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", BulkEditTagsResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<BulkMoveResourcesResponse> bulkMoveResources(BulkMoveResourcesRequest request, AsyncHandler<BulkMoveResourcesRequest, BulkMoveResourcesResponse> handler) {
        Validate.notBlank((String)request.getCompartmentId(), (String)"compartmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBulkMoveResourcesDetails(), "bulkMoveResourcesDetails is required");
        return this.clientCall(request, BulkMoveResourcesResponse::builder).logger(LOG, "bulkMoveResources").serviceDetails("Identity", "BulkMoveResources", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Compartment/BulkMoveResources").method(Method.POST).requestBuilder(BulkMoveResourcesRequest::builder).basePath("/20160918").appendPathParam("compartments").appendPathParam(request.getCompartmentId()).appendPathParam("actions").appendPathParam("bulkMoveResources").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", BulkMoveResourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", BulkMoveResourcesResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CascadeDeleteTagNamespaceResponse> cascadeDeleteTagNamespace(CascadeDeleteTagNamespaceRequest request, AsyncHandler<CascadeDeleteTagNamespaceRequest, CascadeDeleteTagNamespaceResponse> handler) {
        Validate.notBlank((String)request.getTagNamespaceId(), (String)"tagNamespaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CascadeDeleteTagNamespaceResponse::builder).logger(LOG, "cascadeDeleteTagNamespace").serviceDetails("Identity", "CascadeDeleteTagNamespace", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagNamespace/CascadeDeleteTagNamespace").method(Method.POST).requestBuilder(CascadeDeleteTagNamespaceRequest::builder).basePath("/20160918").appendPathParam("tagNamespaces").appendPathParam(request.getTagNamespaceId()).appendPathParam("actions").appendPathParam("cascadeDelete").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", CascadeDeleteTagNamespaceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CascadeDeleteTagNamespaceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeDomainCompartmentResponse> changeDomainCompartment(ChangeDomainCompartmentRequest request, AsyncHandler<ChangeDomainCompartmentRequest, ChangeDomainCompartmentResponse> handler) {
        Validate.notBlank((String)request.getDomainId(), (String)"domainId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDomainCompartmentDetails(), "changeDomainCompartmentDetails is required");
        return this.clientCall(request, ChangeDomainCompartmentResponse::builder).logger(LOG, "changeDomainCompartment").serviceDetails("Identity", "ChangeDomainCompartment", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Domain/ChangeDomainCompartment").method(Method.POST).requestBuilder(ChangeDomainCompartmentRequest::builder).basePath("/20160918").appendPathParam("domains").appendPathParam(request.getDomainId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeDomainCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeDomainCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeDomainLicenseTypeResponse> changeDomainLicenseType(ChangeDomainLicenseTypeRequest request, AsyncHandler<ChangeDomainLicenseTypeRequest, ChangeDomainLicenseTypeResponse> handler) {
        Validate.notBlank((String)request.getDomainId(), (String)"domainId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDomainLicenseTypeDetails(), "changeDomainLicenseTypeDetails is required");
        return this.clientCall(request, ChangeDomainLicenseTypeResponse::builder).logger(LOG, "changeDomainLicenseType").serviceDetails("Identity", "ChangeDomainLicenseType", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Domain/ChangeDomainLicenseType").method(Method.POST).requestBuilder(ChangeDomainLicenseTypeRequest::builder).basePath("/20160918").appendPathParam("domains").appendPathParam(request.getDomainId()).appendPathParam("actions").appendPathParam("changeLicenseType").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeDomainLicenseTypeResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeDomainLicenseTypeResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeTagNamespaceCompartmentResponse> changeTagNamespaceCompartment(ChangeTagNamespaceCompartmentRequest request, AsyncHandler<ChangeTagNamespaceCompartmentRequest, ChangeTagNamespaceCompartmentResponse> handler) {
        Validate.notBlank((String)request.getTagNamespaceId(), (String)"tagNamespaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeTagNamespaceCompartmentDetail(), "changeTagNamespaceCompartmentDetail is required");
        return this.clientCall(request, ChangeTagNamespaceCompartmentResponse::builder).logger(LOG, "changeTagNamespaceCompartment").serviceDetails("Identity", "ChangeTagNamespaceCompartment", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagNamespace/ChangeTagNamespaceCompartment").method(Method.POST).requestBuilder(ChangeTagNamespaceCompartmentRequest::builder).basePath("/20160918").appendPathParam("tagNamespaces").appendPathParam(request.getTagNamespaceId()).appendPathParam("actions").appendPathParam("changeCompartment").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeTagNamespaceCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateAuthTokenResponse> createAuthToken(CreateAuthTokenRequest request, AsyncHandler<CreateAuthTokenRequest, CreateAuthTokenResponse> handler) {
        Objects.requireNonNull(request.getCreateAuthTokenDetails(), "createAuthTokenDetails is required");
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateAuthTokenResponse::builder).logger(LOG, "createAuthToken").serviceDetails("Identity", "CreateAuthToken", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/AuthToken/CreateAuthToken").method(Method.POST).requestBuilder(CreateAuthTokenRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("authTokens").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(AuthToken.class, CreateAuthTokenResponse.Builder::authToken).handleResponseHeaderString("opc-request-id", CreateAuthTokenResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateAuthTokenResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateCompartmentResponse> createCompartment(CreateCompartmentRequest request, AsyncHandler<CreateCompartmentRequest, CreateCompartmentResponse> handler) {
        Objects.requireNonNull(request.getCreateCompartmentDetails(), "createCompartmentDetails is required");
        return this.clientCall(request, CreateCompartmentResponse::builder).logger(LOG, "createCompartment").serviceDetails("Identity", "CreateCompartment", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Compartment/CreateCompartment").method(Method.POST).requestBuilder(CreateCompartmentRequest::builder).basePath("/20160918").appendPathParam("compartments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Compartment.class, CreateCompartmentResponse.Builder::compartment).handleResponseHeaderString("opc-request-id", CreateCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateCompartmentResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateCustomerSecretKeyResponse> createCustomerSecretKey(CreateCustomerSecretKeyRequest request, AsyncHandler<CreateCustomerSecretKeyRequest, CreateCustomerSecretKeyResponse> handler) {
        Objects.requireNonNull(request.getCreateCustomerSecretKeyDetails(), "createCustomerSecretKeyDetails is required");
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateCustomerSecretKeyResponse::builder).logger(LOG, "createCustomerSecretKey").serviceDetails("Identity", "CreateCustomerSecretKey", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/CustomerSecretKey/CreateCustomerSecretKey").method(Method.POST).requestBuilder(CreateCustomerSecretKeyRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("customerSecretKeys").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(CustomerSecretKey.class, CreateCustomerSecretKeyResponse.Builder::customerSecretKey).handleResponseHeaderString("opc-request-id", CreateCustomerSecretKeyResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateCustomerSecretKeyResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateDbCredentialResponse> createDbCredential(CreateDbCredentialRequest request, AsyncHandler<CreateDbCredentialRequest, CreateDbCredentialResponse> handler) {
        Objects.requireNonNull(request.getCreateDbCredentialDetails(), "createDbCredentialDetails is required");
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateDbCredentialResponse::builder).logger(LOG, "createDbCredential").serviceDetails("Identity", "CreateDbCredential", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/User/CreateDbCredential").method(Method.POST).requestBuilder(CreateDbCredentialRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("dbCredentials").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DbCredential.class, CreateDbCredentialResponse.Builder::dbCredential).handleResponseHeaderString("opc-request-id", CreateDbCredentialResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateDbCredentialResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateDomainResponse> createDomain(CreateDomainRequest request, AsyncHandler<CreateDomainRequest, CreateDomainResponse> handler) {
        Objects.requireNonNull(request.getCreateDomainDetails(), "createDomainDetails is required");
        return this.clientCall(request, CreateDomainResponse::builder).logger(LOG, "createDomain").serviceDetails("Identity", "CreateDomain", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Domain/CreateDomain").method(Method.POST).requestBuilder(CreateDomainRequest::builder).basePath("/20160918").appendPathParam("domains").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", CreateDomainResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateDomainResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDynamicGroupResponse> createDynamicGroup(CreateDynamicGroupRequest request, AsyncHandler<CreateDynamicGroupRequest, CreateDynamicGroupResponse> handler) {
        Objects.requireNonNull(request.getCreateDynamicGroupDetails(), "createDynamicGroupDetails is required");
        return this.clientCall(request, CreateDynamicGroupResponse::builder).logger(LOG, "createDynamicGroup").serviceDetails("Identity", "CreateDynamicGroup", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/DynamicGroup/CreateDynamicGroup").method(Method.POST).requestBuilder(CreateDynamicGroupRequest::builder).basePath("/20160918").appendPathParam("dynamicGroups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DynamicGroup.class, CreateDynamicGroupResponse.Builder::dynamicGroup).handleResponseHeaderString("opc-request-id", CreateDynamicGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateDynamicGroupResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateGroupResponse> createGroup(CreateGroupRequest request, AsyncHandler<CreateGroupRequest, CreateGroupResponse> handler) {
        Objects.requireNonNull(request.getCreateGroupDetails(), "createGroupDetails is required");
        return this.clientCall(request, CreateGroupResponse::builder).logger(LOG, "createGroup").serviceDetails("Identity", "CreateGroup", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Group/CreateGroup").method(Method.POST).requestBuilder(CreateGroupRequest::builder).basePath("/20160918").appendPathParam("groups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Group.class, CreateGroupResponse.Builder::group).handleResponseHeaderString("opc-request-id", CreateGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateGroupResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateIdentityProviderResponse> createIdentityProvider(CreateIdentityProviderRequest request, AsyncHandler<CreateIdentityProviderRequest, CreateIdentityProviderResponse> handler) {
        Objects.requireNonNull(request.getCreateIdentityProviderDetails(), "createIdentityProviderDetails is required");
        return this.clientCall(request, CreateIdentityProviderResponse::builder).logger(LOG, "createIdentityProvider").serviceDetails("Identity", "CreateIdentityProvider", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/IdentityProvider/CreateIdentityProvider").method(Method.POST).requestBuilder(CreateIdentityProviderRequest::builder).basePath("/20160918").appendPathParam("identityProviders").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(IdentityProvider.class, CreateIdentityProviderResponse.Builder::identityProvider).handleResponseHeaderString("opc-request-id", CreateIdentityProviderResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateIdentityProviderResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateIdpGroupMappingResponse> createIdpGroupMapping(CreateIdpGroupMappingRequest request, AsyncHandler<CreateIdpGroupMappingRequest, CreateIdpGroupMappingResponse> handler) {
        Objects.requireNonNull(request.getCreateIdpGroupMappingDetails(), "createIdpGroupMappingDetails is required");
        Validate.notBlank((String)request.getIdentityProviderId(), (String)"identityProviderId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateIdpGroupMappingResponse::builder).logger(LOG, "createIdpGroupMapping").serviceDetails("Identity", "CreateIdpGroupMapping", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/IdpGroupMapping/CreateIdpGroupMapping").method(Method.POST).requestBuilder(CreateIdpGroupMappingRequest::builder).basePath("/20160918").appendPathParam("identityProviders").appendPathParam(request.getIdentityProviderId()).appendPathParam("groupMappings").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(IdpGroupMapping.class, CreateIdpGroupMappingResponse.Builder::idpGroupMapping).handleResponseHeaderString("opc-request-id", CreateIdpGroupMappingResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateIdpGroupMappingResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateMfaTotpDeviceResponse> createMfaTotpDevice(CreateMfaTotpDeviceRequest request, AsyncHandler<CreateMfaTotpDeviceRequest, CreateMfaTotpDeviceResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateMfaTotpDeviceResponse::builder).logger(LOG, "createMfaTotpDevice").serviceDetails("Identity", "CreateMfaTotpDevice", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/MfaTotpDevice/CreateMfaTotpDevice").method(Method.POST).requestBuilder(CreateMfaTotpDeviceRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("mfaTotpDevices").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(MfaTotpDevice.class, CreateMfaTotpDeviceResponse.Builder::mfaTotpDevice).handleResponseHeaderString("opc-request-id", CreateMfaTotpDeviceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateMfaTotpDeviceResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateNetworkSourceResponse> createNetworkSource(CreateNetworkSourceRequest request, AsyncHandler<CreateNetworkSourceRequest, CreateNetworkSourceResponse> handler) {
        Objects.requireNonNull(request.getCreateNetworkSourceDetails(), "createNetworkSourceDetails is required");
        return this.clientCall(request, CreateNetworkSourceResponse::builder).logger(LOG, "createNetworkSource").serviceDetails("Identity", "CreateNetworkSource", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/NetworkSources/CreateNetworkSource").method(Method.POST).requestBuilder(CreateNetworkSourceRequest::builder).basePath("/20160918").appendPathParam("networkSources").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(NetworkSources.class, CreateNetworkSourceResponse.Builder::networkSources).handleResponseHeaderString("opc-request-id", CreateNetworkSourceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateNetworkSourceResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateOAuthClientCredentialResponse> createOAuthClientCredential(CreateOAuthClientCredentialRequest request, AsyncHandler<CreateOAuthClientCredentialRequest, CreateOAuthClientCredentialResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateOAuth2ClientCredentialDetails(), "createOAuth2ClientCredentialDetails is required");
        return this.clientCall(request, CreateOAuthClientCredentialResponse::builder).logger(LOG, "createOAuthClientCredential").serviceDetails("Identity", "CreateOAuthClientCredential", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/User/CreateOAuthClientCredential").method(Method.POST).requestBuilder(CreateOAuthClientCredentialRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("oauth2ClientCredentials").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(OAuth2ClientCredential.class, CreateOAuthClientCredentialResponse.Builder::oAuth2ClientCredential).handleResponseHeaderString("opc-request-id", CreateOAuthClientCredentialResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateOAuthClientCredentialResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateOrResetUIPasswordResponse> createOrResetUIPassword(CreateOrResetUIPasswordRequest request, AsyncHandler<CreateOrResetUIPasswordRequest, CreateOrResetUIPasswordResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateOrResetUIPasswordResponse::builder).logger(LOG, "createOrResetUIPassword").serviceDetails("Identity", "CreateOrResetUIPassword", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/UIPassword/CreateOrResetUIPassword").method(Method.POST).requestBuilder(CreateOrResetUIPasswordRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("uiPassword").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(UIPassword.class, CreateOrResetUIPasswordResponse.Builder::uIPassword).handleResponseHeaderString("opc-request-id", CreateOrResetUIPasswordResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateOrResetUIPasswordResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreatePolicyResponse> createPolicy(CreatePolicyRequest request, AsyncHandler<CreatePolicyRequest, CreatePolicyResponse> handler) {
        Objects.requireNonNull(request.getCreatePolicyDetails(), "createPolicyDetails is required");
        return this.clientCall(request, CreatePolicyResponse::builder).logger(LOG, "createPolicy").serviceDetails("Identity", "CreatePolicy", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Policy/CreatePolicy").method(Method.POST).requestBuilder(CreatePolicyRequest::builder).basePath("/20160918").appendPathParam("policies").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Policy.class, CreatePolicyResponse.Builder::policy).handleResponseHeaderString("opc-request-id", CreatePolicyResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreatePolicyResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateRegionSubscriptionResponse> createRegionSubscription(CreateRegionSubscriptionRequest request, AsyncHandler<CreateRegionSubscriptionRequest, CreateRegionSubscriptionResponse> handler) {
        Objects.requireNonNull(request.getCreateRegionSubscriptionDetails(), "createRegionSubscriptionDetails is required");
        Validate.notBlank((String)request.getTenancyId(), (String)"tenancyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateRegionSubscriptionResponse::builder).logger(LOG, "createRegionSubscription").serviceDetails("Identity", "CreateRegionSubscription", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/RegionSubscription/CreateRegionSubscription").method(Method.POST).requestBuilder(CreateRegionSubscriptionRequest::builder).basePath("/20160918").appendPathParam("tenancies").appendPathParam(request.getTenancyId()).appendPathParam("regionSubscriptions").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(RegionSubscription.class, CreateRegionSubscriptionResponse.Builder::regionSubscription).handleResponseHeaderString("opc-request-id", CreateRegionSubscriptionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateSmtpCredentialResponse> createSmtpCredential(CreateSmtpCredentialRequest request, AsyncHandler<CreateSmtpCredentialRequest, CreateSmtpCredentialResponse> handler) {
        Objects.requireNonNull(request.getCreateSmtpCredentialDetails(), "createSmtpCredentialDetails is required");
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateSmtpCredentialResponse::builder).logger(LOG, "createSmtpCredential").serviceDetails("Identity", "CreateSmtpCredential", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/SmtpCredential/CreateSmtpCredential").method(Method.POST).requestBuilder(CreateSmtpCredentialRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("smtpCredentials").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SmtpCredential.class, CreateSmtpCredentialResponse.Builder::smtpCredential).handleResponseHeaderString("opc-request-id", CreateSmtpCredentialResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateSmtpCredentialResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateSwiftPasswordResponse> createSwiftPassword(CreateSwiftPasswordRequest request, AsyncHandler<CreateSwiftPasswordRequest, CreateSwiftPasswordResponse> handler) {
        Objects.requireNonNull(request.getCreateSwiftPasswordDetails(), "createSwiftPasswordDetails is required");
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateSwiftPasswordResponse::builder).logger(LOG, "createSwiftPassword").serviceDetails("Identity", "CreateSwiftPassword", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/SwiftPassword/CreateSwiftPassword").method(Method.POST).requestBuilder(CreateSwiftPasswordRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("swiftPasswords").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SwiftPassword.class, CreateSwiftPasswordResponse.Builder::swiftPassword).handleResponseHeaderString("opc-request-id", CreateSwiftPasswordResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateSwiftPasswordResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateTagResponse> createTag(CreateTagRequest request, AsyncHandler<CreateTagRequest, CreateTagResponse> handler) {
        Validate.notBlank((String)request.getTagNamespaceId(), (String)"tagNamespaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateTagDetails(), "createTagDetails is required");
        return this.clientCall(request, CreateTagResponse::builder).logger(LOG, "createTag").serviceDetails("Identity", "CreateTag", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Tag/CreateTag").method(Method.POST).requestBuilder(CreateTagRequest::builder).basePath("/20160918").appendPathParam("tagNamespaces").appendPathParam(request.getTagNamespaceId()).appendPathParam("tags").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Tag.class, CreateTagResponse.Builder::tag).handleResponseHeaderString("opc-request-id", CreateTagResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateTagResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateTagDefaultResponse> createTagDefault(CreateTagDefaultRequest request, AsyncHandler<CreateTagDefaultRequest, CreateTagDefaultResponse> handler) {
        Objects.requireNonNull(request.getCreateTagDefaultDetails(), "createTagDefaultDetails is required");
        return this.clientCall(request, CreateTagDefaultResponse::builder).logger(LOG, "createTagDefault").serviceDetails("Identity", "CreateTagDefault", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagDefault/CreateTagDefault").method(Method.POST).requestBuilder(CreateTagDefaultRequest::builder).basePath("/20160918").appendPathParam("tagDefaults").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TagDefault.class, CreateTagDefaultResponse.Builder::tagDefault).handleResponseHeaderString("opc-request-id", CreateTagDefaultResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateTagDefaultResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateTagNamespaceResponse> createTagNamespace(CreateTagNamespaceRequest request, AsyncHandler<CreateTagNamespaceRequest, CreateTagNamespaceResponse> handler) {
        Objects.requireNonNull(request.getCreateTagNamespaceDetails(), "createTagNamespaceDetails is required");
        return this.clientCall(request, CreateTagNamespaceResponse::builder).logger(LOG, "createTagNamespace").serviceDetails("Identity", "CreateTagNamespace", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagNamespace/CreateTagNamespace").method(Method.POST).requestBuilder(CreateTagNamespaceRequest::builder).basePath("/20160918").appendPathParam("tagNamespaces").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TagNamespace.class, CreateTagNamespaceResponse.Builder::tagNamespace).handleResponseHeaderString("opc-request-id", CreateTagNamespaceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateUserResponse> createUser(CreateUserRequest request, AsyncHandler<CreateUserRequest, CreateUserResponse> handler) {
        Objects.requireNonNull(request.getCreateUserDetails(), "createUserDetails is required");
        return this.clientCall(request, CreateUserResponse::builder).logger(LOG, "createUser").serviceDetails("Identity", "CreateUser", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/User/CreateUser").method(Method.POST).requestBuilder(CreateUserRequest::builder).basePath("/20160918").appendPathParam("users").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(User.class, CreateUserResponse.Builder::user).handleResponseHeaderString("opc-request-id", CreateUserResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateUserResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeactivateDomainResponse> deactivateDomain(DeactivateDomainRequest request, AsyncHandler<DeactivateDomainRequest, DeactivateDomainResponse> handler) {
        Validate.notBlank((String)request.getDomainId(), (String)"domainId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeactivateDomainResponse::builder).logger(LOG, "deactivateDomain").serviceDetails("Identity", "DeactivateDomain", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Domain/DeactivateDomain").method(Method.POST).requestBuilder(DeactivateDomainRequest::builder).basePath("/20160918").appendPathParam("domains").appendPathParam(request.getDomainId()).appendPathParam("actions").appendPathParam("deactivate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeactivateDomainResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeactivateDomainResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteApiKeyResponse> deleteApiKey(DeleteApiKeyRequest request, AsyncHandler<DeleteApiKeyRequest, DeleteApiKeyResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFingerprint(), (String)"fingerprint must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteApiKeyResponse::builder).logger(LOG, "deleteApiKey").serviceDetails("Identity", "DeleteApiKey", "").method(Method.DELETE).requestBuilder(DeleteApiKeyRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("apiKeys").appendPathParam(request.getFingerprint()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteApiKeyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteAuthTokenResponse> deleteAuthToken(DeleteAuthTokenRequest request, AsyncHandler<DeleteAuthTokenRequest, DeleteAuthTokenResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAuthTokenId(), (String)"authTokenId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteAuthTokenResponse::builder).logger(LOG, "deleteAuthToken").serviceDetails("Identity", "DeleteAuthToken", "").method(Method.DELETE).requestBuilder(DeleteAuthTokenRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("authTokens").appendPathParam(request.getAuthTokenId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteAuthTokenResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteCompartmentResponse> deleteCompartment(DeleteCompartmentRequest request, AsyncHandler<DeleteCompartmentRequest, DeleteCompartmentResponse> handler) {
        Validate.notBlank((String)request.getCompartmentId(), (String)"compartmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteCompartmentResponse::builder).logger(LOG, "deleteCompartment").serviceDetails("Identity", "DeleteCompartment", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Compartment/DeleteCompartment").method(Method.DELETE).requestBuilder(DeleteCompartmentRequest::builder).basePath("/20160918").appendPathParam("compartments").appendPathParam(request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteCustomerSecretKeyResponse> deleteCustomerSecretKey(DeleteCustomerSecretKeyRequest request, AsyncHandler<DeleteCustomerSecretKeyRequest, DeleteCustomerSecretKeyResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCustomerSecretKeyId(), (String)"customerSecretKeyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteCustomerSecretKeyResponse::builder).logger(LOG, "deleteCustomerSecretKey").serviceDetails("Identity", "DeleteCustomerSecretKey", "").method(Method.DELETE).requestBuilder(DeleteCustomerSecretKeyRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("customerSecretKeys").appendPathParam(request.getCustomerSecretKeyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteCustomerSecretKeyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDbCredentialResponse> deleteDbCredential(DeleteDbCredentialRequest request, AsyncHandler<DeleteDbCredentialRequest, DeleteDbCredentialResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDbCredentialId(), (String)"dbCredentialId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDbCredentialResponse::builder).logger(LOG, "deleteDbCredential").serviceDetails("Identity", "DeleteDbCredential", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/User/DeleteDbCredential").method(Method.DELETE).requestBuilder(DeleteDbCredentialRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("dbCredentials").appendPathParam(request.getDbCredentialId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteDbCredentialResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDomainResponse> deleteDomain(DeleteDomainRequest request, AsyncHandler<DeleteDomainRequest, DeleteDomainResponse> handler) {
        Validate.notBlank((String)request.getDomainId(), (String)"domainId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDomainResponse::builder).logger(LOG, "deleteDomain").serviceDetails("Identity", "DeleteDomain", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Domain/DeleteDomain").method(Method.DELETE).requestBuilder(DeleteDomainRequest::builder).basePath("/20160918").appendPathParam("domains").appendPathParam(request.getDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDomainResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteDomainResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDynamicGroupResponse> deleteDynamicGroup(DeleteDynamicGroupRequest request, AsyncHandler<DeleteDynamicGroupRequest, DeleteDynamicGroupResponse> handler) {
        Validate.notBlank((String)request.getDynamicGroupId(), (String)"dynamicGroupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDynamicGroupResponse::builder).logger(LOG, "deleteDynamicGroup").serviceDetails("Identity", "DeleteDynamicGroup", "").method(Method.DELETE).requestBuilder(DeleteDynamicGroupRequest::builder).basePath("/20160918").appendPathParam("dynamicGroups").appendPathParam(request.getDynamicGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteDynamicGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteGroupResponse> deleteGroup(DeleteGroupRequest request, AsyncHandler<DeleteGroupRequest, DeleteGroupResponse> handler) {
        Validate.notBlank((String)request.getGroupId(), (String)"groupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteGroupResponse::builder).logger(LOG, "deleteGroup").serviceDetails("Identity", "DeleteGroup", "").method(Method.DELETE).requestBuilder(DeleteGroupRequest::builder).basePath("/20160918").appendPathParam("groups").appendPathParam(request.getGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteIdentityProviderResponse> deleteIdentityProvider(DeleteIdentityProviderRequest request, AsyncHandler<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse> handler) {
        Validate.notBlank((String)request.getIdentityProviderId(), (String)"identityProviderId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteIdentityProviderResponse::builder).logger(LOG, "deleteIdentityProvider").serviceDetails("Identity", "DeleteIdentityProvider", "").method(Method.DELETE).requestBuilder(DeleteIdentityProviderRequest::builder).basePath("/20160918").appendPathParam("identityProviders").appendPathParam(request.getIdentityProviderId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteIdentityProviderResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteIdpGroupMappingResponse> deleteIdpGroupMapping(DeleteIdpGroupMappingRequest request, AsyncHandler<DeleteIdpGroupMappingRequest, DeleteIdpGroupMappingResponse> handler) {
        Validate.notBlank((String)request.getIdentityProviderId(), (String)"identityProviderId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMappingId(), (String)"mappingId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteIdpGroupMappingResponse::builder).logger(LOG, "deleteIdpGroupMapping").serviceDetails("Identity", "DeleteIdpGroupMapping", "").method(Method.DELETE).requestBuilder(DeleteIdpGroupMappingRequest::builder).basePath("/20160918").appendPathParam("identityProviders").appendPathParam(request.getIdentityProviderId()).appendPathParam("groupMappings").appendPathParam(request.getMappingId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteIdpGroupMappingResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteMfaTotpDeviceResponse> deleteMfaTotpDevice(DeleteMfaTotpDeviceRequest request, AsyncHandler<DeleteMfaTotpDeviceRequest, DeleteMfaTotpDeviceResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMfaTotpDeviceId(), (String)"mfaTotpDeviceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteMfaTotpDeviceResponse::builder).logger(LOG, "deleteMfaTotpDevice").serviceDetails("Identity", "DeleteMfaTotpDevice", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/MfaTotpDevice/DeleteMfaTotpDevice").method(Method.DELETE).requestBuilder(DeleteMfaTotpDeviceRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("mfaTotpDevices").appendPathParam(request.getMfaTotpDeviceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteMfaTotpDeviceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteNetworkSourceResponse> deleteNetworkSource(DeleteNetworkSourceRequest request, AsyncHandler<DeleteNetworkSourceRequest, DeleteNetworkSourceResponse> handler) {
        Validate.notBlank((String)request.getNetworkSourceId(), (String)"networkSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteNetworkSourceResponse::builder).logger(LOG, "deleteNetworkSource").serviceDetails("Identity", "DeleteNetworkSource", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/NetworkSources/DeleteNetworkSource").method(Method.DELETE).requestBuilder(DeleteNetworkSourceRequest::builder).basePath("/20160918").appendPathParam("networkSources").appendPathParam(request.getNetworkSourceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteNetworkSourceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteOAuthClientCredentialResponse> deleteOAuthClientCredential(DeleteOAuthClientCredentialRequest request, AsyncHandler<DeleteOAuthClientCredentialRequest, DeleteOAuthClientCredentialResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getOauth2ClientCredentialId(), (String)"oauth2ClientCredentialId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteOAuthClientCredentialResponse::builder).logger(LOG, "deleteOAuthClientCredential").serviceDetails("Identity", "DeleteOAuthClientCredential", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/User/DeleteOAuthClientCredential").method(Method.DELETE).requestBuilder(DeleteOAuthClientCredentialRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("oauth2ClientCredentials").appendPathParam(request.getOauth2ClientCredentialId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteOAuthClientCredentialResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeletePolicyResponse> deletePolicy(DeletePolicyRequest request, AsyncHandler<DeletePolicyRequest, DeletePolicyResponse> handler) {
        Validate.notBlank((String)request.getPolicyId(), (String)"policyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeletePolicyResponse::builder).logger(LOG, "deletePolicy").serviceDetails("Identity", "DeletePolicy", "").method(Method.DELETE).requestBuilder(DeletePolicyRequest::builder).basePath("/20160918").appendPathParam("policies").appendPathParam(request.getPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeletePolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteSmtpCredentialResponse> deleteSmtpCredential(DeleteSmtpCredentialRequest request, AsyncHandler<DeleteSmtpCredentialRequest, DeleteSmtpCredentialResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSmtpCredentialId(), (String)"smtpCredentialId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSmtpCredentialResponse::builder).logger(LOG, "deleteSmtpCredential").serviceDetails("Identity", "DeleteSmtpCredential", "").method(Method.DELETE).requestBuilder(DeleteSmtpCredentialRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("smtpCredentials").appendPathParam(request.getSmtpCredentialId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteSmtpCredentialResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteSwiftPasswordResponse> deleteSwiftPassword(DeleteSwiftPasswordRequest request, AsyncHandler<DeleteSwiftPasswordRequest, DeleteSwiftPasswordResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSwiftPasswordId(), (String)"swiftPasswordId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSwiftPasswordResponse::builder).logger(LOG, "deleteSwiftPassword").serviceDetails("Identity", "DeleteSwiftPassword", "").method(Method.DELETE).requestBuilder(DeleteSwiftPasswordRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("swiftPasswords").appendPathParam(request.getSwiftPasswordId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteSwiftPasswordResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteTagResponse> deleteTag(DeleteTagRequest request, AsyncHandler<DeleteTagRequest, DeleteTagResponse> handler) {
        Validate.notBlank((String)request.getTagNamespaceId(), (String)"tagNamespaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTagName(), (String)"tagName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteTagResponse::builder).logger(LOG, "deleteTag").serviceDetails("Identity", "DeleteTag", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Tag/DeleteTag").method(Method.DELETE).requestBuilder(DeleteTagRequest::builder).basePath("/20160918").appendPathParam("tagNamespaces").appendPathParam(request.getTagNamespaceId()).appendPathParam("tags").appendPathParam(request.getTagName()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteTagResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteTagResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteTagDefaultResponse> deleteTagDefault(DeleteTagDefaultRequest request, AsyncHandler<DeleteTagDefaultRequest, DeleteTagDefaultResponse> handler) {
        Validate.notBlank((String)request.getTagDefaultId(), (String)"tagDefaultId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteTagDefaultResponse::builder).logger(LOG, "deleteTagDefault").serviceDetails("Identity", "DeleteTagDefault", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagDefault/DeleteTagDefault").method(Method.DELETE).requestBuilder(DeleteTagDefaultRequest::builder).basePath("/20160918").appendPathParam("tagDefaults").appendPathParam(request.getTagDefaultId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteTagDefaultResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteTagNamespaceResponse> deleteTagNamespace(DeleteTagNamespaceRequest request, AsyncHandler<DeleteTagNamespaceRequest, DeleteTagNamespaceResponse> handler) {
        Validate.notBlank((String)request.getTagNamespaceId(), (String)"tagNamespaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteTagNamespaceResponse::builder).logger(LOG, "deleteTagNamespace").serviceDetails("Identity", "DeleteTagNamespace", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagNamespace/DeleteTagNamespace").method(Method.DELETE).requestBuilder(DeleteTagNamespaceRequest::builder).basePath("/20160918").appendPathParam("tagNamespaces").appendPathParam(request.getTagNamespaceId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteTagNamespaceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteUserResponse> deleteUser(DeleteUserRequest request, AsyncHandler<DeleteUserRequest, DeleteUserResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteUserResponse::builder).logger(LOG, "deleteUser").serviceDetails("Identity", "DeleteUser", "").method(Method.DELETE).requestBuilder(DeleteUserRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteUserResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<EnableReplicationToRegionResponse> enableReplicationToRegion(EnableReplicationToRegionRequest request, AsyncHandler<EnableReplicationToRegionRequest, EnableReplicationToRegionResponse> handler) {
        Validate.notBlank((String)request.getDomainId(), (String)"domainId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableReplicationToRegionDetails(), "enableReplicationToRegionDetails is required");
        return this.clientCall(request, EnableReplicationToRegionResponse::builder).logger(LOG, "enableReplicationToRegion").serviceDetails("Identity", "EnableReplicationToRegion", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Domain/EnableReplicationToRegion").method(Method.POST).requestBuilder(EnableReplicationToRegionRequest::builder).basePath("/20160918").appendPathParam("domains").appendPathParam(request.getDomainId()).appendPathParam("actions").appendPathParam("enableReplicationToRegion").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", EnableReplicationToRegionResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", EnableReplicationToRegionResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GenerateTotpSeedResponse> generateTotpSeed(GenerateTotpSeedRequest request, AsyncHandler<GenerateTotpSeedRequest, GenerateTotpSeedResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMfaTotpDeviceId(), (String)"mfaTotpDeviceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GenerateTotpSeedResponse::builder).logger(LOG, "generateTotpSeed").serviceDetails("Identity", "GenerateTotpSeed", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/MfaTotpDevice/GenerateTotpSeed").method(Method.POST).requestBuilder(GenerateTotpSeedRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("mfaTotpDevices").appendPathParam(request.getMfaTotpDeviceId()).appendPathParam("actions").appendPathParam("generateSeed").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleBody(MfaTotpDevice.class, GenerateTotpSeedResponse.Builder::mfaTotpDevice).handleResponseHeaderString("opc-request-id", GenerateTotpSeedResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GenerateTotpSeedResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetAuthenticationPolicyResponse> getAuthenticationPolicy(GetAuthenticationPolicyRequest request, AsyncHandler<GetAuthenticationPolicyRequest, GetAuthenticationPolicyResponse> handler) {
        Validate.notBlank((String)request.getCompartmentId(), (String)"compartmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAuthenticationPolicyResponse::builder).logger(LOG, "getAuthenticationPolicy").serviceDetails("Identity", "GetAuthenticationPolicy", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/AuthenticationPolicy/GetAuthenticationPolicy").method(Method.GET).requestBuilder(GetAuthenticationPolicyRequest::builder).basePath("/20160918").appendPathParam("authenticationPolicies").appendPathParam(request.getCompartmentId()).accept(new String[]{"application/json"}).handleBody(AuthenticationPolicy.class, GetAuthenticationPolicyResponse.Builder::authenticationPolicy).handleResponseHeaderString("opc-request-id", GetAuthenticationPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetAuthenticationPolicyResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetCompartmentResponse> getCompartment(GetCompartmentRequest request, AsyncHandler<GetCompartmentRequest, GetCompartmentResponse> handler) {
        Validate.notBlank((String)request.getCompartmentId(), (String)"compartmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetCompartmentResponse::builder).logger(LOG, "getCompartment").serviceDetails("Identity", "GetCompartment", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Compartment/GetCompartment").method(Method.GET).requestBuilder(GetCompartmentRequest::builder).basePath("/20160918").appendPathParam("compartments").appendPathParam(request.getCompartmentId()).accept(new String[]{"application/json"}).handleBody(Compartment.class, GetCompartmentResponse.Builder::compartment).handleResponseHeaderString("opc-request-id", GetCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetCompartmentResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetDomainResponse> getDomain(GetDomainRequest request, AsyncHandler<GetDomainRequest, GetDomainResponse> handler) {
        Validate.notBlank((String)request.getDomainId(), (String)"domainId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDomainResponse::builder).logger(LOG, "getDomain").serviceDetails("Identity", "GetDomain", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Domain/GetDomain").method(Method.GET).requestBuilder(GetDomainRequest::builder).basePath("/20160918").appendPathParam("domains").appendPathParam(request.getDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Domain.class, GetDomainResponse.Builder::domain).handleResponseHeaderString("opc-request-id", GetDomainResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetDomainResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetDynamicGroupResponse> getDynamicGroup(GetDynamicGroupRequest request, AsyncHandler<GetDynamicGroupRequest, GetDynamicGroupResponse> handler) {
        Validate.notBlank((String)request.getDynamicGroupId(), (String)"dynamicGroupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDynamicGroupResponse::builder).logger(LOG, "getDynamicGroup").serviceDetails("Identity", "GetDynamicGroup", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/DynamicGroup/GetDynamicGroup").method(Method.GET).requestBuilder(GetDynamicGroupRequest::builder).basePath("/20160918").appendPathParam("dynamicGroups").appendPathParam(request.getDynamicGroupId()).accept(new String[]{"application/json"}).handleBody(DynamicGroup.class, GetDynamicGroupResponse.Builder::dynamicGroup).handleResponseHeaderString("opc-request-id", GetDynamicGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetDynamicGroupResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetGroupResponse> getGroup(GetGroupRequest request, AsyncHandler<GetGroupRequest, GetGroupResponse> handler) {
        Validate.notBlank((String)request.getGroupId(), (String)"groupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetGroupResponse::builder).logger(LOG, "getGroup").serviceDetails("Identity", "GetGroup", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Group/GetGroup").method(Method.GET).requestBuilder(GetGroupRequest::builder).basePath("/20160918").appendPathParam("groups").appendPathParam(request.getGroupId()).accept(new String[]{"application/json"}).handleBody(Group.class, GetGroupResponse.Builder::group).handleResponseHeaderString("opc-request-id", GetGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetGroupResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetIamWorkRequestResponse> getIamWorkRequest(GetIamWorkRequestRequest request, AsyncHandler<GetIamWorkRequestRequest, GetIamWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getIamWorkRequestId(), (String)"iamWorkRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetIamWorkRequestResponse::builder).logger(LOG, "getIamWorkRequest").serviceDetails("Identity", "GetIamWorkRequest", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/IamWorkRequest/GetIamWorkRequest").method(Method.GET).requestBuilder(GetIamWorkRequestRequest::builder).basePath("/20160918").appendPathParam("iamWorkRequests").appendPathParam(request.getIamWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IamWorkRequest.class, GetIamWorkRequestResponse.Builder::iamWorkRequest).handleResponseHeaderString("opc-request-id", GetIamWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetIdentityProviderResponse> getIdentityProvider(GetIdentityProviderRequest request, AsyncHandler<GetIdentityProviderRequest, GetIdentityProviderResponse> handler) {
        Validate.notBlank((String)request.getIdentityProviderId(), (String)"identityProviderId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetIdentityProviderResponse::builder).logger(LOG, "getIdentityProvider").serviceDetails("Identity", "GetIdentityProvider", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/IdentityProvider/GetIdentityProvider").method(Method.GET).requestBuilder(GetIdentityProviderRequest::builder).basePath("/20160918").appendPathParam("identityProviders").appendPathParam(request.getIdentityProviderId()).accept(new String[]{"application/json"}).handleBody(IdentityProvider.class, GetIdentityProviderResponse.Builder::identityProvider).handleResponseHeaderString("opc-request-id", GetIdentityProviderResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetIdentityProviderResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetIdpGroupMappingResponse> getIdpGroupMapping(GetIdpGroupMappingRequest request, AsyncHandler<GetIdpGroupMappingRequest, GetIdpGroupMappingResponse> handler) {
        Validate.notBlank((String)request.getIdentityProviderId(), (String)"identityProviderId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMappingId(), (String)"mappingId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetIdpGroupMappingResponse::builder).logger(LOG, "getIdpGroupMapping").serviceDetails("Identity", "GetIdpGroupMapping", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/IdpGroupMapping/GetIdpGroupMapping").method(Method.GET).requestBuilder(GetIdpGroupMappingRequest::builder).basePath("/20160918").appendPathParam("identityProviders").appendPathParam(request.getIdentityProviderId()).appendPathParam("groupMappings").appendPathParam(request.getMappingId()).accept(new String[]{"application/json"}).handleBody(IdpGroupMapping.class, GetIdpGroupMappingResponse.Builder::idpGroupMapping).handleResponseHeaderString("opc-request-id", GetIdpGroupMappingResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetIdpGroupMappingResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetMfaTotpDeviceResponse> getMfaTotpDevice(GetMfaTotpDeviceRequest request, AsyncHandler<GetMfaTotpDeviceRequest, GetMfaTotpDeviceResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMfaTotpDeviceId(), (String)"mfaTotpDeviceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetMfaTotpDeviceResponse::builder).logger(LOG, "getMfaTotpDevice").serviceDetails("Identity", "GetMfaTotpDevice", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/MfaTotpDeviceSummary/GetMfaTotpDevice").method(Method.GET).requestBuilder(GetMfaTotpDeviceRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("mfaTotpDevices").appendPathParam(request.getMfaTotpDeviceId()).accept(new String[]{"application/json"}).handleBody(MfaTotpDeviceSummary.class, GetMfaTotpDeviceResponse.Builder::mfaTotpDeviceSummary).handleResponseHeaderString("opc-request-id", GetMfaTotpDeviceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetMfaTotpDeviceResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetNetworkSourceResponse> getNetworkSource(GetNetworkSourceRequest request, AsyncHandler<GetNetworkSourceRequest, GetNetworkSourceResponse> handler) {
        Validate.notBlank((String)request.getNetworkSourceId(), (String)"networkSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetNetworkSourceResponse::builder).logger(LOG, "getNetworkSource").serviceDetails("Identity", "GetNetworkSource", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/NetworkSources/GetNetworkSource").method(Method.GET).requestBuilder(GetNetworkSourceRequest::builder).basePath("/20160918").appendPathParam("networkSources").appendPathParam(request.getNetworkSourceId()).accept(new String[]{"application/json"}).handleBody(NetworkSources.class, GetNetworkSourceResponse.Builder::networkSources).handleResponseHeaderString("opc-request-id", GetNetworkSourceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetNetworkSourceResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetPolicyResponse> getPolicy(GetPolicyRequest request, AsyncHandler<GetPolicyRequest, GetPolicyResponse> handler) {
        Validate.notBlank((String)request.getPolicyId(), (String)"policyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPolicyResponse::builder).logger(LOG, "getPolicy").serviceDetails("Identity", "GetPolicy", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Policy/GetPolicy").method(Method.GET).requestBuilder(GetPolicyRequest::builder).basePath("/20160918").appendPathParam("policies").appendPathParam(request.getPolicyId()).accept(new String[]{"application/json"}).handleBody(Policy.class, GetPolicyResponse.Builder::policy).handleResponseHeaderString("opc-request-id", GetPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetPolicyResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetStandardTagTemplateResponse> getStandardTagTemplate(GetStandardTagTemplateRequest request, AsyncHandler<GetStandardTagTemplateRequest, GetStandardTagTemplateResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getStandardTagNamespaceName(), (String)"standardTagNamespaceName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetStandardTagTemplateResponse::builder).logger(LOG, "getStandardTagTemplate").serviceDetails("Identity", "GetStandardTagTemplate", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/StandardTagNamespaceTemplate/GetStandardTagTemplate").method(Method.GET).requestBuilder(GetStandardTagTemplateRequest::builder).basePath("/20160918").appendPathParam("tags").appendPathParam("standardTagNamespaceTemplates").appendPathParam(request.getStandardTagNamespaceName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).handleBody(StandardTagNamespaceTemplate.class, GetStandardTagTemplateResponse.Builder::standardTagNamespaceTemplate).handleResponseHeaderString("opc-request-id", GetStandardTagTemplateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetTagResponse> getTag(GetTagRequest request, AsyncHandler<GetTagRequest, GetTagResponse> handler) {
        Validate.notBlank((String)request.getTagNamespaceId(), (String)"tagNamespaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTagName(), (String)"tagName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTagResponse::builder).logger(LOG, "getTag").serviceDetails("Identity", "GetTag", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Tag/GetTag").method(Method.GET).requestBuilder(GetTagRequest::builder).basePath("/20160918").appendPathParam("tagNamespaces").appendPathParam(request.getTagNamespaceId()).appendPathParam("tags").appendPathParam(request.getTagName()).accept(new String[]{"application/json"}).handleBody(Tag.class, GetTagResponse.Builder::tag).handleResponseHeaderString("opc-request-id", GetTagResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetTagResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetTagDefaultResponse> getTagDefault(GetTagDefaultRequest request, AsyncHandler<GetTagDefaultRequest, GetTagDefaultResponse> handler) {
        Validate.notBlank((String)request.getTagDefaultId(), (String)"tagDefaultId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTagDefaultResponse::builder).logger(LOG, "getTagDefault").serviceDetails("Identity", "GetTagDefault", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagDefault/GetTagDefault").method(Method.GET).requestBuilder(GetTagDefaultRequest::builder).basePath("/20160918").appendPathParam("tagDefaults").appendPathParam(request.getTagDefaultId()).accept(new String[]{"application/json"}).handleBody(TagDefault.class, GetTagDefaultResponse.Builder::tagDefault).handleResponseHeaderString("opc-request-id", GetTagDefaultResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetTagDefaultResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetTagNamespaceResponse> getTagNamespace(GetTagNamespaceRequest request, AsyncHandler<GetTagNamespaceRequest, GetTagNamespaceResponse> handler) {
        Validate.notBlank((String)request.getTagNamespaceId(), (String)"tagNamespaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTagNamespaceResponse::builder).logger(LOG, "getTagNamespace").serviceDetails("Identity", "GetTagNamespace", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagNamespace/GetTagNamespace").method(Method.GET).requestBuilder(GetTagNamespaceRequest::builder).basePath("/20160918").appendPathParam("tagNamespaces").appendPathParam(request.getTagNamespaceId()).accept(new String[]{"application/json"}).handleBody(TagNamespace.class, GetTagNamespaceResponse.Builder::tagNamespace).handleResponseHeaderString("opc-request-id", GetTagNamespaceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetTaggingWorkRequestResponse> getTaggingWorkRequest(GetTaggingWorkRequestRequest request, AsyncHandler<GetTaggingWorkRequestRequest, GetTaggingWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTaggingWorkRequestResponse::builder).logger(LOG, "getTaggingWorkRequest").serviceDetails("Identity", "GetTaggingWorkRequest", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TaggingWorkRequest/GetTaggingWorkRequest").method(Method.GET).requestBuilder(GetTaggingWorkRequestRequest::builder).basePath("/20160918").appendPathParam("taggingWorkRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).handleBody(TaggingWorkRequest.class, GetTaggingWorkRequestResponse.Builder::taggingWorkRequest).handleResponseHeaderString("opc-request-id", GetTaggingWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetTaggingWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<GetTenancyResponse> getTenancy(GetTenancyRequest request, AsyncHandler<GetTenancyRequest, GetTenancyResponse> handler) {
        Validate.notBlank((String)request.getTenancyId(), (String)"tenancyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTenancyResponse::builder).logger(LOG, "getTenancy").serviceDetails("Identity", "GetTenancy", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Tenancy/GetTenancy").method(Method.GET).requestBuilder(GetTenancyRequest::builder).basePath("/20160918").appendPathParam("tenancies").appendPathParam(request.getTenancyId()).accept(new String[]{"application/json"}).handleBody(Tenancy.class, GetTenancyResponse.Builder::tenancy).handleResponseHeaderString("opc-request-id", GetTenancyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetUserResponse> getUser(GetUserRequest request, AsyncHandler<GetUserRequest, GetUserResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetUserResponse::builder).logger(LOG, "getUser").serviceDetails("Identity", "GetUser", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/User/GetUser").method(Method.GET).requestBuilder(GetUserRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).accept(new String[]{"application/json"}).handleBody(User.class, GetUserResponse.Builder::user).handleResponseHeaderString("opc-request-id", GetUserResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetUserResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetUserGroupMembershipResponse> getUserGroupMembership(GetUserGroupMembershipRequest request, AsyncHandler<GetUserGroupMembershipRequest, GetUserGroupMembershipResponse> handler) {
        Validate.notBlank((String)request.getUserGroupMembershipId(), (String)"userGroupMembershipId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetUserGroupMembershipResponse::builder).logger(LOG, "getUserGroupMembership").serviceDetails("Identity", "GetUserGroupMembership", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/UserGroupMembership/GetUserGroupMembership").method(Method.GET).requestBuilder(GetUserGroupMembershipRequest::builder).basePath("/20160918").appendPathParam("userGroupMemberships").appendPathParam(request.getUserGroupMembershipId()).accept(new String[]{"application/json"}).handleBody(UserGroupMembership.class, GetUserGroupMembershipResponse.Builder::userGroupMembership).handleResponseHeaderString("opc-request-id", GetUserGroupMembershipResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetUserGroupMembershipResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetUserUIPasswordInformationResponse> getUserUIPasswordInformation(GetUserUIPasswordInformationRequest request, AsyncHandler<GetUserUIPasswordInformationRequest, GetUserUIPasswordInformationResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetUserUIPasswordInformationResponse::builder).logger(LOG, "getUserUIPasswordInformation").serviceDetails("Identity", "GetUserUIPasswordInformation", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/UIPasswordInformation/GetUserUIPasswordInformation").method(Method.GET).requestBuilder(GetUserUIPasswordInformationRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("uiPassword").accept(new String[]{"application/json"}).handleBody(UIPasswordInformation.class, GetUserUIPasswordInformationResponse.Builder::uIPasswordInformation).handleResponseHeaderString("opc-request-id", GetUserUIPasswordInformationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetUserUIPasswordInformationResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Identity", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20160918").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ImportStandardTagsResponse> importStandardTags(ImportStandardTagsRequest request, AsyncHandler<ImportStandardTagsRequest, ImportStandardTagsResponse> handler) {
        return this.clientCall(request, ImportStandardTagsResponse::builder).logger(LOG, "importStandardTags").serviceDetails("Identity", "ImportStandardTags", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Tag/ImportStandardTags").method(Method.POST).requestBuilder(ImportStandardTagsRequest::builder).basePath("/20160918").appendPathParam("tags").appendPathParam("actions").appendPathParam("importStandardTags").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ImportStandardTagsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ImportStandardTagsResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAllowedDomainLicenseTypesResponse> listAllowedDomainLicenseTypes(ListAllowedDomainLicenseTypesRequest request, AsyncHandler<ListAllowedDomainLicenseTypesRequest, ListAllowedDomainLicenseTypesResponse> handler) {
        return this.clientCall(request, ListAllowedDomainLicenseTypesResponse::builder).logger(LOG, "listAllowedDomainLicenseTypes").serviceDetails("Identity", "ListAllowedDomainLicenseTypes", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Domain/ListAllowedDomainLicenseTypes").method(Method.GET).requestBuilder(ListAllowedDomainLicenseTypesRequest::builder).basePath("/20160918").appendPathParam("allowedDomainLicenseTypes").appendQueryParam("currentLicenseTypeName", (Object)request.getCurrentLicenseTypeName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AllowedDomainLicenseTypeSummary.class, ListAllowedDomainLicenseTypesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListAllowedDomainLicenseTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAllowedDomainLicenseTypesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListApiKeysResponse> listApiKeys(ListApiKeysRequest request, AsyncHandler<ListApiKeysRequest, ListApiKeysResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListApiKeysResponse::builder).logger(LOG, "listApiKeys").serviceDetails("Identity", "ListApiKeys", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/ApiKey/ListApiKeys").method(Method.GET).requestBuilder(ListApiKeysRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("apiKeys").accept(new String[]{"application/json"}).handleBodyList(ApiKey.class, ListApiKeysResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListApiKeysResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListApiKeysResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListAuthTokensResponse> listAuthTokens(ListAuthTokensRequest request, AsyncHandler<ListAuthTokensRequest, ListAuthTokensResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAuthTokensResponse::builder).logger(LOG, "listAuthTokens").serviceDetails("Identity", "ListAuthTokens", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/AuthToken/ListAuthTokens").method(Method.GET).requestBuilder(ListAuthTokensRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("authTokens").accept(new String[]{"application/json"}).handleBodyList(AuthToken.class, ListAuthTokensResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListAuthTokensResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAuthTokensResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListAvailabilityDomainsResponse> listAvailabilityDomains(ListAvailabilityDomainsRequest request, AsyncHandler<ListAvailabilityDomainsRequest, ListAvailabilityDomainsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListAvailabilityDomainsResponse::builder).logger(LOG, "listAvailabilityDomains").serviceDetails("Identity", "ListAvailabilityDomains", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/AvailabilityDomain/ListAvailabilityDomains").method(Method.GET).requestBuilder(ListAvailabilityDomainsRequest::builder).basePath("/20160918").appendPathParam("availabilityDomains").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).handleBodyList(AvailabilityDomain.class, ListAvailabilityDomainsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListAvailabilityDomainsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAvailabilityDomainsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListBulkActionResourceTypesResponse> listBulkActionResourceTypes(ListBulkActionResourceTypesRequest request, AsyncHandler<ListBulkActionResourceTypesRequest, ListBulkActionResourceTypesResponse> handler) {
        Objects.requireNonNull(request.getBulkActionType(), "bulkActionType is required");
        return this.clientCall(request, ListBulkActionResourceTypesResponse::builder).logger(LOG, "listBulkActionResourceTypes").serviceDetails("Identity", "ListBulkActionResourceTypes", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/BulkActionResourceTypeCollection/ListBulkActionResourceTypes").method(Method.GET).requestBuilder(ListBulkActionResourceTypesRequest::builder).basePath("/20160918").appendPathParam("compartments").appendPathParam("bulkActionResourceTypes").appendEnumQueryParam("bulkActionType", (BmcEnum)request.getBulkActionType()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).handleBody(BulkActionResourceTypeCollection.class, ListBulkActionResourceTypesResponse.Builder::bulkActionResourceTypeCollection).handleResponseHeaderString("opc-request-id", ListBulkActionResourceTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBulkActionResourceTypesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListBulkEditTagsResourceTypesResponse> listBulkEditTagsResourceTypes(ListBulkEditTagsResourceTypesRequest request, AsyncHandler<ListBulkEditTagsResourceTypesRequest, ListBulkEditTagsResourceTypesResponse> handler) {
        return this.clientCall(request, ListBulkEditTagsResourceTypesResponse::builder).logger(LOG, "listBulkEditTagsResourceTypes").serviceDetails("Identity", "ListBulkEditTagsResourceTypes", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/BulkEditTagsResourceTypeCollection/ListBulkEditTagsResourceTypes").method(Method.GET).requestBuilder(ListBulkEditTagsResourceTypesRequest::builder).basePath("/20160918").appendPathParam("tags").appendPathParam("bulkEditResourceTypes").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).handleBody(BulkEditTagsResourceTypeCollection.class, ListBulkEditTagsResourceTypesResponse.Builder::bulkEditTagsResourceTypeCollection).handleResponseHeaderString("opc-request-id", ListBulkEditTagsResourceTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBulkEditTagsResourceTypesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListCompartmentsResponse> listCompartments(ListCompartmentsRequest request, AsyncHandler<ListCompartmentsRequest, ListCompartmentsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListCompartmentsResponse::builder).logger(LOG, "listCompartments").serviceDetails("Identity", "ListCompartments", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Compartment/ListCompartments").method(Method.GET).requestBuilder(ListCompartmentsRequest::builder).basePath("/20160918").appendPathParam("compartments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(Compartment.class, ListCompartmentsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListCompartmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCompartmentsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListCostTrackingTagsResponse> listCostTrackingTags(ListCostTrackingTagsRequest request, AsyncHandler<ListCostTrackingTagsRequest, ListCostTrackingTagsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListCostTrackingTagsResponse::builder).logger(LOG, "listCostTrackingTags").serviceDetails("Identity", "ListCostTrackingTags", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Tag/ListCostTrackingTags").method(Method.GET).requestBuilder(ListCostTrackingTagsRequest::builder).basePath("/20160918").appendPathParam("tagNamespaces").appendPathParam("actions").appendPathParam("listCostTrackingTags").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).handleBodyList(Tag.class, ListCostTrackingTagsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListCostTrackingTagsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCostTrackingTagsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListCustomerSecretKeysResponse> listCustomerSecretKeys(ListCustomerSecretKeysRequest request, AsyncHandler<ListCustomerSecretKeysRequest, ListCustomerSecretKeysResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListCustomerSecretKeysResponse::builder).logger(LOG, "listCustomerSecretKeys").serviceDetails("Identity", "ListCustomerSecretKeys", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/CustomerSecretKeySummary/ListCustomerSecretKeys").method(Method.GET).requestBuilder(ListCustomerSecretKeysRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("customerSecretKeys").accept(new String[]{"application/json"}).handleBodyList(CustomerSecretKeySummary.class, ListCustomerSecretKeysResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListCustomerSecretKeysResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCustomerSecretKeysResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDbCredentialsResponse> listDbCredentials(ListDbCredentialsRequest request, AsyncHandler<ListDbCredentialsRequest, ListDbCredentialsResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDbCredentialsResponse::builder).logger(LOG, "listDbCredentials").serviceDetails("Identity", "ListDbCredentials", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/User/ListDbCredentials").method(Method.GET).requestBuilder(ListDbCredentialsRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("dbCredentials").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(DbCredentialSummary.class, ListDbCredentialsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListDbCredentialsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDbCredentialsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDomainsResponse> listDomains(ListDomainsRequest request, AsyncHandler<ListDomainsRequest, ListDomainsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDomainsResponse::builder).logger(LOG, "listDomains").serviceDetails("Identity", "ListDomains", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/DomainSummary/ListDomains").method(Method.GET).requestBuilder(ListDomainsRequest::builder).basePath("/20160918").appendPathParam("domains").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("url", (Object)request.getUrl()).appendQueryParam("homeRegionUrl", (Object)request.getHomeRegionUrl()).appendQueryParam("type", (Object)request.getType()).appendQueryParam("licenseType", (Object)request.getLicenseType()).appendQueryParam("isHiddenOnLogin", (Object)request.getIsHiddenOnLogin()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(DomainSummary.class, ListDomainsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListDomainsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDomainsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDynamicGroupsResponse> listDynamicGroups(ListDynamicGroupsRequest request, AsyncHandler<ListDynamicGroupsRequest, ListDynamicGroupsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDynamicGroupsResponse::builder).logger(LOG, "listDynamicGroups").serviceDetails("Identity", "ListDynamicGroups", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/DynamicGroup/ListDynamicGroups").method(Method.GET).requestBuilder(ListDynamicGroupsRequest::builder).basePath("/20160918").appendPathParam("dynamicGroups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(DynamicGroup.class, ListDynamicGroupsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListDynamicGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDynamicGroupsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFaultDomainsResponse> listFaultDomains(ListFaultDomainsRequest request, AsyncHandler<ListFaultDomainsRequest, ListFaultDomainsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getAvailabilityDomain(), "availabilityDomain is required");
        return this.clientCall(request, ListFaultDomainsResponse::builder).logger(LOG, "listFaultDomains").serviceDetails("Identity", "ListFaultDomains", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/FaultDomain/ListFaultDomains").method(Method.GET).requestBuilder(ListFaultDomainsRequest::builder).basePath("/20160918").appendPathParam("faultDomains").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).accept(new String[]{"application/json"}).handleBodyList(FaultDomain.class, ListFaultDomainsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListFaultDomainsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListGroupsResponse> listGroups(ListGroupsRequest request, AsyncHandler<ListGroupsRequest, ListGroupsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListGroupsResponse::builder).logger(LOG, "listGroups").serviceDetails("Identity", "ListGroups", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Group/ListGroups").method(Method.GET).requestBuilder(ListGroupsRequest::builder).basePath("/20160918").appendPathParam("groups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(Group.class, ListGroupsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListGroupsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListIamWorkRequestErrorsResponse> listIamWorkRequestErrors(ListIamWorkRequestErrorsRequest request, AsyncHandler<ListIamWorkRequestErrorsRequest, ListIamWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getIamWorkRequestId(), (String)"iamWorkRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListIamWorkRequestErrorsResponse::builder).logger(LOG, "listIamWorkRequestErrors").serviceDetails("Identity", "ListIamWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/IamWorkRequest/ListIamWorkRequestErrors").method(Method.GET).requestBuilder(ListIamWorkRequestErrorsRequest::builder).basePath("/20160918").appendPathParam("iamWorkRequests").appendPathParam(request.getIamWorkRequestId()).appendPathParam("errors").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(IamWorkRequestErrorSummary.class, ListIamWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListIamWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListIamWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListIamWorkRequestLogsResponse> listIamWorkRequestLogs(ListIamWorkRequestLogsRequest request, AsyncHandler<ListIamWorkRequestLogsRequest, ListIamWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getIamWorkRequestId(), (String)"iamWorkRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListIamWorkRequestLogsResponse::builder).logger(LOG, "listIamWorkRequestLogs").serviceDetails("Identity", "ListIamWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/IamWorkRequestLogSummary/ListIamWorkRequestLogs").method(Method.GET).requestBuilder(ListIamWorkRequestLogsRequest::builder).basePath("/20160918").appendPathParam("iamWorkRequests").appendPathParam(request.getIamWorkRequestId()).appendPathParam("logs").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(IamWorkRequestLogSummary.class, ListIamWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListIamWorkRequestLogsResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", ListIamWorkRequestLogsResponse.Builder::retryAfter).handleResponseHeaderString("opc-next-page", ListIamWorkRequestLogsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListIamWorkRequestsResponse> listIamWorkRequests(ListIamWorkRequestsRequest request, AsyncHandler<ListIamWorkRequestsRequest, ListIamWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListIamWorkRequestsResponse::builder).logger(LOG, "listIamWorkRequests").serviceDetails("Identity", "ListIamWorkRequests", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/IamWorkRequestSummary/ListIamWorkRequests").method(Method.GET).requestBuilder(ListIamWorkRequestsRequest::builder).basePath("/20160918").appendPathParam("iamWorkRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("resourceIdentifier", (Object)request.getResourceIdentifier()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(IamWorkRequestSummary.class, ListIamWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListIamWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListIamWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListIdentityProviderGroupsResponse> listIdentityProviderGroups(ListIdentityProviderGroupsRequest request, AsyncHandler<ListIdentityProviderGroupsRequest, ListIdentityProviderGroupsResponse> handler) {
        Validate.notBlank((String)request.getIdentityProviderId(), (String)"identityProviderId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListIdentityProviderGroupsResponse::builder).logger(LOG, "listIdentityProviderGroups").serviceDetails("Identity", "ListIdentityProviderGroups", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/IdentityProviderGroupSummary/ListIdentityProviderGroups").method(Method.GET).requestBuilder(ListIdentityProviderGroupsRequest::builder).basePath("/20160918").appendPathParam("identityProviders").appendPathParam(request.getIdentityProviderId()).appendPathParam("groups").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(IdentityProviderGroupSummary.class, ListIdentityProviderGroupsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListIdentityProviderGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListIdentityProviderGroupsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListIdentityProvidersResponse> listIdentityProviders(ListIdentityProvidersRequest request, AsyncHandler<ListIdentityProvidersRequest, ListIdentityProvidersResponse> handler) {
        Objects.requireNonNull(request.getProtocol(), "protocol is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListIdentityProvidersResponse::builder).logger(LOG, "listIdentityProviders").serviceDetails("Identity", "ListIdentityProviders", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/IdentityProvider/ListIdentityProviders").method(Method.GET).requestBuilder(ListIdentityProvidersRequest::builder).basePath("/20160918").appendPathParam("identityProviders").appendQueryParam("protocol", (Object)request.getProtocol()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(IdentityProvider.class, ListIdentityProvidersResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListIdentityProvidersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListIdentityProvidersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListIdpGroupMappingsResponse> listIdpGroupMappings(ListIdpGroupMappingsRequest request, AsyncHandler<ListIdpGroupMappingsRequest, ListIdpGroupMappingsResponse> handler) {
        Validate.notBlank((String)request.getIdentityProviderId(), (String)"identityProviderId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListIdpGroupMappingsResponse::builder).logger(LOG, "listIdpGroupMappings").serviceDetails("Identity", "ListIdpGroupMappings", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/IdpGroupMapping/ListIdpGroupMappings").method(Method.GET).requestBuilder(ListIdpGroupMappingsRequest::builder).basePath("/20160918").appendPathParam("identityProviders").appendPathParam(request.getIdentityProviderId()).appendPathParam("groupMappings").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).handleBodyList(IdpGroupMapping.class, ListIdpGroupMappingsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListIdpGroupMappingsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListIdpGroupMappingsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListMfaTotpDevicesResponse> listMfaTotpDevices(ListMfaTotpDevicesRequest request, AsyncHandler<ListMfaTotpDevicesRequest, ListMfaTotpDevicesResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListMfaTotpDevicesResponse::builder).logger(LOG, "listMfaTotpDevices").serviceDetails("Identity", "ListMfaTotpDevices", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/MfaTotpDeviceSummary/ListMfaTotpDevices").method(Method.GET).requestBuilder(ListMfaTotpDevicesRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("mfaTotpDevices").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).handleBodyList(MfaTotpDeviceSummary.class, ListMfaTotpDevicesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListMfaTotpDevicesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMfaTotpDevicesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListNetworkSourcesResponse> listNetworkSources(ListNetworkSourcesRequest request, AsyncHandler<ListNetworkSourcesRequest, ListNetworkSourcesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListNetworkSourcesResponse::builder).logger(LOG, "listNetworkSources").serviceDetails("Identity", "ListNetworkSources", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/NetworkSourcesSummary/ListNetworkSources").method(Method.GET).requestBuilder(ListNetworkSourcesRequest::builder).basePath("/20160918").appendPathParam("networkSources").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(NetworkSourcesSummary.class, ListNetworkSourcesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListNetworkSourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListNetworkSourcesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListOAuthClientCredentialsResponse> listOAuthClientCredentials(ListOAuthClientCredentialsRequest request, AsyncHandler<ListOAuthClientCredentialsRequest, ListOAuthClientCredentialsResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListOAuthClientCredentialsResponse::builder).logger(LOG, "listOAuthClientCredentials").serviceDetails("Identity", "ListOAuthClientCredentials", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/User/ListOAuthClientCredentials").method(Method.GET).requestBuilder(ListOAuthClientCredentialsRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("oauth2ClientCredentials").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(OAuth2ClientCredentialSummary.class, ListOAuthClientCredentialsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListOAuthClientCredentialsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOAuthClientCredentialsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPoliciesResponse> listPolicies(ListPoliciesRequest request, AsyncHandler<ListPoliciesRequest, ListPoliciesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListPoliciesResponse::builder).logger(LOG, "listPolicies").serviceDetails("Identity", "ListPolicies", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Policy/ListPolicies").method(Method.GET).requestBuilder(ListPoliciesRequest::builder).basePath("/20160918").appendPathParam("policies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(Policy.class, ListPoliciesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListPoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPoliciesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListRegionSubscriptionsResponse> listRegionSubscriptions(ListRegionSubscriptionsRequest request, AsyncHandler<ListRegionSubscriptionsRequest, ListRegionSubscriptionsResponse> handler) {
        Validate.notBlank((String)request.getTenancyId(), (String)"tenancyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListRegionSubscriptionsResponse::builder).logger(LOG, "listRegionSubscriptions").serviceDetails("Identity", "ListRegionSubscriptions", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/RegionSubscription/ListRegionSubscriptions").method(Method.GET).requestBuilder(ListRegionSubscriptionsRequest::builder).basePath("/20160918").appendPathParam("tenancies").appendPathParam(request.getTenancyId()).appendPathParam("regionSubscriptions").accept(new String[]{"application/json"}).handleBodyList(RegionSubscription.class, ListRegionSubscriptionsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListRegionSubscriptionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListRegionsResponse> listRegions(ListRegionsRequest request, AsyncHandler<ListRegionsRequest, ListRegionsResponse> handler) {
        return this.clientCall(request, ListRegionsResponse::builder).logger(LOG, "listRegions").serviceDetails("Identity", "ListRegions", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Region/ListRegions").method(Method.GET).requestBuilder(ListRegionsRequest::builder).basePath("/20160918").appendPathParam("regions").accept(new String[]{"application/json"}).handleBodyList(Region.class, ListRegionsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListRegionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListSmtpCredentialsResponse> listSmtpCredentials(ListSmtpCredentialsRequest request, AsyncHandler<ListSmtpCredentialsRequest, ListSmtpCredentialsResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSmtpCredentialsResponse::builder).logger(LOG, "listSmtpCredentials").serviceDetails("Identity", "ListSmtpCredentials", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/SmtpCredentialSummary/ListSmtpCredentials").method(Method.GET).requestBuilder(ListSmtpCredentialsRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("smtpCredentials").accept(new String[]{"application/json"}).handleBodyList(SmtpCredentialSummary.class, ListSmtpCredentialsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSmtpCredentialsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSmtpCredentialsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListStandardTagNamespacesResponse> listStandardTagNamespaces(ListStandardTagNamespacesRequest request, AsyncHandler<ListStandardTagNamespacesRequest, ListStandardTagNamespacesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListStandardTagNamespacesResponse::builder).logger(LOG, "listStandardTagNamespaces").serviceDetails("Identity", "ListStandardTagNamespaces", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/StandardTagNamespaceTemplateSummary/ListStandardTagNamespaces").method(Method.GET).requestBuilder(ListStandardTagNamespacesRequest::builder).basePath("/20160918").appendPathParam("tags").appendPathParam("standardTagNamespaceTemplates").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).handleBodyList(StandardTagNamespaceTemplateSummary.class, ListStandardTagNamespacesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListStandardTagNamespacesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListStandardTagNamespacesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSwiftPasswordsResponse> listSwiftPasswords(ListSwiftPasswordsRequest request, AsyncHandler<ListSwiftPasswordsRequest, ListSwiftPasswordsResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSwiftPasswordsResponse::builder).logger(LOG, "listSwiftPasswords").serviceDetails("Identity", "ListSwiftPasswords", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/SwiftPassword/ListSwiftPasswords").method(Method.GET).requestBuilder(ListSwiftPasswordsRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("swiftPasswords").accept(new String[]{"application/json"}).handleBodyList(SwiftPassword.class, ListSwiftPasswordsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSwiftPasswordsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSwiftPasswordsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListTagDefaultsResponse> listTagDefaults(ListTagDefaultsRequest request, AsyncHandler<ListTagDefaultsRequest, ListTagDefaultsResponse> handler) {
        return this.clientCall(request, ListTagDefaultsResponse::builder).logger(LOG, "listTagDefaults").serviceDetails("Identity", "ListTagDefaults", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagDefaultSummary/ListTagDefaults").method(Method.GET).requestBuilder(ListTagDefaultsRequest::builder).basePath("/20160918").appendPathParam("tagDefaults").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("tagDefinitionId", (Object)request.getTagDefinitionId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(TagDefaultSummary.class, ListTagDefaultsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListTagDefaultsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTagDefaultsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListTagNamespacesResponse> listTagNamespaces(ListTagNamespacesRequest request, AsyncHandler<ListTagNamespacesRequest, ListTagNamespacesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListTagNamespacesResponse::builder).logger(LOG, "listTagNamespaces").serviceDetails("Identity", "ListTagNamespaces", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagNamespaceSummary/ListTagNamespaces").method(Method.GET).requestBuilder(ListTagNamespacesRequest::builder).basePath("/20160918").appendPathParam("tagNamespaces").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("includeSubcompartments", (Object)request.getIncludeSubcompartments()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(TagNamespaceSummary.class, ListTagNamespacesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListTagNamespacesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTagNamespacesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListTaggingWorkRequestErrorsResponse> listTaggingWorkRequestErrors(ListTaggingWorkRequestErrorsRequest request, AsyncHandler<ListTaggingWorkRequestErrorsRequest, ListTaggingWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTaggingWorkRequestErrorsResponse::builder).logger(LOG, "listTaggingWorkRequestErrors").serviceDetails("Identity", "ListTaggingWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TaggingWorkRequestErrorSummary/ListTaggingWorkRequestErrors").method(Method.GET).requestBuilder(ListTaggingWorkRequestErrorsRequest::builder).basePath("/20160918").appendPathParam("taggingWorkRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).handleBodyList(TaggingWorkRequestErrorSummary.class, ListTaggingWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListTaggingWorkRequestErrorsResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", ListTaggingWorkRequestErrorsResponse.Builder::retryAfter).handleResponseHeaderString("opc-next-page", ListTaggingWorkRequestErrorsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListTaggingWorkRequestLogsResponse> listTaggingWorkRequestLogs(ListTaggingWorkRequestLogsRequest request, AsyncHandler<ListTaggingWorkRequestLogsRequest, ListTaggingWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTaggingWorkRequestLogsResponse::builder).logger(LOG, "listTaggingWorkRequestLogs").serviceDetails("Identity", "ListTaggingWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TaggingWorkRequestLogSummary/ListTaggingWorkRequestLogs").method(Method.GET).requestBuilder(ListTaggingWorkRequestLogsRequest::builder).basePath("/20160918").appendPathParam("taggingWorkRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).handleBodyList(TaggingWorkRequestLogSummary.class, ListTaggingWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListTaggingWorkRequestLogsResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", ListTaggingWorkRequestLogsResponse.Builder::retryAfter).handleResponseHeaderString("opc-next-page", ListTaggingWorkRequestLogsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListTaggingWorkRequestsResponse> listTaggingWorkRequests(ListTaggingWorkRequestsRequest request, AsyncHandler<ListTaggingWorkRequestsRequest, ListTaggingWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListTaggingWorkRequestsResponse::builder).logger(LOG, "listTaggingWorkRequests").serviceDetails("Identity", "ListTaggingWorkRequests", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TaggingWorkRequestSummary/ListTaggingWorkRequests").method(Method.GET).requestBuilder(ListTaggingWorkRequestsRequest::builder).basePath("/20160918").appendPathParam("taggingWorkRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("resourceIdentifier", (Object)request.getResourceIdentifier()).accept(new String[]{"application/json"}).handleBodyList(TaggingWorkRequestSummary.class, ListTaggingWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListTaggingWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTaggingWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListTagsResponse> listTags(ListTagsRequest request, AsyncHandler<ListTagsRequest, ListTagsResponse> handler) {
        Validate.notBlank((String)request.getTagNamespaceId(), (String)"tagNamespaceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTagsResponse::builder).logger(LOG, "listTags").serviceDetails("Identity", "ListTags", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagSummary/ListTags").method(Method.GET).requestBuilder(ListTagsRequest::builder).basePath("/20160918").appendPathParam("tagNamespaces").appendPathParam(request.getTagNamespaceId()).appendPathParam("tags").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(TagSummary.class, ListTagsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListTagsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTagsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListUserGroupMembershipsResponse> listUserGroupMemberships(ListUserGroupMembershipsRequest request, AsyncHandler<ListUserGroupMembershipsRequest, ListUserGroupMembershipsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListUserGroupMembershipsResponse::builder).logger(LOG, "listUserGroupMemberships").serviceDetails("Identity", "ListUserGroupMemberships", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/UserGroupMembership/ListUserGroupMemberships").method(Method.GET).requestBuilder(ListUserGroupMembershipsRequest::builder).basePath("/20160918").appendPathParam("userGroupMemberships").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("userId", (Object)request.getUserId()).appendQueryParam("groupId", (Object)request.getGroupId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).handleBodyList(UserGroupMembership.class, ListUserGroupMembershipsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListUserGroupMembershipsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListUserGroupMembershipsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListUsersResponse> listUsers(ListUsersRequest request, AsyncHandler<ListUsersRequest, ListUsersResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListUsersResponse::builder).logger(LOG, "listUsers").serviceDetails("Identity", "ListUsers", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/User/ListUsers").method(Method.GET).requestBuilder(ListUsersRequest::builder).basePath("/20160918").appendPathParam("users").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("identityProviderId", (Object)request.getIdentityProviderId()).appendQueryParam("externalIdentifier", (Object)request.getExternalIdentifier()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(User.class, ListUsersResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListUsersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListUsersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Identity", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/WorkRequestSummary/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20160918").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("resourceIdentifier", (Object)request.getResourceIdentifier()).accept(new String[]{"application/json"}).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<MoveCompartmentResponse> moveCompartment(MoveCompartmentRequest request, AsyncHandler<MoveCompartmentRequest, MoveCompartmentResponse> handler) {
        Validate.notBlank((String)request.getCompartmentId(), (String)"compartmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getMoveCompartmentDetails(), "moveCompartmentDetails is required");
        return this.clientCall(request, MoveCompartmentResponse::builder).logger(LOG, "moveCompartment").serviceDetails("Identity", "MoveCompartment", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Compartment/MoveCompartment").method(Method.POST).requestBuilder(MoveCompartmentRequest::builder).basePath("/20160918").appendPathParam("compartments").appendPathParam(request.getCompartmentId()).appendPathParam("actions").appendPathParam("moveCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", MoveCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", MoveCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<RecoverCompartmentResponse> recoverCompartment(RecoverCompartmentRequest request, AsyncHandler<RecoverCompartmentRequest, RecoverCompartmentResponse> handler) {
        Validate.notBlank((String)request.getCompartmentId(), (String)"compartmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RecoverCompartmentResponse::builder).logger(LOG, "recoverCompartment").serviceDetails("Identity", "RecoverCompartment", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Compartment/RecoverCompartment").method(Method.POST).requestBuilder(RecoverCompartmentRequest::builder).basePath("/20160918").appendPathParam("compartments").appendPathParam(request.getCompartmentId()).appendPathParam("actions").appendPathParam("recoverCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Compartment.class, RecoverCompartmentResponse.Builder::compartment).handleResponseHeaderString("opc-request-id", RecoverCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", RecoverCompartmentResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<RemoveTagDefaultLockResponse> removeTagDefaultLock(RemoveTagDefaultLockRequest request, AsyncHandler<RemoveTagDefaultLockRequest, RemoveTagDefaultLockResponse> handler) {
        Validate.notBlank((String)request.getTagDefaultId(), (String)"tagDefaultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveLockDetails(), "removeLockDetails is required");
        return this.clientCall(request, RemoveTagDefaultLockResponse::builder).logger(LOG, "removeTagDefaultLock").serviceDetails("Identity", "RemoveTagDefaultLock", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagDefault/RemoveTagDefaultLock").method(Method.POST).requestBuilder(RemoveTagDefaultLockRequest::builder).basePath("/20160918").appendPathParam("tagDefaults").appendPathParam(request.getTagDefaultId()).appendPathParam("actions").appendPathParam("removeLock").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TagDefault.class, RemoveTagDefaultLockResponse.Builder::tagDefault).handleResponseHeaderString("opc-request-id", RemoveTagDefaultLockResponse.Builder::opcRequestId).handleResponseHeaderString("etag", RemoveTagDefaultLockResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<RemoveTagNamespaceLockResponse> removeTagNamespaceLock(RemoveTagNamespaceLockRequest request, AsyncHandler<RemoveTagNamespaceLockRequest, RemoveTagNamespaceLockResponse> handler) {
        Validate.notBlank((String)request.getTagNamespaceId(), (String)"tagNamespaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveLockDetails(), "removeLockDetails is required");
        return this.clientCall(request, RemoveTagNamespaceLockResponse::builder).logger(LOG, "removeTagNamespaceLock").serviceDetails("Identity", "RemoveTagNamespaceLock", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagNamespace/RemoveTagNamespaceLock").method(Method.POST).requestBuilder(RemoveTagNamespaceLockRequest::builder).basePath("/20160918").appendPathParam("tagNamespaces").appendPathParam(request.getTagNamespaceId()).appendPathParam("actions").appendPathParam("removeLock").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TagNamespace.class, RemoveTagNamespaceLockResponse.Builder::tagNamespace).handleResponseHeaderString("opc-request-id", RemoveTagNamespaceLockResponse.Builder::opcRequestId).handleResponseHeaderString("etag", RemoveTagNamespaceLockResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<RemoveUserFromGroupResponse> removeUserFromGroup(RemoveUserFromGroupRequest request, AsyncHandler<RemoveUserFromGroupRequest, RemoveUserFromGroupResponse> handler) {
        Validate.notBlank((String)request.getUserGroupMembershipId(), (String)"userGroupMembershipId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RemoveUserFromGroupResponse::builder).logger(LOG, "removeUserFromGroup").serviceDetails("Identity", "RemoveUserFromGroup", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/UserGroupMembership/RemoveUserFromGroup").method(Method.DELETE).requestBuilder(RemoveUserFromGroupRequest::builder).basePath("/20160918").appendPathParam("userGroupMemberships").appendPathParam(request.getUserGroupMembershipId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", RemoveUserFromGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ResetIdpScimClientResponse> resetIdpScimClient(ResetIdpScimClientRequest request, AsyncHandler<ResetIdpScimClientRequest, ResetIdpScimClientResponse> handler) {
        Validate.notBlank((String)request.getIdentityProviderId(), (String)"identityProviderId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ResetIdpScimClientResponse::builder).logger(LOG, "resetIdpScimClient").serviceDetails("Identity", "ResetIdpScimClient", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/ScimClientCredentials/ResetIdpScimClient").method(Method.POST).requestBuilder(ResetIdpScimClientRequest::builder).basePath("/20160918").appendPathParam("identityProviders").appendPathParam(request.getIdentityProviderId()).appendPathParam("actions").appendPathParam("resetScimClient").accept(new String[]{"application/json"}).handleBody(ScimClientCredentials.class, ResetIdpScimClientResponse.Builder::scimClientCredentials).handleResponseHeaderString("opc-request-id", ResetIdpScimClientResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateAuthTokenResponse> updateAuthToken(UpdateAuthTokenRequest request, AsyncHandler<UpdateAuthTokenRequest, UpdateAuthTokenResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAuthTokenId(), (String)"authTokenId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAuthTokenDetails(), "updateAuthTokenDetails is required");
        return this.clientCall(request, UpdateAuthTokenResponse::builder).logger(LOG, "updateAuthToken").serviceDetails("Identity", "UpdateAuthToken", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/AuthToken/UpdateAuthToken").method(Method.PUT).requestBuilder(UpdateAuthTokenRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("authTokens").appendPathParam(request.getAuthTokenId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(AuthToken.class, UpdateAuthTokenResponse.Builder::authToken).handleResponseHeaderString("opc-request-id", UpdateAuthTokenResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateAuthTokenResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateAuthenticationPolicyResponse> updateAuthenticationPolicy(UpdateAuthenticationPolicyRequest request, AsyncHandler<UpdateAuthenticationPolicyRequest, UpdateAuthenticationPolicyResponse> handler) {
        Validate.notBlank((String)request.getCompartmentId(), (String)"compartmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAuthenticationPolicyDetails(), "updateAuthenticationPolicyDetails is required");
        return this.clientCall(request, UpdateAuthenticationPolicyResponse::builder).logger(LOG, "updateAuthenticationPolicy").serviceDetails("Identity", "UpdateAuthenticationPolicy", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/AuthenticationPolicy/UpdateAuthenticationPolicy").method(Method.PUT).requestBuilder(UpdateAuthenticationPolicyRequest::builder).basePath("/20160918").appendPathParam("authenticationPolicies").appendPathParam(request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(AuthenticationPolicy.class, UpdateAuthenticationPolicyResponse.Builder::authenticationPolicy).handleResponseHeaderString("opc-request-id", UpdateAuthenticationPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateAuthenticationPolicyResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateCompartmentResponse> updateCompartment(UpdateCompartmentRequest request, AsyncHandler<UpdateCompartmentRequest, UpdateCompartmentResponse> handler) {
        Validate.notBlank((String)request.getCompartmentId(), (String)"compartmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCompartmentDetails(), "updateCompartmentDetails is required");
        return this.clientCall(request, UpdateCompartmentResponse::builder).logger(LOG, "updateCompartment").serviceDetails("Identity", "UpdateCompartment", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Compartment/UpdateCompartment").method(Method.PUT).requestBuilder(UpdateCompartmentRequest::builder).basePath("/20160918").appendPathParam("compartments").appendPathParam(request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Compartment.class, UpdateCompartmentResponse.Builder::compartment).handleResponseHeaderString("opc-request-id", UpdateCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateCompartmentResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateCustomerSecretKeyResponse> updateCustomerSecretKey(UpdateCustomerSecretKeyRequest request, AsyncHandler<UpdateCustomerSecretKeyRequest, UpdateCustomerSecretKeyResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCustomerSecretKeyId(), (String)"customerSecretKeyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCustomerSecretKeyDetails(), "updateCustomerSecretKeyDetails is required");
        return this.clientCall(request, UpdateCustomerSecretKeyResponse::builder).logger(LOG, "updateCustomerSecretKey").serviceDetails("Identity", "UpdateCustomerSecretKey", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/CustomerSecretKeySummary/UpdateCustomerSecretKey").method(Method.PUT).requestBuilder(UpdateCustomerSecretKeyRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("customerSecretKeys").appendPathParam(request.getCustomerSecretKeyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(CustomerSecretKeySummary.class, UpdateCustomerSecretKeyResponse.Builder::customerSecretKeySummary).handleResponseHeaderString("opc-request-id", UpdateCustomerSecretKeyResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateCustomerSecretKeyResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateDomainResponse> updateDomain(UpdateDomainRequest request, AsyncHandler<UpdateDomainRequest, UpdateDomainResponse> handler) {
        Validate.notBlank((String)request.getDomainId(), (String)"domainId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDomainDetails(), "updateDomainDetails is required");
        return this.clientCall(request, UpdateDomainResponse::builder).logger(LOG, "updateDomain").serviceDetails("Identity", "UpdateDomain", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Domain/UpdateDomain").method(Method.PUT).requestBuilder(UpdateDomainRequest::builder).basePath("/20160918").appendPathParam("domains").appendPathParam(request.getDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateDomainResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateDomainResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDynamicGroupResponse> updateDynamicGroup(UpdateDynamicGroupRequest request, AsyncHandler<UpdateDynamicGroupRequest, UpdateDynamicGroupResponse> handler) {
        Validate.notBlank((String)request.getDynamicGroupId(), (String)"dynamicGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDynamicGroupDetails(), "updateDynamicGroupDetails is required");
        return this.clientCall(request, UpdateDynamicGroupResponse::builder).logger(LOG, "updateDynamicGroup").serviceDetails("Identity", "UpdateDynamicGroup", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/DynamicGroup/UpdateDynamicGroup").method(Method.PUT).requestBuilder(UpdateDynamicGroupRequest::builder).basePath("/20160918").appendPathParam("dynamicGroups").appendPathParam(request.getDynamicGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DynamicGroup.class, UpdateDynamicGroupResponse.Builder::dynamicGroup).handleResponseHeaderString("opc-request-id", UpdateDynamicGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateDynamicGroupResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateGroupResponse> updateGroup(UpdateGroupRequest request, AsyncHandler<UpdateGroupRequest, UpdateGroupResponse> handler) {
        Validate.notBlank((String)request.getGroupId(), (String)"groupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateGroupDetails(), "updateGroupDetails is required");
        return this.clientCall(request, UpdateGroupResponse::builder).logger(LOG, "updateGroup").serviceDetails("Identity", "UpdateGroup", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Group/UpdateGroup").method(Method.PUT).requestBuilder(UpdateGroupRequest::builder).basePath("/20160918").appendPathParam("groups").appendPathParam(request.getGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Group.class, UpdateGroupResponse.Builder::group).handleResponseHeaderString("opc-request-id", UpdateGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateGroupResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateIdentityProviderResponse> updateIdentityProvider(UpdateIdentityProviderRequest request, AsyncHandler<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse> handler) {
        Validate.notBlank((String)request.getIdentityProviderId(), (String)"identityProviderId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateIdentityProviderDetails(), "updateIdentityProviderDetails is required");
        return this.clientCall(request, UpdateIdentityProviderResponse::builder).logger(LOG, "updateIdentityProvider").serviceDetails("Identity", "UpdateIdentityProvider", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/IdentityProvider/UpdateIdentityProvider").method(Method.PUT).requestBuilder(UpdateIdentityProviderRequest::builder).basePath("/20160918").appendPathParam("identityProviders").appendPathParam(request.getIdentityProviderId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(IdentityProvider.class, UpdateIdentityProviderResponse.Builder::identityProvider).handleResponseHeaderString("opc-request-id", UpdateIdentityProviderResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateIdentityProviderResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateIdpGroupMappingResponse> updateIdpGroupMapping(UpdateIdpGroupMappingRequest request, AsyncHandler<UpdateIdpGroupMappingRequest, UpdateIdpGroupMappingResponse> handler) {
        Validate.notBlank((String)request.getIdentityProviderId(), (String)"identityProviderId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMappingId(), (String)"mappingId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateIdpGroupMappingDetails(), "updateIdpGroupMappingDetails is required");
        return this.clientCall(request, UpdateIdpGroupMappingResponse::builder).logger(LOG, "updateIdpGroupMapping").serviceDetails("Identity", "UpdateIdpGroupMapping", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/IdpGroupMapping/UpdateIdpGroupMapping").method(Method.PUT).requestBuilder(UpdateIdpGroupMappingRequest::builder).basePath("/20160918").appendPathParam("identityProviders").appendPathParam(request.getIdentityProviderId()).appendPathParam("groupMappings").appendPathParam(request.getMappingId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(IdpGroupMapping.class, UpdateIdpGroupMappingResponse.Builder::idpGroupMapping).handleResponseHeaderString("opc-request-id", UpdateIdpGroupMappingResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateIdpGroupMappingResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateNetworkSourceResponse> updateNetworkSource(UpdateNetworkSourceRequest request, AsyncHandler<UpdateNetworkSourceRequest, UpdateNetworkSourceResponse> handler) {
        Validate.notBlank((String)request.getNetworkSourceId(), (String)"networkSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNetworkSourceDetails(), "updateNetworkSourceDetails is required");
        return this.clientCall(request, UpdateNetworkSourceResponse::builder).logger(LOG, "updateNetworkSource").serviceDetails("Identity", "UpdateNetworkSource", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/NetworkSources/UpdateNetworkSource").method(Method.PUT).requestBuilder(UpdateNetworkSourceRequest::builder).basePath("/20160918").appendPathParam("networkSources").appendPathParam(request.getNetworkSourceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(NetworkSources.class, UpdateNetworkSourceResponse.Builder::networkSources).handleResponseHeaderString("opc-request-id", UpdateNetworkSourceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateNetworkSourceResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateOAuthClientCredentialResponse> updateOAuthClientCredential(UpdateOAuthClientCredentialRequest request, AsyncHandler<UpdateOAuthClientCredentialRequest, UpdateOAuthClientCredentialResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getOauth2ClientCredentialId(), (String)"oauth2ClientCredentialId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOAuth2ClientCredentialDetails(), "updateOAuth2ClientCredentialDetails is required");
        return this.clientCall(request, UpdateOAuthClientCredentialResponse::builder).logger(LOG, "updateOAuthClientCredential").serviceDetails("Identity", "UpdateOAuthClientCredential", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/User/UpdateOAuthClientCredential").method(Method.PUT).requestBuilder(UpdateOAuthClientCredentialRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("oauth2ClientCredentials").appendPathParam(request.getOauth2ClientCredentialId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(OAuth2ClientCredential.class, UpdateOAuthClientCredentialResponse.Builder::oAuth2ClientCredential).handleResponseHeaderString("opc-request-id", UpdateOAuthClientCredentialResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateOAuthClientCredentialResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdatePolicyResponse> updatePolicy(UpdatePolicyRequest request, AsyncHandler<UpdatePolicyRequest, UpdatePolicyResponse> handler) {
        Validate.notBlank((String)request.getPolicyId(), (String)"policyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePolicyDetails(), "updatePolicyDetails is required");
        return this.clientCall(request, UpdatePolicyResponse::builder).logger(LOG, "updatePolicy").serviceDetails("Identity", "UpdatePolicy", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Policy/UpdatePolicy").method(Method.PUT).requestBuilder(UpdatePolicyRequest::builder).basePath("/20160918").appendPathParam("policies").appendPathParam(request.getPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Policy.class, UpdatePolicyResponse.Builder::policy).handleResponseHeaderString("opc-request-id", UpdatePolicyResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdatePolicyResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateSmtpCredentialResponse> updateSmtpCredential(UpdateSmtpCredentialRequest request, AsyncHandler<UpdateSmtpCredentialRequest, UpdateSmtpCredentialResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSmtpCredentialId(), (String)"smtpCredentialId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSmtpCredentialDetails(), "updateSmtpCredentialDetails is required");
        return this.clientCall(request, UpdateSmtpCredentialResponse::builder).logger(LOG, "updateSmtpCredential").serviceDetails("Identity", "UpdateSmtpCredential", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/SmtpCredentialSummary/UpdateSmtpCredential").method(Method.PUT).requestBuilder(UpdateSmtpCredentialRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("smtpCredentials").appendPathParam(request.getSmtpCredentialId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(SmtpCredentialSummary.class, UpdateSmtpCredentialResponse.Builder::smtpCredentialSummary).handleResponseHeaderString("opc-request-id", UpdateSmtpCredentialResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateSmtpCredentialResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateSwiftPasswordResponse> updateSwiftPassword(UpdateSwiftPasswordRequest request, AsyncHandler<UpdateSwiftPasswordRequest, UpdateSwiftPasswordResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSwiftPasswordId(), (String)"swiftPasswordId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSwiftPasswordDetails(), "updateSwiftPasswordDetails is required");
        return this.clientCall(request, UpdateSwiftPasswordResponse::builder).logger(LOG, "updateSwiftPassword").serviceDetails("Identity", "UpdateSwiftPassword", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/SwiftPassword/UpdateSwiftPassword").method(Method.PUT).requestBuilder(UpdateSwiftPasswordRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("swiftPasswords").appendPathParam(request.getSwiftPasswordId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(SwiftPassword.class, UpdateSwiftPasswordResponse.Builder::swiftPassword).handleResponseHeaderString("opc-request-id", UpdateSwiftPasswordResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateSwiftPasswordResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateTagResponse> updateTag(UpdateTagRequest request, AsyncHandler<UpdateTagRequest, UpdateTagResponse> handler) {
        Validate.notBlank((String)request.getTagNamespaceId(), (String)"tagNamespaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTagName(), (String)"tagName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTagDetails(), "updateTagDetails is required");
        return this.clientCall(request, UpdateTagResponse::builder).logger(LOG, "updateTag").serviceDetails("Identity", "UpdateTag", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/Tag/UpdateTag").method(Method.PUT).requestBuilder(UpdateTagRequest::builder).basePath("/20160918").appendPathParam("tagNamespaces").appendPathParam(request.getTagNamespaceId()).appendPathParam("tags").appendPathParam(request.getTagName()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Tag.class, UpdateTagResponse.Builder::tag).handleResponseHeaderString("opc-request-id", UpdateTagResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateTagResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateTagDefaultResponse> updateTagDefault(UpdateTagDefaultRequest request, AsyncHandler<UpdateTagDefaultRequest, UpdateTagDefaultResponse> handler) {
        Validate.notBlank((String)request.getTagDefaultId(), (String)"tagDefaultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTagDefaultDetails(), "updateTagDefaultDetails is required");
        return this.clientCall(request, UpdateTagDefaultResponse::builder).logger(LOG, "updateTagDefault").serviceDetails("Identity", "UpdateTagDefault", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagDefault/UpdateTagDefault").method(Method.PUT).requestBuilder(UpdateTagDefaultRequest::builder).basePath("/20160918").appendPathParam("tagDefaults").appendPathParam(request.getTagDefaultId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TagDefault.class, UpdateTagDefaultResponse.Builder::tagDefault).handleResponseHeaderString("opc-request-id", UpdateTagDefaultResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateTagDefaultResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateTagNamespaceResponse> updateTagNamespace(UpdateTagNamespaceRequest request, AsyncHandler<UpdateTagNamespaceRequest, UpdateTagNamespaceResponse> handler) {
        Validate.notBlank((String)request.getTagNamespaceId(), (String)"tagNamespaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTagNamespaceDetails(), "updateTagNamespaceDetails is required");
        return this.clientCall(request, UpdateTagNamespaceResponse::builder).logger(LOG, "updateTagNamespace").serviceDetails("Identity", "UpdateTagNamespace", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/TagNamespace/UpdateTagNamespace").method(Method.PUT).requestBuilder(UpdateTagNamespaceRequest::builder).basePath("/20160918").appendPathParam("tagNamespaces").appendPathParam(request.getTagNamespaceId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).hasBody().handleBody(TagNamespace.class, UpdateTagNamespaceResponse.Builder::tagNamespace).handleResponseHeaderString("opc-request-id", UpdateTagNamespaceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateUserResponse> updateUser(UpdateUserRequest request, AsyncHandler<UpdateUserRequest, UpdateUserResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateUserDetails(), "updateUserDetails is required");
        return this.clientCall(request, UpdateUserResponse::builder).logger(LOG, "updateUser").serviceDetails("Identity", "UpdateUser", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/User/UpdateUser").method(Method.PUT).requestBuilder(UpdateUserRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(User.class, UpdateUserResponse.Builder::user).handleResponseHeaderString("opc-request-id", UpdateUserResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateUserResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateUserCapabilitiesResponse> updateUserCapabilities(UpdateUserCapabilitiesRequest request, AsyncHandler<UpdateUserCapabilitiesRequest, UpdateUserCapabilitiesResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateUserCapabilitiesDetails(), "updateUserCapabilitiesDetails is required");
        return this.clientCall(request, UpdateUserCapabilitiesResponse::builder).logger(LOG, "updateUserCapabilities").serviceDetails("Identity", "UpdateUserCapabilities", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/User/UpdateUserCapabilities").method(Method.PUT).requestBuilder(UpdateUserCapabilitiesRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("capabilities").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(User.class, UpdateUserCapabilitiesResponse.Builder::user).handleResponseHeaderString("opc-request-id", UpdateUserCapabilitiesResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateUserCapabilitiesResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateUserStateResponse> updateUserState(UpdateUserStateRequest request, AsyncHandler<UpdateUserStateRequest, UpdateUserStateResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateStateDetails(), "updateStateDetails is required");
        return this.clientCall(request, UpdateUserStateResponse::builder).logger(LOG, "updateUserState").serviceDetails("Identity", "UpdateUserState", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/User/UpdateUserState").method(Method.PUT).requestBuilder(UpdateUserStateRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("state").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(User.class, UpdateUserStateResponse.Builder::user).handleResponseHeaderString("opc-request-id", UpdateUserStateResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateUserStateResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UploadApiKeyResponse> uploadApiKey(UploadApiKeyRequest request, AsyncHandler<UploadApiKeyRequest, UploadApiKeyResponse> handler) {
        Validate.notBlank((String)request.getUserId(), (String)"userId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateApiKeyDetails(), "createApiKeyDetails is required");
        return this.clientCall(request, UploadApiKeyResponse::builder).logger(LOG, "uploadApiKey").serviceDetails("Identity", "UploadApiKey", "https://docs.oracle.com/iaas/api/#/en/identity/20160918/ApiKey/UploadApiKey").method(Method.POST).requestBuilder(UploadApiKeyRequest::builder).basePath("/20160918").appendPathParam("users").appendPathParam(request.getUserId()).appendPathParam("apiKeys").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ApiKey.class, UploadApiKeyResponse.Builder::apiKey).handleResponseHeaderString("opc-request-id", UploadApiKeyResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UploadApiKeyResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public IdentityAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)IdentityAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public IdentityAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(IdentityAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public IdentityAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)IdentityAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public IdentityAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)IdentityAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public IdentityAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)IdentityAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public IdentityAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)IdentityAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public IdentityAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)IdentityAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, IdentityAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "identity";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"identity");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public IdentityAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new IdentityAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

