/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.util.TreePath;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CodeStyleUtils;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.ui.JavaRenameProperties;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.lookup.Lookups;

public class RenamePropertyRefactoringPlugin
extends JavaRefactoringPlugin {
    private RenameRefactoring refactoring;
    private TreePathHandle property;
    private CodeStyle codeStyle;
    private boolean isStatic;
    private boolean isBoolean;
    private RenameRefactoring getterDelegate;
    private RenameRefactoring setterDelegate;
    private RenameRefactoring parameterDelegate;
    private boolean inited = false;

    public RenamePropertyRefactoringPlugin(RenameRefactoring rename) {
        this.refactoring = rename;
        this.property = (TreePathHandle)rename.getRefactoringSource().lookup(TreePathHandle.class);
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        return JavaSource.forFileObject((FileObject)this.property.getFileObject());
    }

    @Override
    public Problem checkParameters() {
        if (!this.isRenameProperty()) {
            return null;
        }
        this.initDelegates();
        Problem p = null;
        if (this.getterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.getterDelegate.checkParameters())) != null && p.isFatal()) {
            return p;
        }
        if (this.setterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.setterDelegate.checkParameters())) != null && p.isFatal()) {
            return p;
        }
        if (this.parameterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.parameterDelegate.checkParameters())) != null && p.isFatal()) {
            return p;
        }
        p = JavaPluginUtils.chainProblems(p, super.checkParameters());
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem fastCheckParameters(CompilationController info) throws IOException {
        if (!this.isRenameProperty()) {
            return null;
        }
        this.initDelegates();
        info.toPhase(JavaSource.Phase.RESOLVED);
        Element el = this.property.resolveElement((CompilationInfo)info);
        if (el == null || el.getKind() != ElementKind.FIELD) {
            return null;
        }
        String oldName = el.getSimpleName().toString();
        String bareName = RefactoringUtils.removeFieldPrefixSuffix(el, this.codeStyle);
        boolean isStatic = el.getModifiers().contains((Object)Modifier.STATIC);
        String bareNewName = CodeStyleUtils.removePrefixSuffix((CharSequence)this.refactoring.getNewName(), (String)(isStatic ? this.codeStyle.getStaticFieldNamePrefix() : this.codeStyle.getFieldNamePrefix()), (String)(isStatic ? this.codeStyle.getStaticFieldNameSuffix() : this.codeStyle.getFieldNameSuffix()));
        if (bareName.equals(bareNewName)) {
            return null;
        }
        Problem p = null;
        JavaRenameProperties renameProps = (JavaRenameProperties)this.refactoring.getContext().lookup(JavaRenameProperties.class);
        boolean saveNoChange = false;
        if (renameProps != null) {
            saveNoChange = renameProps.isNoChangeOK();
            renameProps.setNoChangeOK(true);
        }
        try {
            if (this.getterDelegate != null) {
                String gettername = CodeStyleUtils.computeGetterName((CharSequence)this.refactoring.getNewName(), (boolean)this.isBoolean, (boolean)isStatic, (CodeStyle)this.codeStyle);
                this.getterDelegate.setNewName(gettername);
                p = JavaPluginUtils.chainProblems(p, this.getterDelegate.fastCheckParameters());
                if (p != null && p.isFatal()) {
                    Problem problem = p;
                    return problem;
                }
            }
            if (this.setterDelegate != null) {
                String settername = CodeStyleUtils.computeSetterName((CharSequence)this.refactoring.getNewName(), (boolean)isStatic, (CodeStyle)this.codeStyle);
                this.setterDelegate.setNewName(settername);
                p = JavaPluginUtils.chainProblems(p, this.setterDelegate.fastCheckParameters());
                if (p != null && p.isFatal()) {
                    Problem problem = p;
                    return problem;
                }
            }
            if (this.parameterDelegate != null) {
                String newParam = RefactoringUtils.addParamPrefixSuffix(CodeStyleUtils.removePrefixSuffix((CharSequence)this.refactoring.getNewName(), (String)(isStatic ? this.codeStyle.getStaticFieldNamePrefix() : this.codeStyle.getFieldNamePrefix()), (String)(isStatic ? this.codeStyle.getStaticFieldNameSuffix() : this.codeStyle.getFieldNameSuffix())), this.codeStyle);
                this.parameterDelegate.setNewName(newParam);
                p = JavaPluginUtils.chainProblems(p, this.parameterDelegate.fastCheckParameters());
                if (p != null && p.isFatal()) {
                    Problem problem = p;
                    return problem;
                }
            }
        }
        finally {
            if (renameProps != null) {
                renameProps.setNoChangeOK(saveNoChange);
            }
        }
        p = JavaPluginUtils.chainProblems(p, super.fastCheckParameters(info));
        return p;
    }

    @Override
    protected Problem preCheck(CompilationController javac) throws IOException {
        if (!this.isRenameProperty()) {
            return null;
        }
        this.initDelegates();
        Problem p = null;
        if (this.getterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.getterDelegate.preCheck())) != null && p.isFatal()) {
            return p;
        }
        if (this.setterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.setterDelegate.preCheck())) != null && p.isFatal()) {
            return p;
        }
        if (this.parameterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.parameterDelegate.preCheck())) != null && p.isFatal()) {
            return p;
        }
        p = JavaPluginUtils.chainProblems(p, super.preCheck(javac));
        return p;
    }

    public Problem prepare(RefactoringElementsBag reb) {
        if (!this.isRenameProperty()) {
            return null;
        }
        this.initDelegates();
        this.fireProgressListenerStart(3, 3);
        Problem p = null;
        if (this.getterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.getterDelegate.prepare(reb.getSession()))) != null && p.isFatal()) {
            return p;
        }
        this.fireProgressListenerStep();
        if (this.setterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.setterDelegate.prepare(reb.getSession()))) != null && p.isFatal()) {
            return p;
        }
        this.fireProgressListenerStep();
        if (this.parameterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.parameterDelegate.prepare(reb.getSession()))) != null && p.isFatal()) {
            return p;
        }
        this.fireProgressListenerStep();
        this.fireProgressListenerStop();
        return p;
    }

    private boolean isRenameProperty() {
        JavaRenameProperties renameProps = (JavaRenameProperties)this.refactoring.getContext().lookup(JavaRenameProperties.class);
        return renameProps != null && renameProps.isIsRenameGettersSetters();
    }

    private void initDelegates() {
        if (this.inited) {
            return;
        }
        try {
            this.getJavaSource(JavaRefactoringPlugin.Phase.PREPARE).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController p) throws Exception {
                    JavaRenameProperties renameProps = (JavaRenameProperties)RenamePropertyRefactoringPlugin.this.refactoring.getContext().lookup(JavaRenameProperties.class);
                    p.toPhase(JavaSource.Phase.RESOLVED);
                    RenamePropertyRefactoringPlugin.this.codeStyle = RefactoringUtils.getCodeStyle((CompilationInfo)p);
                    Element propertyElement = RenamePropertyRefactoringPlugin.this.property.resolveElement((CompilationInfo)p);
                    RenamePropertyRefactoringPlugin.this.isStatic = propertyElement.getModifiers().contains((Object)Modifier.STATIC);
                    RenamePropertyRefactoringPlugin.this.isBoolean = propertyElement.asType().getKind() == TypeKind.BOOLEAN;
                    String propName = RefactoringUtils.removeFieldPrefixSuffix(propertyElement, RenamePropertyRefactoringPlugin.this.codeStyle);
                    String paramName = RefactoringUtils.addParamPrefixSuffix(propName, RenamePropertyRefactoringPlugin.this.codeStyle);
                    String newParam = RefactoringUtils.addParamPrefixSuffix(CodeStyleUtils.removePrefixSuffix((CharSequence)RenamePropertyRefactoringPlugin.this.refactoring.getNewName(), (String)(RenamePropertyRefactoringPlugin.this.isStatic ? RenamePropertyRefactoringPlugin.this.codeStyle.getStaticFieldNamePrefix() : RenamePropertyRefactoringPlugin.this.codeStyle.getFieldNamePrefix()), (String)(RenamePropertyRefactoringPlugin.this.isStatic ? RenamePropertyRefactoringPlugin.this.codeStyle.getStaticFieldNameSuffix() : RenamePropertyRefactoringPlugin.this.codeStyle.getFieldNameSuffix())), RenamePropertyRefactoringPlugin.this.codeStyle);
                    for (ExecutableElement el : ElementFilter.methodsIn(propertyElement.getEnclosingElement().getEnclosedElements())) {
                        TreePath elPath = p.getTrees().getPath(el);
                        if (elPath == null || p.getTreeUtilities().isSynthetic(elPath)) continue;
                        if (RefactoringUtils.isGetter((CompilationInfo)p, el, propertyElement)) {
                            RenamePropertyRefactoringPlugin.this.getterDelegate = new RenameRefactoring(Lookups.singleton((Object)TreePathHandle.create((Element)el, (CompilationInfo)p)));
                            RenamePropertyRefactoringPlugin.this.getterDelegate.getContext().add((Object)renameProps);
                            String gettername = CodeStyleUtils.computeGetterName((CharSequence)RenamePropertyRefactoringPlugin.this.refactoring.getNewName(), (boolean)RenamePropertyRefactoringPlugin.this.isBoolean, (boolean)RenamePropertyRefactoringPlugin.this.isStatic, (CodeStyle)RenamePropertyRefactoringPlugin.this.codeStyle);
                            RenamePropertyRefactoringPlugin.this.getterDelegate.setNewName(gettername);
                            RenamePropertyRefactoringPlugin.this.getterDelegate.setSearchInComments(RenamePropertyRefactoringPlugin.this.refactoring.isSearchInComments());
                            continue;
                        }
                        if (!RefactoringUtils.isSetter((CompilationInfo)p, el, propertyElement)) continue;
                        RenamePropertyRefactoringPlugin.this.setterDelegate = new RenameRefactoring(Lookups.singleton((Object)TreePathHandle.create((Element)el, (CompilationInfo)p)));
                        RenamePropertyRefactoringPlugin.this.setterDelegate.getContext().add((Object)renameProps);
                        String settername = CodeStyleUtils.computeSetterName((CharSequence)RenamePropertyRefactoringPlugin.this.refactoring.getNewName(), (boolean)RenamePropertyRefactoringPlugin.this.isStatic, (CodeStyle)RenamePropertyRefactoringPlugin.this.codeStyle);
                        RenamePropertyRefactoringPlugin.this.setterDelegate.setNewName(settername);
                        RenamePropertyRefactoringPlugin.this.setterDelegate.setSearchInComments(RenamePropertyRefactoringPlugin.this.refactoring.isSearchInComments());
                        VariableElement par = el.getParameters().iterator().next();
                        if (!par.getSimpleName().contentEquals(paramName)) continue;
                        RenamePropertyRefactoringPlugin.this.parameterDelegate = new RenameRefactoring(Lookups.singleton((Object)TreePathHandle.create((TreePath)p.getTrees().getPath(par), (CompilationInfo)p)));
                        RenamePropertyRefactoringPlugin.this.parameterDelegate.getContext().add((Object)RenamePropertyRefactoringPlugin.this);
                        RenamePropertyRefactoringPlugin.this.parameterDelegate.setNewName(newParam);
                        RenamePropertyRefactoringPlugin.this.parameterDelegate.setSearchInComments(RenamePropertyRefactoringPlugin.this.refactoring.isSearchInComments());
                        RenamePropertyRefactoringPlugin.this.parameterDelegate.getContext().add((Object)renameProps);
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.inited = true;
    }
}

