/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.monitor.fs;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.SingleObjectCache;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.monitor.fs.FsInfo;
import org.opensearch.monitor.fs.FsProbe;

public class FsService {
    private static final Logger logger = LogManager.getLogger(FsService.class);
    private final Supplier<FsInfo> fsInfoSupplier;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.fs.refresh_interval", TimeValue.timeValueSeconds((long)1L), TimeValue.timeValueSeconds((long)1L), Setting.Property.NodeScope);
    public static final Setting<Boolean> ALWAYS_REFRESH_SETTING = Setting.boolSetting("monitor.fs.always_refresh", false, Setting.Property.NodeScope);

    public FsService(Settings settings, NodeEnvironment nodeEnvironment, FileCache fileCache) {
        FsProbe probe = new FsProbe(nodeEnvironment, fileCache);
        FsInfo initialValue = FsService.stats(probe, null);
        if (ALWAYS_REFRESH_SETTING.get(settings).booleanValue()) {
            assert (!REFRESH_INTERVAL_SETTING.exists(settings));
            logger.debug("bypassing refresh_interval");
            this.fsInfoSupplier = () -> FsService.stats(probe, initialValue);
        } else {
            TimeValue refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
            logger.debug("using refresh_interval [{}]", (Object)refreshInterval);
            this.fsInfoSupplier = new FsInfoCache(refreshInterval, initialValue, probe)::getOrRefresh;
        }
    }

    public FsInfo stats() {
        return this.fsInfoSupplier.get();
    }

    private static FsInfo stats(FsProbe probe, FsInfo initialValue) {
        try {
            return probe.stats(initialValue);
        }
        catch (IOException e) {
            logger.debug("unexpected exception reading filesystem info", (Throwable)e);
            return null;
        }
    }

    private static class FsInfoCache
    extends SingleObjectCache<FsInfo> {
        private final FsInfo initialValue;
        private final FsProbe probe;

        FsInfoCache(TimeValue interval, FsInfo initialValue, FsProbe probe) {
            super(interval, initialValue);
            this.initialValue = initialValue;
            this.probe = probe;
        }

        @Override
        protected FsInfo refresh() {
            return FsService.stats(this.probe, this.initialValue);
        }
    }
}

