/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.hash;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import org.opensearch.common.annotation.InternalApi;

@InternalApi
public final class T1ha1 {
    private static final long SEED = System.nanoTime();
    private static final Mux64 MUX_64_IMPL = T1ha1.fastestMux64Impl();
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle SHORT_HANDLE = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.LITTLE_ENDIAN);
    private static final long p0 = -1397876144561010005L;
    private static final long p1 = -9060310162943971527L;
    private static final long p2 = -3102859499281072565L;
    private static final long p3 = -4783758754205231759L;
    private static final long p4 = -7203794624561552469L;
    private static final long p5 = -4584538756293004475L;
    private static final long p6 = -3793450102829700047L;
    private static final int s0 = 41;
    private static final int s1 = 17;
    private static final int s2 = 31;

    private T1ha1() {
    }

    public static long hash(byte[] input, int offset, int length) {
        return T1ha1.hash(input, offset, length, SEED);
    }

    public static long hash(byte[] input, int offset, int length, long seed) {
        long a = seed;
        long b = length;
        if (length > 32) {
            long c = Long.rotateRight(length, 17) + seed;
            long d = (long)length ^ Long.rotateRight(seed, 17);
            do {
                long w0 = T1ha1.fetch64(input, offset);
                long w1 = T1ha1.fetch64(input, offset + 8);
                long w2 = T1ha1.fetch64(input, offset + 16);
                long w3 = T1ha1.fetch64(input, offset + 24);
                long d02 = w0 ^ Long.rotateRight(w2 + d, 17);
                long c13 = w1 ^ Long.rotateRight(w3 + c, 17);
                c += a ^ Long.rotateRight(w0, 41);
                d -= b ^ Long.rotateRight(w1, 31);
                a ^= -9060310162943971527L * (d02 + w3);
                b ^= -1397876144561010005L * (c13 + w2);
                offset += 32;
            } while ((length -= 32) >= 32);
            a ^= -3793450102829700047L * (Long.rotateRight(c, 17) + d);
            b ^= -4584538756293004475L * (Long.rotateRight(d, 17) + c);
        }
        return T1ha1.h32(input, offset, length, a, b);
    }

    private static long h32(byte[] input, int offset, int length, long a, long b) {
        switch (length) {
            default: {
                b += T1ha1.mux64(T1ha1.fetch64(input, offset), -7203794624561552469L);
                offset += 8;
                length -= 8;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                a += T1ha1.mux64(T1ha1.fetch64(input, offset), -4783758754205231759L);
                offset += 8;
                length -= 8;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                b += T1ha1.mux64(T1ha1.fetch64(input, offset), -3102859499281072565L);
                offset += 8;
                length -= 8;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                a += T1ha1.mux64(T1ha1.tail64(input, offset, length), -9060310162943971527L);
            }
            case 0: 
        }
        return T1ha1.mux64(Long.rotateRight(a + b, 17), -7203794624561552469L) + T1ha1.mix64(a ^ b, -1397876144561010005L);
    }

    private static long mux64(long a, long b) {
        return MUX_64_IMPL.mux64(a, b);
    }

    private static long mix64(long a, long b) {
        return (a *= b) ^ Long.rotateRight(a, 41);
    }

    private static long tail64(byte[] input, int offset, int length) {
        switch (length) {
            case 1: {
                return T1ha1.fetch8(input, offset);
            }
            case 2: {
                return T1ha1.fetch16(input, offset);
            }
            case 3: {
                return T1ha1.fetch16(input, offset) | T1ha1.fetch8(input, offset + 2) << 16;
            }
            case 4: {
                return T1ha1.fetch32(input, offset);
            }
            case 5: {
                return T1ha1.fetch32(input, offset) | T1ha1.fetch8(input, offset + 4) << 32;
            }
            case 6: {
                return T1ha1.fetch32(input, offset) | T1ha1.fetch16(input, offset + 4) << 32;
            }
            case 7: {
                return T1ha1.fetch32(input, offset) | T1ha1.fetch32(input, offset + 3) << 24;
            }
        }
        return T1ha1.fetch64(input, offset);
    }

    private static long fetch64(byte[] input, int offset) {
        return LONG_HANDLE.get(input, offset);
    }

    private static long fetch32(byte[] input, int offset) {
        return (long)INT_HANDLE.get(input, offset) & 0xFFFFFFFFL;
    }

    private static long fetch16(byte[] input, int offset) {
        return (long)SHORT_HANDLE.get(input, offset) & 0xFFFFL;
    }

    private static long fetch8(byte[] input, int offset) {
        return (long)input[offset] & 0xFFL;
    }

    private static Mux64 fastestMux64Impl() {
        try {
            MethodHandle unsignedMultiplyHigh = MethodHandles.publicLookup().findStatic(Math.class, "unsignedMultiplyHigh", MethodType.methodType(Long.TYPE, Long.TYPE, Long.TYPE));
            return (a, b) -> {
                try {
                    return unsignedMultiplyHigh.invokeExact(a, b) ^ a * b;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            return (a, b) -> Math.multiplyHigh(a, b) ^ a * b;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    private static interface Mux64 {
        public long mux64(long var1, long var3);
    }
}

