/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport.handler;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.forecast.indices.ForecastIndex;
import org.opensearch.forecast.indices.ForecastIndexManagement;
import org.opensearch.forecast.model.ForecastResult;
import org.opensearch.forecast.ratelimit.ForecastResultWriteRequest;
import org.opensearch.forecast.transport.ForecastResultBulkAction;
import org.opensearch.forecast.transport.ForecastResultBulkRequest;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.transport.ResultBulkResponse;
import org.opensearch.timeseries.transport.handler.IndexMemoryPressureAwareResultHandler;
import org.opensearch.transport.client.Client;

public class ForecastIndexMemoryPressureAwareResultHandler
extends IndexMemoryPressureAwareResultHandler<ForecastResult, ForecastResultWriteRequest, ForecastResultBulkRequest, ResultBulkResponse, ForecastIndex, ForecastIndexManagement> {
    private static final Logger LOG = LogManager.getLogger(ForecastIndexMemoryPressureAwareResultHandler.class);

    @Inject
    public ForecastIndexMemoryPressureAwareResultHandler(Client client, ForecastIndexManagement anomalyDetectionIndices, ClusterService clusterService) {
        super(client, anomalyDetectionIndices, clusterService);
    }

    @Override
    public void bulk(ForecastResultBulkRequest currentBulkRequest, ActionListener<ResultBulkResponse> listener) {
        if (currentBulkRequest.numberOfActions() <= 0) {
            listener.onFailure((Exception)new TimeSeriesException("no result to save"));
            return;
        }
        this.client.execute((ActionType)ForecastResultBulkAction.INSTANCE, (ActionRequest)currentBulkRequest, ActionListener.wrap(response -> {
            LOG.debug("Result saved successfully.");
            listener.onResponse((Object)response);
        }, exception -> {
            LOG.error("Error in bulking results", (Throwable)exception);
            listener.onFailure(exception);
        }));
    }
}

