"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRANSFORM_ROUTE_PREFIX = exports.Setting = exports.SM_ROUTE_PREFIX = exports.SECURITY_EXCEPTION_PREFIX = exports.NOTIFICATION_CONFIGS_ROUTE = exports.NOTIFICATIONS_API_ROUTE_PREFIX = exports.INDEX = exports.DEFAULT_HEADERS = exports.CLUSTER = exports.CHANNELS_ROUTE = exports.API_ROUTE_PREFIX_ROLLUP = exports.API_ROUTE_PREFIX = exports.API = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const API_ROUTE_PREFIX = exports.API_ROUTE_PREFIX = "/_plugins/_ism";
const API_ROUTE_PREFIX_ROLLUP = exports.API_ROUTE_PREFIX_ROLLUP = "/_plugins/_rollup";
const TRANSFORM_ROUTE_PREFIX = exports.TRANSFORM_ROUTE_PREFIX = "/_plugins/_transform";
const NOTIFICATIONS_API_ROUTE_PREFIX = exports.NOTIFICATIONS_API_ROUTE_PREFIX = "/_plugins/_notifications";
const CHANNELS_ROUTE = exports.CHANNELS_ROUTE = `${NOTIFICATIONS_API_ROUTE_PREFIX}/channels`;
const NOTIFICATION_CONFIGS_ROUTE = exports.NOTIFICATION_CONFIGS_ROUTE = `${NOTIFICATIONS_API_ROUTE_PREFIX}/configs`;
const SM_ROUTE_PREFIX = exports.SM_ROUTE_PREFIX = "/_plugins/_sm";
const API = exports.API = {
  POLICY_BASE: `${API_ROUTE_PREFIX}/policies`,
  EXPLAIN_BASE: `${API_ROUTE_PREFIX}/explain`,
  RETRY_BASE: `${API_ROUTE_PREFIX}/retry`,
  ADD_POLICY_BASE: `${API_ROUTE_PREFIX}/add`,
  REMOVE_POLICY_BASE: `${API_ROUTE_PREFIX}/remove`,
  CHANGE_POLICY_BASE: `${API_ROUTE_PREFIX}/change_policy`,
  ROLLUP_JOBS_BASE: `${API_ROUTE_PREFIX_ROLLUP}/jobs`,
  TRANSFORM_BASE: `${TRANSFORM_ROUTE_PREFIX}`,
  CHANNELS_BASE: `${CHANNELS_ROUTE}`,
  NOTIFICATION_CONFIGS_BASE: `${NOTIFICATION_CONFIGS_ROUTE}`,
  SM_POLICY_BASE: `${SM_ROUTE_PREFIX}/policies`
};
const DEFAULT_HEADERS = exports.DEFAULT_HEADERS = {
  "Content-Type": "application/json",
  Accept: "application/json"
};
let CLUSTER = exports.CLUSTER = /*#__PURE__*/function (CLUSTER) {
  CLUSTER["ADMIN"] = "admin";
  CLUSTER["ISM"] = "opendistro_ism";
  CLUSTER["DATA"] = "data";
  return CLUSTER;
}({});
let INDEX = exports.INDEX = /*#__PURE__*/function (INDEX) {
  INDEX["OPENDISTRO_ISM_CONFIG"] = ".opendistro-ism-config";
  return INDEX;
}({});
let Setting = exports.Setting = /*#__PURE__*/function (Setting) {
  Setting["RolloverAlias"] = "plugins.index_state_management.rollover_alias";
  return Setting;
}({});
const SECURITY_EXCEPTION_PREFIX = exports.SECURITY_EXCEPTION_PREFIX = "[security_exception]";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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