/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupVpcAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupVpcAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.SecurityGroupVpcAssociation;

public class DescribeSecurityGroupVpcAssociationsIterable
implements SdkIterable<DescribeSecurityGroupVpcAssociationsResponse> {
    private final Ec2Client client;
    private final DescribeSecurityGroupVpcAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSecurityGroupVpcAssociationsIterable(Ec2Client client, DescribeSecurityGroupVpcAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSecurityGroupVpcAssociationsResponseFetcher();
    }

    public Iterator<DescribeSecurityGroupVpcAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SecurityGroupVpcAssociation> securityGroupVpcAssociations() {
        Function<DescribeSecurityGroupVpcAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityGroupVpcAssociations() != null) {
                return response.securityGroupVpcAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSecurityGroupVpcAssociationsResponseFetcher
    implements SyncPageFetcher<DescribeSecurityGroupVpcAssociationsResponse> {
        private DescribeSecurityGroupVpcAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSecurityGroupVpcAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSecurityGroupVpcAssociationsResponse nextPage(DescribeSecurityGroupVpcAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSecurityGroupVpcAssociationsIterable.this.client.describeSecurityGroupVpcAssociations(DescribeSecurityGroupVpcAssociationsIterable.this.firstRequest);
            }
            return DescribeSecurityGroupVpcAssociationsIterable.this.client.describeSecurityGroupVpcAssociations((DescribeSecurityGroupVpcAssociationsRequest)((Object)DescribeSecurityGroupVpcAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

