/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client.impl;

import jakarta.json.Json;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class JsonTransformer {
    private JsonTransformer() {
    }

    public static class XContentObjectJsonpSerializer
    implements JsonpSerializer<Object> {
        public void serialize(Object obj, JsonGenerator generator, JsonpMapper mapper) {
            if (!(obj instanceof ToXContentObject)) {
                throw new IllegalArgumentException("This method requires an object of type ToXContentObject, actual type is " + obj.getClass().getName());
            }
            this.serialize((ToXContentObject)obj, generator);
        }

        private void serialize(ToXContentObject obj, JsonGenerator generator) {
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                obj.toXContent(builder, ToXContent.EMPTY_PARAMS);
                this.serializeString(builder.toString(), generator);
            }
            catch (IOException e) {
                throw new OpenSearchStatusException("Error parsing XContentObject", RestStatus.BAD_REQUEST, new Object[0]);
            }
        }

        private void serializeString(String json, JsonGenerator generator) {
            try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(json));){
                generator.write((JsonValue)jsonReader.readObject());
            }
        }
    }
}

