/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ltr;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ltr.UpdateFeaturesetResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class UpdateFeaturesetRequest
extends RequestBase
implements ToCopyableBuilder<Builder, UpdateFeaturesetRequest> {
    @Nonnull
    private final String id;
    @Nullable
    private final String routing;
    @Nullable
    private final String store;
    public static final Endpoint<UpdateFeaturesetRequest, UpdateFeaturesetResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateFeaturesetRequest, UpdateFeaturesetResponse>(request -> "POST", request -> {
        boolean _id = true;
        int _store = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.store() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ltr/_featureset/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ltr/");
            SimpleEndpoint.pathEncode(request.store, buf);
            buf.append("/_featureset/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, UpdateFeaturesetResponse._DESERIALIZER);

    private UpdateFeaturesetRequest(Builder builder) {
        super(builder);
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.routing = builder.routing;
        this.store = builder.store;
    }

    public static UpdateFeaturesetRequest of(Function<Builder, ObjectBuilder<UpdateFeaturesetRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String id() {
        return this.id;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final String store() {
        return this.store;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.routing != null) {
            params.put("routing", this.routing);
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Objects.hashCode(this.routing);
        result = 31 * result + Objects.hashCode(this.store);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateFeaturesetRequest other = (UpdateFeaturesetRequest)o;
        return this.id.equals(other.id) && Objects.equals(this.routing, other.routing) && Objects.equals(this.store, other.store);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, UpdateFeaturesetRequest> {
        private String id;
        @Nullable
        private String routing;
        @Nullable
        private String store;

        public Builder() {
        }

        private Builder(UpdateFeaturesetRequest o) {
            super(o);
            this.id = o.id;
            this.routing = o.routing;
            this.store = o.store;
        }

        private Builder(Builder o) {
            super(o);
            this.id = o.id;
            this.routing = o.routing;
            this.store = o.store;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        @Nonnull
        public final Builder store(@Nullable String value) {
            this.store = value;
            return this;
        }

        @Override
        @Nonnull
        public UpdateFeaturesetRequest build() {
            this._checkSingleUse();
            return new UpdateFeaturesetRequest(this);
        }
    }
}

