/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timelineservice;

import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

public final class TimelineMetricCalculator {
    private TimelineMetricCalculator() {
    }

    public static int compare(Number n1, Number n2) {
        if (n1 == null || n2 == null) {
            throw new YarnRuntimeException("Number to be compared shouldn't be null.");
        }
        if (n1 instanceof Integer || n1 instanceof Long) {
            if (n1.longValue() == n2.longValue()) {
                return 0;
            }
            return n1.longValue() < n2.longValue() ? -1 : 1;
        }
        if (n1 instanceof Float || n1 instanceof Double) {
            if (n1.doubleValue() == n2.doubleValue()) {
                return 0;
            }
            return n1.doubleValue() < n2.doubleValue() ? -1 : 1;
        }
        throw new YarnRuntimeException("Unsupported types for number comparison: " + n1.getClass().getName() + ", " + n2.getClass().getName());
    }

    public static Number sub(Number n1, Number n2) {
        if (n1 == null) {
            throw new YarnRuntimeException("Number to be subtracted shouldn't be null.");
        }
        if (n2 == null) {
            return n1;
        }
        if (n1 instanceof Integer || n1 instanceof Long) {
            return n1.longValue() - n2.longValue();
        }
        if (n1 instanceof Float || n1 instanceof Double) {
            return n1.doubleValue() - n2.doubleValue();
        }
        return null;
    }

    public static Number sum(Number n1, Number n2) {
        if (n1 == null) {
            return n2;
        }
        if (n2 == null) {
            return n1;
        }
        if (n1 instanceof Integer || n1 instanceof Long) {
            return n1.longValue() + n2.longValue();
        }
        if (n1 instanceof Float || n1 instanceof Double) {
            return n1.doubleValue() + n2.doubleValue();
        }
        return null;
    }
}

