/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.datetime;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAmount;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.datetime.CalendarLookup;
import org.opensearch.sql.expression.datetime.DateTimeFormatterUtil;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.DefaultFunctionResolver;
import org.opensearch.sql.expression.function.FunctionDSL;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.function.SerializableFunction;
import org.opensearch.sql.expression.function.SerializableTriFunction;
import org.opensearch.sql.utils.DateTimeFormatters;
import org.opensearch.sql.utils.DateTimeUtils;

public final class DateTimeFunctions {
    public static final long SECONDS_PER_DAY = 86400L;
    private static final Long DAYS_0000_TO_1970 = 719528L;
    private static final Double MYSQL_MAX_TIMESTAMP = 3.25367712E10;
    private static final ExprIntegerValue DEFAULT_WEEK_OF_YEAR_MODE = new ExprIntegerValue(0);
    private static final Map<String, String> extract_formats = ImmutableMap.builder().put((Object)"MICROSECOND", (Object)"SSSSSS").put((Object)"SECOND", (Object)"ss").put((Object)"MINUTE", (Object)"mm").put((Object)"HOUR", (Object)"HH").put((Object)"DAY", (Object)"dd").put((Object)"MONTH", (Object)"MM").put((Object)"YEAR", (Object)"yyyy").put((Object)"SECOND_MICROSECOND", (Object)"ssSSSSSS").put((Object)"MINUTE_MICROSECOND", (Object)"mmssSSSSSS").put((Object)"MINUTE_SECOND", (Object)"mmss").put((Object)"HOUR_MICROSECOND", (Object)"HHmmssSSSSSS").put((Object)"HOUR_SECOND", (Object)"HHmmss").put((Object)"HOUR_MINUTE", (Object)"HHmm").put((Object)"DAY_MICROSECOND", (Object)"ddHHmmssSSSSSS").put((Object)"DAY_SECOND", (Object)"ddHHmmss").put((Object)"DAY_MINUTE", (Object)"ddHHmm").put((Object)"DAY_HOUR", (Object)"ddHH").put((Object)"YEAR_MONTH", (Object)"yyyyMM").put((Object)"QUARTER", (Object)"Q").put((Object)"DOY", (Object)"D").put((Object)"DOW", (Object)"e").build();
    private static final Table<String, String, String> formats = ImmutableTable.builder().put((Object)"date", (Object)"usa", (Object)"%m.%d.%Y").put((Object)"date", (Object)"jis", (Object)"%Y-%m-%d").put((Object)"date", (Object)"iso", (Object)"%Y-%m-%d").put((Object)"date", (Object)"eur", (Object)"%d.%m.%Y").put((Object)"date", (Object)"internal", (Object)"%Y%m%d").put((Object)"time", (Object)"usa", (Object)"%h:%i:%s %p").put((Object)"time", (Object)"jis", (Object)"%H:%i:%s").put((Object)"time", (Object)"iso", (Object)"%H:%i:%s").put((Object)"time", (Object)"eur", (Object)"%H.%i.%s").put((Object)"time", (Object)"internal", (Object)"%H%i%s").put((Object)"timestamp", (Object)"usa", (Object)"%Y-%m-%d %H.%i.%s").put((Object)"timestamp", (Object)"jis", (Object)"%Y-%m-%d %H:%i:%s").put((Object)"timestamp", (Object)"iso", (Object)"%Y-%m-%d %H:%i:%s").put((Object)"timestamp", (Object)"eur", (Object)"%Y-%m-%d %H.%i.%s").put((Object)"timestamp", (Object)"internal", (Object)"%Y%m%d%H%i%s").build();

    public static void register(BuiltinFunctionRepository repository) {
        repository.register(DateTimeFunctions.adddate());
        repository.register(DateTimeFunctions.addtime());
        repository.register(DateTimeFunctions.convert_tz());
        repository.register(DateTimeFunctions.curtime());
        repository.register(DateTimeFunctions.curdate());
        repository.register(DateTimeFunctions.current_date());
        repository.register(DateTimeFunctions.current_time());
        repository.register(DateTimeFunctions.current_timestamp());
        repository.register(DateTimeFunctions.date());
        repository.register(DateTimeFunctions.datediff());
        repository.register(DateTimeFunctions.datetime());
        repository.register(DateTimeFunctions.date_add());
        repository.register(DateTimeFunctions.date_format());
        repository.register(DateTimeFunctions.date_sub());
        repository.register(DateTimeFunctions.day());
        repository.register(DateTimeFunctions.dayName());
        repository.register(DateTimeFunctions.dayOfMonth(BuiltinFunctionName.DAYOFMONTH));
        repository.register(DateTimeFunctions.dayOfMonth(BuiltinFunctionName.DAY_OF_MONTH));
        repository.register(DateTimeFunctions.dayOfWeek(BuiltinFunctionName.DAYOFWEEK.getName()));
        repository.register(DateTimeFunctions.dayOfWeek(BuiltinFunctionName.DAY_OF_WEEK.getName()));
        repository.register(DateTimeFunctions.dayOfYear(BuiltinFunctionName.DAYOFYEAR));
        repository.register(DateTimeFunctions.dayOfYear(BuiltinFunctionName.DAY_OF_YEAR));
        repository.register(DateTimeFunctions.extract());
        repository.register(DateTimeFunctions.from_days());
        repository.register(DateTimeFunctions.from_unixtime());
        repository.register(DateTimeFunctions.get_format());
        repository.register(DateTimeFunctions.hour(BuiltinFunctionName.HOUR));
        repository.register(DateTimeFunctions.hour(BuiltinFunctionName.HOUR_OF_DAY));
        repository.register(DateTimeFunctions.last_day());
        repository.register(DateTimeFunctions.localtime());
        repository.register(DateTimeFunctions.localtimestamp());
        repository.register(DateTimeFunctions.makedate());
        repository.register(DateTimeFunctions.maketime());
        repository.register(DateTimeFunctions.microsecond());
        repository.register(DateTimeFunctions.minute(BuiltinFunctionName.MINUTE));
        repository.register(DateTimeFunctions.minute_of_day());
        repository.register(DateTimeFunctions.minute(BuiltinFunctionName.MINUTE_OF_HOUR));
        repository.register(DateTimeFunctions.month(BuiltinFunctionName.MONTH));
        repository.register(DateTimeFunctions.month(BuiltinFunctionName.MONTH_OF_YEAR));
        repository.register(DateTimeFunctions.monthName());
        repository.register(DateTimeFunctions.now());
        repository.register(DateTimeFunctions.period_add());
        repository.register(DateTimeFunctions.period_diff());
        repository.register(DateTimeFunctions.quarter());
        repository.register(DateTimeFunctions.sec_to_time());
        repository.register(DateTimeFunctions.second(BuiltinFunctionName.SECOND));
        repository.register(DateTimeFunctions.second(BuiltinFunctionName.SECOND_OF_MINUTE));
        repository.register(DateTimeFunctions.subdate());
        repository.register(DateTimeFunctions.subtime());
        repository.register(DateTimeFunctions.str_to_date());
        repository.register(DateTimeFunctions.sysdate());
        repository.register(DateTimeFunctions.time());
        repository.register(DateTimeFunctions.time_format());
        repository.register(DateTimeFunctions.time_to_sec());
        repository.register(DateTimeFunctions.timediff());
        repository.register(DateTimeFunctions.timestamp());
        repository.register(DateTimeFunctions.timestampadd());
        repository.register(DateTimeFunctions.timestampdiff());
        repository.register(DateTimeFunctions.to_days());
        repository.register(DateTimeFunctions.to_seconds());
        repository.register(DateTimeFunctions.unix_timestamp());
        repository.register(DateTimeFunctions.utc_date());
        repository.register(DateTimeFunctions.utc_time());
        repository.register(DateTimeFunctions.utc_timestamp());
        repository.register(DateTimeFunctions.week(BuiltinFunctionName.WEEK));
        repository.register(DateTimeFunctions.week(BuiltinFunctionName.WEEKOFYEAR));
        repository.register(DateTimeFunctions.week(BuiltinFunctionName.WEEK_OF_YEAR));
        repository.register(DateTimeFunctions.weekday());
        repository.register(DateTimeFunctions.year());
        repository.register(DateTimeFunctions.yearweek());
    }

    private static FunctionResolver now(FunctionName functionName) {
        return FunctionDSL.define(functionName, FunctionDSL.implWithProperties(functionProperties -> new ExprTimestampValue(DateTimeFunctions.formatNow(functionProperties.getQueryStartClock())), ExprCoreType.TIMESTAMP));
    }

    private static FunctionResolver now() {
        return DateTimeFunctions.now(BuiltinFunctionName.NOW.getName());
    }

    private static FunctionResolver current_timestamp() {
        return DateTimeFunctions.now(BuiltinFunctionName.CURRENT_TIMESTAMP.getName());
    }

    private static FunctionResolver localtimestamp() {
        return DateTimeFunctions.now(BuiltinFunctionName.LOCALTIMESTAMP.getName());
    }

    private static FunctionResolver localtime() {
        return DateTimeFunctions.now(BuiltinFunctionName.LOCALTIME.getName());
    }

    private static FunctionResolver sysdate() {
        return FunctionDSL.define(BuiltinFunctionName.SYSDATE.getName(), FunctionDSL.implWithProperties(functionProperties -> new ExprTimestampValue(DateTimeFunctions.formatNow(functionProperties.getSystemClock())), ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties((functionProperties, v) -> new ExprTimestampValue(DateTimeFunctions.formatNow(functionProperties.getSystemClock(), v.integerValue())), ExprCoreType.TIMESTAMP, ExprCoreType.INTEGER));
    }

    private static FunctionResolver curtime(FunctionName functionName) {
        return FunctionDSL.define(functionName, FunctionDSL.implWithProperties(functionProperties -> new ExprTimeValue(DateTimeFunctions.formatNow(functionProperties.getQueryStartClock()).toLocalTime()), ExprCoreType.TIME));
    }

    private static FunctionResolver curtime() {
        return DateTimeFunctions.curtime(BuiltinFunctionName.CURTIME.getName());
    }

    private static FunctionResolver current_time() {
        return DateTimeFunctions.curtime(BuiltinFunctionName.CURRENT_TIME.getName());
    }

    private static FunctionResolver curdate(FunctionName functionName) {
        return FunctionDSL.define(functionName, FunctionDSL.implWithProperties(functionProperties -> new ExprDateValue(DateTimeFunctions.formatNow(functionProperties.getQueryStartClock()).toLocalDate()), ExprCoreType.DATE));
    }

    private static FunctionResolver curdate() {
        return DateTimeFunctions.curdate(BuiltinFunctionName.CURDATE.getName());
    }

    private static FunctionResolver current_date() {
        return DateTimeFunctions.curdate(BuiltinFunctionName.CURRENT_DATE.getName());
    }

    private static Stream<SerializableFunction<?, ?>> get_date_add_date_sub_signatures(SerializableTriFunction<FunctionProperties, ExprValue, ExprValue, ExprValue> function) {
        return Stream.of(FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(function), ExprCoreType.TIMESTAMP, ExprCoreType.DATE, ExprCoreType.INTERVAL), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(function), ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP, ExprCoreType.INTERVAL), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(function), ExprCoreType.TIMESTAMP, ExprCoreType.TIME, ExprCoreType.INTERVAL));
    }

    private static Stream<SerializableFunction<?, ?>> get_adddate_subdate_signatures(SerializableTriFunction<FunctionProperties, ExprValue, ExprValue, ExprValue> function) {
        return Stream.of(FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(function), ExprCoreType.DATE, ExprCoreType.DATE, ExprCoreType.LONG), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(function), ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP, ExprCoreType.LONG), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(function), ExprCoreType.TIMESTAMP, ExprCoreType.TIME, ExprCoreType.LONG));
    }

    private static DefaultFunctionResolver adddate() {
        return FunctionDSL.define(BuiltinFunctionName.ADDDATE.getName(), (SerializableFunction[])Stream.concat(DateTimeFunctions.get_date_add_date_sub_signatures(DateTimeFunctions::exprAddDateInterval), DateTimeFunctions.get_adddate_subdate_signatures(DateTimeFunctions::exprAddDateDays)).toArray(SerializableFunction[]::new));
    }

    private static DefaultFunctionResolver addtime() {
        return FunctionDSL.define(BuiltinFunctionName.ADDTIME.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprAddTime), ExprCoreType.TIME, ExprCoreType.TIME, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprAddTime), ExprCoreType.TIME, ExprCoreType.TIME, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprAddTime), ExprCoreType.TIME, ExprCoreType.TIME, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprAddTime), ExprCoreType.TIMESTAMP, ExprCoreType.DATE, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprAddTime), ExprCoreType.TIMESTAMP, ExprCoreType.DATE, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprAddTime), ExprCoreType.TIMESTAMP, ExprCoreType.DATE, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprAddTime), ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprAddTime), ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprAddTime), ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver convert_tz() {
        return FunctionDSL.define(BuiltinFunctionName.CONVERT_TZ.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprConvertTZ), ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP, ExprCoreType.STRING, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprConvertTZ), ExprCoreType.TIMESTAMP, ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver date() {
        return FunctionDSL.define(BuiltinFunctionName.DATE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDate), ExprCoreType.DATE, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDate), ExprCoreType.DATE, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDate), ExprCoreType.DATE, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver datediff() {
        return FunctionDSL.define(BuiltinFunctionName.DATEDIFF.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprDateDiff), ExprCoreType.LONG, ExprCoreType.DATE, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprDateDiff), ExprCoreType.LONG, ExprCoreType.DATE, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprDateDiff), ExprCoreType.LONG, ExprCoreType.TIME, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprDateDiff), ExprCoreType.LONG, ExprCoreType.TIME, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprDateDiff), ExprCoreType.LONG, ExprCoreType.TIMESTAMP, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprDateDiff), ExprCoreType.LONG, ExprCoreType.DATE, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprDateDiff), ExprCoreType.LONG, ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprDateDiff), ExprCoreType.LONG, ExprCoreType.TIMESTAMP, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprDateDiff), ExprCoreType.LONG, ExprCoreType.TIME, ExprCoreType.TIMESTAMP));
    }

    private static FunctionResolver datetime() {
        return FunctionDSL.define(BuiltinFunctionName.DATETIME.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprDateTime), ExprCoreType.TIMESTAMP, ExprCoreType.STRING, ExprCoreType.STRING), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprDateTimeNoTimezone), ExprCoreType.TIMESTAMP, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver date_add() {
        return FunctionDSL.define(BuiltinFunctionName.DATE_ADD.getName(), (SerializableFunction[])DateTimeFunctions.get_date_add_date_sub_signatures(DateTimeFunctions::exprAddDateInterval).toArray(SerializableFunction[]::new));
    }

    private static DefaultFunctionResolver date_sub() {
        return FunctionDSL.define(BuiltinFunctionName.DATE_SUB.getName(), (SerializableFunction[])DateTimeFunctions.get_date_add_date_sub_signatures(DateTimeFunctions::exprSubDateInterval).toArray(SerializableFunction[]::new));
    }

    private static DefaultFunctionResolver day() {
        return FunctionDSL.define(BuiltinFunctionName.DAY.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver dayName() {
        return FunctionDSL.define(BuiltinFunctionName.DAYNAME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDayName), ExprCoreType.STRING, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDayName), ExprCoreType.STRING, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDayName), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver dayOfMonth(BuiltinFunctionName name) {
        return FunctionDSL.define(name.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg) -> DateTimeFunctions.dayOfMonthToday(functionProperties.getQueryStartClock())), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver dayOfWeek(FunctionName name) {
        return FunctionDSL.define(name, FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg) -> DateTimeFunctions.dayOfWeekToday(functionProperties.getQueryStartClock())), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDayOfWeek), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDayOfWeek), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDayOfWeek), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver dayOfYear(BuiltinFunctionName dayOfYear) {
        return FunctionDSL.define(dayOfYear.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg) -> DateTimeFunctions.dayOfYearToday(functionProperties.getQueryStartClock())), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDayOfYear), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDayOfYear), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprDayOfYear), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver extract() {
        return FunctionDSL.define(BuiltinFunctionName.EXTRACT.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprExtractForTime), ExprCoreType.LONG, ExprCoreType.STRING, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprExtract), ExprCoreType.LONG, ExprCoreType.STRING, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprExtract), ExprCoreType.LONG, ExprCoreType.STRING, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprExtract), ExprCoreType.LONG, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver from_days() {
        return FunctionDSL.define(BuiltinFunctionName.FROM_DAYS.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprFromDays), ExprCoreType.DATE, ExprCoreType.LONG));
    }

    private static FunctionResolver from_unixtime() {
        return FunctionDSL.define(BuiltinFunctionName.FROM_UNIXTIME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprFromUnixTime), ExprCoreType.TIMESTAMP, ExprCoreType.DOUBLE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprFromUnixTimeFormat), ExprCoreType.STRING, ExprCoreType.DOUBLE, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver get_format() {
        return FunctionDSL.define(BuiltinFunctionName.GET_FORMAT.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprGetFormat), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver hour(BuiltinFunctionName name) {
        return FunctionDSL.define(name.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprHour), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprHour), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprHour), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprHour), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver last_day() {
        return FunctionDSL.define(BuiltinFunctionName.LAST_DAY.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprLastDay), ExprCoreType.DATE, ExprCoreType.STRING), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg) -> DateTimeFunctions.exprLastDayToday(functionProperties.getQueryStartClock())), ExprCoreType.DATE, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprLastDay), ExprCoreType.DATE, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprLastDay), ExprCoreType.DATE, ExprCoreType.TIMESTAMP));
    }

    private static FunctionResolver makedate() {
        return FunctionDSL.define(BuiltinFunctionName.MAKEDATE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMakeDate), ExprCoreType.DATE, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    private static FunctionResolver maketime() {
        return FunctionDSL.define(BuiltinFunctionName.MAKETIME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMakeTime), ExprCoreType.TIME, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver microsecond() {
        return FunctionDSL.define(BuiltinFunctionName.MICROSECOND.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMicrosecond), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMicrosecond), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMicrosecond), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver minute(BuiltinFunctionName name) {
        return FunctionDSL.define(name.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMinute), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMinute), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMinute), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMinute), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver minute_of_day() {
        return FunctionDSL.define(BuiltinFunctionName.MINUTE_OF_DAY.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMinuteOfDay), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMinuteOfDay), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMinuteOfDay), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMinuteOfDay), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver month(BuiltinFunctionName month) {
        return FunctionDSL.define(month.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg) -> DateTimeFunctions.monthOfYearToday(functionProperties.getQueryStartClock())), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMonth), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMonth), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMonth), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver monthName() {
        return FunctionDSL.define(BuiltinFunctionName.MONTHNAME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMonthName), ExprCoreType.STRING, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMonthName), ExprCoreType.STRING, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprMonthName), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver period_add() {
        return FunctionDSL.define(BuiltinFunctionName.PERIOD_ADD.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprPeriodAdd), ExprCoreType.INTEGER, ExprCoreType.INTEGER, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver period_diff() {
        return FunctionDSL.define(BuiltinFunctionName.PERIOD_DIFF.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprPeriodDiff), ExprCoreType.INTEGER, ExprCoreType.INTEGER, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver quarter() {
        return FunctionDSL.define(BuiltinFunctionName.QUARTER.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprQuarter), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprQuarter), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprQuarter), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver sec_to_time() {
        return FunctionDSL.define(BuiltinFunctionName.SEC_TO_TIME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprSecToTime), ExprCoreType.TIME, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprSecToTime), ExprCoreType.TIME, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprSecToTimeWithNanos), ExprCoreType.TIME, ExprCoreType.DOUBLE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprSecToTimeWithNanos), ExprCoreType.TIME, ExprCoreType.FLOAT));
    }

    private static DefaultFunctionResolver second(BuiltinFunctionName name) {
        return FunctionDSL.define(name.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprSecond), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprSecond), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprSecond), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprSecond), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver subdate() {
        return FunctionDSL.define(BuiltinFunctionName.SUBDATE.getName(), (SerializableFunction[])Stream.concat(DateTimeFunctions.get_date_add_date_sub_signatures(DateTimeFunctions::exprSubDateInterval), DateTimeFunctions.get_adddate_subdate_signatures(DateTimeFunctions::exprSubDateDays)).toArray(SerializableFunction[]::new));
    }

    private static DefaultFunctionResolver subtime() {
        return FunctionDSL.define(BuiltinFunctionName.SUBTIME.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprSubTime), ExprCoreType.TIME, ExprCoreType.TIME, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprSubTime), ExprCoreType.TIME, ExprCoreType.TIME, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprSubTime), ExprCoreType.TIME, ExprCoreType.TIME, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprSubTime), ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprSubTime), ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprSubTime), ExprCoreType.TIMESTAMP, ExprCoreType.DATE, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprSubTime), ExprCoreType.TIMESTAMP, ExprCoreType.DATE, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprSubTime), ExprCoreType.TIMESTAMP, ExprCoreType.DATE, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunctions::exprSubTime), ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver str_to_date() {
        return FunctionDSL.define(BuiltinFunctionName.STR_TO_DATE.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg, format) -> DateTimeFunctions.exprStrToDate(functionProperties, arg, format)), ExprCoreType.TIMESTAMP, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver time() {
        return FunctionDSL.define(BuiltinFunctionName.TIME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprTime), ExprCoreType.TIME, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprTime), ExprCoreType.TIME, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprTime), ExprCoreType.TIME, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprTime), ExprCoreType.TIME, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver timediff() {
        return FunctionDSL.define(BuiltinFunctionName.TIMEDIFF.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprTimeDiff), ExprCoreType.TIME, ExprCoreType.TIME, ExprCoreType.TIME));
    }

    private static DefaultFunctionResolver time_to_sec() {
        return FunctionDSL.define(BuiltinFunctionName.TIME_TO_SEC.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprTimeToSec), ExprCoreType.LONG, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprTimeToSec), ExprCoreType.LONG, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprTimeToSec), ExprCoreType.LONG, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver timestamp() {
        return FunctionDSL.define(BuiltinFunctionName.TIMESTAMP.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v), ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> DateTimeFunctions.exprAddTime(FunctionProperties.None, v1, v2)), ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver timestampadd() {
        return FunctionDSL.define(BuiltinFunctionName.TIMESTAMPADD.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprTimestampAdd), ExprCoreType.TIMESTAMP, ExprCoreType.STRING, ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, part, amount, time) -> DateTimeFunctions.exprTimestampAddForTimeType(functionProperties.getQueryStartClock(), part, amount, time)), ExprCoreType.TIMESTAMP, ExprCoreType.STRING, ExprCoreType.INTEGER, ExprCoreType.TIME));
    }

    private static DefaultFunctionResolver timestampdiff() {
        return FunctionDSL.define(BuiltinFunctionName.TIMESTAMPDIFF.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprTimestampDiff), ExprCoreType.TIMESTAMP, ExprCoreType.STRING, ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, part, startTime, endTime) -> DateTimeFunctions.exprTimestampDiffForTimeType(functionProperties, part, startTime, endTime)), ExprCoreType.TIMESTAMP, ExprCoreType.STRING, ExprCoreType.TIME, ExprCoreType.TIME));
    }

    private static DefaultFunctionResolver to_days() {
        return FunctionDSL.define(BuiltinFunctionName.TO_DAYS.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprToDays), ExprCoreType.LONG, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprToDays), ExprCoreType.LONG, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprToDays), ExprCoreType.LONG, ExprCoreType.DATE));
    }

    private static DefaultFunctionResolver to_seconds() {
        return FunctionDSL.define(BuiltinFunctionName.TO_SECONDS.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprToSeconds), ExprCoreType.LONG, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprToSecondsForIntType), ExprCoreType.LONG, ExprCoreType.LONG));
    }

    private static FunctionResolver unix_timestamp() {
        return FunctionDSL.define(BuiltinFunctionName.UNIX_TIMESTAMP.getName(), FunctionDSL.implWithProperties(functionProperties -> DateTimeFunctions.unixTimeStamp(functionProperties.getQueryStartClock()), ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::unixTimeStampOf), ExprCoreType.DOUBLE, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::unixTimeStampOf), ExprCoreType.DOUBLE, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::unixTimeStampOf), ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver utc_date() {
        return FunctionDSL.define(BuiltinFunctionName.UTC_DATE.getName(), FunctionDSL.implWithProperties(functionProperties -> DateTimeFunctions.exprUtcDate(functionProperties), ExprCoreType.DATE));
    }

    private static DefaultFunctionResolver utc_time() {
        return FunctionDSL.define(BuiltinFunctionName.UTC_TIME.getName(), FunctionDSL.implWithProperties(functionProperties -> DateTimeFunctions.exprUtcTime(functionProperties), ExprCoreType.TIME));
    }

    private static DefaultFunctionResolver utc_timestamp() {
        return FunctionDSL.define(BuiltinFunctionName.UTC_TIMESTAMP.getName(), FunctionDSL.implWithProperties(functionProperties -> DateTimeFunctions.exprUtcTimestamp(functionProperties), ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver week(BuiltinFunctionName week) {
        return FunctionDSL.define(week.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg) -> DateTimeFunctions.weekOfYearToday(DEFAULT_WEEK_OF_YEAR_MODE, functionProperties.getQueryStartClock())), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprWeekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprWeekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprWeekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, time, modeArg) -> DateTimeFunctions.weekOfYearToday(modeArg, functionProperties.getQueryStartClock())), ExprCoreType.INTEGER, ExprCoreType.TIME, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprWeek), ExprCoreType.INTEGER, ExprCoreType.DATE, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprWeek), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprWeek), ExprCoreType.INTEGER, ExprCoreType.STRING, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver weekday() {
        return FunctionDSL.define(BuiltinFunctionName.WEEKDAY.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg) -> new ExprIntegerValue(DateTimeFunctions.formatNow(functionProperties.getQueryStartClock()).getDayOfWeek().getValue() - 1)), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprWeekday), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprWeekday), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprWeekday), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver year() {
        return FunctionDSL.define(BuiltinFunctionName.YEAR.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprYear), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprYear), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprYear), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver yearweek() {
        return FunctionDSL.define(BuiltinFunctionName.YEARWEEK.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg) -> DateTimeFunctions.yearweekToday(DEFAULT_WEEK_OF_YEAR_MODE, functionProperties.getQueryStartClock())), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprYearweekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprYearweekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprYearweekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, time, modeArg) -> DateTimeFunctions.yearweekToday(modeArg, functionProperties.getQueryStartClock())), ExprCoreType.INTEGER, ExprCoreType.TIME, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprYearweek), ExprCoreType.INTEGER, ExprCoreType.DATE, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprYearweek), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunctions::exprYearweek), ExprCoreType.INTEGER, ExprCoreType.STRING, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver date_format() {
        return FunctionDSL.define(BuiltinFunctionName.DATE_FORMAT.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedDate), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedDate), ExprCoreType.STRING, ExprCoreType.DATE, ExprCoreType.STRING), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, time, formatString) -> DateTimeFormatterUtil.getFormattedDateOfToday(formatString, time, functionProperties.getQueryStartClock())), ExprCoreType.STRING, ExprCoreType.TIME, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedDate), ExprCoreType.STRING, ExprCoreType.TIMESTAMP, ExprCoreType.STRING));
    }

    private static ExprValue dayOfMonthToday(Clock clock) {
        return new ExprIntegerValue(LocalDateTime.now(clock).getDayOfMonth());
    }

    public static ExprValue dayOfYearToday(Clock clock) {
        return new ExprIntegerValue(LocalDateTime.now(clock).getDayOfYear());
    }

    private static ExprValue weekOfYearToday(ExprValue mode, Clock clock) {
        return new ExprIntegerValue(CalendarLookup.getWeekNumber(mode.integerValue(), LocalDateTime.now(clock).toLocalDate()));
    }

    public static ExprValue dayOfWeekToday(Clock clock) {
        return new ExprIntegerValue(DateTimeFunctions.formatNow(clock).getDayOfWeek().getValue() % 7 + 1);
    }

    private static ExprValue exprAddDateInterval(FunctionProperties functionProperties, ExprValue datetime, ExprValue interval) {
        return DateTimeFunctions.exprDateApplyInterval(functionProperties, datetime, interval.intervalValue(), true);
    }

    public static ExprValue exprDateApplyInterval(FunctionProperties functionProperties, ExprValue datetime, TemporalAmount interval, Boolean isAdd) {
        LocalDateTime dt = DateTimeUtils.extractTimestamp(datetime, functionProperties).atZone(ZoneOffset.UTC).toLocalDateTime();
        return new ExprTimestampValue(isAdd != false ? dt.plus(interval) : dt.minus(interval));
    }

    private static DefaultFunctionResolver time_format() {
        return FunctionDSL.define(BuiltinFunctionName.TIME_FORMAT.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedTime), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedTime), ExprCoreType.STRING, ExprCoreType.DATE, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedTime), ExprCoreType.STRING, ExprCoreType.TIME, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedTime), ExprCoreType.STRING, ExprCoreType.TIMESTAMP, ExprCoreType.STRING));
    }

    private static ExprValue exprAddDateDays(FunctionProperties functionProperties, ExprValue datetime, ExprValue days) {
        return DateTimeFunctions.exprDateApplyDays(functionProperties, datetime, days.longValue(), true);
    }

    public static ExprValue exprDateApplyDays(FunctionProperties functionProperties, ExprValue datetime, Long days, Boolean isAdd) {
        if (datetime.type() == ExprCoreType.DATE) {
            return new ExprDateValue(isAdd != false ? datetime.dateValue().plusDays(days) : datetime.dateValue().minusDays(days));
        }
        LocalDateTime dt = DateTimeUtils.extractTimestamp(datetime, functionProperties).atZone(ZoneOffset.UTC).toLocalDateTime();
        return new ExprTimestampValue(isAdd != false ? dt.plusDays(days) : dt.minusDays(days));
    }

    public static ExprValue exprApplyTime(FunctionProperties functionProperties, ExprValue temporal, ExprValue temporalDelta, Boolean isAdd) {
        Duration interval = Duration.between(LocalTime.MIN, temporalDelta.timeValue());
        Instant result = isAdd != false ? DateTimeUtils.extractTimestamp(temporal, functionProperties).plus(interval) : DateTimeUtils.extractTimestamp(temporal, functionProperties).minus(interval);
        return temporal.type() == ExprCoreType.TIME ? new ExprTimeValue(result.atZone(ZoneOffset.UTC).toLocalTime()) : new ExprTimestampValue(result);
    }

    public static ExprValue exprAddTime(FunctionProperties functionProperties, ExprValue temporal, ExprValue temporalDelta) {
        return DateTimeFunctions.exprApplyTime(functionProperties, temporal, temporalDelta, true);
    }

    public static ExprValue exprConvertTZ(ExprValue startingDateTime, ExprValue fromTz, ExprValue toTz) {
        if (startingDateTime.type() == ExprCoreType.STRING) {
            try {
                startingDateTime = new ExprTimestampValue(LocalDateTime.parse(startingDateTime.stringValue(), DateTimeFormatters.DATE_TIME_FORMATTER_VARIABLE_NANOS));
            }
            catch (DateTimeParseException e) {
                return ExprNullValue.of();
            }
        }
        try {
            ZoneId convertedFromTz = ZoneId.of(fromTz.stringValue());
            ZoneId convertedToTz = ZoneId.of(toTz.stringValue());
            if (!DateTimeUtils.isValidMySqlTimeZoneId(convertedFromTz).booleanValue() || !DateTimeUtils.isValidMySqlTimeZoneId(convertedToTz).booleanValue()) {
                return ExprNullValue.of();
            }
            ZonedDateTime zonedDateTime = startingDateTime.timestampValue().atZone(ZoneOffset.UTC).toLocalDateTime().atZone(convertedFromTz);
            return new ExprTimestampValue(zonedDateTime.withZoneSameInstant(convertedToTz).toLocalDateTime());
        }
        catch (DateTimeException | ExpressionEvaluationException e) {
            return ExprNullValue.of();
        }
    }

    public static ExprValue exprDate(ExprValue exprValue) {
        if (exprValue instanceof ExprStringValue) {
            return new ExprDateValue(exprValue.stringValue());
        }
        return new ExprDateValue(exprValue.dateValue());
    }

    public static ExprValue exprDateDiff(FunctionProperties functionProperties, ExprValue first, ExprValue second) {
        return new ExprLongValue(ChronoUnit.DAYS.between(DateTimeUtils.extractDate(second, functionProperties), DateTimeUtils.extractDate(first, functionProperties)));
    }

    public static ExprValue exprDateTime(FunctionProperties properties, ExprValue timestamp, ExprValue timeZone) {
        String toTz;
        ExprTimestampValue tz;
        String defaultTimeZone = properties.getCurrentZoneId().toString();
        try {
            LocalDateTime ldtFormatted = LocalDateTime.parse(timestamp.stringValue(), DateTimeFormatters.DATE_TIME_FORMATTER_STRICT_WITH_TZ);
            if (timeZone.isNull()) {
                return new ExprTimestampValue(ldtFormatted);
            }
        }
        catch (DateTimeParseException e) {
            return ExprNullValue.of();
        }
        try {
            ZonedDateTime zdtWithZoneOffset = ZonedDateTime.parse(timestamp.stringValue(), DateTimeFormatters.DATE_TIME_FORMATTER_STRICT_WITH_TZ);
            ZoneId fromTZ = zdtWithZoneOffset.getZone();
            tz = new ExprTimestampValue(zdtWithZoneOffset.toLocalDateTime());
            toTz = String.valueOf(fromTZ);
        }
        catch (DateTimeParseException e) {
            tz = new ExprTimestampValue(timestamp.stringValue());
            toTz = defaultTimeZone;
        }
        ExprValue convertTZResult = DateTimeFunctions.exprConvertTZ(tz, new ExprStringValue(toTz), timeZone);
        return convertTZResult;
    }

    public static ExprValue exprDateTimeNoTimezone(FunctionProperties properties, ExprValue dateTime) {
        return DateTimeFunctions.exprDateTime(properties, dateTime, ExprNullValue.of());
    }

    private static ExprValue exprDayName(ExprValue date) {
        return new ExprStringValue(date.dateValue().getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.getDefault()));
    }

    public static ExprValue exprDayOfMonth(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getDayOfMonth());
    }

    public static ExprValue exprDayOfWeek(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getDayOfWeek().getValue() % 7 + 1);
    }

    public static ExprValue exprDayOfYear(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getDayOfYear());
    }

    public static ExprLongValue formatExtractFunction(ExprValue part, ExprValue timestamp) {
        String partName = part.stringValue().toUpperCase(Locale.ROOT);
        LocalDateTime arg = timestamp.timestampValue().atZone(ZoneOffset.UTC).toLocalDateTime();
        if (partName.equals("WEEK")) {
            return new ExprLongValue(arg.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR));
        }
        String text = arg.format(DateTimeFormatter.ofPattern(extract_formats.get(partName), Locale.ENGLISH));
        return new ExprLongValue(Long.parseLong(text));
    }

    private static ExprValue exprExtract(ExprValue part, ExprValue timestamp) {
        return DateTimeFunctions.formatExtractFunction(part, timestamp);
    }

    public static ExprValue exprExtractForTime(FunctionProperties functionProperties, ExprValue part, ExprValue time) {
        return DateTimeFunctions.formatExtractFunction(part, new ExprTimestampValue(DateTimeUtils.extractTimestamp(time, functionProperties)));
    }

    public static ExprValue exprFromDays(ExprValue exprValue) {
        return new ExprDateValue(LocalDate.ofEpochDay(exprValue.longValue() - DAYS_0000_TO_1970));
    }

    public static ExprValue exprFromUnixTime(ExprValue time) {
        if (0.0 > time.doubleValue()) {
            return ExprNullValue.of();
        }
        if (MYSQL_MAX_TIMESTAMP <= time.doubleValue()) {
            return ExprNullValue.of();
        }
        return new ExprTimestampValue(DateTimeFunctions.exprFromUnixTimeImpl(time));
    }

    private static LocalDateTime exprFromUnixTimeImpl(ExprValue time) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond((long)Math.floor(time.doubleValue())), ZoneOffset.UTC).withNano((int)(time.doubleValue() % 1.0 * 1.0E9));
    }

    public static ExprValue exprFromUnixTimeFormat(ExprValue time, ExprValue format) {
        ExprValue value = DateTimeFunctions.exprFromUnixTime(time);
        if (value.equals(ExprNullValue.of())) {
            return ExprNullValue.of();
        }
        return DateTimeFormatterUtil.getFormattedDate(value, format);
    }

    public static ExprValue exprGetFormat(ExprValue type, ExprValue format) {
        if (formats.contains((Object)type.stringValue().toLowerCase(Locale.ROOT), (Object)format.stringValue().toLowerCase(Locale.ROOT))) {
            return new ExprStringValue((String)formats.get((Object)type.stringValue().toLowerCase(Locale.ROOT), (Object)format.stringValue().toLowerCase(Locale.ROOT)));
        }
        return ExprNullValue.of();
    }

    public static ExprValue exprHour(ExprValue time) {
        return new ExprIntegerValue(ChronoUnit.HOURS.between(LocalTime.MIN, time.timeValue()));
    }

    private static LocalDate getLastDay(LocalDate today) {
        return LocalDate.of(today.getYear(), today.getMonth(), today.getMonth().length(today.isLeapYear()));
    }

    public static ExprValue exprLastDay(ExprValue timestamp) {
        return new ExprDateValue(DateTimeFunctions.getLastDay(timestamp.dateValue()));
    }

    public static ExprValue exprLastDayToday(Clock clock) {
        return new ExprDateValue(DateTimeFunctions.getLastDay(DateTimeFunctions.formatNow(clock).toLocalDate()));
    }

    public static ExprValue exprMakeDate(ExprValue yearExpr, ExprValue dayOfYearExp) {
        long year = Math.round(yearExpr.doubleValue());
        long dayOfYear = Math.round(dayOfYearExp.doubleValue());
        if (0L >= dayOfYear || 0L > year) {
            return ExprNullValue.of();
        }
        if (0L == year) {
            year = 2000L;
        }
        return new ExprDateValue(LocalDate.ofYearDay((int)year, 1).plusDays(dayOfYear - 1L));
    }

    public static ExprValue exprMakeTime(ExprValue hourExpr, ExprValue minuteExpr, ExprValue secondExpr) {
        long hour = Math.round(hourExpr.doubleValue());
        long minute = Math.round(minuteExpr.doubleValue());
        Double second = secondExpr.doubleValue();
        if (0L > hour || 0L > minute || 0.0 > second) {
            return ExprNullValue.of();
        }
        return new ExprTimeValue(LocalTime.parse(String.format(Locale.US, "%02d:%02d:%012.9f", hour, minute, second), DateTimeFormatter.ISO_TIME));
    }

    public static ExprValue exprMicrosecond(ExprValue time) {
        return new ExprIntegerValue(TimeUnit.MICROSECONDS.convert(time.timeValue().getNano(), TimeUnit.NANOSECONDS));
    }

    public static ExprValue exprMinute(ExprValue time) {
        return new ExprIntegerValue(ChronoUnit.MINUTES.between(LocalTime.MIN, time.timeValue()) % 60L);
    }

    public static ExprValue exprMinuteOfDay(ExprValue time) {
        return new ExprIntegerValue(ChronoUnit.MINUTES.between(LocalTime.MIN, time.timeValue()));
    }

    public static ExprValue exprMonth(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getMonthValue());
    }

    private static ExprValue exprMonthName(ExprValue date) {
        return new ExprStringValue(date.dateValue().getMonth().getDisplayName(TextStyle.FULL, Locale.getDefault()));
    }

    private static LocalDate parseDatePeriod(Integer period) {
        String input = period.toString();
        if (input.length() <= 5) {
            input = String.format("200%05d", period);
        }
        try {
            return LocalDate.parse(input, DateTimeFormatters.DATE_FORMATTER_SHORT_YEAR);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return LocalDate.parse(input, DateTimeFormatters.DATE_FORMATTER_LONG_YEAR);
            }
            catch (DateTimeParseException ignored) {
                return null;
            }
        }
    }

    public static ExprValue exprPeriodAdd(ExprValue period, ExprValue months) {
        int input = period.integerValue() * 100 + 1;
        LocalDate parsedDate = DateTimeFunctions.parseDatePeriod(input);
        if (parsedDate == null) {
            return ExprNullValue.of();
        }
        String res = DateTimeFormatters.DATE_FORMATTER_LONG_YEAR.format(parsedDate.plusMonths(months.integerValue().intValue()));
        return new ExprIntegerValue(Integer.parseInt(res.substring(0, res.length() - 2)));
    }

    public static ExprValue exprPeriodDiff(ExprValue period1, ExprValue period2) {
        LocalDate parsedDate1 = DateTimeFunctions.parseDatePeriod(period1.integerValue() * 100 + 1);
        LocalDate parsedDate2 = DateTimeFunctions.parseDatePeriod(period2.integerValue() * 100 + 1);
        if (parsedDate1 == null || parsedDate2 == null) {
            return ExprNullValue.of();
        }
        return new ExprIntegerValue(ChronoUnit.MONTHS.between(parsedDate2, parsedDate1));
    }

    public static ExprValue exprQuarter(ExprValue date) {
        int month = date.dateValue().getMonthValue();
        return new ExprIntegerValue(month / 3 + (month % 3 == 0 ? 0 : 1));
    }

    public static ExprValue exprSecToTime(ExprValue totalSeconds) {
        return new ExprTimeValue(LocalTime.MIN.plus(Duration.ofSeconds(totalSeconds.longValue())));
    }

    private static long formatNanos(ExprValue seconds) {
        BigDecimal formattedNanos = BigDecimal.valueOf(seconds.doubleValue());
        formattedNanos = formattedNanos.subtract(BigDecimal.valueOf(formattedNanos.intValue()));
        return formattedNanos.scaleByPowerOfTen(9).longValue();
    }

    public static ExprValue exprSecToTimeWithNanos(ExprValue totalSeconds) {
        long nanos = DateTimeFunctions.formatNanos(totalSeconds);
        return new ExprTimeValue(LocalTime.MIN.plus(Duration.ofSeconds(totalSeconds.longValue(), nanos)));
    }

    public static ExprValue exprSecond(ExprValue time) {
        return new ExprIntegerValue(ChronoUnit.SECONDS.between(LocalTime.MIN, time.timeValue()) % 60L);
    }

    private static ExprValue exprSubDateDays(FunctionProperties functionProperties, ExprValue date, ExprValue days) {
        return DateTimeFunctions.exprDateApplyDays(functionProperties, date, days.longValue(), false);
    }

    private static ExprValue exprSubDateInterval(FunctionProperties functionProperties, ExprValue datetime, ExprValue expr) {
        return DateTimeFunctions.exprDateApplyInterval(functionProperties, datetime, expr.intervalValue(), false);
    }

    public static ExprValue exprSubTime(FunctionProperties functionProperties, ExprValue temporal, ExprValue temporalDelta) {
        return DateTimeFunctions.exprApplyTime(functionProperties, temporal, temporalDelta, false);
    }

    public static ExprValue exprStrToDate(FunctionProperties fp, ExprValue dateTimeExpr, ExprValue formatStringExp) {
        return DateTimeFormatterUtil.parseStringWithDateOrTime(fp, dateTimeExpr, formatStringExp);
    }

    public static ExprValue exprTime(ExprValue exprValue) {
        if (exprValue instanceof ExprStringValue) {
            return new ExprTimeValue(exprValue.stringValue());
        }
        return new ExprTimeValue(exprValue.timeValue());
    }

    public static ExprValue exprTimeDiff(ExprValue first, ExprValue second) {
        return new ExprTimeValue(LocalTime.MIN.plus(Duration.between(second.timeValue(), first.timeValue())));
    }

    public static ExprValue exprTimeToSec(ExprValue time) {
        return new ExprLongValue(time.timeValue().toSecondOfDay());
    }

    public static ExprValue exprTimestampAdd(ExprValue partExpr, ExprValue amountExpr, ExprValue datetimeExpr) {
        ChronoUnit temporalUnit;
        String part = partExpr.stringValue();
        int amount = amountExpr.integerValue();
        LocalDateTime timestamp = datetimeExpr.timestampValue().atZone(ZoneOffset.UTC).toLocalDateTime();
        switch (part) {
            case "MICROSECOND": {
                temporalUnit = ChronoUnit.MICROS;
                break;
            }
            case "MILLISECOND": {
                temporalUnit = ChronoUnit.MILLIS;
                break;
            }
            case "SECOND": {
                temporalUnit = ChronoUnit.SECONDS;
                break;
            }
            case "MINUTE": {
                temporalUnit = ChronoUnit.MINUTES;
                break;
            }
            case "HOUR": {
                temporalUnit = ChronoUnit.HOURS;
                break;
            }
            case "DAY": {
                temporalUnit = ChronoUnit.DAYS;
                break;
            }
            case "WEEK": {
                temporalUnit = ChronoUnit.WEEKS;
                break;
            }
            case "MONTH": {
                temporalUnit = ChronoUnit.MONTHS;
                break;
            }
            case "QUARTER": {
                temporalUnit = ChronoUnit.MONTHS;
                amount *= 3;
                break;
            }
            case "YEAR": {
                temporalUnit = ChronoUnit.YEARS;
                break;
            }
            default: {
                return ExprNullValue.of();
            }
        }
        return new ExprTimestampValue(timestamp.plus(amount, temporalUnit));
    }

    public static ExprValue exprTimestampAddForTimeType(Clock clock, ExprValue partExpr, ExprValue amountExpr, ExprValue timeExpr) {
        LocalDateTime datetime = LocalDateTime.of(DateTimeFunctions.formatNow(clock).toLocalDate(), timeExpr.timeValue());
        return DateTimeFunctions.exprTimestampAdd(partExpr, amountExpr, new ExprTimestampValue(datetime));
    }

    private static ExprValue getTimeDifference(String part, LocalDateTime startTime, LocalDateTime endTime) {
        long returnVal;
        switch (part.toUpperCase(Locale.ROOT)) {
            case "MICROSECOND": {
                returnVal = ChronoUnit.MICROS.between(startTime, endTime);
                break;
            }
            case "MILLISECOND": {
                returnVal = ChronoUnit.MILLIS.between(startTime, endTime);
                break;
            }
            case "SECOND": {
                returnVal = ChronoUnit.SECONDS.between(startTime, endTime);
                break;
            }
            case "MINUTE": {
                returnVal = ChronoUnit.MINUTES.between(startTime, endTime);
                break;
            }
            case "HOUR": {
                returnVal = ChronoUnit.HOURS.between(startTime, endTime);
                break;
            }
            case "DAY": {
                returnVal = ChronoUnit.DAYS.between(startTime, endTime);
                break;
            }
            case "WEEK": {
                returnVal = ChronoUnit.WEEKS.between(startTime, endTime);
                break;
            }
            case "MONTH": {
                returnVal = ChronoUnit.MONTHS.between(startTime, endTime);
                break;
            }
            case "QUARTER": {
                returnVal = ChronoUnit.MONTHS.between(startTime, endTime) / 3L;
                break;
            }
            case "YEAR": {
                returnVal = ChronoUnit.YEARS.between(startTime, endTime);
                break;
            }
            default: {
                return ExprNullValue.of();
            }
        }
        return new ExprLongValue(returnVal);
    }

    public static ExprValue exprTimestampDiff(ExprValue partExpr, ExprValue startTimeExpr, ExprValue endTimeExpr) {
        return DateTimeFunctions.getTimeDifference(partExpr.stringValue(), startTimeExpr.timestampValue().atZone(ZoneOffset.UTC).toLocalDateTime(), endTimeExpr.timestampValue().atZone(ZoneOffset.UTC).toLocalDateTime());
    }

    public static ExprValue exprTimestampDiffForTimeType(FunctionProperties fp, ExprValue partExpr, ExprValue startTimeExpr, ExprValue endTimeExpr) {
        return DateTimeFunctions.getTimeDifference(partExpr.stringValue(), DateTimeUtils.extractTimestamp(startTimeExpr, fp).atZone(ZoneOffset.UTC).toLocalDateTime(), DateTimeUtils.extractTimestamp(endTimeExpr, fp).atZone(ZoneOffset.UTC).toLocalDateTime());
    }

    public static ExprValue exprUtcDate(FunctionProperties functionProperties) {
        return new ExprDateValue(DateTimeFunctions.exprUtcTimestamp(functionProperties).dateValue());
    }

    public static ExprValue exprUtcTime(FunctionProperties functionProperties) {
        return new ExprTimeValue(DateTimeFunctions.exprUtcTimestamp(functionProperties).timeValue());
    }

    public static ExprValue exprUtcTimestamp(FunctionProperties functionProperties) {
        LocalDateTime dt = DateTimeFunctions.formatNow(functionProperties.getQueryStartClock());
        return new ExprTimestampValue(dt);
    }

    public static ExprValue exprToDays(ExprValue date) {
        return new ExprLongValue(date.dateValue().toEpochDay() + DAYS_0000_TO_1970);
    }

    public static ExprValue exprToSeconds(ExprValue date) {
        return new ExprLongValue(date.timestampValue().atOffset(ZoneOffset.UTC).toEpochSecond() + DAYS_0000_TO_1970 * 86400L);
    }

    private static DateTimeFormatter getFormatter(int dateAsInt) {
        int length = String.format("%d", dateAsInt).length();
        if (length > 8) {
            throw new DateTimeException("Integer argument was out of range");
        }
        switch (length) {
            case 8: {
                return DateTimeFormatters.DATE_FORMATTER_LONG_YEAR;
            }
            case 6: {
                return DateTimeFormatters.DATE_FORMATTER_SHORT_YEAR;
            }
            case 5: {
                return DateTimeFormatters.DATE_FORMATTER_SINGLE_DIGIT_YEAR;
            }
            case 4: {
                return DateTimeFormatters.DATE_FORMATTER_NO_YEAR;
            }
            case 3: {
                return DateTimeFormatters.DATE_FORMATTER_SINGLE_DIGIT_MONTH;
            }
        }
        throw new DateTimeException("No Matching Format");
    }

    public static ExprValue exprToSecondsForIntType(ExprValue dateExpr) {
        try {
            LocalDate date = LocalDate.parse(String.valueOf(dateExpr.integerValue()), DateTimeFunctions.getFormatter(dateExpr.integerValue()));
            return new ExprLongValue(date.toEpochSecond(LocalTime.MIN, ZoneOffset.UTC) + DAYS_0000_TO_1970 * 86400L);
        }
        catch (DateTimeException ignored) {
            return ExprNullValue.of();
        }
    }

    public static ExprValue exprWeek(ExprValue date, ExprValue mode) {
        return new ExprIntegerValue(CalendarLookup.getWeekNumber(mode.integerValue(), date.dateValue()));
    }

    public static ExprValue exprWeekday(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getDayOfWeek().getValue() - 1);
    }

    public static ExprValue unixTimeStamp(Clock clock) {
        return new ExprLongValue(Instant.now(clock).getEpochSecond());
    }

    public static ExprValue unixTimeStampOf(ExprValue value) {
        Double res = DateTimeFunctions.unixTimeStampOfImpl(value);
        if (res == null) {
            return ExprNullValue.of();
        }
        if (res < 0.0) {
            return new ExprDoubleValue(0);
        }
        if (res >= MYSQL_MAX_TIMESTAMP) {
            return new ExprDoubleValue(0);
        }
        return new ExprDoubleValue(res);
    }

    public static Double transferUnixTimeStampFromDoubleInput(Double value) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getNumberInstance(Locale.ROOT);
        format.applyPattern("0.#");
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(6);
        String input = format.format(value);
        double fraction = 0.0;
        if (input.contains(".")) {
            fraction = value - (double)Math.round(Math.ceil(value));
            input = input.substring(0, input.indexOf(46));
        }
        try {
            LocalDateTime res = LocalDateTime.parse(input, DateTimeFormatters.DATE_TIME_FORMATTER_SHORT_YEAR);
            return (double)res.toEpochSecond(ZoneOffset.UTC) + fraction;
        }
        catch (DateTimeParseException res) {
            try {
                LocalDateTime res2 = LocalDateTime.parse(input, DateTimeFormatters.DATE_TIME_FORMATTER_LONG_YEAR);
                return (double)res2.toEpochSecond(ZoneOffset.UTC) + fraction;
            }
            catch (DateTimeParseException res2) {
                try {
                    LocalDate res3 = LocalDate.parse(input, DateTimeFormatters.DATE_FORMATTER_SHORT_YEAR);
                    return (double)res3.toEpochSecond(LocalTime.MIN, ZoneOffset.UTC) + 0.0;
                }
                catch (DateTimeParseException res3) {
                    try {
                        LocalDate res4 = LocalDate.parse(input, DateTimeFormatters.DATE_FORMATTER_LONG_YEAR);
                        return (double)res4.toEpochSecond(LocalTime.MIN, ZoneOffset.UTC) + 0.0;
                    }
                    catch (DateTimeParseException ignored) {
                        return null;
                    }
                }
            }
        }
    }

    private static Double unixTimeStampOfImpl(ExprValue value) {
        switch ((ExprCoreType)value.type()) {
            case DATE: {
                return (double)value.dateValue().toEpochSecond(LocalTime.MIN, ZoneOffset.UTC) + 0.0;
            }
            case TIMESTAMP: {
                return (double)value.timestampValue().getEpochSecond() + (double)value.timestampValue().getNano() / 1.0E9;
            }
        }
        return DateTimeFunctions.transferUnixTimeStampFromDoubleInput(value.doubleValue());
    }

    public static ExprValue exprWeekWithoutMode(ExprValue date) {
        return DateTimeFunctions.exprWeek(date, DEFAULT_WEEK_OF_YEAR_MODE);
    }

    public static ExprValue exprYear(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getYear());
    }

    private static ExprIntegerValue extractYearweek(LocalDate date, int mode) {
        int modeJava = CalendarLookup.getWeekNumber(mode, date) != 0 ? mode : (mode <= 4 ? 2 : 7);
        int formatted = CalendarLookup.getYearNumber(modeJava, date) * 100 + CalendarLookup.getWeekNumber(modeJava, date);
        return new ExprIntegerValue(formatted);
    }

    public static ExprValue exprYearweek(ExprValue date, ExprValue mode) {
        return DateTimeFunctions.extractYearweek(date.dateValue(), mode.integerValue());
    }

    private static ExprValue exprYearweekWithoutMode(ExprValue date) {
        return DateTimeFunctions.exprYearweek(date, new ExprIntegerValue(0));
    }

    public static ExprValue yearweekToday(ExprValue mode, Clock clock) {
        return DateTimeFunctions.extractYearweek(LocalDateTime.now(clock).toLocalDate(), mode.integerValue());
    }

    public static ExprValue monthOfYearToday(Clock clock) {
        return new ExprIntegerValue(LocalDateTime.now(clock).getMonthValue());
    }

    public static LocalDateTime formatNow(Clock clock) {
        return DateTimeFunctions.formatNow(clock, 0);
    }

    public static LocalDateTime formatNow(Clock clock, Integer fsp) {
        LocalDateTime res = LocalDateTime.now(clock);
        int defaultPrecision = 9;
        if (fsp < 0 || fsp > 6) {
            throw new IllegalArgumentException(String.format("Invalid `fsp` value: %d, allowed 0 to 6", fsp));
        }
        int nano = new BigDecimal(res.getNano()).setScale(fsp - defaultPrecision, RoundingMode.DOWN).intValue();
        return res.withNano(nano);
    }

    @Generated
    private DateTimeFunctions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

